import re
import sys
import urllib
import warnings

try:
    from urlparse import parse_qs  # Python 2.6+
except ImportError:
    from cgi import parse_qs


__all__ = [
    "get_wsgi_get_arg",
    "wsgi_env2dict",
    "match_url_in_re",
]


warnings.simplefilter('default')


#
# From Tornado 2.3, tornado/escape.py

_UTF8_TYPES = (bytes, type(None))
def utf8(value):
    """Converts a string argument to a byte string.

    If the argument is already a byte string or None, it is returned unchanged.
    Otherwise it must be a unicode string and is encoded as utf8.
    """
    if isinstance(value, _UTF8_TYPES):
        return value
    assert isinstance(value, unicode)
    return value.encode("utf-8")

# python 3 changed things around enough that we need two separate
# implementations of url_unescape.  We also need our own implementation
# of parse_qs since python 3's version insists on decoding everything.
if sys.version_info[0] < 3:
    def url_unescape(value, encoding='utf-8'):
        """Decodes the given value from a URL.

        The argument may be either a byte or unicode string.

        If encoding is None, the result will be a byte string.  Otherwise,
        the result is a unicode string in the specified encoding.
        """
        if encoding is None:
            return urllib.unquote_plus(utf8(value))
        else:
            return unicode(urllib.unquote_plus(utf8(value)), encoding)

    parse_qs_bytes = parse_qs
else:
    def url_unescape(value, encoding='utf-8'):
        """Decodes the given value from a URL.

        The argument may be either a byte or unicode string.

        If encoding is None, the result will be a byte string.  Otherwise,
        the result is a unicode string in the specified encoding.
        """
        if encoding is None:
            return urllib.parse.unquote_to_bytes(value)
        else:
            return urllib.unquote_plus(to_basestring(value), encoding=encoding)

    def parse_qs_bytes(qs, keep_blank_values=False, strict_parsing=False):
        """Parses a query string like urlparse.parse_qs, but returns the
        values as byte strings.

        Keys still become type str (interpreted as latin1 in python3!)
        because it's too painful to keep them as byte strings in
        python3 and in practice they're nearly always ascii anyway.
        """
        # This is gross, but python3 doesn't give us another way.
        # Latin1 is the universal donor of character encodings.
        result = parse_qs(qs, keep_blank_values, strict_parsing,
                          encoding='latin1', errors='strict')
        encoded = {}
        for k,v in result.iteritems():
            encoded[k] = [i.encode('latin1') for i in v]
        return encoded


def wsgi_env2dict(env, keep_empty = False):
    new_args = {}
    args = parse_qs_bytes(env["QUERY_STRING"], keep_blank_values = keep_empty)
    for key, val in args.iteritems():
        if val is not None:
            new_args[key] = val[0]
        elif val is None and keep_empty:
            new_args[key] = None

    return new_args

def get_wsgi_get_arg(name, env_dict = None, env = None, default = None):
#    warnings.warn("get_wsgi_arg deprecated in the future version, using get_wsgi_get_arg instead of it",
#                  DeprecationWarning, stacklevel = 1)

    if env_dict is not None:
        return env_dict.get(name, default)
    elif env is not None:
        args = parse_qs_bytes(env["QUERY_STRING"])
        val = args.get(name)
        if val is not None:
            return val[-1]
    else:
        raise ValueError("env and env_dict both are None")

    return default


def match_url_in_re(pattern, url):
    if pattern == url:
        return True
    else:
        result = re.compile('^' + pattern + '$').match(url)
        if result:
            return True
    return False
