from __future__ import unicode_literals

import logging
import os

import tornado.locale
import tornado.web

_DATA_DIR = os.path.join(os.path.dirname(__file__), 'data')
_LOCALE_DIR = os.path.join(_DATA_DIR, 'locale')
_STATIC_DIR = os.path.join(_DATA_DIR, 'static')
_TEMPLATE_DIR = os.path.join(_DATA_DIR, 'template')

logger = logging.getLogger(__name__)


class IndexHandler(tornado.web.RequestHandler):

    DOMAIN = 'kuechenradio'

    def initialize(self, config):
        from . import Extension
        self.default_locale = config[Extension.ext_name]['default_locale']
        tornado.locale.load_gettext_translations(_LOCALE_DIR, self.DOMAIN)

    def get(self, path):
        def lc_selected(code):
            # match 'en' if user/default locale is 'en_US'
            if self.get_user_locale().code.startswith(code):
                return 'selected'
            else:
                return ''
        return self.render('index.html', lc_selected=lc_selected)

    def get_user_locale(self):
        code = self.get_argument('locale', None)
        if code:
            locale = tornado.locale.get(code)
        else:
            locale = self.get_browser_locale(self.default_locale)
        logger.debug('user locale=%s', locale.code)
        return locale

    def get_template_path(self):
        return _TEMPLATE_DIR;


def factory(config, core):
    return [
        (r'/(index.html)?', IndexHandler, {'config': config}),
        (r'/(.*)', tornado.web.StaticFileHandler, {'path': _STATIC_DIR})
    ]
