(function ( root, doc, factory ) {
    if ( typeof define === "function" && define.amd ) {
	define( [ "jquery" ], function ( $ ) {
	    factory( $, root, doc );
	    return $.mobile;
	});
    } else {
	factory( root.jQuery, root, doc );
    }
}( this, document, function ( jQuery, window, document, undefined ) {
(function( $, window, undefined ) {
        $.mopidy = {};
})( jQuery, this );

(function( $, window, undefined ) {
    function getArtistNames( artists ) {
        var names = [], i = 0;
        if (artists && artists.length) {
            for (; i !== artists.length; ++i) {
                names.push(artists[i].name);
            }
        }
        return names;
    }

    $.extend( $.mopidy, {

        loadMessageDelay: 50,

        defaultImage: "images/mopidy.png",

        itemCallbacks: {
            "TlTrack": function(tlTrack) {
                var track = tlTrack.track,
                    $li = $("<li />", { "data-icon": false, value: tlTrack.tlid }),
                    $a = $("<a />", { href: track.uri }),
                    $p = $("<p />");
                $a.data( "model", tlTrack );

                if (track.album && track.album.images && track.album.images.length) {
                    $a.append( $( "<img />", { src: track.album.images[0] } ) );
                } else {
                    $a.append( $( "<img />", { src: $.mopidy.defaultImage } ) );
                }
                $a.append( $("<h2 />", { text: track.name }) );
                if (track.artists && track.artists.length) {
                    $p.append($("<span />", { text: track.artists[0].name }));
                    if (track.album && track.album.name) {
                        $p.append(" - ");
                    }
                }
                if (track.album && track.album.name) {
                    $p.append($("<span />", { text: track.album.name }));
                }
                $a.append($p);
                $li.append($a);
                return $li;
            },
            "Track": function(track) {
                var $li = $("<li />", { "data-icon": false }),
                    $a = $("<a />", { href: track.uri }),
                    $p = $("<p />");
                $a.data( "model", track );
                if (track.album && track.album.images && track.album.images.length) {
                    $a.append( $( "<img />", { src: track.album.images[0] } ) );
                } else {
                    $a.append( $( "<img />", { src: $.mopidy.defaultImage } ) );
                }
                $a.append( $("<h2 />", { text: track.name }) );
                if (track.artists && track.artists.length) {
                    $p.append($("<span />", { text: track.artists[0].name }));
                    if (track.album && track.album.name) {
                        $p.append(" - ");
                    }
                }
                if (track.album && track.album.name) {
                    $p.append($("<span />", { text: track.album.name }));
                }
                $a.append($p);
                $li.append($a);
                return $li;
            },
            "Album": function(album) {
                var $li = $("<li />", { "data-icon": false }),
                    $a = $("<a />", { href: album.uri }),
                    $p = $("<p />");
                if (album.images && album.images.length) {
                    $a.append( $( "<img />", { src: album.images[0] } ) );
                } else {
                    $a.append( $( "<img />", { src: $.mopidy.defaultImage } ) );
                }
                $a.append( $("<h2 />", { text: album.name }) );
                if (album.artists && album.artists.length) {
                    $p.append($("<span />", { text: album.artists[0].name }));
                }
                $a.append($p);
                $li.append($a);
                return $li;
            },
            "Playlist": function(playlist) {
                var $li = $("<li />"),
                    $a = $("<a />", { href: playlist.uri, text: playlist.name });
                $a.data( "model", playlist );
                $li.append($a);
                return $li;
            },
            "Ref": function(ref) {
                var $li = $("<li />", ref.type === "track" ? { "data-icon": false } : {}),
                    $a = $("<a />", { href: ref.uri, text: ref.name || "" });
                $li.append($a);
                return $li;
            },
        },

        trackrel: {
            uri: function( track ) {
                return track.uri;
            },
            name: function( track ) {
                return track.name;
            },
            artists: function( track ) {
                return getArtistNames( track.artists ).join( ", " );
            },
            composers: function( track ) {
                return getArtistNames( track.composers ).join( ", " );
            },
            performers: function( track ) {
                return getArtistNames( track.performers ).join( ", " );
            },
            genre: function( track ) {
                return track.genre;
            },
            trackno: function( track ) {
                return track.track_no;
            },
            date: function( track ) {
                return track.date;
            },
            length: function( track ) {
                return track.length;
            },
            comment: function( track ) {
                return track.comment;
            },
            albumuri: function( track ) {
                return track.album && track.album.uri;
            },
            albumname: function( track ) {
                return track.album && track.album.name;
            },
            albumartists: function( track ) {
                return getArtistNames( track.album && track.album.artists ).join( ", " );
            },
            albumdate: function( track ) {
                return track.album && track.album.date;
            }
        },

        _listitem: function(model) {
            var $li = $.mopidy.itemCallbacks[model.__model__](model);
            $li.data("model", model);
            return $li;
        },
    });
})( jQuery, this );

(function( $, window, undefined ) {
    var mopidy = new Mopidy(),
        deferred = $.Deferred(),
        requests = {},
        timeout;

    mopidy.on(console.log.bind(console));
    mopidy.on( "state:online", function() {
        deferred.resolveWith( mopidy );
    });
    mopidy.on( "state:offline", function() {
        // FIXME: make configurable, use popup?
        $( ":mobile-pagecontainer" ).pagecontainer( "change", "#offline", {
            role: "dialog"
        });
        deferred = $.Deferred();
    });
    mopidy.on( "websocket:outgoingMessage", function( event ) {
        if ( $.isEmptyObject( requests ) ) {
            timeout = window.setTimeout(function() {
                $.mobile.loading( "show" );
            }, $.mopidy.loadMessageDelay );
        }
        requests[event.id] = null;
    });
    mopidy.on( "websocket:incomingMessage", function( event ) {
        var data = $.parseJSON( event.data );
        if ( data.id !== undefined ) {
            delete requests[data.id];
            if ( $.isEmptyObject( requests ) ) {
                window.clearTimeout( timeout );
                $.mobile.loading( "hide" );
            }
        }
    });

    $.extend( $.mopidy, {
        connect: function() {
            return deferred.promise();
        },
    });
})( jQuery, this );

(function( $, window, undefined ) {

    $.widget( "mopidy.library", $.mobile.listview, {
	initSelector: ":jqmData(role='library')",

        options: {
            model: null,
            history: [],
            uri: null
        },

        back: function() {
            var model = this.options.history.pop();
            if ( model !== undefined ) {
                this._browse( model );
            }
        },

        _create: function() {
            this._super();
            var library = this,
                $library = this.element,
                add = $library.data( "add" ),
                back = $library.data( "back" ),
                title = $library.data( "title" );

            if ( add ) {
                $( add ).click(function() {
                    var uris = [];
                    $library.find( "li" ).each(function() {
                        var $this = $( this ),
                            model = $this.data( "model" );
                        if (model.type !== "directory") {
                            uris.push(model.uri);
                        }
                    });
                    if (uris.length) {
                        $.mopidy.connect().then(function() {
                            var mopidy = this,
                                i;
                            mopidy.tracklist.add(null, null, uris[0]).then(function(tlTracks) {
                                if (tlTracks.length) {
                                    mopidy.playback.play(tlTracks[0]);
                                }
                            });
                            for (i = 1; i !== uris.length; ++i) {
                                mopidy.tracklist.add(null, null, uris[i]);
                            }
                        });
                    }
                });
            }

            if ( back ) {
                $( back ).click(function() {
                    $library.parent().find( ".ui-input-search input" ).val( "" );
                    library.back();
                });
            }
            if ( title ) {
                library.$title = $(title);
                library.deftitle = $(title).text();
            }
            $library.on( "filterablebeforefilter", function ( e, data ) {
                e.preventDefault();
                var $input = $( data.input ),
                    query = $input.val();
                if ( query && query.length > 0 ) {
                    library._search( query );
                } else {
                    library._browse( library.options.model );
                }
            });
            $library.on( "click", "a", function( event ) {
                var $a = $(this),
                    $li = $a.parent();
                event.preventDefault();
                $.mopidy.connect().then(function() {
                    var mopidy = this,
                        model = $li.data("model");
                    if (model.type === "directory") {
                        library.options.history.push( library.options.model );
                        library._browse( model );
                    } else if (model.uri) {
                        mopidy.tracklist.add(null, null, model.uri).then(function(tlTracks) {
                            mopidy.playback.play(tlTracks[0]);
                        });
                    }
                });
            });

            $.mopidy.connect().then(function() {
                console.log("library:online");
                library._browse( null );
            });
	},

        _browse: function( model ) {
            var library = this,
                $library = this.element,
                uri = model ? model.uri : null;
            $.mopidy.connect().then(function() {
                this.library.browse( uri ).then(function( refs ) {
                    var i;
                    if ( library.$title ) {
                        library.$title.text( model ? model.name : library.deftitle );
                    }
                    library.options.model = model;
                    library.options.uri = uri;
                    $library.empty();
                    for ( i = 0; i !== refs.length; ++i ) {
                        $library.append( $.mopidy._listitem( refs[i] ) );
                    }
                    $library.library( "refresh" );
                    $library.trigger( "updatelayout");
                });
            });
        },

        _search: function( query ) {
            var $library = this.element,
                uris = this.options.uri ? [this.options.uri] : undefined;
            $.mopidy.connect().then(function() {
                this.library.search( { any: query }, uris ).then(function( results ) {
                    $library.empty();
                    $.each( results, function() {
                        var i;
                        if ( this.artists ) {
                            for ( i = 0; i !== this.artists.length; ++i ) {
                                $library.append( $.mopidy._listitem( this.artists[i] ) );
                            }
                        }
                        if ( this.albums ) {
                            for (i = 0; i !== this.albums.length; ++i) {
                                $library.append( $.mopidy._listitem( this.albums[i]) );
                            }
                        }
                        if ( this.tracks ) {
                            for (i = 0; i !== this.tracks.length; ++i) {
                                $library.append( $.mopidy._listitem( this.tracks[i]) );
                            }
                        }
                    });

                    $library.library( "refresh" );
                    $library.trigger( "updatelayout");
                });
            });
        },
    });
})( jQuery, this );

(function( $, window, undefined ) {
    var PAUSED = "paused",
        PLAYING = "playing",
        STOPPED = "stopped",
        controlActive = {
            play: [PAUSED, STOPPED],
            pause: [PLAYING],
            resume: [PAUSED],
            stop: [PLAYING, PAUSED, STOPPED]
        };

    $.widget( "mopidy.playback", {
        initSelector: ":jqmData(role='playback')",

        selector: ":jqmData(rel)",  // (rel|=mopidy)

        options: $.extend( {}, $.mopidy.playbackState ),

        _create: function() {
            var playback = this,
            $playback = this.element;
            this.$controls = this.element.find( this.selector );

            // TODO: global state - query on mopidyinit?
            // assume initially stopped
            playback._handleState("stopped");
            $.mopidy.connect().then(function() {
                this.on( "state:online", function() {
                    console.log( "playback reconnect" );
                    playback._initControls( this );
                });
                this.on( "event:playbackStateChanged", function(event) {
                    playback._handleState(event.new_state);
                });
                playback._initControls( this );
            });
            $playback.on( "click", ":jqmData(rel='play')", function( event ) {
                event.preventDefault();
                playback.play();
            });
            $playback.on( "click", ":jqmData(rel='pause')", function( event ) {
                event.preventDefault();
                playback.pause();
            });
            $playback.on( "click", ":jqmData(rel='resume')", function( event ) {
                event.preventDefault();
                playback.resume();
            });
            $playback.on( "click", ":jqmData(rel='stop')", function( event ) {
                event.preventDefault();
                playback.stop();
            });
            $playback.on( "click", ":jqmData(rel='next')", function( event ) {
                event.preventDefault();
                playback.next();
            });
            $playback.on( "click", ":jqmData(rel='previous')", function( event ) {
                event.preventDefault();
                playback.prev();
            });
            $playback.on( "change", ":jqmData(rel='mute')", function() {
                playback.mute( $( this ).prop( "checked" ) );
            });
            $playback.on("change", ":jqmData(rel='volume')", function() {
                playback.volume( $( this ).val() );
            });
        },

        _initControls: function( mopidy ) {
            var widget = this,
                $element = this.element;
            mopidy.playback.getState().then(function( state ) {
                widget._handleState(state);
            });
            mopidy.playback.getMute().then(function( mute ) {
                widget._handleMute(mute);
            });
            mopidy.playback.getVolume().then(function( volume ) {
                widget.options.volume = volume;
                $element.find( ":jqmData(rel='volume')" ).each(function() {
                    $( this ).val( volume );
                    $( this ).slider( "refresh" );
                });
            });
            mopidy.playback.getCurrentTlTrack().then(function( tlTrack ) {
                widget._handleTrack( tlTrack );
            });
        },

        _handleState: function( state ) {
            this.options.state = state;
            this.$controls.each(function() {
                var $this = $( this ),
                    rel = $this.data( "rel" );
                if (rel in controlActive) {
                    if ($.inArray( state, controlActive[rel] ) >= 0) {
                        $this.show();
                    } else {
                        $this.hide();
                    }
                }
            });
        },

        _handleMute: function( mute ) {
            this.options.mute = mute;
            this.$controls.each(function() {
                var $this = $( this ),
                    rel = $this.data( "rel" );
                if ( rel === "mute" ) {
                    $this.prop( "checked", mute );
                }
            });
        },

        play: function() {
            $.mopidy.connect().then(function() {
                this.playback.play();
            });
        },

        stop: function() {
            $.mopidy.connect().then(function() {
                this.playback.stop();
            });
        },

        pause: function() {
            $.mopidy.connect().then(function() {
                this.playback.pause();
            });
        },

        resume: function() {
            $.mopidy.connect().then(function() {
                this.playback.resume();
            });
        },

        next: function() {
            $.mopidy.connect().then(function() {
                this.playback.next();
            });
        },

        prev: function() {
            $.mopidy.connect().then(function() {
                this.playback.previous();
            });
        },

        mute: function( mute ) {
            $.mopidy.connect().then(function() {
                this.playback.setMute( mute );
            });
        },

        volume: function( volume ) {
            $.mopidy.connect().then(function() {
                this.playback.setVolume( parseInt( volume ) );
            });
        }
    });
})( jQuery, this );

(function( $, window, undefined ) {
    $.widget( "mopidy.playlists", $.mobile.listview, {
	initSelector: ":jqmData(role='playlists')",

        _create: function() {
            var widget = this;
            widget._super();

            widget.element.on( "click", "a", function( e ) {
                e.preventDefault();
                var model = $( this ).data( "model" );
                if (model && model.__model__ === "Track") {
                    $.mopidy.connect().then(function() {
                        var mopidy = this;
                        mopidy.tracklist.add(null, null, model.uri).then(function( tlTracks ) {
                            mopidy.playback.play( tlTracks[0] );
                        });
                    });
                } else if (model && model.__model__ === "Playlist") {
                    $.mopidy.connect().then(function() {
                        var mopidy = this;
                        mopidy.playlists.lookup( model.uri ).then(function( playlist ) {
                            widget.element.empty();
                            widget.element.append( $.map( playlist.tracks, $.mopidy._listitem ) );
                            widget.refresh();
                        });
                    });
                } else {
                    console.log( "Tracklist: Invalid model:" + (model || "none") );
                }
            });

            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.on( "event:playlistsLoaded", function() {
                    widget._loadPlaylists( mopidy );
                });
                mopidy.on( "event:playlistChanged", function( playlist ) {
                    widget._updatePlaylist( mopidy, playlist );
                });
                widget._loadPlaylists( mopidy );
            });
	},

        _loadPlaylists: function( mopidy ) {
            var $element = this.element;
            mopidy.playlists.getPlaylists().then(function( playlists ) {
                $element.empty();
                $element.append( $.map( playlists, $.mopidy._listitem ) );
                $element.playlists( "refresh" );
            });
        },

        back: function() {
            var widget = this;
            $.mopidy.connect().then(function() {
                widget._loadPlaylists( this );
            });
        }
    });
})( jQuery, this );

(function( $, window, undefined ) {
    $.widget( "mopidy.tracklist", $.mobile.listview, {
	initSelector: ":jqmData(role='tracklist')",

        selectedClass: "ui-btn-active",

        _create: function() {
            var widget = this;
            widget._super();

            widget.element.on( "click", "a", function( e ) {
                e.preventDefault();
                var model = $( this ).data( "model" );
                if (model && model.__model__ === "TlTrack") {
                    $.mopidy.connect().then(function() {
                        this.playback.play( model );
                    });
                } else {
                    console.log( "Tracklist: Invalid model:", model || "none" );
                }
            });

            widget.element.on( "swipeleft", "li", function() {
                var $li = $( this ),
                    model = $li.data( "model" );
                if ( $.support.cssTransform3d ) {
                    $li
                    // Add the class for the transition direction
                    .addClass( "left" )
                    // When the transition is done...
                    .on( "webkitTransitionEnd transitionend otransitionend", function() {
                        $.mopidy.connect().then(function() {
                            this.tracklist.remove({ tlid: [ model.tlid ] });
                        });
                    })
                    // During the transition the previous button gets bottom border
                    .prev( "li" ).children( "a" ).addClass( "border-bottom" )
                    // Remove the highlight
                    .end().end().children( ".ui-btn" ).removeClass( "ui-btn-active" );
                }
                else {
                    $.mopidy.connect().then(function() {
                        this.tracklist.remove({ tlid: [ model.tlid ] });
                    });
                }
            });

            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.on( "state:online", function() {
                    console.log( "tracklist reconnect" );
                    widget._loadTracklist( mopidy );
                });
                mopidy.on( "event:tracklistChanged", function() {
                    widget._loadTracklist( mopidy );
                });
                mopidy.on( "event:trackPlaybackStarted", function( event ) {
                    widget._newTrack( event.tl_track );
                });
                widget._loadTracklist( mopidy );
            });
	},

        _loadTracklist: function( mopidy ) {
            var widget = this,
                $element = this.element;
            mopidy.tracklist.getTlTracks().then(function( tlTracks ) {
                $element.empty();
                $element.append( $.map( tlTracks, $.mopidy._listitem ) );
                mopidy.playback.getCurrentTlTrack().then(function( tlTrack ) {
                    widget._newTrack( tlTrack );
                });
                $element.tracklist( "refresh" );
            });
        },

        _newTrack: function( tlTrack ) {
            var $selected = this.element.find( "li[value=" + tlTrack.tlid + "]" );
            this.element.find( "li > a" ).removeClass( this.selectedClass );
            $selected.find( "a" ).addClass( this.selectedClass );
        },

        clear: function() {
            $.mopidy.connect().then(function() {
                this.tracklist.clear();
            });
        }
    });
})( jQuery, this );

(function( $, window, undefined ) {
    $.widget( "mopidy.trackview", {
	initSelector: ":jqmData(role='trackview')",

        selector: ":jqmData(rel)",  // (rel|=mopidy)

        options: { },

        _create: function() {
            var trackview = this;
            trackview.$elements = this.element.find( this.selector );
            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.on( "state:online", function() {
                    console.log( "trackview reconnect" );
                    mopidy.playback.getCurrentTlTrack().then(function( tlTrack ) {
                        trackview._handleTrack( tlTrack );
                    });
                });
                mopidy.on( "event:trackPlaybackStarted", function( event ) {
                    trackview._handleTrack( event.tl_track );
                });
                mopidy.playback.getCurrentTlTrack().then(function( tlTrack ) {
                    trackview._handleTrack( tlTrack );
                });
            });
	},

        _handleTrack: function( tlTrack ) {
            var track = tlTrack.track;
            this.$elements.each(function() {
                var $this = $( this ),
                    rel = $this.data("rel"),
                    fn = $.mopidy.trackrel[rel];
                if (fn) {
                    $this.text( fn( track ) || "" );
                } else if (rel === "image") {
                    if (track.album && track.album.images && track.album.images.length) {
                        $this.attr( "src", track.album.images[0] );
                    } else {
                        $this.attr( "src", $.mopidy.defaultImage );
                    }
                }
            });
        },
    });
})( jQuery, this );

(function( $, window, undefined ) {

    $( window ).on( "navigate", function( event, data ) {
        console.log("navigate:", event, data);
    });

    $(window.document).on( "pagecreate", function(e) {
        $(e.target).find($.mopidy.playback.prototype.initSelector).playback();
        $(e.target).find($.mopidy.tracklist.prototype.initSelector).tracklist();
        $(e.target).find($.mopidy.playlists.prototype.initSelector).playlists();
    });
})( jQuery, this );


}));
