(function (root, doc, factory) {
    if (typeof define === "function" && define.amd) {
	define(["jquery"], function ($) {
	    factory($, root, doc);
	    return $.mobile;
	});
    } else {
	factory(root.jQuery, root, doc);
    }
}(this, document, function(jQuery, window, document, undefined) {
(function( $, window, undefined ) {
        $.mopidy = {};
})( jQuery, this );

(function($, undefined) {

    var swipeCss = {
        left: {
            "-webkit-transition": "-webkit-transform 250ms ease;",
            "-webkit-transform": "translateX(-100%);",
            "-moz-transition": "-moz-transform 250ms ease;",
            "-moz-transform": "translateX(-100%);",
            "-o-transition": "-o-transform 250ms ease;",
            "-o-transform": "translateX(-100%);",
            "transition": "transform 250ms ease;",
            "transform": "translateX(-100%);"
        },
        right: {
            "-webkit-transition": "-webkit-transform 250ms ease;",
            "-webkit-transform": "translateX(100%);",
            "-moz-transition": "-moz-transform 250ms ease;",
            "-moz-transform": "translateX(100%);",
            "-o-transition": "-o-transform 250ms ease;",
            "-o-transform": "translateX(100%);",
            "transition": "transform 250ms ease;",
            "transform": "translateX(100%);"
        }
    };

    function wrapAnchor(anchor, model, icon) {
        return $("<li />", {"data-icon": icon}).append(anchor.data("model", model));
    }

    function getAlbumImageURI(album) {
        if (album && album.images && album.images.length) {
            return album.images[0];
        } else {
            return $.mopidy.defaultImage;
        }
    }

    function getArtists(artists) {
        if (artists && artists.length) {
            return $.map(artists, function (artist) {
                return artist.name;
            }).join(", ");
        } else {
            return "";
        }

    }

    $.extend( $.mopidy, {

        loadMessageDelay: 50,

        defaultImage: "images/mopidy.png",

        itemCallbacks: {
            "TlTrack": function(tlTrack, icon) {
                var track = tlTrack.track,
                    text = getArtists(track.artists);
                if (track.album && track.album.name) {
                    text += " - " + track.album.name;
                }
                return wrapAnchor(
                    $("<a />", {href: track.uri})
                        .append($("<img />", {src: getAlbumImageURI(track.album)}))
                        .append($("<h1 />", {text: track.name || ""}))
                        .append($("<p />", {text: text})),
                    tlTrack,
                    icon !== undefined ? icon : false
                ).val(tlTrack.tlid);
            },
            "Track": function(track, icon) {
                var text = getArtists(track.artists);
                if (track.album && track.album.name) {
                    text += " - " + track.album.name;
                }
                return wrapAnchor(
                    $("<a />", {href: track.uri})
                        .append($("<img />", {src: getAlbumImageURI(track.album)}))
                        .append($("<h1 />", {text: track.name || ""}))
                        .append($("<p />", {text: text})),
                    track,
                    icon !== undefined ? icon : false
                );
            },
            "Album": function(album, icon) {
                return wrapAnchor(
                    $("<a />", {href: album.uri})
                        .append($("<img />", {src: getAlbumImageURI(album)}))
                        .append($("<h1 />", {text: album.name || ""}))
                        .append($("<p />", {text: getArtists(album.artists)})),
                    album,
                    icon !== undefined ? icon : false
                );
            },
            "Artist": function(artist, icon) {
                return wrapAnchor(
                    $("<a />", {href: artist.uri, text: artist.name || ""}),
                    artist,
                    icon !== undefined ? icon : false
                );
            },
            "Ref": function(ref, icon) {
                return wrapAnchor(
                    $("<a />", {href: ref.uri, text: ref.name || ""}),
                    ref,
                    icon !== undefined ? icon : ref.type === "track" ? false : undefined
                );
            },
        },

        _listitem: function(model) {
            var $li = $.mopidy.itemCallbacks[model.__model__](model);
            $li.data("model", model);
            return $li;
        },

        mapKey: function(array, key) {
            return $.map(array, function(e) { return e[key]; });
        },

        swipe: function($element, direction, callback) {
            if ($.support.cssTransform3d) {
                swipeCss;
                $element
                    .addClass(direction)
                    //.css(swipeCss[direction])
                    .on("webkitTransitionEnd transitionend otransitionend", callback)
                    .prev("li").children("a").addClass("border-bottom")
                    .end().end().children(".ui-btn").removeClass("ui-btn-active");
            } else {
                callback();
            }
        },

    });
})(jQuery);

(function( $, window, undefined ) {
    var mopidy = new Mopidy({callingConvention: "by-position-only"}),
        deferred = $.Deferred(),
        requests = {},
        timeout;

    mopidy.on(console.log.bind(console));
    mopidy.on( "state:online", function() {
        deferred.resolveWith( mopidy );
    });
    mopidy.on( "state:offline", function() {
        // FIXME: make configurable, use popup?
        $( ":mobile-pagecontainer" ).pagecontainer( "change", "#offline", {
            role: "dialog"
        });
        deferred = $.Deferred();
    });
    mopidy.on( "websocket:outgoingMessage", function( event ) {
        if ( $.isEmptyObject( requests ) ) {
            timeout = window.setTimeout(function() {
                $.mobile.loading( "show" );
            }, $.mopidy.loadMessageDelay );
        }
        requests[event.id] = null;
    });
    mopidy.on( "websocket:incomingMessage", function( event ) {
        var data = $.parseJSON( event.data );
        if ( data.id !== undefined ) {
            delete requests[data.id];
            if ( $.isEmptyObject( requests ) ) {
                window.clearTimeout( timeout );
                $.mobile.loading( "hide" );
            }
        }
    });

    $.extend( $.mopidy, {
        connect: function() {
            return deferred.promise();
        },
    });
})( jQuery, this );

(function( $, window, undefined ) {

    $.widget( "mopidy.library", $.mobile.listview, {
	initSelector: ":jqmData(role='library')",

        options: {
            model: null,
            history: [],
            uri: null
        },

        back: function() {
            var model = this.options.history.pop();
            if ( model !== undefined ) {
                this._browse( model );
            }
        },

        _create: function() {
            this._super();
            var library = this,
                $library = this.element,
                add = $library.data( "add" ),
                back = $library.data( "back" ),
                title = $library.data( "title" );

            if ( add ) {
                $( add ).click(function() {
                    var uris = [];
                    $library.find( "li" ).each(function() {
                        var $this = $( this ),
                            model = $this.data( "model" );
                        if (model.type !== "directory") {
                            uris.push(model.uri);
                        }
                    });
                    if (uris.length) {
                        $.mopidy.connect().then(function() {
                            var mopidy = this,
                                i;
                            mopidy.tracklist.add(null, null, uris[0]).then(function(tlTracks) {
                                if (tlTracks.length) {
                                    mopidy.playback.play(tlTracks[0]);
                                }
                            });
                            for (i = 1; i !== uris.length; ++i) {
                                mopidy.tracklist.add(null, null, uris[i]);
                            }
                        });
                    }
                });
            }

            if ( back ) {
                $( back ).click(function() {
                    $library.parent().find( ".ui-input-search input" ).val( "" );
                    library.back();
                });
            }
            if ( title ) {
                library.$title = $(title);
                library.deftitle = $(title).text();
            }
            $library.on( "filterablebeforefilter", function ( e, data ) {
                e.preventDefault();
                var $input = $( data.input ),
                    query = $input.val();
                if ( query && query.length > 0 ) {
                    library._search( query );
                } else {
                    library._browse( library.options.model );
                }
            });
            $library.on( "click", "a", function( event ) {
                var $a = $(this),
                    $li = $a.parent();
                event.preventDefault();
                $.mopidy.connect().then(function() {
                    var mopidy = this,
                        model = $li.data("model");
                    if (model.type === "directory") {
                        library.options.history.push( library.options.model );
                        library._browse( model );
                    } else if (model.uri) {
                        mopidy.tracklist.add(null, null, model.uri).then(function(tlTracks) {
                            mopidy.playback.play(tlTracks[0]);
                        });
                    }
                });
            });

            $.mopidy.connect().then(function() {
                console.log("library:online");
                library._browse( null );
            });
	},

        _browse: function( model ) {
            var library = this,
                $library = this.element,
                uri = model ? model.uri : null;
            $.mopidy.connect().then(function() {
                this.library.browse( uri ).then(function( refs ) {
                    var i;
                    if ( library.$title ) {
                        library.$title.text( model ? model.name : library.deftitle );
                    }
                    library.options.model = model;
                    library.options.uri = uri;
                    $library.empty();
                    for ( i = 0; i !== refs.length; ++i ) {
                        $library.append( $.mopidy._listitem( refs[i] ) );
                    }
                    $library.library( "refresh" );
                    $library.trigger( "updatelayout");
                });
            });
        },

        browse: function(uri) {
            uri;
        },

        findExact: function(query, uris) {
            query;
            uris;
        },

        _lookup: function(uri) {
            uri;
        },

        //refresh: function(uri) {
        //    if (uri !== undefined) {
        //        $.mopidy.connect().then(function() {
        //            this.library.refresh(uri);
        //        });
        //    }
        //    this._super();
        //},

        search: function(query, uris) {
            query;
            uris;
        },

        _search: function( query ) {
            var $library = this.element,
                uris = this.options.uri ? [this.options.uri] : undefined;
            $.mopidy.connect().then(function() {
                this.library.search( { any: [ query ] }, uris ).then(function( results ) {
                    $library.empty();
                    $.each( results, function() {
                        var i;
                        if ( this.artists ) {
                            for ( i = 0; i !== this.artists.length; ++i ) {
                                $library.append( $.mopidy._listitem( this.artists[i] ) );
                            }
                        }
                        if ( this.albums ) {
                            for (i = 0; i !== this.albums.length; ++i) {
                                $library.append( $.mopidy._listitem( this.albums[i]) );
                            }
                        }
                        if ( this.tracks ) {
                            for (i = 0; i !== this.tracks.length; ++i) {
                                $library.append( $.mopidy._listitem( this.tracks[i]) );
                            }
                        }
                    });

                    $library.library( "refresh" );
                    $library.trigger( "updatelayout");
                });
            });
        },
    });
})( jQuery, this );

(function ($, window, undefined) {

    // TODO:
    // - define & trigger change events
    // - toggle control (play/pause)
    // - update volume/seek on events (but not if source)
    // - handle non-slider input for volume/seek
    // - hide/disable controls if not available for current state
    // - refresh/trigger "updatelayout" on hide/show?
    // - refresh (check for new controls)?
    // - calculate/update timePosition?

    $.widget("mopidy.playback", {

        initSelector: ":jqmData(role='playback')",

        options: {
            controls: ":jqmData(rel)",
        },

        _create: function() {
            var widget = this,
                $widget = this.element;

            this._mute = null;
            this._state = null;
            this._track = null;
            this._volume = null;
            this.$controls = $widget.find(this.options.controls);

            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.on("event:muteChanged", function(event) {
                    widget._setMute(event.mute);
                });
                mopidy.on("event:playbackStateChanged", function(event) {
                    widget._setState(event.new_state);
                });
                //mopidy.on("event:seeked", function(event) {
                //    //var timePosition = event.time_position;
                //    //if (widget.options.timePosition !== timePosition) {
                //    //    widget.options.timePosition = timePosition;
                //    //    //$controls.filter(":jqmData(rel='seek')").val(timePosition);
                //    //    //$controls.filter(":jqmData(rel='seek')").slider("refresh");
                //    //}
                //});
                mopidy.on("event:trackPlaybackEnded", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:trackPlaybackPaused", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:trackPlaybackResumed", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:trackPlaybackStarted", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:volumeChanged", function(event) {
                    widget._setVolume(event.volume);
                });
            });

            this.$controls.on("click", function(event) {
                var rel = $(this).jqmData("rel");
                if ($.inArray(rel, ["next", "pause", "play", "previous", "resume", "stop"]) !== -1) {
                    $widget.playback(rel);
                    event.preventDefault();  // necessary?
                }
            });

            this.$controls.on("change", function() {
                var $this = $(this);
                switch ($this.jqmData("rel")) {
                case "mute":
                    $widget.playback("mute", $this.prop("checked"));
                    break;
                case "seek":
                    //$widget.playback("option", "timePosition", parseInt($this.val()));
                    break;
                case "volume":
                    $widget.playback("volume", parseInt($this.val()));
                    break;
                }
            });
        },

        _init: function() {
            var widget = this;
            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.playback.getCurrentTlTrack().then(function(tlTrack) {
                    widget._setTrack(tlTrack);
                });
                mopidy.playback.getMute().then(function(mute) {
                    widget._setMute(mute);
                });
                mopidy.playback.getState().then(function(state) {
                    widget._setState(state);
                });
                mopidy.playback.getTimePosition().then(function(time_position) {
                    widget._timePosition = time_position;
                });
                mopidy.playback.getVolume().then(function(volume) {
                    widget._setVolume(volume);
                });
            });
            this._super();
        },

        _setMute: function(value) {
            if (this._mute !== value) {
                this._mute = value;
                this.$controls.filter(":jqmData(rel='mute')").val(value).checkboxradio("refresh");
                this._trigger("mutechange");
            }
        },

        _setState: function(state) {
            if (this._state !== state) {
                this.$controls.each(function() {
                    var $this = $(this);
                    switch ($this.jqmData("rel")) {
                    case "pause":
                        // TODO: stopped -> paused ok?
                        $this.prop("disabled", state === "paused");
                        break;
                    case "play":
                        // TODO: check state chart!
                        $this.prop("disabled", state === "playing");
                        break;
                    case "resume":
                        $this.prop("disabled", state !== "paused");
                        break;
                    case "stop":
                        $this.prop("disabled", state === "stopped");
                        break;
                    }
                });
                this._state = state;
                this._trigger("statechange");
            }
        },

        _setTrack: function(tlTrack) {
            var widget = this;
            if (this._track !== tlTrack) {
                $.mopidy.connect().then(function() {
                    this.tracklist.nextTrack(tlTrack).then(function(t) {
                        widget.$controls
                            .filter(":jqmData(rel='next')")
                            .prop("disabled", !t);
                    });
                    this.tracklist.previousTrack(tlTrack).then(function(t) {
                        widget.$controls
                            .filter(":jqmData(rel='previous')")
                            .prop("disabled", !t);
                    });
                });
                this._track = tlTrack;
                this._trigger("trackchange");
            }
        },

        _setVolume: function(value) {
            if (this._volume !== value) {
                this._volume = value;
                // FIXME!
                this.$controls.filter(":jqmData(rel='volume')").val(value).slider("refresh");
                this._trigger("volumechange");
            }
        },

        changeTrack: function(tlTrack, onErrorStep) {
            $.mopidy.connect().then(function() {
                if (onErrorStep !== undefined) {
                    this.playback.changeTrack(tlTrack, onErrorStep);
                } else {
                    this.playback.changeTrack(tlTrack);
                }
            });
        },

        getCurrentTlTrack: function() {
            return this._track;
        },

        getCurrentTrack: function() {
            return this._track ? this._track.track : null;
        },

        getTimePosition: function() {
        },

        mute: function(value) {
            if (value === undefined) {
                return this._mute;
            }
            value = Boolean(value); // ???
            if (this._mute !== value) {
                $.mopidy.connect().then(function() {
                    this.playback.setMute(value);
                });
            }
        },

        next: function() {
            $.mopidy.connect().then(function() {
                this.playback.next();
            });
        },

        pause: function() {
            $.mopidy.connect().then(function() {
                this.playback.pause();
            });
        },

        play: function(tlTrack, onErrorStep) {
            $.mopidy.connect().then(function() {
                if (onErrorStep !== undefined) {
                    this.playback.play(tlTrack, onErrorStep);
                } else {
                    this.playback.play(tlTrack);
                }
            });
        },

        previous: function() {
            $.mopidy.connect().then(function() {
                this.playback.previous();
            });
        },

        resume: function() {
            $.mopidy.connect().then(function() {
                this.playback.resume();
            });
        },

        seek: function(timePosition) {
            $.mopidy.connect().then(function() {
                this.playback.seek(timePosition);
            });
        },

        state: function(value) {
            if (value === undefined) {
                return this._state;
            }
            if (this._state !== value) {
                $.mopidy.connect().then(function() {
                    this.playback.setState(value);
                });
            }
        },

        stop: function(clearCurrentTrack) {
            $.mopidy.connect().then(function() {
                this.playback.stop(clearCurrentTrack);
            });
        },

        volume: function(value) {
            if (value === undefined) {
                return this._volume;
            }
            value = parseInt(value); // ???
            if (this._volume !== value) {
                $.mopidy.connect().then(function() {
                    this.playback.setVolume(value);
                });
            }
        }
    });
})(jQuery, this);

(function($, window, undefined) {

    function defaultAnchorCallback(track) {
        return $("<a />", {href: track.uri, text: track.name || ""});
    }

    $.widget("mopidy.playlists", $.mobile.collapsibleset, {

	initSelector: ":jqmData(role='playlists')",

        options: {
            anchorCallback: defaultAnchorCallback
        },

        _create: function() {
            var widget = this;
            this._super();

            this._on({
                "click li a": function(event) {
                    var $item = $(event.currentTarget).closest("li"),
                        $playlist = $item.closest(".ui-collapsible"),
                        tracks = $playlist.data("model").tracks,
                        index = $item.index();
                    $.mopidy.connect().then(function() {
                        var tracklist = this.tracklist,
                            playback = this.playback;
                        tracklist.clear().then(function() {
                            tracklist.add(tracks).then(function(tlTracks) {
                                playback.play(tlTracks[index]);
                            });
                        });
                    });
                    event.preventDefault();
                }
            });

            $.mopidy.connect().then(function() {
                var mopidy = this;
                this.on("event:playlistChanged", function(/*playlist*/) {
                    widget._getPlaylists(mopidy);
                });
                this.on("event:playlistsLoaded", function() {
                    widget._getPlaylists(mopidy);
                });
                widget._getPlaylists(mopidy);
            });

        },

        _getPlaylists: function(mopidy) { // includeTracks?
            var $element = this.element,
                options = this.options;
            mopidy.playlists.getPlaylists().then(function(playlists) {
                var $collapsibles = $.map(playlists, function(playlist) {
                    var $items = $.map(playlist.tracks || [], function(track) {
                        return $("<li />", {"data-icon": false})
                            .append(options.anchorCallback(track))
                            .data("model", track);
                    });
                    return $("<div />")
                        .append($("<h1 />", {text: playlist.name || ""}))
                        .append($("<ul />").append($items).listview())
                        .collapsible({inset: options.inset})
                        .data("model", playlist);
                });
                $element.empty().append($collapsibles);
                $element.playlists("refresh");
            });
        },

        create: function(name, uriScheme) {
            $.mopidy.connect().then(function() {
                this.playlists.create(name, uriScheme);
            });
        },

        delete: function(uri) {
            $.mopidy.connect().then(function() {
                this.playlists.delete(uri);
            });
        },

        refresh: function(uriScheme) {
            if (uriScheme !== undefined) {
                $.mopidy.connect().then(function() {
                    this.playlists.refresh(uriScheme);
                });
            }
            this._super();
        },

        save: function(playlist) {
            $.mopidy.connect().then(function() {
                this.playlists.save(playlist);
            });
        }
    });
})(jQuery, this);

(function($, window, undefined) {

    function defaultAnchorCallback(tlTrack) {
        var track = tlTrack.track,
            album = track.album || {},
            artists = track.artists || [],
            images = album.images || [],
            text = [];
        if (artists.length) {
            text.push($.mopidy.mapKey(artists, "name").join(", "));
        }
        if (album.name) {
            text.push(album.name);
        }
        return $("<a />", {href: track.uri})
            .append($("<img />", {src: images[0] || $.mopidy.defaultImage}))
            .append($("<h1 />", {text: track.name || ""}))
            .append($("<p />", {text: text.join(" - ")}));
    }

    $.widget("mopidy.tracklist", $.mobile.listview, {

	initSelector: ":jqmData(role='tracklist')",

        options: {
            anchorCallback: defaultAnchorCallback,
            consume: null,
            random: null,
            repeat: null,
            single: null
        },

        _create: function() {
            var $element = this.element,
                options = this.options,
                widget = this;
            this._super();

            this._currentTlId = null;

            this._tracklistOptions = {
                consume: null,
                random: null,
                repeat: null,
                single: null
            };

            this._on({
                "click li a": function(event) {
                    var $item = $(event.currentTarget).closest("li"),
                        model = $item.data("model");
                    $.mopidy.connect().then(function() {
                        this.playback.play(model);
                    });
                    event.preventDefault();
                },
                "swipeleft li": function(event) {
                    var $item = $(event.currentTarget),
                        model = $item.data("model");
                    $.mopidy.swipe($item, "left", function() {
                        widget.remove({tlid: [model.tlid]});
                    });
                }
            });

            // FIXME: _setOption, _init?
            $.each(["consume", "random", "repeat", "single"], function(i, option) {
                $(options[option]).on("change", function() {
                    $element.tracklist(option, $(this).prop("checked"));
                });
            });

            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.on("event:optionsChanged", function() {
                    widget._getTracklistOptions(mopidy);
                });
                mopidy.on("event:tracklistChanged", function() {
                    widget._getTlTracks(mopidy);
                });
                mopidy.on("event:trackPlaybackStarted", function(event) {
                    widget._updateCurrentTlId(event.tl_track.tlid);
                });
                mopidy.playback.getCurrentTlTrack().then(function(tlTrack) {
                    widget._updateCurrentTlId(tlTrack ? tlTrack.tlid : null);
                });
                widget._getTlTracks(mopidy);
                widget._getTracklistOptions(mopidy);
            });
	},

        _getTlTracks: function(mopidy) {
            var $element = this.element,
                anchorCallback = this.options.anchorCallback,
                widget = this;
            mopidy.tracklist.getTlTracks().then(function(tlTracks) {
                var $items = $.map(tlTracks, function(tlTrack) {
                    return $("<li />", {"data-icon": false})
                        .append(anchorCallback(tlTrack))
                        .data("model", tlTrack);
                });
                $element.empty().append($items).tracklist("refresh");
                widget._updateCurrentTlId(widget._currentTlId);
            });
        },

        _getTracklistOptions: function(mopidy) {
            var widget = this,
                tracklist = mopidy.tracklist;
            tracklist.getConsume().then(function(consume) {
                widget._updateTracklistOption("consume", consume);
            });
            tracklist.getRandom().then(function(random) {
                widget._updateTracklistOption("random", random);
            });
            tracklist.getRepeat().then(function(repeat) {
                widget._updateTracklistOption("repeat", repeat);
            });
            tracklist.getSingle().then(function(single) {
                widget._updateTracklistOption("single", single);
            });
        },

        _updateCurrentTlId: function(tlid) {
            this.element.children("li").each(function() {
                var $item = $(this),
                    model = $item.data("model");
                $item.find("a").toggleClass("ui-btn-active", model.tlid === tlid);
            });
            this._currentTlId = tlid;
        },

        _updateTracklistOption: function(key, value) {
            var tracklistOptions = this._tracklistOptions;
            if (tracklistOptions[key] !== value) {
                tracklistOptions[key] = value;
                if (this.options[key]) {
                    $(this.options[key]).prop("checked", value);
                    $(this.options[key]).checkboxradio("refresh"); // FIXME
                }
            }
        },

        add: function(what, position) {
            $.mopidy.connect().then(function() {
                switch ($.type(what)) {
                case "string":
                    this.tracklist.add(null, position, what);
                    break;
                case "array":
                    this.tracklist.add(what, position, null);
                    break;
                default:
                    // assuming single track
                    this.tracklist.add([what], position, null);
                    break;
                }
            });
        },

        clear: function() {
            $.mopidy.connect().then(function() {
                this.tracklist.clear();
            });
        },

        consume: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.consume;
            }
            if (tracklistOptions.consume !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setConsume(value);
                });
            }
        },

        move: function(start, end, to) {
            $.mopidy.connect().then(function() {
                this.tracklist.move(start, end, to);
            });
        },

        remove: function(criteria) {
            $.mopidy.connect().then(function() {
                this.tracklist.remove(criteria);
            });
        },

        random: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.random;
            }
            if (tracklistOptions.random !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setRandom(value);
                });
            }
        },

        repeat: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.repeat;
            }
            if (tracklistOptions.repeat !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setRepeat(value);
                });
            }
        },

        shuffle: function(start, end) {
            $.mopidy.connect().then(function() {
                this.tracklist.shuffle(start, end);
            });
        },

        single: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.single;
            }
            if (tracklistOptions.single !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setSingle(value);
                });
            }
        },

    });
})(jQuery, this);

(function($, window, undefined) {
    $(window.document).on("pagecreate", function(event) {
        $(event.target).find($.mopidy.playback.prototype.initSelector).playback();
        $(event.target).find($.mopidy.tracklist.prototype.initSelector).tracklist();
        $(event.target).find($.mopidy.playlists.prototype.initSelector).playlists();
    });
})(jQuery, this);


}));
