(function (root, doc, factory) {
    if (typeof define === "function" && define.amd) {
	define(["jquery"], function ($) {
	    factory($, root, doc);
	    return $.mobile;
	});
    } else {
	factory(root.jQuery, root, doc);
    }
}(this, document, function(jQuery, window, document, undefined) {
(function( $, window, undefined ) {
        $.mopidy = {};
})( jQuery, this );

(function($, undefined) {

    var swipeCss = {
        left: {
            "-webkit-transition": "-webkit-transform 250ms ease;",
            "-webkit-transform": "translateX(-100%);",
            "-moz-transition": "-moz-transform 250ms ease;",
            "-moz-transform": "translateX(-100%);",
            "-o-transition": "-o-transform 250ms ease;",
            "-o-transform": "translateX(-100%);",
            "transition": "transform 250ms ease;",
            "transform": "translateX(-100%);"
        },
        right: {
            "-webkit-transition": "-webkit-transform 250ms ease;",
            "-webkit-transform": "translateX(100%);",
            "-moz-transition": "-moz-transform 250ms ease;",
            "-moz-transform": "translateX(100%);",
            "-o-transition": "-o-transform 250ms ease;",
            "-o-transform": "translateX(100%);",
            "transition": "transform 250ms ease;",
            "transform": "translateX(100%);"
        }
    };

    function wrapAnchor(anchor, model, icon) {
        return $("<li />", {"data-icon": icon}).append(anchor.mopidyModel(model));
    }

    function getAlbumImageURI(album) {
        if (album && album.images && album.images.length) {
            return album.images[0];
        } else {
            return $.mopidy.defaultImage;
        }
    }

    function getArtists(artists) {
        if (artists && artists.length) {
            return $.map(artists, function (artist) {
                return artist.name;
            }).join(", ");
        } else {
            return "";
        }

    }

    $.extend( $.mopidy, {

        loadMessageDelay: 50,

        defaultImage: "images/mopidy.png",

        itemCallbacks: {
            "TlTrack": function(tlTrack, icon) {
                var track = tlTrack.track,
                    text = getArtists(track.artists);
                if (track.album && track.album.name) {
                    text += " - " + track.album.name;
                }
                return wrapAnchor(
                    $("<a />", {href: track.uri})
                        .append($("<img />", {src: getAlbumImageURI(track.album)}))
                        .append($("<h1 />", {text: track.name || ""}))
                        .append($("<p />", {text: text})),
                    tlTrack,
                    icon !== undefined ? icon : false
                ).val(tlTrack.tlid);
            },
            "Track": function(track, icon) {
                var text = getArtists(track.artists);
                if (track.album && track.album.name) {
                    text += " - " + track.album.name;
                }
                return wrapAnchor(
                    $("<a />", {href: track.uri})
                        .append($("<img />", {src: getAlbumImageURI(track.album)}))
                        .append($("<h1 />", {text: track.name || ""}))
                        .append($("<p />", {text: text})),
                    track,
                    icon !== undefined ? icon : false
                );
            },
            "Album": function(album, icon) {
                return wrapAnchor(
                    $("<a />", {href: album.uri})
                        .append($("<img />", {src: getAlbumImageURI(album)}))
                        .append($("<h1 />", {text: album.name || ""}))
                        .append($("<p />", {text: getArtists(album.artists)})),
                    album,
                    icon !== undefined ? icon : false
                );
            },
            "Artist": function(artist, icon) {
                return wrapAnchor(
                    $("<a />", {href: artist.uri, text: artist.name || ""}),
                    artist,
                    icon !== undefined ? icon : false
                );
            },
            "Ref": function(ref, icon) {
                return wrapAnchor(
                    $("<a />", {href: ref.uri, text: ref.name || ""}),
                    ref,
                    icon !== undefined ? icon : ref.type === "track" ? false : undefined
                );
            },
        },

        _listitem: function(model) {
            var $li = $.mopidy.itemCallbacks[model.__model__](model);
            $li.mopidyModel(model);
            return $li;
        },

        mapKey: function(array, key) {
            return $.map(array || [], function(e) { return e[key]; });
        },

        swipe: function($element, direction, callback) {
            if ($.support.cssTransform3d) {
                swipeCss;
                $element
                    .addClass(direction)
                    //.css(swipeCss[direction])
                    .on("webkitTransitionEnd transitionend otransitionend", callback)
                    .prev("li").children("a").addClass("border-bottom")
                    .end().end().children(".ui-btn").removeClass("ui-btn-active");
            } else {
                callback();
            }
        },

    });
})(jQuery);

(function( $, window, undefined ) {
    var mopidy = new Mopidy({callingConvention: "by-position-only"}),
        deferred = $.Deferred(),
        requests = {},
        timeout;

    mopidy.on(console.log.bind(console));
    mopidy.on( "state:online", function() {
        deferred.resolveWith( mopidy );
    });
    mopidy.on( "state:offline", function() {
        // FIXME: make configurable, use popup?
        $( ":mobile-pagecontainer" ).pagecontainer( "change", "#offline", {
            role: "dialog"
        });
        deferred = $.Deferred();
    });
    mopidy.on( "websocket:outgoingMessage", function( event ) {
        if ( $.isEmptyObject( requests ) ) {
            timeout = window.setTimeout(function() {
                $.mobile.loading( "show" );
            }, $.mopidy.loadMessageDelay );
        }
        requests[event.id] = null;
    });
    mopidy.on( "websocket:incomingMessage", function( event ) {
        var data = $.parseJSON( event.data );
        if ( data.id !== undefined ) {
            delete requests[data.id];
            if ( $.isEmptyObject( requests ) ) {
                window.clearTimeout( timeout );
                $.mobile.loading( "hide" );
            }
        }
    });

    $.extend( $.mopidy, {
        connect: function() {
            return deferred.promise();
        },
    });
})( jQuery, this );

(function($, undefined) {

    $.extend($.mopidy, {

        isRef: function(model, type) {
            return model.__model__ === "Ref" && (type === undefined || model.type === type);
        },

        isAlbum: function(model) {
            return model.__model__ === "Album";
        },

        isArtist: function(model) {
            return model.__model__ === "Artist";
        },

        isTrack: function(model) {
            return model.__model__ === "Track";
        },

        isPlaylist: function(model) {
            return model.__model__ === "Playlist";
        },

        getModelByUri: function(models, uri) {
            for (var i = 0; i !== models.length; ++i) {
                if ((models[i].track || models[i]).uri === uri) {
                    return models[i];
                }
            }
            return null;
        },

    });

    $.extend($.fn, {

        mopidyModel: function(value) {
	    if (value === undefined) {
		return this.data("model");
	    } else {
		return this.data("model", value);
	    }
	},

	mopidyRemoveModel: function() {
	    return this.removeData("model");
	},

    });

})(jQuery);

(function( $, window, undefined ) {

    function defaultRefClickCallback() {
        var $item = $(this),
            $library = $item.closest(":jqmData(role='library')"),
            parentUri = $library.library("getCurrentUri"),
            uri = $item.mopidyModel().uri;
        $.mopidy.connect().then(function() {
            var tracklist = this.tracklist,
                playback = this.playback;
            tracklist.clear().then(function() {
                tracklist.add(null, null, parentUri).then(function(tlTracks) {
                    var tlTrack = $.mopidy.getModelByUri(tlTracks, uri);
                    if (tlTrack) {
                        return playback.play(tlTrack);
                    }
                    tracklist.add(null, null, uri).then(function(tlTracks) {
                        return playback.play(tlTracks[0]);
                    });
                    $item.nextAll().each(function() {
                        var model = $(this).mopidyModel();
                        if ($.mopidy.isRef(model, "track")) {
                            tracklist.add(null, null, model.uri);
                        }
                    });
                    $item.prevAll().each(function() {
                        var model = $(this).mopidyModel();
                        if ($.mopidy.isRef(model, "track")) {
                            tracklist.add(null, 0, model.uri);
                        }
                    });
                });
            });
        });
    }

    function defaultAlbumClickCallback() {
        var $item = $(this),
            album = $item.mopidyModel();
        $.mopidy.connect().then(function() {
            var tracklist = this.tracklist,
                playback = this.playback;
            tracklist.clear().then(function() {
                tracklist.add(null, null, album.uri).then(function(tlTracks) {
                    playback.play(tlTracks[0]);
                });
            });
        });
    }

    function defaultArtistClickCallback() {
        var $item = $(this),
            artist = $item.mopidyModel();
        $.mopidy.connect().then(function() {
            var tracklist = this.tracklist,
                playback = this.playback;
            tracklist.clear().then(function() {
                tracklist.add(null, null, artist.uri).then(function(tlTracks) {
                    playback.play(tlTracks[0]);
                });
            });
        });
    }

    function defaultTrackClickCallback() {
        var $item = $(this),
            track = $item.mopidyModel(),
            prevTracks = $item.prevAll().map(function() {
                var model = $(this).mopidyModel();
                return $.mopidy.isTrack(model) ? model : null;
            }).get(),
            nextTracks = $item.nextAll().map(function() {
                var model = $(this).mopidyModel();
                return $.mopidy.isTrack(model) ? model : null;
            }).get(),
            tracks = [].concat(prevTracks, track, nextTracks);
        $.mopidy.connect().then(function() {
            var tracklist = this.tracklist,
                playback = this.playback;
            tracklist.clear().then(function() {
                tracklist.add(tracks).then(function(tlTracks) {
                    playback.play($.mopidy.getModelByUri(tlTracks, track.uri));
                });
            });
        });
    }

    function defaultRefItemCallback(ref) {
        var icon = ref.type === "track" ? false : undefined;
        return $("<li />", {"data-icon": icon})
            .append($("<a />", {href: ref.uri, text: ref.name || ""}))
            .mopidyModel(ref);
    }

    function defaultAlbumItemCallback(album) {
        var artists = $.mopidy.mapKey(album.artists, "name").join(", ");
        return $("<li />", {"data-icon": false})
            .append(
                $("<a />", {href: album.uri})
                    .append($("<h1 />", {text: album.name || ""}))
                    .append($("<p />", {text: artists}))
            )
            .mopidyModel(album);
    }

    function defaultArtistItemCallback(artist) {
        return $("<li />", {"data-icon": false})
            .append($("<a />", {href: artist.uri, text: artist.name || ""}))
            .mopidyModel(artist);
    }

    function defaultTrackItemCallback(track) {
        var album = track.album || {},
            artists = $.mopidy.mapKey(album.artists, "name").join(", "),
            text = [];
        if (artists.length) {
            text.push(artists);
        }
        if (album.name) {
            text.push(album.name);
        }
        return $("<li />", {"data-icon": false})
            .append(
                $("<a />", {href: track.uri})
                    .append($("<h1 />", {text: track.name || ""}))
                    .append($("<p />", {text: text.join(" - ")}))
            )
            .mopidyModel(track);
    }

    $.widget( "mopidy.library", $.mobile.listview, {

	initSelector: ":jqmData(role='library')",

        options: {
            back: null,
            forward: null,
            title: null  // label, caption?
        },

        _create: function() {
            var $element = this.element,
                options = this.options,
                widget = this;
            this._super();
            this._history = [];
            this._currentHistoryIndex = -1;

            this._on({
                "click li a": function(event) {
                    var $item = $(event.currentTarget).closest("li"),
                        model = $item.mopidyModel();
                    if ($.mopidy.isAlbum(model)) {
                        defaultAlbumClickCallback.call($item.get(), model);
                    } else if ($.mopidy.isArtist(model)) {
                        defaultArtistClickCallback.call($item.get(), model);
                    } else if ($.mopidy.isTrack(model)) {
                        defaultTrackClickCallback.call($item.get(), model);
                    } else if ($.mopidy.isRef(model, "track")) {
                        defaultRefClickCallback.call($item.get(), model);
                    } else {
                        $.mopidy.connect().then(function() {
                            widget._browse(this, model.uri);
                            widget._pushState(null, model.name, model.uri);
                        });
                    }
                    event.preventDefault();
                },
                "filterablebeforefilter": function(event, data) {
                    var $input = $(data.input),
                        query = $input.val(),
                        uri = widget.getCurrentUri();
                    $.mopidy.connect().then(function() {
                        if (query && query.length > 0) {
                            widget._search(this, {any: [query]}, uri ? [uri] : null);
                        } else {
                            widget._browse(this, uri);
                        }
                    });
                    event.preventDefault();
                    event.stopPropagation();
                }
            });

            // FIXME: _setOption, _init?
            $.each(["back", "forward"], function(i, option) {
                $(options[option]).on("click", function() {
                    $element.library(option);
                });
            });

            this._pushState(null, $(options.title).text(), null);
            this.go(0);
        },

        _pushState: function(state, title, uri) {
            var options = this.options,
                index = this._currentHistoryIndex + 1;
            $(options.back).toggle(index !== 0);
            $(options.forward).hide();
            $(options.title).text(title || "");
            this._history.splice(index, Number.MAX_VALUE, {
                state: state,
                title: title,
                uri: uri
            });
            this._currentHistoryIndex = index;
        },

        _browse: function(mopidy, uri) {
            var $element = this.element;
            mopidy.library.browse(uri).then(function(refs) {
                var $items = $.map(refs, defaultRefItemCallback);
                $element.empty().append($items).library("refresh");
            });
        },

        _search: function(mopidy, query, uris, exact) {
            var $element = this.element,
                promise;
            if (exact) {
                promise = mopidy.library.findExact(query, uris);
            } else {
                promise = mopidy.library.search(query, uris);
            }
            promise.then(function(results) {
                var $items = $.map(results || [], function(result) {
                    return [].concat(
                        $.map(result.artists || [], defaultArtistItemCallback),
                        $.map(result.albums || [], defaultAlbumItemCallback),
                        $.map(result.tracks || [], defaultTrackItemCallback)
                    );
                });
                $element.empty().append($items).library("refresh");
            });
        },

        back: function() {
            this.go(-1);
        },

        browse: function(uri) {
            var widget = this;
            $.mopidy.connect().then(function() {
                widget._browse(this, uri);
                widget._pushState(null, null, uri);
            });
        },

        findExact: function(query, uris) {
            var widget = this;
            $.mopidy.connect().then(function() {
                widget._search(this, query, uris, true);
                //widget._pushState({query: query, uris: uris, exact: true});
            });
        },

        forward: function() {
            this.go(+1);
        },

        getCurrentUri: function() {
            return this._history[this._currentHistoryIndex].uri;
        },


        go: function(delta) {
            var options = this.options,
                history = this._history,
                index = this._currentHistoryIndex + delta,
                widget = this;
            if (index >= 0 && index < history.length) {
                $.mopidy.connect().then(function() {
                    widget._browse(this, history[index].uri);
                });
                $(options.back).toggle(index > 0);
                $(options.forward).toggle(index < history.length - 1);
                $(options.title).text(history[index].title || "");
                this._currentHistoryIndex = index;
            }
        },

        refresh: function(/*uri*/) {
            // if (uri !== undefined) {
            //     $.mopidy.connect().then(function() {
            //         this.library.refresh(uri);
            //     });
            // }
            this._super();
        },

        search: function(query, uris) {
            var widget = this;
            $.mopidy.connect().then(function() {
                widget._search(this, query, uris, false);
                //widget._pushState({query: query, uris: uris, exact: false});
            });
        },

    });
})(jQuery, this);

(function ($, window, undefined) {

    $.widget("mopidy.playback", {

        initSelector: ":jqmData(role='playback')",

        options: {
            controls: ":jqmData(rel)",
        },

        _create: function() {
            var widget = this,
                $widget = this.element;

            this._mute = null;
            this._state = null;
            this._track = null;
            this._volume = null;
            this.$controls = $widget.find(this.options.controls);

            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.on("event:muteChanged", function(event) {
                    widget._setMute(event.mute);
                });
                mopidy.on("event:playbackStateChanged", function(event) {
                    widget._setState(event.new_state);
                });
                //mopidy.on("event:seeked", function(event) {
                //    //var timePosition = event.time_position;
                //    //if (widget.options.timePosition !== timePosition) {
                //    //    widget.options.timePosition = timePosition;
                //    //    //$controls.filter(":jqmData(rel='seek')").val(timePosition);
                //    //    //$controls.filter(":jqmData(rel='seek')").slider("refresh");
                //    //}
                //});
                mopidy.on("event:trackPlaybackEnded", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:trackPlaybackPaused", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:trackPlaybackResumed", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:trackPlaybackStarted", function(event) {
                    widget._setTrack(event.tl_track);
                });
                mopidy.on("event:volumeChanged", function(event) {
                    widget._setVolume(event.volume);
                });
            });

            this.$controls.on("click", function(event) {
                var rel = $(this).jqmData("rel");
                if ($.inArray(rel, ["next", "pause", "play", "previous", "resume", "stop"]) !== -1) {
                    $widget.playback(rel);
                    event.preventDefault();  // necessary?
                }
            });

            this.$controls.on("change", function() {
                var $this = $(this);
                switch ($this.jqmData("rel")) {
                case "mute":
                    $widget.playback("mute", $this.prop("checked"));
                    break;
                case "seek":
                    //$widget.playback("option", "timePosition", parseInt($this.val()));
                    break;
                case "volume":
                    $widget.playback("volume", parseInt($this.val()));
                    break;
                }
            });
        },

        _init: function() {
            var widget = this;
            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.playback.getCurrentTlTrack().then(function(tlTrack) {
                    widget._setTrack(tlTrack);
                });
                mopidy.playback.getMute().then(function(mute) {
                    widget._setMute(mute);
                });
                mopidy.playback.getState().then(function(state) {
                    widget._setState(state);
                });
                mopidy.playback.getTimePosition().then(function(time_position) {
                    widget._timePosition = time_position;
                });
                mopidy.playback.getVolume().then(function(volume) {
                    widget._setVolume(volume);
                });
            });
            this._super();
        },

        _setMute: function(value) {
            if (this._mute !== value) {
                this._mute = value;
                this.$controls.filter(":jqmData(rel='mute')").val(value).checkboxradio("refresh");
                this._trigger("mutechange");
            }
        },

        _setState: function(state) {
            if (this._state !== state) {
                this.$controls.each(function() {
                    var $this = $(this);
                    switch ($this.jqmData("rel")) {
                    case "pause":
                        // TODO: stopped -> paused ok?
                        $this.prop("disabled", state === "paused");
                        break;
                    case "play":
                        break;
                    case "resume":
                        $this.prop("disabled", state !== "paused");
                        break;
                    case "stop":
                        $this.prop("disabled", state === "stopped");
                        break;
                    }
                });
                this._state = state;
                this._trigger("statechange");
            }
        },

        _setTrack: function(tlTrack) {
            var widget = this;
            if (this._track !== tlTrack) {
                $.mopidy.connect().then(function() {
                    this.tracklist.nextTrack(tlTrack).then(function(t) {
                        widget.$controls
                            .filter(":jqmData(rel='next')")
                            .prop("disabled", !t);
                    });
                    this.tracklist.previousTrack(tlTrack).then(function(t) {
                        widget.$controls
                            .filter(":jqmData(rel='previous')")
                            .prop("disabled", !t);
                    });
                });
                this._track = tlTrack;
                this._trigger("trackchange");
            }
        },

        _setVolume: function(value) {
            if (this._volume !== value) {
                this._volume = value;
                // FIXME!
                this.$controls.filter(":jqmData(rel='volume')").val(value).slider("refresh");
                this._trigger("volumechange");
            }
        },

        changeTrack: function(tlTrack, onErrorStep) {
            $.mopidy.connect().then(function() {
                if (onErrorStep !== undefined) {
                    this.playback.changeTrack(tlTrack, onErrorStep);
                } else {
                    this.playback.changeTrack(tlTrack);
                }
            });
        },

        getCurrentTlTrack: function() {
            return this._track;
        },

        getCurrentTrack: function() {
            return this._track ? this._track.track : null;
        },

        getTimePosition: function() {
        },

        mute: function(value) {
            if (value === undefined) {
                return this._mute;
            }
            value = Boolean(value); // ???
            if (this._mute !== value) {
                $.mopidy.connect().then(function() {
                    this.playback.setMute(value);
                });
            }
        },

        next: function() {
            $.mopidy.connect().then(function() {
                this.playback.next();
            });
        },

        pause: function() {
            $.mopidy.connect().then(function() {
                this.playback.pause();
            });
        },

        play: function(tlTrack, onErrorStep) {
            $.mopidy.connect().then(function() {
                if (onErrorStep !== undefined) {
                    this.playback.play(tlTrack, onErrorStep);
                } else {
                    this.playback.play(tlTrack);
                }
            });
        },

        previous: function() {
            $.mopidy.connect().then(function() {
                this.playback.previous();
            });
        },

        resume: function() {
            $.mopidy.connect().then(function() {
                this.playback.resume();
            });
        },

        seek: function(timePosition) {
            $.mopidy.connect().then(function() {
                this.playback.seek(timePosition);
            });
        },

        state: function(value) {
            if (value === undefined) {
                return this._state;
            }
            if (this._state !== value) {
                $.mopidy.connect().then(function() {
                    this.playback.setState(value);
                });
            }
        },

        stop: function(clearCurrentTrack) {
            $.mopidy.connect().then(function() {
                this.playback.stop(clearCurrentTrack);
            });
        },

        volume: function(value) {
            if (value === undefined) {
                return this._volume;
            }
            value = parseInt(value); // ???
            if (this._volume !== value) {
                $.mopidy.connect().then(function() {
                    this.playback.setVolume(value);
                });
            }
        }
    });
})(jQuery, this);

(function($, window, undefined) {

    function defaultTrackClickCallback() {
        var $item = $(this),
            $playlist = $item.closest(".ui-collapsible"),
            tracks = $playlist.mopidyModel().tracks,
            uri = $item.mopidyModel().uri;
        $.mopidy.connect().then(function() {
            var tracklist = this.tracklist,
                playback = this.playback;
            tracklist.clear().then(function() {
                tracklist.add(tracks).then(function(tlTracks) {
                    var tlTrack = $.mopidy.getModelByUri(tlTracks, uri);
                    playback.play(tlTrack || tlTracks[0]);
                });
            });
        });
    }

    function defaultTrackItemCallback(track) {
        return $("<li />", {"data-icon": false})
            .append($("<a />", {href: track.uri, text: track.name || ""}))
            .mopidyModel(track);
    }

    $.widget("mopidy.playlists", $.mobile.collapsibleset, {

	initSelector: ":jqmData(role='playlists')",

        options: {
        },

        _create: function() {
            var widget = this;
            this._super();

            this._on({
                "click li a": function(event) {
                    var $item = $(event.currentTarget).closest("li");
                    defaultTrackClickCallback.call($item.get(), event);
                    event.preventDefault();
                }
            });

            $.mopidy.connect().then(function() {
                var mopidy = this;
                this.on("event:playlistChanged", function(/*playlist*/) {
                    widget._getPlaylists(mopidy);
                });
                this.on("event:playlistsLoaded", function() {
                    widget._getPlaylists(mopidy);
                });
                widget._getPlaylists(mopidy);
            });

        },

        _getPlaylists: function(mopidy) { // includeTracks?
            var $element = this.element,
                options = this.options;
            mopidy.playlists.getPlaylists().then(function(playlists) {
                var $collapsibles = $.map(playlists, function(playlist) {
                    var $items = $.map(playlist.tracks || [], defaultTrackItemCallback);
                    return $("<div />").jqmData("role", "collapsible")
                        .append($("<h1 />", {text: playlist.name || ""}))
                        .append($("<ul />").append($items).listview())
                        .collapsible({inset: options.inset})
                        .mopidyModel(playlist);
                });
                $element.empty().append($collapsibles).playlists("refresh");
            });
        },

        create: function(name, uriScheme) {
            $.mopidy.connect().then(function() {
                this.playlists.create(name, uriScheme);
            });
        },

        delete: function(uri) {
            $.mopidy.connect().then(function() {
                this.playlists.delete(uri);
            });
        },

        refresh: function(/*uriScheme*/) {
            //if (uriScheme !== undefined) {
            //    $.mopidy.connect().then(function() {
            //        this.playlists.refresh(uriScheme);
            //    });
            //}
            this._super();
        },

        save: function(playlist) {
            $.mopidy.connect().then(function() {
                this.playlists.save(playlist);
            });
        }
    });
})(jQuery, this);

(function($, window, undefined) {

    function defaultAnchorCallback(tlTrack) {
        var track = tlTrack.track,
            album = track.album || {},
            artists = track.artists || [],
            images = album.images || [],
            text = [];
        if (artists.length) {
            text.push($.mopidy.mapKey(artists, "name").join(", "));
        }
        if (album.name) {
            text.push(album.name);
        }
        return $("<a />", {href: track.uri})
            .append($("<img />", {src: images[0] || $.mopidy.defaultImage}))
            .append($("<h1 />", {text: track.name || ""}))
            .append($("<p />", {text: text.join(" - ")}));
    }

    $.widget("mopidy.tracklist", $.mobile.listview, {

	initSelector: ":jqmData(role='tracklist')",

        options: {
            anchorCallback: defaultAnchorCallback,
            consume: null,
            random: null,
            repeat: null,
            single: null
        },

        _create: function() {
            var $element = this.element,
                options = this.options,
                widget = this;
            this._super();

            this._currentTlId = null;

            this._tracklistOptions = {
                consume: null,
                random: null,
                repeat: null,
                single: null
            };

            this._on({
                "click li a": function(event) {
                    var $item = $(event.currentTarget).closest("li"),
                        model = $item.mopidyModel();
                    $.mopidy.connect().then(function() {
                        this.playback.play(model);
                    });
                    event.preventDefault();
                },
                "swipeleft li": function(event) {
                    var $item = $(event.currentTarget),
                        model = $item.mopidyModel();
                    $.mopidy.swipe($item, "left", function() {
                        widget.remove({tlid: [model.tlid]});
                    });
                }
            });

            // FIXME: _setOption, _init?
            $.each(["consume", "random", "repeat", "single"], function(i, option) {
                $(options[option]).on("change", function() {
                    $element.tracklist(option, $(this).prop("checked"));
                });
            });

            $.mopidy.connect().then(function() {
                var mopidy = this;
                mopidy.on("event:optionsChanged", function() {
                    widget._getTracklistOptions(mopidy);
                });
                mopidy.on("event:tracklistChanged", function() {
                    widget._getTlTracks(mopidy);
                });
                mopidy.on("event:trackPlaybackStarted", function(event) {
                    widget._updateCurrentTlId(event.tl_track.tlid);
                });
                mopidy.playback.getCurrentTlTrack().then(function(tlTrack) {
                    widget._updateCurrentTlId(tlTrack ? tlTrack.tlid : null);
                });
                widget._getTlTracks(mopidy);
                widget._getTracklistOptions(mopidy);
            });
	},

        _getTlTracks: function(mopidy) {
            var $element = this.element,
                anchorCallback = this.options.anchorCallback,
                widget = this;
            mopidy.tracklist.getTlTracks().then(function(tlTracks) {
                var $items = $.map(tlTracks, function(tlTrack) {
                    return $("<li />", {"data-icon": false})
                        .append(anchorCallback(tlTrack))
                        .mopidyModel(tlTrack);
                });
                $element.empty().append($items).tracklist("refresh");
                widget._updateCurrentTlId(widget._currentTlId);
            });
        },

        _getTracklistOptions: function(mopidy) {
            var widget = this,
                tracklist = mopidy.tracklist;
            tracklist.getConsume().then(function(consume) {
                widget._updateTracklistOption("consume", consume);
            });
            tracklist.getRandom().then(function(random) {
                widget._updateTracklistOption("random", random);
            });
            tracklist.getRepeat().then(function(repeat) {
                widget._updateTracklistOption("repeat", repeat);
            });
            tracklist.getSingle().then(function(single) {
                widget._updateTracklistOption("single", single);
            });
        },

        _updateCurrentTlId: function(tlid) {
            this.element.children("li").each(function() {
                var $item = $(this),
                    model = $item.mopidyModel();
                $item.find("a").toggleClass("ui-btn-active", model.tlid === tlid);
            });
            this._currentTlId = tlid;
        },

        _updateTracklistOption: function(key, value) {
            var tracklistOptions = this._tracklistOptions;
            if (tracklistOptions[key] !== value) {
                tracklistOptions[key] = value;
                if (this.options[key]) {
                    $(this.options[key]).prop("checked", value);
                    $(this.options[key]).checkboxradio("refresh"); // FIXME
                }
            }
        },

        add: function(what, position) {
            $.mopidy.connect().then(function() {
                switch ($.type(what)) {
                case "string":
                    this.tracklist.add(null, position, what);
                    break;
                case "array":
                    this.tracklist.add(what, position, null);
                    break;
                default:
                    // assuming single track
                    this.tracklist.add([what], position, null);
                    break;
                }
            });
        },

        clear: function() {
            $.mopidy.connect().then(function() {
                this.tracklist.clear();
            });
        },

        consume: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.consume;
            }
            if (tracklistOptions.consume !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setConsume(value);
                });
            }
        },

        move: function(start, end, to) {
            $.mopidy.connect().then(function() {
                this.tracklist.move(start, end, to);
            });
        },

        remove: function(criteria) {
            $.mopidy.connect().then(function() {
                this.tracklist.remove(criteria);
            });
        },

        random: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.random;
            }
            if (tracklistOptions.random !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setRandom(value);
                });
            }
        },

        repeat: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.repeat;
            }
            if (tracklistOptions.repeat !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setRepeat(value);
                });
            }
        },

        shuffle: function(start, end) {
            $.mopidy.connect().then(function() {
                this.tracklist.shuffle(start, end);
            });
        },

        single: function(value) {
            var tracklistOptions = this._tracklistOptions;
            if (value === undefined) {
                return tracklistOptions.single;
            }
            if (tracklistOptions.single !== value) {
                $.mopidy.connect().then(function() {
                    this.tracklist.setSingle(value);
                });
            }
        },

    });
})(jQuery, this);

(function($, window, undefined) {
    $(window.document).on("pagecreate", function(event) {
        $(event.target).find($.mopidy.playback.prototype.initSelector).playback();
        $(event.target).find($.mopidy.tracklist.prototype.initSelector).tracklist();
        $(event.target).find($.mopidy.playlists.prototype.initSelector).playlists();
    });
})(jQuery, this);


}));
