from __future__ import unicode_literals

import unittest

from mopidy_http_kuechenradio import Extension


class ExtensionTest(unittest.TestCase):

    def test_get_default_config(self):
        ext = Extension()
        config = ext.get_default_config()
        self.assertIn('[http-kuechenradio]', config)
        self.assertIn('enabled = true', config)

    def test_get_config_schema(self):
        ext = Extension()
        schema = ext.get_config_schema()
        self.assertIn('title', schema)
        self.assertIn('default_locale', schema)
