$(function() {
    var defaultTrackName = $("#trackname").text(),
        defaultTrackArtists = $("#trackartists").text(),
        defaultTrackAlbum = $("#trackalbum").text(),
        defaultTrackImage = $("#trackimage").attr("src");

    function updateTrackView(track) {
        if (track) {
            $("#trackname").text(track.name || "");
            if (track.artists && track.artists.length) {
                $("#trackartists").text($.mopidy.mapKey(track.artists, "name").join(", "));
            } else {
                $("#trackartists").text(defaultTrackArtists);
            }
            if (track.album) {
                $("#trackalbum").text(track.album.name || "");
                if (track.album.images && track.album.images.length) {
                    $("#trackimage").attr("src", track.album.images[0]);
                } else {
                    $("#trackimage").attr("src", defaultTrackImage);
                }
            } else {
                $("#trackalbum").text(defaultTrackAlbum);
                $("#trackimage").attr("src", defaultTrackImage);
            }
        } else {
            $("#trackname").text(defaultTrackName);
            $("#trackartists").text(defaultTrackArtists);
            $("#trackalbum").text(defaultTrackAlbum);
            $("#trackimage").attr("src", defaultTrackImage);
        }
    }


    $("#playback").on("pagecreate", function() {
        var $playback = $(this).find(":jqmData(role='playback')");
        $playback.on("playbackcreate", function() {
            updateTrackView($(this).playback("getCurrentTrack"));
        });
        $playback.on("playbacktrackchange", function() {
            updateTrackView($(this).playback("getCurrentTrack"));
        });
    });

    $("#playlists").on("pagecreate", function() {
        var $playlists = $(this).find(":jqmData(role='playlists')");
        $("#playlists-refresh").on("click", function() {
            $playlists.playlists("refresh", null);
        });
    });

    $("#settings").on("pagecreate", function() {
        $("#settings-lang").on("change", function() {
            $(this).closest("form").submit();
        });
    });
});
