# future imports
from __future__ import unicode_literals

# stdlib imports
import re
from setuptools import find_packages
from setuptools import setup


def get_version(filename):
    content = open(filename).read()
    metadata = dict(re.findall("__([a-z]+)__ = '([^']+)'", content))
    return metadata['version']


setup(
    name='Mopidy-Webhooks',
    version=get_version('mopidy_webhooks/__init__.py'),
    url='https://github.com/paddycarey/mopidy-webhooks',
    license='Apache License, Version 2.0',
    author='Patrick Carey',
    author_email='paddy@wackwack.co.uk',
    description='Mopidy extension that sends webhook notifications to a remote server',
    long_description=open('README.rst').read(),
    packages=find_packages(exclude=['tests', 'tests.*']),
    zip_safe=False,
    include_package_data=True,
    install_requires=[
        'setuptools',
        'Mopidy >= 0.18',
        'Pykka >= 1.1',
        'requests',
    ],
    test_suite='nose.collector',
    tests_require=[
        'nose',
        'mock >= 1.0',
    ],
    entry_points={
        'mopidy.ext': [
            'webhooks = mopidy_webhooks:Extension',
        ],
    },
    classifiers=[
        'Environment :: No Input/Output (Daemon)',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2',
        'Topic :: Multimedia :: Sound/Audio :: Players',
    ],
)
