#
##
### Mother Configuration File
##      -> Commented values are default values <-
#

  #                 #
  ###             ### 
  #  MOTHER TUNING  #
  ###             ###
  #                 #


#
##
# The MotherMap is the file where informations
# about database structure are stored.
# 
# Set here his location: to avoid problems, use
# an absolute path.
#
# Remember to launch mothermapper to create the
# Map file before to use Mother for this 
# environment.
##
#

MOTHER_MAP= '/my/mother/map'

#
##
# By default, Mother uses OIDs.
# This will be changed when postgres-8.2.3 will be the 
# most diffused version of postgres.
#
# OIDs have been deprecated with postgres-8.1, but 
# they are completely working and supported.
#
# Anyway, it's possible to avoid OIDs, but to do that
# a postgres version >= 8.2.3 is needed.
#
# If you run a postgres version >= 8.2.3, set the 
# following to False. It's all.
#
# If you run a version < 8.1, use True. It's all.
#
# Otherwise, you HAVE to set the following to True
# and your tables have to be created WITH OIDS:
#
#   CREATE TABLE my_table ( ... ) WITH OIDS;
#
# If you decide to upgrade postgres to 8.2.3, it's 
# safe to change this switch to False.
# If you decide to upgrade to 8.1, make sure that 
# your tables use OIDs.
#
# If you use a postgres version < 8.2.3 and you don't
# want to use OIDs, choose another ORM, but forget
# the Mother introspection ;)
##
#

# MOTHER_OIDS= True


  #                    #
  ###                ### 
  #  DATABASE ADAPTER  #
  ###                ###
  #                    #

#
##
### DB info
##
#

# If DB_HOST is None, Unix Sockets will be used (Unix only ;)
# In this case, DB_PORT is ignored.

DB_HOST= 'localhost'
DB_NAME= "universe"
DB_USER= "space_man"
DB_PASSWD= "space_password"
# DB_PORT= 5432


#
##
### Threaded Environment
##
#

#
##
# Are you planning to use Mother in a threaded environment?
# For example, in a web application.
#
# If you want to use Mother in a threaded environment,
# you need to use Sessions. To see how, please, refer
# to the official documentation.
#
# In this case, you may want a pool of persistent connections,
# instead of creating a new connection for each session.
##
#

# DB_POOL= False

#
##
### How many connections in your Pool?
##
# You can specify a min and a max.
# `min' means that the pool will be initialized
# with `min' connections.
# When a connection is requested, but no connection
# is availbale, a new connection will be created if 
# `max' connections are not established yet.
# Otherwise, the request will wait until a connection
# will be available.
## 
#

# DB_POOL_MIN= 4
# DB_POOL_MAX= 10

#
##
### Timeout
##
# This is the timeout for the Queue. 
# A request will wait DB_POOL_TIMEOUT seconds:
# after that, an exception will be raised.
##
#

# DB_POOL_TIMEOUT= 30

#
## Default Session name
#
# Each session has a name. If you don't specify
# a session name, Mother assigns a random name
# obtained with the following string, followed by 
# a random integer. 
# If you want, you can decide the prefix that 
# Mother will be use.
##
#

# MOTHER_SESSION_NAME = 'MoSession-'



    #           #
    ###       ### 
    #  LOGGING  #
    ###       ###
    #           #

#
## Which prefix for logs output?
#

# LOG_PREFIX= "Mother"

#
## Logging with colors?
# If you are a win32 user, set to False.
##
#

# LOG_COLOR= True

#
##
# LOG_LEVEL 
# 
#  Decreasing:
#
#   - DBG_CRITICAL
#   - DBG_ERROR   
#   - DBG_WARNING 
#   - DBG_INFO    
#   - DBG_INSANE
#   - DBG_NOISE
#   - DBG_SOFT 
#   - DBG_NORMAL
#
# Use DBG_WARNING if you want to see
# only error, warning and critical messages, 
# for example.
#
# To disable logging, use: 
#
#   - DBG_NONE  
##
#

# LOG_LEVEL= DBG_INFO

#
## 
# Log to standard output?
##
#

# LOG_TO_STDOUT= True

#
## 
# Log to file?
# If yes, specify here the file to be used, 
# otherwise set LOG_TO_FILE to None
#
# If enabled, you can use log rotation 
# capability: each LOG_FILE_ROTATE hours,
# the log file will be rotated.
# A LOG_FILE_NUMBER number of files will be
# maintained.
##
#

# LOG_TO_FILE= None

#
## Rotate the log file every day (minutes)
## and maintain logs for a week (days):
#

# LOG_FILE_ROTATE= 60 * 24
# LOG_FILE_NUMBER= 7

#
##  
#  Unix Only
#  Log to Syslog? If yes, which facility? 
#  Note that to use this feature, you have to
#  enable TCP in your syslog configuration.
##
#

# LOG_TO_SYSLOG = False
# LOG_FACILITY  = LOG_USER
# LOG_SERVER    = ('localhost', 514)

#
## 
# Enable SMTP logging?
# If you enable SMTP logging, use Speaker.log_mail()
# to send log via mail.
##
#

# LOG_TO_SMTP= False

#
## If LOG_TO_SMTP is True, set the following:
#

# LOG_SMTP_SERVER=  'localhost'
# LOG_SMTP_SENDER=  'debug@debug.debug'
# LOG_SMTP_RCPT=    'destination@debug.debug'
# LOG_SMTP_SUBJECT= 'debug message from Mother'

