#!/usr/bin/env python

try:
    from setuptools import setup, Extension
except ImportError:
    print 'Installing setuptools ...'
    import ez_setup
    ez_setup.use_setuptools()
    from setuptools import setup, Extension
    print 'Done installing setuptools.'
from distutils.sysconfig import get_python_inc
from setuptools.dist import Distribution
import numpy
import numpy.numarray as nn
import os, glob
import sys
#import matplotlib

#from distutils.core import setup
#import py2exe

# include directories for hungarian
numpyincludedirs = numpy.get_include()
numarrayincludedirs = nn.get_numarray_include_dirs()
includedirs = numarrayincludedirs+[numpyincludedirs,]

# read version number from version file
path = os.path.abspath( os.curdir )
mtrax_path = os.path.join( path, 'mtrax' )
ver_filename = os.path.join( mtrax_path, 'version.py' )
ver_file = open( ver_filename, "r" )
for line in ver_file: # parse through file version.py
    if line.find( '__version__' ) >= 0:
        line_sp = line.split() # split by whitespace
        version_str = line_sp[2] # third item
        this_version = version_str[1:-1] # strip quotes
ver_file.close()

# add all of the .xrc and .bmp files
mtrax_package_data = [ f[6:] for f in glob.glob('mtrax/*.xrc')]+\
                     [ f[6:] for f in glob.glob('mtrax/*.bmp')]+\
                     [ f[6:] for f in glob.glob('mtraxicon.ico')]
eager_resources = [ f for f in glob.glob('mtrax/*.xrc') ] + \
    [ f for f in glob.glob('mtrax/*.bmp')] + \
    [ f for f in glob.glob('mtraxicon.ico)')]
print 'mtrax_package_data: ',mtrax_package_data

setup( name="Mtrax",
       version=this_version,
       description="Multiple fly tracker",
       author="Caltech ethomics project",
       author_email="branson@caltech.edu",
       url="http://www.dickinson.caltech.edu/Research/Mtrax",
       packages=['mtrax'],
       entry_points = {'console_scripts': ['mtrax=mtrax:main']},
       package_dir={'mtrax': 'mtrax',
                    'hungarian': 'hungarian',
                    'houghcircles': 'houghcircles'},
       py_modules=['mtrax.colormapk','mtrax.imagesk',
                   'mtrax.houghcircles','mtrax.setarena'],
       package_data = {'mtrax':mtrax_package_data},
       eager_resources=eager_resources,
       install_requires=['wxPython>=2.8',
                         'numpy>=1.0.4',
                         'matplotlib>=0.91.2',
                         'scipy>=0.6',
                         'PIL>=1.1.6',
                         'motmot.wxvideo>=0.5.2.dev',
                         'motmot.wxglvideo>=0.6.1.dev',
                         'motmot.wxvalidatedtext',
                         'motmot.imops',
                         'pygarrayimage',
                         'pyglet>=1.0',
             ],
       dependency_links = [
           "http://alldunn.com/wxPython/stuff/",
           #"http://vision.caltech.edu/~kristin/pythoneggs_for_mtrax/",
           ],
       ext_modules=[Extension('hungarian',['hungarian/hungarian.cpp',
                                           'hungarian/asp.cpp'],
                              include_dirs=includedirs),
                    Extension('houghcircles_C',
                              ['houghcircles/houghcircles_C.c'],
                              include_dirs=[numpyincludedirs,])
                    ],
        )
