#!/usr/bin/env python
# -*- coding: iso8859-15 -*-

# =============================================================================
# $Id: setup.py 39 2006-01-30 14:29:32Z s0undt3ch $
# =============================================================================
#             $URL: http://mulehashdb.ufsoft.org/svn/tags/MuleHashDB-0.1.1/setup.py $
# $LastChangedDate: 2006-01-30 14:29:32 +0000 (Mon, 30 Jan 2006) $
#             $Rev: 39 $
#   $LastChangedBy: s0undt3ch $
# =============================================================================

###############################################################################
#                                                                             # 
# Copyright  2005 by Pedro Algarvio                                          # 
#                                                                             #
# This program is free software; you can redistribute it and/or modify it     #
# under the terms of the GNU General Public License as published by the Free  #
# Software Foundation; either version 2 of the License, or (at your option)   #
# any later version.                                                          #
# This program is distributed in the hope that it will be useful, but WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       #
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   #
# more details.                                                               #
#                                                                             #
###############################################################################

# =============================================================================
# vim: set tabstop=4
# vim: set shiftwidth=4
#
# Display a red square on the 80th char so we can easely limit line width to a
# max of 79 chars, the way it should be.
# vim: autocmd BufEnter * match Error /\%80v/
# =============================================================================

from distutils.core import setup
from distutils.command.install import install
import os.path
import MuleHashDB


PACKAGE			= 'MuleHashDB'
VERSION			= MuleHashDB.__version__
AUTHOR			= MuleHashDB.__author__
AUTHOR_EMAIL	= MuleHashDB.__author_email__
SUMMARY			= 'An aMule Hash Database Management Tool'
DESCRIPTION		= \
"""
MuleHashDB is a hash database management for your Mule.
Currently it's only suposed to work with aMule since it has a cli tool,
amulecmd from where you can add all links from your download list to the
database."""
HOME_PAGE		= MuleHashDB.__url__
LICENSE			= MuleHashDB.__license__
PLATFORMS		= 'Anywhere aMule and Python can run I guess.'

SHARE_DIR	= os.path.join('share', PACKAGE)
DOCS_DIR    = os.path.join('share', PACKAGE, 'doc')

def _p(unix_path):
	return os.path.normpath(unix_path)

class custom_install (install):
	def run (self):
		self.siteconfig()

	def siteconfig (self):
		self.SHARE_DIR = os.path.join(self.prefix, 'share', PACKAGE)
		self.DOCS_DIR = os.path.join(self.prefix, 'share', PACKAGE, 'doc')
		f = open(_p('MuleHashDB/locations.py'), 'w')
		f.write("""
# PLEASE DO NOT EDIT THIS FILE!
# This file was autogenerated when installing %(package)s %(version)s.
#
__share_dir__	= '%(share_dir)s'
__docs_dir__	= '%(docs_dir)s'

""" % {
		'package': PACKAGE,
		'version': VERSION,
		'share_dir': os.path.abspath(self.SHARE_DIR),
		'docs_dir': os.path.abspath(self.DOCS_DIR)})
		f.close()

		# Run actual install
		install.run(self)
		print
		print '----------------------------------------------------------------'
		print "\033[1;32m Thanks for using %s %s!\033[m" % (PACKAGE, VERSION)
		print
		print "\033[1m The first time you run %s, it will create a " % PACKAGE
		print " configuration file for your user."
		print
		print " You should edit that file to setup %s for your system." \
				% PACKAGE
		print
		print " Usefull Directories ( not that important at the moment " \
				"\033[1;33m;)\033[m\033[1m ):"
		print "   Share:\033[1;34m %s\033[m\033[1m" % os.path.abspath(self.SHARE_DIR)
		print "    Docs:\033[1;34m %s\033[m\033[m" % os.path.abspath(self.DOCS_DIR)
		print '----------------------------------------------------------------'
		print '\033[1;31m Submit bugs or new features to:\033[m'
		print '  \033[1;33m *\033[m\033[1;34m http://mulehashdb.ufsoft.org'
		print '  \033[m\033[1;33m *\033[m\033[1;34m ufs@ufsoft.org\033[m'
		print '----------------------------------------------------------------'
				

setup(name=PACKAGE,
		version=VERSION,
		author=AUTHOR,
		author_email=AUTHOR_EMAIL,
		url=HOME_PAGE,
		description=SUMMARY.strip(),
		long_description=DESCRIPTION.strip(),
		license=LICENSE,
		platforms=PLATFORMS,
		packages=["MuleHashDB"],
		scripts=["mhdb"],
		data_files=[
			(SHARE_DIR, ['mulehashdb.conf']),
			(DOCS_DIR, [
				'AUTHORS',
				'COPYING',
				'README',
				'ChangeLog'
			])
		],
		classifiers=[
			'Development Status :: 3 - Alpha',
#			'Development Status :: 5 - Production/Stable',
			'Environment :: Console',
			'License :: OSI Approved :: GNU General Public License (GPL)',
			'Natural Language :: English',
			'Operating System :: POSIX :: Linux',
			'Operating System :: Microsoft ',
			'Programming Language :: Python',
			'Topic :: Communications :: File Sharing',
			'Topic :: Database',
			'Topic :: Utilities'
		],
		cmdclass = {'install': custom_install}
)
