# Copyright (C) 2011 Vaadin Ltd.
# Copyright (C) 2011 Richard Lincoln
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Wraps information related to drag and drop operation."""


class DragAndDropEvent(object):
    """DragAndDropEvent wraps information related to drag and drop operation.
    It is passed by terminal implementation for L{DropHandler.drop} and
    L{AcceptCriterion.accept} methods.

    DragAndDropEvent instances contains both the dragged data in
    L{Transferable} (generated by L{DragSource} and details
    about the current drop event in L{TargetDetails} (generated by
    L{DropTarget}.
    """

    def __init__(self, transferable, dropTargetDetails):
        self._transferable = transferable
        self._dropTargetDetails = dropTargetDetails


    def getTransferable(self):
        """@return: the Transferable instance representing the data dragged
                    in this drag and drop event
        """
        return self._transferable


    def getTargetDetails(self):
        """@return: the TargetDetails containing drop target related details
                    of drag and drop operation
        """
        return self._dropTargetDetails
