# Copyright (C) 2012 Vaadin Ltd. 
# Copyright (C) 2012 Richard Lincoln
# 
# Licensed under the Apache License, Version 2.0 (the "License"); 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at 
# 
#     http://www.apache.org/licenses/LICENSE-2.0 
# 
# Unless required by applicable law or agreed to in writing, software 
# distributed under the License is distributed on an "AS IS" BASIS, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
# See the License for the specific language governing permissions and 
# limitations under the License.

"""Wraps information related to drag and drop operation."""


class DragAndDropEvent(object):
    """DragAndDropEvent wraps information related to drag and drop operation.
    It is passed by terminal implementation for L{DropHandler.drop} and
    L{AcceptCriterion.accept} methods.

    DragAndDropEvent instances contains both the dragged data in
    L{Transferable} (generated by L{DragSource} and details
    about the current drop event in L{TargetDetails} (generated by
    L{DropTarget}.
    """

    def __init__(self, transferable, dropTargetDetails):
        self._transferable = transferable
        self._dropTargetDetails = dropTargetDetails


    def getTransferable(self):
        """@return: the Transferable instance representing the data dragged
                    in this drag and drop event
        """
        return self._transferable


    def getTargetDetails(self):
        """@return: the TargetDetails containing drop target related details
                    of drag and drop operation
        """
        return self._dropTargetDetails
