#!/usr/bin/env python

import sys
import os
import glob
import platform
from distutils.core import setup, Extension

arch=platform.architecture()[0]

def nt_runtime():
    if arch == '32bit':
        binaries = ["Win32/hoc.pyd", "Win32/nrniv.dll"]
    elif arch == '64bit':
        binaries = ["Win64/hoc.pyd", "Win64/nrniv.dll", "Win64/pthreadGC2.dll", "Win64/IEShims.dll"]
    else:
        sys.exit("Unsupported architecture: " + arch)
    runtime_packages=["neuron", "neuron.tests", "neuron.neuroml"]
    runtime_package_dir={"neuron": "python/neuron"}
    runtime_package_data={}
    runtime_data_files=[("neuronhome/bin", binaries),
              ("neuronhome/lib/hoc", glob.glob("home/hoc/*.hoc")),
              ("neuronhome/lib/hoc/celbild", glob.glob("home/hoc/celbild/*.hoc")),
              ("neuronhome/lib/hoc/chanbild", glob.glob("home/hoc/chanbild/*.hoc")),
              ("neuronhome/lib/hoc/import3d", glob.glob("home/hoc/import3d/*.hoc")),
              ("neuronhome/lib/hoc/lincir", glob.glob("home/hoc/lincir/*.hoc")),
              ("neuronhome/lib/hoc/mulfit", glob.glob("home/hoc/mulfit/*.hoc")),
              ("neuronhome/lib/hoc/mview", glob.glob("home/hoc/mview/*.hoc")),
              ("neuronhome/lib/hoc/netbild", glob.glob("home/hoc/netbild/*.hoc")),
              ]

    runtime_env={'package_dir':runtime_package_dir,
    'packages':runtime_packages,
    'package_data':runtime_package_data,
    'data_files':runtime_data_files}
    #ext_modules=[hoc_module],

    return runtime_env

def linux_runtime():
    if arch=='64bit':
        
        runtime_package_dir = {'':'unix/share/nrn/lib/python'}
        runtime_packages=['neuron','neuron.tests']
        runtime_package_data={'neuron': ['hoc.so']}
        runtime_data_files=[('/usr/lib64', glob.glob('unix/x86_64/lib/*')),
                            ('/usr/lib', glob.glob('unix/x86_64/lib/*'))]

        runtime_env={'package_dir':runtime_package_dir,
        'packages':runtime_packages,
        'package_data':runtime_package_data,
        'data_files':runtime_data_files}
        #ext_modules=[hoc_module],
        return runtime_env

    else:
        sys.exit('32bit Linux not currently supported')


if os.name == 'nt':
    runtime_env=nt_runtime()
elif sys.platform =='linux2':
    runtime_env=linux_runtime()
else:
    sys.exit("Only Windows and 64-bit Linux currently supported by PyNEURON")

setup(name="NEURON",
  version="7.2.536.14", # NEURON 7.2 revision 536
  packages=runtime_env['packages'],
  package_dir=runtime_env['package_dir'],
  data_files=runtime_env['data_files'],
  package_data=runtime_env['package_data'],
  #TODO: additional data files, from NEURONHOME
  #TODO: we need to set the NEURONHOME environment variable
  author="Uri Cohen,Mike Vella",
  author_email="uri.cohen@alice.nc.huji.ac.il",
  url="https://bitbucket.org/uric/pyneuron/",
  description="A Python package version of NEURON, for empirically-based simulations of neurons and networks of neurons",
  long_description="""A Python package version of NEURON,
Yale's project "for empirically-based simulations of neurons and networks of neurons"
See http://www.neuron.yale.edu/neuron/""",
  download_url="https://bitbucket.org/uric/pyneuron/downloads/PyNEURON-7.2.536.8.zip", 
  classifiers=[
      "Development Status :: 4 - Beta",
      "Environment :: Console",
      "Environment :: Win32 (MS Windows)",
      "Intended Audience :: End Users/Desktop",
      "Intended Audience :: Developers",
      "Intended Audience :: Science/Research",
      "License :: OSI Approved :: GNU General Public License (GPL)", # Like NEURON,
      "Operating System :: Microsoft :: Windows",
      "Operating System :: POSIX",
      #"Operating System :: UNIX",
      #"Operating System :: MacOS",
      #"Operating System :: OS Independent",
      "Programming Language :: C",
      "Programming Language :: Python :: 2",
      "Topic :: Scientific/Engineering",
      ]
  )
