#!/usr/bin/env python

import sys
import os
import glob
import platform
from distutils.core import setup, Extension

def windows_installer():
    arch=platform.architecture()[0]
    if arch == '32bit':
        binaries = ["Win32/hoc.pyd", "Win32/nrniv.dll"]
    elif arch == '64bit':
        binaries = ["Win64/hoc.pyd", "Win64/nrniv.dll", "Win64/pthreadGC2.dll", "Win64/IEShims.dll"]
    else:
        sys.exit("Unsupported architecture: " + arch)
        
    setup(name="NEURON",
          version="7.2.536.8", # NEURON 7.2 revision 536
          packages=["neuron", "neuron.tests", "neuron.neuroml"],
          package_dir={"neuron": "python/neuron"},
          data_files=[("neuronhome/bin", binaries),
                      ("neuronhome/lib/hoc", glob.glob("home/hoc/*.hoc")),
                      ("neuronhome/lib/hoc/celbild", glob.glob("home/hoc/celbild/*.hoc")),
                      ("neuronhome/lib/hoc/chanbild", glob.glob("home/hoc/chanbild/*.hoc")),
                      ("neuronhome/lib/hoc/import3d", glob.glob("home/hoc/import3d/*.hoc")),
                      ("neuronhome/lib/hoc/lincir", glob.glob("home/hoc/lincir/*.hoc")),
                      ("neuronhome/lib/hoc/mulfit", glob.glob("home/hoc/mulfit/*.hoc")),
                      ("neuronhome/lib/hoc/mview", glob.glob("home/hoc/mview/*.hoc")),
                      ("neuronhome/lib/hoc/netbild", glob.glob("home/hoc/netbild/*.hoc")),
                      ],
          #TODO: additional data files, from NEURONHOME
          #TODO: we need to set the NEURONHOME environment variable
          author="Uri Cohen",
          author_email="uri.cohen@alice.nc.huji.ac.il",
          url="https://bitbucket.org/uric/pyneuron/",
          description="A Python package version of NEURON, for empirically-based simulations of neurons and networks of neurons",
          long_description="""A Python package version of NEURON,
    Yale's project "for empirically-based simulations of neurons and networks of neurons"
    See http://www.neuron.yale.edu/neuron/""",
          download_url="https://bitbucket.org/uric/pyneuron/downloads/PyNEURON-7.2.536.8.zip", 
          classifiers=[
              "Development Status :: 4 - Beta",
              "Environment :: Console",
              "Environment :: Win32 (MS Windows)",
              "Intended Audience :: End Users/Desktop",
              "Intended Audience :: Developers",
              "Intended Audience :: Science/Research",
              "License :: OSI Approved :: GNU General Public License (GPL)", # Like NEURON,
              "Operating System :: Microsoft :: Windows",
              #"Operating System :: POSIX",
              #"Operating System :: MacOS",
              #"Operating System :: OS Independent",
              "Programming Language :: C",
              "Programming Language :: Python :: 2",
              "Topic :: Scientific/Engineering",
              ]
          )

def posix_installer():
    # if using MPI then at least for linking need special paths and libraries
    mpicc_bin = "gcc"
    mpicxx_bin = "g++"

    os.environ["CC"]=mpicc_bin
    os.environ["CXX"]=mpicxx_bin

    include_dirs = ['unix/src/oc','unix/src/nrnpython']
    defines = []

    libdirs = ["unix/x86_64/lib"]

    epre='-Wl,-R'

    ela=[ epre+"/usr/lib"]

    #This hoc module isn't used as the package_data line in setup contains the precompiled module.
    #It is however provided here should a user wish to compile the module locally.
    hoc_module = Extension(
          "neuron.hoc",
          ["inithoc.cpp"],
          library_dirs=libdirs,
          extra_link_args = ela,
          extra_objects = [],
          libraries = [
	    "nrnpython",
            "nrnoc", "oc", "nrniv", "ivoc",
            "memacs", "meschach", "neuron_gnu", "nrnmpi",
            "scopmath", "sparse13", "sundials", "ivos",
	    "readline"
          ],
          include_dirs = include_dirs,
          define_macros=defines
        )


    import glob
    setup(name="NEURON", version="7.2",
          description = "NEURON bindings for python",
          package_dir = {'':'unix/share/nrn/lib/python'}, #needs to be updated to a relative link
          packages=['neuron','neuron.tests'],
          package_data={'neuron': ['hoc.so']},
    #      ext_modules=[hoc_module],
          data_files=[('/usr/lib', glob.glob('unix/x86_64/lib/*'))]
    )

if os.name == 'nt':
    nt_installer()
elif os.name =='posix':
    posix_installer()
else:
    sys.exit("Only Windows and Linux currently supported by PyNEURON")
