# -*- coding: utf-8 -*-

#+---------------------------------------------------------------------------+
#|          01001110 01100101 01110100 01111010 01101111 01100010            |
#|                                                                           |
#|               Netzob : Inferring communication protocols                  |
#+---------------------------------------------------------------------------+
#| Copyright (C) 2011 Georges Bossert and Frédéric Guihéry                   |
#| This program is free software: you can redistribute it and/or modify      |
#| it under the terms of the GNU General Public License as published by      |
#| the Free Software Foundation, either version 3 of the License, or         |
#| (at your option) any later version.                                       |
#|                                                                           |
#| This program is distributed in the hope that it will be useful,           |
#| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
#| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the              |
#| GNU General Public License for more details.                              |
#|                                                                           |
#| You should have received a copy of the GNU General Public License         |
#| along with this program. If not, see <http://www.gnu.org/licenses/>.      |
#+---------------------------------------------------------------------------+
#| @url      : http://www.netzob.org                                         |
#| @contact  : contact@netzob.org                                            |
#| @sponsors : Amossys, http://www.amossys.fr                                |
#|             Supélec, http://www.rennes.supelec.fr/ren/rd/cidre/           |
#+---------------------------------------------------------------------------+

#+----------------------------------------------
#| Standard library imports
#+----------------------------------------------
from gettext import gettext as _
import logging

#+----------------------------------------------
#| Related third party imports
#+----------------------------------------------

#+----------------------------------------------
#| Local application imports
#+----------------------------------------------
from netzob.Inference.Grammar.Angluin import Angluin
from netzob.Inference.Grammar.MQCache import MQCache
# Replace by previous import statement : from Angluin import Angluin
import threading
from gi.repository import GObject
import time


#+----------------------------------------------
#| GrammarInferer:
#|    Given Angluin's L*a algorithm, it learns
#|    the grammar of a protocol
#+----------------------------------------------
class GrammarInferer(threading.Thread):

    def __init__(self, vocabulary, inputDictionary, oracle, equivalenceOracle, resetScript, cb_submitedQuery, cb_hypotheticalAutomaton):
        threading.Thread.__init__(self)
        # create logger with the given configuration
        self.log = logging.getLogger('netzob.Inference.Grammar.GrammarInferer.py')
        self.vocabulary = vocabulary
        self.inputDictionary = inputDictionary
        self.oracle = oracle
        self.equivalenceOracle = equivalenceOracle
        self.resetScript = resetScript
        self.cb_submitedQuery = cb_submitedQuery
        self.cb_hypotheticalAutomaton = cb_hypotheticalAutomaton
        self.active = False
        self.inferedAutomaton = None
        self.hypotheticalAutomaton = None
        self.learner = None

    def run(self):
        self.log.info("Starting the Grammar inferring process")
        self.active = True
        self.infer()
        self.active = False
        self.log.info("Ending the Grammar inferring process")

    def hasFinish(self):
        return not self.active

    def getInferedAutomaton(self):
        return self.inferedAutomaton

    def getHypotheticalAutomaton(self):
        return self.hypotheticalAutomaton

    def getSubmitedQueries(self):
        if self.learner is not None:
            return self.learner.getSubmitedQueries()
        return []

    def stop(self):
        self.active = False

    def infer(self):
        self.active = True
        equivalent = False

        startTime = time.time()

        # Create a MQ cache
        cache = MQCache()

#        cacheMSG = ["SYSINFO, > UnknownSymbol,EmptySymbol,EmptySymbol"]
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,SDBOT")
#        cacheMSG.append("LOGIN,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("EXECUTE,UnknownSymbol,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,UnknownSymbol,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING,CPU")
#        cacheMSG.append("DOWNLOAD,LOGIN > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("EXECUTE,SYSINFO,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGIN,LOGOUT > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGOUT,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGOUT,SYSINFO,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("EXECUTE,LOGIN,SYSINFO > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("EXECUTE,LOGOUT,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, STATUS, LOGOUT, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, SDBOT, EmptySymbol")
#        cacheMSG.append("LOGIN, SYSINFO, SYSINFO > UnknownSymbol, PASSWORD_ACCEPTED, CPU, CPU")
#        cacheMSG.append("LOGIN, SYSINFO, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, CPU, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, STATUS, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, DOWNLOAD, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, DOWNLOADING, CANTEXECUTE")
#        cacheMSG.append("EXECUTE, EXECUTE > UnknownSymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, EXECUTE, STATUS, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, CANTEXECUTE, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, LOGIN, UnknownSymbol > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, BAD_DNS, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, DOWNLOAD, EXECUTE, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, DOWNLOADING, BAD_DNS, CANTEXECUTE")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, DOWNLOAD, EXECUTE, EXECUTE, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, DOWNLOADING, CANTEXECUTE, CANTEXECUTE")
#        cacheMSG.append("DOWNLOAD, LOGOUT > UnknownSymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, UnknownSymbol, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE, SYSINFO, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE, BAD_DNS, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE, EXECUTE, EXECUTE, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE, BAD_DNS, CANTEXECUTE, CANTEXECUTE")
#        cacheMSG.append("LOGOUT, LOGOUT, LOGIN, LOGOUT > UnknownSymbol, EmptySymbol, EmptySymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE")
#        cacheMSG.append("EXECUTE, LOGOUT > UnknownSymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE, EXECUTE, EXECUTE, SYSINFO > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE, BAD_DNS, CANTEXECUTE, CANTEXECUTE")
#        cacheMSG.append("EXECUTE, LOGOUT, EXECUTE, LOGIN > UnknownSymbol, EmptySymbol, EmptySymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGOUT, LOGIN > UnknownSymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, STATUS, UnknownSymbol > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, SDBOT")
#        cacheMSG.append("LOGOUT, STATUS > UnknownSymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, STATUS, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, CANTEXECUTE")
#        cacheMSG.append("EXECUTE, DOWNLOAD, EXECUTE, LOGIN > UnknownSymbol, EmptySymbol, EmptySymbol, EmptySymbol, PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, LOGOUT, UnknownSymbol > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE, DOWNLOAD, EXECUTE, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE, BAD_DNS, BAD_DNS, EmptySymbol")
#        cacheMSG.append("LOGIN, SYSINFO, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, CPU, CANTEXECUTE")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, LOGOUT, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, EXECUTE, LOGIN, SYSINFO > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, CANTEXECUTE, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, DOWNLOAD, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, BAD_DNS")
#        cacheMSG.append("LOGIN, LOGIN, DOWNLOAD > UnknownSymbol, PASSWORD_ACCEPTED, EmptySymbol, DOWNLOADING")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, STATUS, EXECUTE, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, CANTEXECUTE, EmptySymbol")
#        cacheMSG.append("EXECUTE, LOGIN, STATUS > UnknownSymbol, EmptySymbol, PASSWORD_ACCEPTED, SDBOT")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE, DOWNLOAD, UnknownSymbol > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE, BAD_DNS, BAD_DNS")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE, EXECUTE, LOGIN, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE, BAD_DNS, CANTEXECUTE, CANTEXECUTE")
#        cacheMSG.append("LOGOUT, LOGOUT, LOGIN, STATUS > UnknownSymbol, EmptySymbol, EmptySymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, LOGOUT, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, BAD_DNS, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, DOWNLOAD, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, BAD_DNS")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, LOGIN, UnknownSymbol > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, DOWNLOAD, EXECUTE, DOWNLOAD > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, DOWNLOADING, CANTEXECUTE")
#        cacheMSG.append("LOGIN, UnknownSymbol, SYSINFO > UnknownSymbol, PASSWORD_ACCEPTED, EmptySymbol, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, LOGOUT, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, EXECUTE, SYSINFO, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, CANTEXECUTE, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, LOGIN, SYSINFO > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, LOGOUT, EXECUTE > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, DOWNLOAD, EXECUTE, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, BAD_DNS, CANTEXECUTE")
#        cacheMSG.append("LOGOUT, LOGOUT, LOGIN > UnknownSymbol, EmptySymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("EXECUTE, SYSINFO, UnknownSymbol > UnknownSymbol, EmptySymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, EXECUTE, EXECUTE, SYSINFO, LOGIN > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, CANTEXECUTE, BAD_DNS, CANTEXECUTE, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, DOWNLOAD, SYSINFO > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CANTEXECUTE, DOWNLOADING, BAD_DNS")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, SYSINFO, STATUS, SYSINFO, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, BAD_DNS, CPU, SDBOT, CPU")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, UnknownSymbol, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, EmptySymbol")
#        cacheMSG.append("LOGOUT, LOGOUT, LOGIN, DOWNLOAD > UnknownSymbol, EmptySymbol, EmptySymbol, EmptySymbol, EmptySymbol")
#        cacheMSG.append("LOGIN, DOWNLOAD, SYSINFO, STATUS, EXECUTE, SYSINFO, LOGOUT > UnknownSymbol, PASSWORD_ACCEPTED, DOWNLOADING, CPU, SDBOT, BAD_DNS, CANTEXECUTE, CPU")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGOUT,LOGIN,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,BAD_DNS")
#
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("EXECUTE,STATUS,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGOUT,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("SYSINFO,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,STATUS,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("LOGOUT,LOGIN,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("EXECUTE,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("EXECUTE,UnknownSymbol,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGIN,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,SYSINFO,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,DOWNLOAD,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("LOGIN,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("EXECUTE,STATUS,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,DOWNLOAD,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("DOWNLOAD,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,SYSINFO,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGOUT,STATUS,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,UnknownSymbol,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,UnknownSymbol,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("EXECUTE,LOGIN,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS")
#        cacheMSG.append("LOGIN,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,CPU,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGOUT,SYSINFO,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("DOWNLOAD,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGIN,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGIN,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,EXECUTE,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,SDBOT")
#        cacheMSG.append("LOGOUT,EXECUTE,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("SYSINFO,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("EXECUTE,DOWNLOAD,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,CPU")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("STATUS,LOGIN > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("EXECUTE,UnknownSymbol,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,STATUS,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("STATUS,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGOUT,STATUS,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGOUT,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("SYSINFO,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("STATUS,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGOUT,EXECUTE,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("DOWNLOAD,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,EXECUTE,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGOUT,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("UnknownSymbol,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGIN,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("EXECUTE,EXECUTE,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGOUT,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("EXECUTE,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("EXECUTE,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("UnknownSymbol,LOGIN > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("LOGOUT,DOWNLOAD,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,SDBOT")
#        cacheMSG.append("LOGOUT,SYSINFO,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("EXECUTE,STATUS,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGIN,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("DOWNLOAD,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("EXECUTE,EXECUTE,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("EXECUTE,DOWNLOAD,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("EXECUTE,SYSINFO,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("EXECUTE,EXECUTE,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("EXECUTE,SYSINFO,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,SDBOT")
#        cacheMSG.append("SYSINFO,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGIN,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGOUT,DOWNLOAD,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("EXECUTE,DOWNLOAD,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,SDBOT")
#        cacheMSG.append("EXECUTE,LOGOUT,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("EXECUTE,STATUS,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,SYSINFO,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,DOWNLOAD,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("EXECUTE,LOGIN,UnknownSymbol > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,SDBOT")
#        cacheMSG.append("EXECUTE,UnknownSymbol,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("SYSINFO,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGIN,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("STATUS,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGIN,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGIN,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,EXECUTE,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("EXECUTE,LOGIN,EXECUTE > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("SYSINFO,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,SYSINFO,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("EXECUTE,DOWNLOAD,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGIN,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,UnknownSymbol,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,CPU,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,DOWNLOADING,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGOUT,DOWNLOAD,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("SYSINFO,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("UnknownSymbol,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGIN,DOWNLOAD > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,UnknownSymbol,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("EXECUTE,SYSINFO,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,STATUS,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("LOGOUT,LOGIN,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,UnknownSymbol,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGOUT,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGIN,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGOUT,UnknownSymbol,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,STATUS,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("STATUS,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CPU")
#        cacheMSG.append("EXECUTE,STATUS,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,UnknownSymbol,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGOUT,UnknownSymbol,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("STATUS,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,SYSINFO,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,EXECUTE,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("UnknownSymbol,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,EXECUTE,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGOUT,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("EXECUTE,DOWNLOAD,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,SDBOT")
#        cacheMSG.append("EXECUTE,LOGOUT,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,EXECUTE,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CPU")
#        cacheMSG.append("UnknownSymbol,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,SYSINFO,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGOUT,DOWNLOAD,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,EXECUTE,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,SDBOT,EmptySymbol")
#        cacheMSG.append("UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGOUT,LOGIN,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,STATUS,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,STATUS,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,DOWNLOAD,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("EXECUTE,STATUS,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("LOGOUT,LOGOUT,DOWNLOAD,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS")
#        cacheMSG.append("LOGIN,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,SDBOT,CPU")
#        cacheMSG.append("EXECUTE,UnknownSymbol,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,DOWNLOAD,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("EXECUTE,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,EXECUTE,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGOUT,LOGOUT,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGOUT,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,LOGIN,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,CANTEXECUTE")
#        cacheMSG.append("EXECUTE,DOWNLOAD,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,BAD_DNS")
#        cacheMSG.append("EXECUTE,DOWNLOAD > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,STATUS,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGIN,LOGIN > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED,EmptySymbol")
#        cacheMSG.append("DOWNLOAD,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,EXECUTE,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,DOWNLOADING")
#        cacheMSG.append("LOGOUT,EXECUTE,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,SYSINFO,STATUS > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("UnknownSymbol,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,DOWNLOAD,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("UnknownSymbol,LOGOUT > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("EXECUTE,LOGIN > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,DOWNLOAD,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE,STATUS,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CANTEXECUTE,DOWNLOADING")
#        cacheMSG.append("LOGIN,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,CPU,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,STATUS,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGOUT,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGOUT,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,SDBOT")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,SYSINFO,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CPU,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("EXECUTE,UnknownSymbol,UnknownSymbol > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGOUT,STATUS,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,LOGIN,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,SYSINFO,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGOUT,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,LOGOUT,SYSINFO,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,LOGOUT,EXECUTE > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,SYSINFO,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,CPU")
#        cacheMSG.append("LOGOUT,STATUS,EXECUTE > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,SYSINFO,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,CPU,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,LOGIN,STATUS > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,SDBOT")
#        cacheMSG.append("SYSINFO,LOGIN > UnknownSymbol,EmptySymbol,PASSWORD_ACCEPTED")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,UnknownSymbol,SYSINFO > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,EXECUTE,DOWNLOAD,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,LOGOUT,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,LOGOUT,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,STATUS,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,STATUS,LOGOUT > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,UnknownSymbol,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,EmptySymbol")
#        cacheMSG.append("LOGOUT,DOWNLOAD,LOGIN > UnknownSymbol,EmptySymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("STATUS,SYSINFO > UnknownSymbol,EmptySymbol,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,EXECUTE,LOGIN,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,CANTEXECUTE,BAD_DNS,EmptySymbol")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,STATUS,EXECUTE,DOWNLOAD,UnknownSymbol > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,SDBOT,BAD_DNS,CANTEXECUTE,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,STATUS,EXECUTE,EXECUTE,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,SDBOT,CANTEXECUTE,CANTEXECUTE")
#        cacheMSG.append("LOGIN,DOWNLOAD,LOGIN > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,BAD_DNS")
#        cacheMSG.append("LOGIN,DOWNLOAD,SYSINFO,SYSINFO,DOWNLOAD,UnknownSymbol,DOWNLOAD > UnknownSymbol,PASSWORD_ACCEPTED,DOWNLOADING,CPU,BAD_DNS,CPU,DOWNLOADING,DOWNLOADING")
#        cache.preloadCache(cacheMSG, self.vocabulary)

        # we first initialize the angluin's algo
        self.learner = Angluin(self.vocabulary, self.inputDictionary, self.oracle, self.resetScript, self.cb_submitedQuery, self.cb_hypotheticalAutomaton, cache)

        while not equivalent and self.active:
            self.log.info("=============================================================================")
            self.log.info("Execute one new round of the inferring process")
            self.log.info("=============================================================================")

            self.learner.learn()
            if not self.active:
                break

            self.hypotheticalAutomaton = self.learner.getInferedAutomata()
            self.log.info("An hypothetical automaton has been computed")

            # Execute the call back function for the hypothetial automaton
            GObject.idle_add(self.cb_hypotheticalAutomaton, self.hypotheticalAutomaton)

            counterExample = self.equivalenceOracle.findCounterExample(self.hypotheticalAutomaton, self.inputDictionary, cache)

            if not self.active:
                break
            if counterExample is None:
                self.log.info("No counter-example were found !")
                equivalent = True
            else:
                self.log.info("A counter-example has been found")
                for s in counterExample.getSymbols():
                    self.log.info("symbol : " + str(s) + " => " + str(s.getID()))
                self.learner.addCounterExamples([counterExample])

        automaton = self.learner.getInferedAutomata()
        self.log.info("The following automaton has been computed : " + str(automaton.getDotCode()))

        # Now we apply indeterminism
        i_session = 0
        sessions = self.vocabulary.getSessions()
        for session in self.sessions:
            self.log.info("Re-inject session (" + str(i_session) + ") in the automata")
            new_automata = self.applyMessagesOnAutomata(automaton, messages)
            i_session = i_session + 1

        endTime = time.time()
        self.log.info("The inferring process is finished !")

        print "Elapsed time: ", (endTime - startTime) * 1000, " msecs"
        self.inferedAutomaton = automaton

    def applyMessagesOnAutomata(automaton, messages):
        self.log.info("Apply the messages (" + str(messages) + ") on automata")
        currentState = automaton.getInitialState()
        return automaton
