"""

"""

import os

from djangosite import Site

#~ execfile(os.path.join(os.path.dirname(__file__),'version.py'))
#~ execfile(os.path.join(os.path.dirname(__file__),'setup_info.py'))
execfile(os.path.join(os.path.dirname(__file__),'..','setup_info.py'))

__version__ = SETUP_INFO['version'] # 


#~ __author__ = "Luc Saffre <luc.saffre@gmx.net>"

#~ __url__ = "http://lino.saffre-rumma.net"
#~ __url__ = "http://code.google.com/p/lino/"
#~ __url__ = "http://north.lino-framework.org"


#~ __copyright__ = "Copyright (c) 2002-2013 Luc Saffre."


gettext = lambda s: s

# todo: remove this
def language_choices(*args):
    """
    A subset of Django's LANGUAGES.
    See :doc:`/blog/2011/0226`.
    """
    _langs = dict(
        en=gettext('English'),
        de=gettext('German'),
        fr=gettext('French'),
        nl=gettext('Dutch'),
        et=gettext('Estonian'),
    )
    return [(x,_langs[x]) for x in args]
      



class Site(Site):
    """
    Extends :class:`djangosite.Site`
    by adding some attributes and methods used by `north`.
    """
    
    languages = None
    
    #~ languages = ['en']
    
    """
    The language distribution used in this database.
    
    This must be either `None` or an iterable of language codes.
    Examples::
    
      languages = "en de fr nl et".split()
      languages = ['en']
      
    The first language in this list will be the site's 
    default language.
    
    Changing this setting affects your database structure 
    if your application uses babel fields,
    and thus require a data migration.
    
    ? Lino will use this setting to set the Django 
    ? settings :setting:`LANGUAGES` and  :setting:`LANGUAGE_CODE`.
    
    """
    
    demo_fixtures = ['std','demo']
    """
    The list of fixtures to be loaded by the 
    `initdb_demo <lino.management.commands.initdb_demo>`
    command.
    """
    
    migration_module = None
    """
    If you maintain a data migration module for your application, 
    specify its name here.
    """
    
    loading_from_dump = False
    """
    Set to `False` by python dumps that were generated by
    :meth:`lino.utils.dumpy.Serializer.serialize`.
    Used in 
    :func:`lino.modlib.cal.models.update_auto_task`
    and
    :mod:`lino.modlib.mails.models`.
    See also :doc:`/blog/2011/0901`.
    """
    
    #~ def __init__(self,*args):
    def init_nolocal(self,*args):
        super(Site,self).init_nolocal(*args)
        self.update_settings(SERIALIZATION_MODULES = {
            "py" : "north.dpy",
        })
        
        if self.languages is not None:
            lc = language_choices(*self.languages)
            self.update_settings(LANGUAGES = lc)
            self.update_settings(LANGUAGE_CODE = lc[0][0])
        
        
        
    def install_migrations(self,*args):
        """
        See :func:`lino.utils.dumpy.install_migrations`.
        """
        from .dpy import install_migrations
        install_migrations(self,*args)
        
          
    def using(self,ui=None):
        for u in super(Site,self).using(ui): yield u
        yield (SETUP_INFO['name'],SETUP_INFO['version'],SETUP_INFO['url'])
        

#~ class Site(BaseSite):
    
    #~ def __init__(self,*args,**kwargs):
        #~ super(Site,self).__init__(*args)
        #~ self.run_djangosite_local(**kwargs)
