# Numberjack
## A Python constraint programming platform

## What is Numberjack?

Numberjack is a modelling package written in Python for constraint programming.
Python benefits from a large and active programming community, Numberjack is
therefore a perfect tool to embed CP technology into larger applications. It is
designed to support a number of underlying C/C++ solvers seamlessly and
efficiently. There are a number of available back-ends: three mixed integer
programming solvers ([Gurobi][gurobiopt], [CPLEX][cplex], and [SCIP][scipopt]),
two satisfiability solvers ([MiniSat][minisat] and [Walksat][walksat]), a
constraint programming solver (Mistral), and a weighted constraint satisfaction
solver ([Toulbar2][toulbar2]).

* Numberjack offers a high level constraint programming language
* Numberjack directly benefits from python's features and modules
* Numberjack uses efficient underlying C/C++ solvers.

## Installation

Numberjack offers the ability to use several high-performance solvers, some of
which are required to be installed separately or have their own dependencies.
The source-code for building Mistral, Toulbar2, Minisat, and Walksat is included
in the Numberjack distribution and interfaces to additional solvers are
available.

To install Numberjack from source simply run `python setup.py build` from the
Numberjack directory, followed by `python setup.py install`. This requires the
following to be installed:

* python-dev
* swig
* libxml2-dev
* zlib1g-dev 
* libgmp-dev

[minisat]: http://minisat.se
[walksat]: http://www.cs.rochester.edu/u/kautz/walksat/
[toulbar2]: https://mulcyber.toulouse.inra.fr/projects/toulbar2/


## Building the Solver Interfaces

The following solvers are entirely optional and are not required to use
Numberjack however they can be a valuable tool to have. If any of the solvers
cannot be found on the system, then their interface will be disabled within
Numberjack. If you add one of these solvers after already installing Numberjack,
please reinstall Numberjack to enable the new interface.


### Gurobi Optimizer

Numberjack provides an interface to the mathematical programming solver,
[Gurobi][gurobiopt]. To use it in Numberjack, [Download and install Gurobi
Optimizer][gurobiopt] from their website. Numberjack has been tested against
Gurobi versions 5.1, 5.5, and 5.6.

Numberjack will try to automatically find the Gurobi install location by first
checking the `GUROBI_HOME` environment variable which should be set according to
the Gurobi install guide. If not, it will try to find the path based on the
location of the `gurobi_cl` executable.

```bash
export GUROBI_HOME="/opt/gurobi550/linux64"    # Example Linux install dir
export GUROBI_HOME="/Library/gurobi550/mac64"  # Example Mac OS X install dir
```

[gurobiopt]: http://www.gurobi.com/download/gurobi-optimizer
[gurobiqs]: http://www.gurobi.com/documentation/current/quick-start-guide/


### CPLEX

Numberjack provides an interface to [IBM ILOG CPLEX Optimizer][cplex] and has
been tested against CPLEX versions 12.5, and 12.5.1.

Numberjack will try to automatically find the CPLEX install location by first
checking the environment variable `CPLEXDIR`. If this is not set it will try to
find it based on the location of the `cplex` executable.

```bash
export CPLEXDIR="/opt/ibm/ILOG/CPLEX_Studio1251/cplex"
export CPLEXDIR="/Applications/IBM/ILOG/CPLEX_Studio1251/cplex"
```

[cplex]: http://www.ibm.com/software/commerce/optimization/cplex-optimizer/


### SCIP

SCIP is an open-source MIP solver available from: [http://scip.zib.de][scipopt],
please download version 3.1.0. The simplest way to install SCIP is to [download
the source code of SCIP Optimization Suite v3.1.0][scipoptdl] and place
scipoptsuite-3.1.0.tgz in the same folder as Numberjack, alongside this file, so
that it can be compiled with the necessary flags.

If you would like to compile SCIP yourself from a different location, then
please set the environment variable `ZIBPATH` to the scipoptsuite directory and
compile the static library using the following options:

```bash
export ZIBPATH=path_to/scipoptsuite-3.1.0
make scipoptlib ZIMPL=false ZLIB=false READLINE=false GAMS=false GMP=false LEGACY=true SPX_LEGACY=true
```

[scipopt]: http://scip.zib.de
[scipoptdl]: http://scip.zib.de/download.php?fname=scipoptsuite-3.1.0.tgz


### OSI Solvers
_The following OSI solvers have not been ported to the distutils build system yet._

Before you get started with the compiling Osi solvers for Numberjack you must first get the Osi module working.

Download Osi from: [http://www.coin-or.org/download/source/Osi/][osi]

To do this you need to download Osi-???.tgz and extract it in the solvers/osi/ folder.
The version that the Makefile presumes is Osi-0.105.2. If you download a different version the line `OSIVER = 0.105.2` will have to be changed.

#### OsiClp
Download Clp from: [http://www.coin-or.org/download/source/Clp/][osiclp]

The version that the Makefile presumes is Clp-1.14.5. If you download a different version the line `CLPVER = 1.14.5` will have to be changed.

#### OsiCbc
Download Cbc from: [http://www.coin-or.org/download/source/Cbc/][osicbc]

The version that the Makefile presumes is Cbc-2.7.5. If you download a different version the line `CBCVER = 2.7.5` will have to be changed.

CBC Supports several different lp solver backends(_e.g. glpk_) but currently dynamically links Clp.
There will be some work done on this, but as it stands you need to have Clp installed to the system for CBC to work.

#### OsiVol
Download Vol from: [http://www.coin-or.org/download/source/Vol/][osivol]

The version that the Makefile presumes is Vol-1.3.2. If you download a different version the line `VOLVER = 1.3.2` will have to be changed.

#### OsiDylp
Download Dylp from: [http://www.coin-or.org/download/source/Dylp/][osidylp]

The version that the Makefile presumes is DyLP-1.8.2. If you download a different version the line `DYLPVER = 1.8.2` will have to be changed.

#### OsiSpx (soplex)
Download soplex from: [http://soplex.zib.de/download.shtml][soplex]

The version that the Makefile presumes is soplex-1.6.0. If you download a different version the line `SPXVER = 1.6.0` will have to be changed.

#### OsiGlpk
Download Glpk from: [http://ftp.gnu.org/gnu/glpk/][glpk]

The version that the Makefile presumes is glpk-4.47. If you download a different version the line `GLPKVER = 4.47` will have to be changed.

[njhome]: http://numberjack.ucc.ie
[osi]: http://www.coin-or.org/download/source/Osi/
[osiclp]: http://www.coin-or.org/download/source/Clp/
[osicbc]: http://www.coin-or.org/download/source/Cbc/
[osivol]: http://www.coin-or.org/download/source/Vol/
[osidylp]: http://www.coin-or.org/download/source/DyLP/
[soplex]: http://soplex.zib.de/download.shtml
[glpk]: http://ftp.gnu.org/gnu/glpk/
