'''
Created on 6 Nov. 2009

@author: coissac
'''
#@PydevCodeAnalysisIgnore

from _dynamic cimport *  


cdef class LCS(DynamicProgramming):
            
    def __init__(self):
        DynamicProgramming.__init__(self,opengap=0,extgap=0)

    property opengap:
        def __get__(self):
            return self._opengap
        
    property extgap:
        def __get__(self):
            return self._extgap
        
    cdef double matchScore(self,int h, int v):
        return iupacPartialMatch(self.hSeq.sequence[h-1],self.vSeq.sequence[v-1])
        
    cdef double doAlignment(self) except? 0:
        cdef int i  # vertical index
        cdef int j  # horizontal index
        cdef int idx
        cdef int jump
        cdef int delta
        cdef double score
        cdef double scoremax
        cdef int    path

        
        if self.needToCompute:
            self.allocate()
            self.reset()
            
            for j in range(1,self.hSeq.length+1):
                idx = self.index(j,0)
                self.matrix.matrix[idx].score = 0
                self.matrix.matrix[idx].path  = j
                                
            for i in range(1,self.vSeq.length+1):
                idx = self.index(0,i)
                self.matrix.matrix[idx].score = 0
                self.matrix.matrix[idx].path  = -i
                
            for i in range(1,self.vSeq.length+1):
                for j in range(1,self.hSeq.length+1):
                    
                    # 1 - came from diagonal
                    idx = self.index(j-1,i-1)
                    # print "computing cell : %d,%d --> %d/%d" % (j,i,self.index(j,i),self.matrix.msize),
                    scoremax = self.matrix.matrix[idx].score + \
                               self.matchScore(j,i)
                    path = 0

                    # print "so=%f sd=%f sm=%f" % (self.matrix.matrix[idx].score,self.matchScore(j,i),scoremax),

                    # 2 - open horizontal gap
                    idx = self.index(j-1,i)
                    score = self.matrix.matrix[idx].score
                    if score > scoremax : 
                        scoremax = score
                        path = self.matrix.matrix[idx].path
                        if path >=0:
                            path+=1
                        else: 
                            path=+1
                    
                    # 3 - open vertical gap
                    idx = self.index(j,i-1)
                    score = self.matrix.matrix[idx].score 
                    if score > scoremax : 
                        scoremax = score
                        path = self.matrix.matrix[idx].path
                        if path <=0:
                            path-=1
                        else:
                            path=-1
                        
                    idx = self.index(j,i)
                    self.matrix.matrix[idx].score = scoremax
                    self.matrix.matrix[idx].path  = path 
                                        
        self.sequenceChanged=False
        self.scoreChanged=False

        idx = self.index(self.hSeq.length,self.vSeq.length)
        return self.matrix.matrix[idx].score
                   
    cdef void backtrack(self):
        #cdef list path=[]
        cdef int i
        cdef int j 
        cdef int p
        
        self.doAlignment()
        i=self.vSeq.length
        j=self.hSeq.length
        self.path=allocatePath(i,j,self.path)
        
        while (i or j):
            p=self.matrix.matrix[self.index(j,i)].path
            self.path.path[self.path.length]=p
            self.path.length+=1
#            path.append(p)
            if p==0:
                i-=1
                j-=1
            elif p < 0:
                i+=p
            else:
                j-=p
                
        #path.reverse()
        #reversePath(self.path)
        self.path.hStart=0
        self.path.vStart=0
        #return 0,0,path
                           
        
           

