(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27610,        779]*)
(*NotebookOutlinePosition[     28245,        801]*)
(*  CellTagsIndexPosition[     28201,        797]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(PF[RK_, P_] := \((RK - 1)\)*P\)], "Input"],

Cell[BoxData[
    \(\(\(PR[RK_, P_]\  := \ Exp[\(-PF[RK, P]\)\ ]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(R[NC_, P] := \[Sum]\+\(RK = 1\)\%NC PR[RK, P]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Log[R[NC, P]]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`log(\(\[ExponentialE]\^P - \[ExponentialE]\^\(P - NC\ \
P\)\)\/\(\(-1\) + \[ExponentialE]\^P\))\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`FindRoot[72 == R[344, P]\ , {P, {0.1}}]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(FindRoot::"frnum"\), \(\(:\)\(\ \)\), "\<\"Function \
\\!\\(TraditionalForm\\`\\({\\(\\(72.` \[InvisibleSpace]\\)\\) - \
\\(\\(1.`\\\\ \\(\\(R(\\(\\(344.`, 0.1`\\)\\))\\)\\)\\)\\)}\\)\\) is not a \
length \\!\\(TraditionalForm\\`1\\) list of numbers at \
\\!\\(TraditionalForm\\`\\({P}\\)\\) = \
\\!\\(TraditionalForm\\`\\({0.1`}\\)\\).\"\>"}], TraditionalForm]], "Message"],

Cell[BoxData[
    \(TraditionalForm\`FindRoot[72 == R(344, P), {P, {0.1`}}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`FindRoot[72 == R(344, P), {P, {0, 1`}}]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(FindRoot::"frnum"\), \(\(:\)\(\ \)\), "\<\"Function \
\\!\\(TraditionalForm\\`\\({\\(\\(72.` \[InvisibleSpace]\\)\\) - \
\\(\\(1.`\\\\ \\(\\(R(\\(\\(344.`, 0.`\\)\\))\\)\\)\\)\\)}\\)\\) is not a \
length \\!\\(TraditionalForm\\`1\\) list of numbers at \
\\!\\(TraditionalForm\\`P\\) = \\!\\(TraditionalForm\\`0.`\\).\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    \(TraditionalForm\`FindRoot[72 == R(344, P), {P, {0, 1.`}}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`FindRoot[72 == R(344, P), {P, {0, 1`}}]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(FindRoot::"frnum"\), \(\(:\)\(\ \)\), "\<\"Function \
\\!\\(TraditionalForm\\`\\({\\(\\(72.` \[InvisibleSpace]\\)\\) - \
\\(\\(1.`\\\\ \\(\\(R(\\(\\(344.`, 0.`\\)\\))\\)\\)\\)\\)}\\)\\) is not a \
length \\!\\(TraditionalForm\\`1\\) list of numbers at \
\\!\\(TraditionalForm\\`P\\) = \\!\\(TraditionalForm\\`0.`\\).\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    \(TraditionalForm\`FindRoot[72 == R(344, P), {P, {0, 1.`}}]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(TraditionalForm\`Solve[\[ExponentialE]\^A == \(\[ExponentialE]\^\(P - \
NC\ P\)\ \((\(-1\) + \[ExponentialE]\^\(NC\ P\))\)\)\/\(\(-1\) + \
\[ExponentialE]\^P\), P]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(X = \(NC - A\)\/\(1\/2\ NC\ \((NC + 1)\) - NC\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(NC - A\)\/\(1\/2\ NC\ \((NC + 1)\) - NC\)\)], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PR[RK, X]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1 - \(\((NC - A)\)\ \((RK - 1)\)\)\/\(1\/2\ NC\ \((NC \
+ 1)\) - NC\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(PP[RK_, A_, NC_] := 
      1 - \(2 \((NC - A)\)\ \((RK - 1)\)\)\/\(NC\ \((NC - 1)\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Sum]\+\(r = 1\)\%344 PP[r, 72, 344]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`72\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(TraditionalForm\`72\), "\[IndentingNewLine]", 
    \(TraditionalForm\`Plot[PP[r, 72, 344], {r, 1, 344}]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`72\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00276855 0.231114 0.372205 [
[.16224 .21861 -6 -9 ]
[.16224 .21861 6 0 ]
[.30066 .21861 -9 -9 ]
[.30066 .21861 9 0 ]
[.43909 .21861 -9 -9 ]
[.43909 .21861 9 0 ]
[.57752 .21861 -9 -9 ]
[.57752 .21861 9 0 ]
[.71595 .21861 -9 -9 ]
[.71595 .21861 9 0 ]
[.85437 .21861 -9 -9 ]
[.85437 .21861 9 0 ]
[.9928 .21861 -9 -9 ]
[.9928 .21861 9 0 ]
[.01131 .04501 -24 -4.5 ]
[.01131 .04501 0 4.5 ]
[.01131 .13806 -30 -4.5 ]
[.01131 .13806 0 4.5 ]
[.01131 .32416 -24 -4.5 ]
[.01131 .32416 0 4.5 ]
[.01131 .41722 -18 -4.5 ]
[.01131 .41722 0 4.5 ]
[.01131 .51027 -24 -4.5 ]
[.01131 .51027 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16224 .23111 m
.16224 .23736 L
s
[(50)] .16224 .21861 0 1 Mshowa
.30066 .23111 m
.30066 .23736 L
s
[(100)] .30066 .21861 0 1 Mshowa
.43909 .23111 m
.43909 .23736 L
s
[(150)] .43909 .21861 0 1 Mshowa
.57752 .23111 m
.57752 .23736 L
s
[(200)] .57752 .21861 0 1 Mshowa
.71595 .23111 m
.71595 .23736 L
s
[(250)] .71595 .21861 0 1 Mshowa
.85437 .23111 m
.85437 .23736 L
s
[(300)] .85437 .21861 0 1 Mshowa
.9928 .23111 m
.9928 .23736 L
s
[(350)] .9928 .21861 0 1 Mshowa
.125 Mabswid
.0515 .23111 m
.0515 .23486 L
s
.07918 .23111 m
.07918 .23486 L
s
.10687 .23111 m
.10687 .23486 L
s
.13455 .23111 m
.13455 .23486 L
s
.18992 .23111 m
.18992 .23486 L
s
.21761 .23111 m
.21761 .23486 L
s
.24529 .23111 m
.24529 .23486 L
s
.27298 .23111 m
.27298 .23486 L
s
.32835 .23111 m
.32835 .23486 L
s
.35604 .23111 m
.35604 .23486 L
s
.38372 .23111 m
.38372 .23486 L
s
.41141 .23111 m
.41141 .23486 L
s
.46678 .23111 m
.46678 .23486 L
s
.49446 .23111 m
.49446 .23486 L
s
.52215 .23111 m
.52215 .23486 L
s
.54983 .23111 m
.54983 .23486 L
s
.6052 .23111 m
.6052 .23486 L
s
.63289 .23111 m
.63289 .23486 L
s
.66058 .23111 m
.66058 .23486 L
s
.68826 .23111 m
.68826 .23486 L
s
.74363 .23111 m
.74363 .23486 L
s
.77132 .23111 m
.77132 .23486 L
s
.799 .23111 m
.799 .23486 L
s
.82669 .23111 m
.82669 .23486 L
s
.88206 .23111 m
.88206 .23486 L
s
.90975 .23111 m
.90975 .23486 L
s
.93743 .23111 m
.93743 .23486 L
s
.96512 .23111 m
.96512 .23486 L
s
.25 Mabswid
0 .23111 m
1 .23111 L
s
.02381 .04501 m
.03006 .04501 L
s
[(-0.5)] .01131 .04501 1 0 Mshowa
.02381 .13806 m
.03006 .13806 L
s
[(-0.25)] .01131 .13806 1 0 Mshowa
.02381 .32416 m
.03006 .32416 L
s
[(0.25)] .01131 .32416 1 0 Mshowa
.02381 .41722 m
.03006 .41722 L
s
[(0.5)] .01131 .41722 1 0 Mshowa
.02381 .51027 m
.03006 .51027 L
s
[(0.75)] .01131 .51027 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .06362 m
.02756 .06362 L
s
.02381 .08223 m
.02756 .08223 L
s
.02381 .10084 m
.02756 .10084 L
s
.02381 .11945 m
.02756 .11945 L
s
.02381 .15667 m
.02756 .15667 L
s
.02381 .17528 m
.02756 .17528 L
s
.02381 .19389 m
.02756 .19389 L
s
.02381 .2125 m
.02756 .2125 L
s
.02381 .24972 m
.02756 .24972 L
s
.02381 .26833 m
.02756 .26833 L
s
.02381 .28694 m
.02756 .28694 L
s
.02381 .30555 m
.02756 .30555 L
s
.02381 .34278 m
.02756 .34278 L
s
.02381 .36139 m
.02756 .36139 L
s
.02381 .38 m
.02756 .38 L
s
.02381 .39861 m
.02756 .39861 L
s
.02381 .43583 m
.02756 .43583 L
s
.02381 .45444 m
.02756 .45444 L
s
.02381 .47305 m
.02756 .47305 L
s
.02381 .49166 m
.02756 .49166 L
s
.02381 .52888 m
.02756 .52888 L
s
.02381 .54749 m
.02756 .54749 L
s
.02381 .5661 m
.02756 .5661 L
s
.02381 .58471 m
.02756 .58471 L
s
.02381 .0264 m
.02756 .0264 L
s
.02381 .00779 m
.02756 .00779 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02658 .60332 m
.0651 .57944 L
.10711 .5534 L
.14657 .52894 L
.18452 .50542 L
.22491 .48039 L
.26379 .45629 L
.30511 .43067 L
.34493 .406 L
.38323 .38225 L
.42398 .357 L
.46321 .33268 L
.50094 .30929 L
.54111 .2844 L
.57977 .26043 L
.62087 .23495 L
.66046 .21041 L
.69855 .18681 L
.73907 .16169 L
.77809 .13751 L
.81955 .11181 L
.8595 .08704 L
.89794 .06322 L
.93882 .03788 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`008Oooool0
0ol0003oooooooooo`3looooo`008Oooool00ol0003oooooooooo`3looooo`008Oooool2o`000?go
oooo000Qooooo`03o`000?oooooooooo0>cooooo0_l0000>ooooo`008Oooool00ol0003ooooooooo
o`3[ooooo`03o`000?oooooooooo00kooooo000Qooooo`03o`000?oooooooooo0>Wooooo0_l0000A
ooooo`008Oooool2o`000>Wooooo00?o0000ooooooooool04Oooool0027ooooo00?o0000oooooooo
ool0i_ooool2o`0001Cooooo000>ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o0000
1Oooool00ol0003oooooooooo`3Uooooo`03o`000?oooooooooo01Cooooo000=ooooo`04o`000?oo
ooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo0>?o
oooo0_l0000Gooooo`001_ooool5o`0000;ooooo00Co0000oooooooooooo00002oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0>;ooooo00?o0000ooooooooool05oooool000gooooo
00Co0000oooooooooooo00002oooool00ol0003oooooooooo`02ooooo`;o0000hOooool2o`0001[o
oooo000=ooooo`04o`000?ooooooooooo`0000Oooooo1?l00005ooooo`03o`000?oooooooooo0=oo
oooo00?o0000ooooooooool06_ooool000gooooo00Co0000oooooooooooo00001oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo0=kooooo00?o0000ooooooooool06oooool000kooooo
0_l00008ooooo`Go00001?ooool00ol0003oooooooooo`3Looooo`;o00007_ooool0027ooooo00?o
0000ooooooooool0foooool00ol0003oooooooooo`0Nooooo`008Oooool2o`000=[ooooo0_l0000Q
ooooo`008Oooool00ol0003oooooooooo`3Gooooo`;o00008oooool0027ooooo00?o0000oooooooo
ool0e_ooool00ol0003oooooooooo`0Sooooo`008Oooool00ol0003oooooooooo`3Dooooo`;o0000
9_ooool0027ooooo0_l0003Cooooo`;o0000:?ooool0027ooooo00?o0000ooooooooool0dOooool0
0ol0003oooooooooo`0Xooooo`008Oooool00ol0003oooooooooo`3?ooooo`;o0000:oooool0027o
oooo00?o0000ooooooooool0cOooool2o`0002gooooo000Qooooo`03o`000?oooooooooo0<cooooo
00?o0000ooooooooool0;Oooool0027ooooo0_l0003;ooooo`;o0000<?ooool0027ooooo00?o0000
ooooooooool0b?ooool2o`0003;ooooo000Qooooo`03o`000?oooooooooo0<Oooooo00?o0000oooo
ooooool0<_ooool0027ooooo00?o0000ooooooooool0aOooool2o`0003Gooooo000Qooooo`03o`00
0?oooooooooo0<?ooooo0_l0000gooooo`008Oooool2o`000<;ooooo0_l0000iooooo`008Oooool0
0ol0003oooooooooo`30ooooo`03o`000?oooooooooo03Wooooo0008ooooo`;o00001?ooool01?l0
003oooooooooooooool5o`0000;ooooo0ol00005ooooo`03o`000?oooooooooo0;kooooo0_l0000l
ooooo`001oooool01?l0003oooooooooool00008ooooo`06o`000?ooooooooooo`000?oooooo0000
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;cooooo0_l0000nooooo`001Ol0
0002ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`02ooooo`;o0000^oooool2o`00043ooooo0007ooooo`04o`000?ooooooooooo`0000[ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Sooooo
0_l00012ooooo`001oooool01?l0003oooooooooool00007ooooo`06o`000?ooooooooooooooool0
003ooooo1?l00005ooooo`03o`000?oooooooooo0;Oooooo00?o0000ooooooooool0@_ooool000Oo
oooo00Co0000oooooooooooo00001oooool01ol0003ooooooooooooooooo0000ooooool000002?oo
ool00ol0003oooooooooo`2eooooo`;o0000AOooool000Sooooo0_l00009ooooo`?o00000_ooool5
o`0000Cooooo00?o0000ooooooooool0/oooool2o`0004Oooooo000Qooooo`;o0000/oooool00ol0
003oooooooooo`17ooooo`008Oooool00ol0003oooooooooo`2`ooooo`;o0000B_ooool0027ooooo
00?o0000ooooooooool0[oooool00ol0003oooooooooo`1:ooooo`008Oooool00ol0003ooooooooo
o`2]ooooo`;o0000COooool0027ooooo00?o0000ooooooooool0[?ooool00ol0003oooooooooo`1=
ooooo`008Oooool2o`000:cooooo00?o0000ooooooooool0C_ooool0027ooooo00?o0000oooooooo
ool0ZOooool2o`00057ooooo000Qooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool0
DOooool0027ooooo00?o0000ooooooooool06oooool3o`0000Cooooo0_l0000Gooooo`?o00001?oo
ool2o`0000Cooooo0_l0000Dooooo`?o00000oooool3o`0000Cooooo0_l0000Cooooo`Go00000ooo
ool2o`0000Cooooo0_l0000Cooooo`Go00000_ooool3o`0000Cooooo0_l0000Dooooo`?o00001?oo
ool2o`0000Cooooo0_l0000Dooooo`?o00000oooool3o`0000Cooooo0_l00003ooooo`008Oooool0
0ol0003oooooooooo`0Jooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooooooo
ool0000Gooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool0000Dooooo`05o`000?ooooooooooooooool000000oooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooooooo017ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0001?ooooo0_l000001?oooooo0000ooooool00003
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool04?ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000Boooo
o`07o`000?ooooooooooooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo
0Ol00001ooooo`7ooooo000Qooooo`;o00007oooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooooooo01Gooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0001Cooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0001;ooooo0ol00007ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool05?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`03ooooo`04o`000?oooooo
ooooo`0000;ooooo0Ol00001ooooo`7ooooo000Qooooo`03o`000?oooooooooo01kooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00;ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool0000Dooooo`03o`000?oooooooooo00Go
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Cooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00oooooo00Go
0000ooooooooooooooooo`000006ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool04_ooool2o`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000D
ooooo`;o00001_ooool01?l0003oooooooooool00002ooooo`7o00000Oooool1ooooo`008Oooool0
0ol0003oooooooooo`0Jooooo`Co00000oooool01?l0003oooooooooool0000Gooooo`03o`000?oo
oooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000Dooooo`04
o`000?ooooooooooooooo`Co00000oooool01?l0003oooooooooool0000Booooo`05o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000oo
oooo0_l000000ooooooo0000ooooo`02ooooo`03o`000?oooooo000000?o00000oooool01?l0003o
ooooooooool0000Fooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooo000000?o00000oooool01?l0003ooooooooo
ool00002ooooo`008Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00Cooooo00Co
0000oooooooooooo00005_ooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool0000Cooooo`;o00000oooool00ol0003oooooooooo`04ooooo`04o`000?oooooooooo
o`0001;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00003_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooo
ool000001_ooool01?l0003oooooooooool0000Booooo`05o`000?ooooooooooooooool000000_oo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0001;ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000000Kooooo00Co0000oooooooooooo00000_ooool0027ooooo0_l0000K
ooooo`Go00000oooool2o`0001Sooooo00?o0000ooooooooool00oooool2o`0000Cooooo0_l0000E
ooooo`04o`000?ooooooooooooooo`Go00000oooool2o`0001Cooooo0ol00004ooooo`;o00001?oo
ool2o`0000gooooo0_l00005ooooo`?o00000_ooool5o`0000?ooooo0_l0000Dooooo`?o00001?oo
ool2o`0000Cooooo0_l0000Dooooo`?o00000_ooool5o`0000?ooooo0_l00003ooooo`008Oooool0
0ol0003oooooooooo`2Kooooo`;o0000Goooool0027ooooo00?o0000ooooooooool0V_ooool00ol0
003oooooooooo`1Oooooo`008Oooool00ol0003oooooooooo`2Hooooo`;o0000H_ooool0027ooooo
00?o0000ooooooooool0U_ooool2o`0006Cooooo000Koooooogo00002?ooool0027ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool00_l00002ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01oooool0
027ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo
023ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`05ooooo`;o00006Oooool00ol0
003oooooooooo`0Pooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool01oooool0027o
oooo00?o0000ooooooooool0Soooool2o`0006_ooooo000Qooooo`03o`000?oooooooooo08kooooo
00?o0000ooooooooool0Joooool0027ooooo0_l0002=ooooo`;o0000K_ooool0027ooooo00?o0000
ooooooooool0R_ooool2o`00073ooooo000Qooooo`03o`000?oooooooooo08Sooooo0_l0001boooo
o`008Oooool00ol0003oooooooooo`26ooooo`;o0000M?ooool0027ooooo0_l00026ooooo`03o`00
0?oooooooooo07Cooooo000Qooooo`03o`000?oooooooooo08?ooooo0_l0001gooooo`008Oooool0
0ol0003oooooooooo`21ooooo`;o0000NOooool0027ooooo00?o0000ooooooooool0P?ooool00ol0
003oooooooooo`1iooooo`008Oooool00ol0003oooooooooo`1nooooo`;o0000O?ooool0027ooooo
0_l0001nooooo`03o`000?oooooooooo07cooooo000Qooooo`03o`000?oooooooooo07_ooooo0_l0
001oooooo`008Oooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo07oooooo000Qoooo
o`03o`000?oooooooooo07Wooooo00?o0000ooooooooool0P?ooool0027ooooo00?o0000oooooooo
ool0Moooool2o`0008?ooooo000Qooooo`;o0000Moooool00ol0003oooooooooo`23ooooo`008Ooo
ool00ol0003oooooooooo`1dooooo`;o0000Q_ooool000Sooooo0_l00004ooooo`04o`000?oooooo
ooooooooo`Go00000_ooool3o`0000Gooooo00?o0000ooooooooool0Loooool00ol0003ooooooooo
o`26ooooo`001oooool01?l0003oooooooooool00008ooooo`06o`000?ooooooooooo`000?oooooo
00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo077ooooo0_l00029ooooo`00
1oooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool00_ooool2o`00077ooooo00?o0000ooooooooool0ROooool000Oooooo00Co0000oooooooooooo
00002_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0K_ooool2o`0008cooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Ko0000oooooooo
ooooooooo`000?ooool4o`0000Gooooo00?o0000ooooooooool0KOooool00ol0003oooooooooo`2<
ooooo`001oooool01?l0003oooooooooool00007ooooo`07o`000?ooooooooooooooool0003ooooo
o`000008ooooo`03o`000?oooooooooo06_ooooo0_l0002?ooooo`002?ooool2o`0000Wooooo0ol0
0002ooooo`Go00001?ooool00ol0003oooooooooo`1Yooooo`;o0000TOooool0027ooooo0_l0001Y
ooooo`03o`000?oooooooooo097ooooo000Qooooo`03o`000?oooooooooo06Kooooo0_l0002Doooo
o`008Oooool00ol0003oooooooooo`1Tooooo`;o0000U_ooool0027ooooo00?o0000ooooooooool0
Hoooool00ol0003oooooooooo`2Fooooo`008Oooool00ol0003oooooooooo`1Qooooo`;o0000VOoo
ool0027ooooo0_l0001Pooooo`;o0000Voooool0027ooooo00?o0000ooooooooool0GOooool2o`00
09gooooo000Qooooo`03o`000?oooooooooo05cooooo00?o0000ooooooooool0WOooool0027ooooo
00?o0000ooooooooool0F_ooool2o`000:3ooooo000Qooooo`03o`000?oooooooooo05Sooooo0_l0
002Rooooo`008Oooool2o`0005Oooooo0_l0002Tooooo`008Oooool00ol0003oooooooooo`1Eoooo
o`03o`000?oooooooooo0:Cooooo000Qooooo`03o`000?oooooooooo05?ooooo0_l0002Wooooo`00
8Oooool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo0:Oooooo000Qooooo`;o0000DOoo
ool2o`000:[ooooo000Qooooo`03o`000?oooooooooo04oooooo00?o0000ooooooooool0Z_ooool0
00kooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo
04gooooo0_l0002]ooooo`003Oooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooo
ooooool000001?ooool00ol0003oooooooooo`1;ooooo`;o0000[oooool000gooooo00Co0000oooo
oooooooo00002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04[ooooo00?o0000
ooooooooool0[oooool000gooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`02
ooooo`;o0000BOooool2o`000;;ooooo000=ooooo`04o`000?ooooooooooo`0000Oooooo1?l00005
ooooo`03o`000?oooooooooo04Kooooo0_l0002dooooo`003Oooool01?l0003oooooooooool00007
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0AOooool00ol0003oooooooooo`2d
ooooo`003_ooool2o`0000Sooooo1Ol00004ooooo`03o`000?oooooooooo04?ooooo0_l0002goooo
o`008Oooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo0;Oooooo000Qooooo`;o0000
@Oooool2o`000;[ooooo000Qooooo`03o`000?oooooooooo03kooooo0_l0002looooo`008Oooool0
0ol0003oooooooooo`0mooooo`03o`000?oooooooooo0;cooooo000Qooooo`03o`000?oooooooooo
03_ooooo0_l0002oooooo`008Oooool2o`0003_ooooo00?o0000ooooooooool0_oooool0027ooooo
00?o0000ooooooooool0>?ooool2o`000<;ooooo000Qooooo`03o`000?oooooooooo03Kooooo0_l0
0034ooooo`008Oooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo0<Cooooo000Qoooo
o`03o`000?oooooooooo03?ooooo0_l00037ooooo`008Oooool2o`0003;ooooo0_l00039ooooo`00
8Oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo0<Wooooo000Qooooo`03o`000?oo
oooooooo02kooooo0_l0003<ooooo`008Oooool00ol0003oooooooooo`0/ooooo`;o0000c_ooool0
027ooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`3>ooooo`008Oooool2o`0002[o
oooo0_l0003Aooooo`008Oooool00ol0003oooooooooo`0Wooooo`;o0000doooool000Sooooo0_l0
0004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o
0000ooooooooool09_ooool00ol0003oooooooooo`3Cooooo`001oooool01?l0003oooooooooool0
0009ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo02Cooooo0_l0003Fooooo`001oooool01?l0003oooooooooool0000:ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`0002Cooooo00?o0000ooooooooool0
e_ooool000Oooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool08Oooool2o`000=Wooooo0007ooooo`04o`000?oo
ooooooooo`0000_ooooo00?o0000ooooool000000ol00005ooooo`03o`000?oooooooooo023ooooo
00?o0000ooooooooool0fOooool000Oooooo00Co0000oooooooooooo00001oooool01ol0003ooooo
oooooooooooo0000ooooool000002?ooool00ol0003oooooooooo`0Nooooo`;o0000g?ooool000So
oooo0_l00008ooooo`Go000000?oooooo`000?l000000ol00004ooooo`03o`000?oooooooooo01go
oooo00?o0000ooooooooool0g?ooool0027ooooo0_l0000Looooo`;o0000goooool0027ooooo00?o
0000ooooooooool06Oooool2o`000>7ooooo000Qooooo`03o`000?oooooooooo01Sooooo00?o0000
ooooooooool0hOooool0027ooooo00?o0000ooooooooool05_ooool2o`000>Cooooo000Qooooo`03
o`000?oooooooooo01Cooooo0_l0003Vooooo`008Oooool2o`0001Cooooo00?o0000ooooooooool0
i_ooool0027ooooo00?o0000ooooooooool04Oooool2o`000>Wooooo000Qooooo`03o`000?oooooo
oooo013ooooo00?o0000ooooooooool0jOooool0027ooooo00?o0000ooooooooool03_ooool2o`00
0>cooooo000Qooooo`03o`000?oooooooooo00cooooo0_l0003^ooooo`008Oooool2o`0000cooooo
00?o0000ooooooooool0k_ooool0027ooooo00?o0000ooooooooool02Oooool2o`000?7ooooo000Q
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0lOooool0027ooooo00?o0000oooo
ooooool01_ooool2o`000?Cooooo000Qooooo`;o00001Oooool2o`000?Kooooo000Qooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0m_ooool0027ooooo00Co0000oooooooooooooooo
0_l0003iooooo`006Oooool3o`0000Gooooo00Co0000ooooool0003o0000noooool001[ooooo00?o
0000ooooooooool01?ooool2o`000?gooooo000Jooooo`03o`000?oooooooooo00Cooooo0_l0003m
ooooo`006_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0?cooooo000Jooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0o?ooool001Wooooo0_l00006ooooo`03o`00
0?oooooooooo0?cooooo000Jooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0o?oo
ool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-47.4018, -0.72723, 1.42951, \
0.010633}}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PP[250, 72, 344]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-\(2183\/14749\)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Remove[A]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(A\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`A\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`FindRoot[
      R[344, P] \[Equal] 72, {P, {0, 1}}]\)], "Input",
  FormatType->StandardForm],

Cell[BoxData[
    FormBox[
      RowBox[{\(FindRoot::"frnum"\), \(\(:\)\(\ \)\), "\<\"Function \
\\!\\(TraditionalForm\\`\\({\\(\\(R(\\(\\(344.`, 0.`\\)\\))\\)\\) - \
72.`}\\)\\) is not a length \\!\\(TraditionalForm\\`1\\) list of numbers at \
\\!\\(TraditionalForm\\`P\\) = \\!\\(TraditionalForm\\`0.`\\).\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    \(TraditionalForm\`FindRoot[R(344, P) == 72, {P, {0, 1}}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`FindRoot[
      R(344, P) == 72, {P, {0.000, 1.000}}]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(FindRoot::"frnum"\), \(\(:\)\(\ \)\), "\<\"Function \
\\!\\(TraditionalForm\\`\\({\\(\\(R(\\(\\(344.`, 0.`\\)\\))\\)\\) - \
72.`}\\)\\) is not a length \\!\\(TraditionalForm\\`1\\) list of numbers at \
\\!\\(TraditionalForm\\`P\\) = \\!\\(TraditionalForm\\`0.`\\).\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    \(TraditionalForm\`FindRoot[R(344, P) == 72, {P, {0.`, 1.`}}]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[IndentingNewLine]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`R[344, 0.1]\)], "Input",
  FormatType->StandardForm],

Cell[BoxData[
    \(TraditionalForm\`R(344, 0.1`)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[IndentingNewLine]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`R(N, P)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(\[ExponentialE]\^\(P - N\ P\)\ \((\(-1\) + \
\[ExponentialE]\^\(N\ P\))\)\)\/\(\(-1\) + \[ExponentialE]\^P\)\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 845}},
WindowSize->{520, 723},
WindowMargins->{{4, Automatic}, {Automatic, 4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 62, 1, 28, "Input"],
Cell[1819, 54, 109, 2, 46, "Input"],
Cell[1931, 58, 78, 1, 59, "Input"],

Cell[CellGroupData[{
Cell[2034, 63, 60, 1, 28, "Input"],
Cell[2097, 66, 146, 2, 49, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2280, 73, 89, 1, 30, "Input"],
Cell[2372, 76, 417, 7, 35, "Message"],
Cell[2792, 85, 89, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2918, 91, 89, 1, 30, "Input"],
Cell[3010, 94, 404, 7, 21, "Message"],
Cell[3417, 103, 91, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3545, 109, 89, 1, 30, "Input"],
Cell[3637, 112, 404, 7, 21, "Message"],
Cell[4044, 121, 91, 1, 30, "Output"]
}, Open  ]],
Cell[4150, 125, 196, 3, 49, "Input"],

Cell[CellGroupData[{
Cell[4371, 132, 80, 1, 55, "Input"],
Cell[4454, 135, 96, 2, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4587, 142, 42, 1, 28, "Input"],
Cell[4632, 145, 120, 2, 56, "Output"]
}, Open  ]],
Cell[4767, 150, 118, 2, 49, "Input"],

Cell[CellGroupData[{
Cell[4910, 156, 70, 1, 59, "Input"],
Cell[4983, 159, 53, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5073, 165, 138, 2, 50, "Input"],
Cell[5214, 169, 53, 1, 30, "Output"],
Cell[5270, 172, 20059, 514, 186, 4422, 316, "GraphicsData", "PostScript", \
"Graphics"],
Cell[25332, 688, 167, 4, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25536, 697, 49, 1, 28, "Input"],
Cell[25588, 700, 71, 1, 47, "Output"]
}, Open  ]],
Cell[25674, 704, 42, 1, 28, "Input"],

Cell[CellGroupData[{
Cell[25741, 709, 34, 1, 28, "Input"],
Cell[25778, 712, 52, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25867, 718, 129, 3, 30, "Input"],
Cell[25999, 723, 352, 6, 21, "Message"],
Cell[26354, 731, 89, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26480, 737, 103, 2, 30, "Input"],
Cell[26586, 741, 352, 6, 21, "Message"],
Cell[26941, 749, 93, 1, 30, "Output"]
}, Open  ]],
Cell[27049, 753, 52, 1, 46, "Input"],

Cell[CellGroupData[{
Cell[27126, 758, 89, 2, 30, "Input"],
Cell[27218, 762, 63, 1, 30, "Output"]
}, Open  ]],
Cell[27296, 766, 52, 1, 46, "Input"],

Cell[CellGroupData[{
Cell[27373, 771, 57, 1, 30, "Input"],
Cell[27433, 774, 161, 2, 49, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

