(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7239,        269]*)
(*NotebookOutlinePosition[      7874,        291]*)
(*  CellTagsIndexPosition[      7830,        287]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Smatch[p1_, p2_] := 
      1/Log[2]*\ 
        Log[\((p1*p2\  + \ 
                1/3\ \((1 - p1)\)*\((1 - p2)\))\)/\((p1*\((1 - p2)\) + 
                p2*\((1 - p1)\) + 
                2/3*\((1 - p1)\)*\((1 - p2)\))\)]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Smatch[p1, p2]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(log(3\/\(\(-4\)\ p2\ p1 + p1 + p2 + 2\) - \
1)\)\/\(log(2)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Smismatch[p1_, p2_] := \ 
      1/Log[2]\ *\ 
        Log[\((\ 1/3\ \((1 - p1)\)*\((1 - p2)\) + \ 
                p1\ *\ 1/3\ \((1 - p2)\) + \ 
                p2\ *\ 1/3\ \((1 - p1)\))\)/\((p1*p2\  + \ 
                p1\ *\ 2/3\ \((1 - p2)\)\  + \ p2\ *\ 2/3\ \((1 - p1)\)\  + \ 
                2/3\ \((1 - p1)\)*\((1 - p2)\))\)]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Smismatch[p1, p2]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(log(3\/\(p1\ p2 + 2\) - 1)\)\/\(log(2)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(SMQ[Q1_, Q2_] := 
      Smatch[1 - 10^\(-\((Q1/10\ )\)\), 1 - 10^\(-\((Q2/10\ )\)\)]\)], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(SMisQ[Q1_, Q2_] := 
      Smismatch[1 - 10^\(-\((Q1/10\ )\)\), 
        1 - 10^\(-\((Q2/10\ )\)\)]\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(N[SMQ[40, 40]]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`12.28752001379883`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[SMisQ[4, 4]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-1.8891705167231274`\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(GoodMatch[p1_, 
        p2_] := \((p1*p2\  + \ 1/3\ \((1 - p1)\)*\((1 - p2)\))\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(FullSimplify[
      1 - GoodMatch[p1, p2]]\)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1\/3\ \((\(-4\)\ p2\ p1 + p1 + p2 + 2)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(BadMatch[p1_, 
        p2_] := \((p1*\((1 - p2)\) + p2*\((1 - p1)\) + 
          2/3*\((1 - p1)\)*\((1 - p2)\))\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(FullSimplify[
      BadMatch[p1, p2] + \ GoodMatch[p1, p2]]\)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(GoodMisMatch[p1_, p2_] := \((\ 
        1/3\ \((1 - p1)\)*\((1 - p2)\) + \ p1\ *\ 1/3\ \((1 - p2)\) + \ 
          p2\ *\ 1/3\ \((1 - p1)\))\)\)], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(BadMisMatch[p1_, 
        p2_] := \((p1*p2\  + \ p1\ *\ 2/3\ \((1 - p2)\)\  + \ 
          p2\ *\ 2/3\ \((1 - p1)\)\  + \ 
          2/3\ \((1 - p1)\)*\((1 - p2)\))\)\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(FullSimplify[
      BadMisMatch[p1, p2] + \ GoodMisMatch[p1, p2]]\)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Smatch2[p1_, p2_] := 
      1/Log[2]*Log[GoodMatch[p1, p2]/\((1 - GoodMatch[p1, p2])\)]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Smatch2[p1, p2]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(log(3\/\(\(-4\)\ p2\ p1 + p1 + p2 + 2\) - \
1)\)\/\(log(2)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(ErrArticle[p1_, p2_] := \((1 - p1)\) + \((1 - p2)\) - 
        4/3 \((1 - p1)\) \((1 - p2)\)\)], "Input"],

Cell[BoxData[
    \(SmatchArt[p1_, p2_] := 
      1/Log[2]*\ Log[\((1 - ErrArticle[p1, p2])\)*4]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Distribute[SmatchArt[p1, p2]]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(log(4\/3\ \((\(-p2\) + p1\ \((4\ p2 - 1)\) + 1)\))\)\
\/\(log(2)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(SmismatchArt[p1_, p2_] := 
      1/Log[2]*\ Log[4/3*ErrArticle[p1, p2]]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(FullSimplify[
      SmismatchArt[p1, p2]]\)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(log(\(-4\)\ p2\ p1 + p1 + p2 + 2) - \
log(9\/4)\)\/\(log(2)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[SmatchArt[1 - 10^\(-4\), 1 - 10^\(-2\)]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1.9855490050777345`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[SmismatchArt[1 - 10^\(-4\), 1 - 10^\(-4\)]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-11.872771063146129`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Distribute[Log[GoodMatch[p1, p2]*4]/Log[2]]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(log(4\/3\ \((\(-p2\) + p1\ \((4\ p2 - 1)\) + 1)\))\)\
\/\(log(2)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Log[GoodMatch[1 - 10^\(-4\), 1 - 10^\(-2\)]*4]/Log[2]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1.9853566393912445`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Log[GoodMisMatch[p1, p2]*4/3]/Log[2]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(log(4\/9 - \(4\ p1\ p2\)\/9)\)\/\(log(2)\)\)], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Log[GoodMatch[1 - 10^\(-4\), 1 - 10^\(-4\)]*4/3]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`0.28748206578511437`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{0, 1440}, {0, 845}},
WindowSize->{847, 756},
WindowMargins->{{4, Automatic}, {Automatic, 4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 256, 6, 101, "Input"],

Cell[CellGroupData[{
Cell[2035, 61, 61, 1, 32, "Input"],
Cell[2099, 64, 113, 2, 65, "Output"]
}, Open  ]],
Cell[2227, 69, 367, 7, 124, "Input"],

Cell[CellGroupData[{
Cell[2619, 80, 64, 1, 32, "Input"],
Cell[2686, 83, 93, 1, 65, "Output"]
}, Open  ]],
Cell[2794, 87, 117, 2, 32, "Input"],
Cell[2914, 91, 162, 3, 55, "Input"],

Cell[CellGroupData[{
Cell[3101, 98, 83, 2, 55, "Input"],
Cell[3187, 102, 69, 1, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3293, 108, 47, 1, 32, "Input"],
Cell[3343, 111, 75, 1, 34, "Output"]
}, Open  ]],
Cell[3433, 115, 113, 2, 32, "Input"],

Cell[CellGroupData[{
Cell[3571, 121, 106, 2, 55, "Input"],
Cell[3680, 125, 91, 1, 52, "Output"]
}, Open  ]],
Cell[3786, 129, 146, 3, 32, "Input"],

Cell[CellGroupData[{
Cell[3957, 136, 123, 2, 55, "Input"],
Cell[4083, 140, 52, 1, 34, "Output"]
}, Open  ]],
Cell[4150, 144, 175, 3, 55, "Input"],
Cell[4328, 149, 230, 4, 78, "Input"],

Cell[CellGroupData[{
Cell[4583, 157, 129, 2, 55, "Input"],
Cell[4715, 161, 52, 1, 34, "Output"]
}, Open  ]],
Cell[4782, 165, 120, 2, 55, "Input"],

Cell[CellGroupData[{
Cell[4927, 171, 62, 1, 32, "Input"],
Cell[4992, 174, 113, 2, 65, "Output"]
}, Open  ]],
Cell[5120, 179, 125, 2, 32, "Input"],
Cell[5248, 183, 109, 2, 32, "Input"],

Cell[CellGroupData[{
Cell[5382, 189, 76, 1, 32, "Input"],
Cell[5461, 192, 119, 2, 62, "Output"]
}, Open  ]],
Cell[5595, 197, 140, 3, 55, "Input"],

Cell[CellGroupData[{
Cell[5760, 204, 105, 2, 55, "Input"],
Cell[5868, 208, 114, 2, 62, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6019, 215, 75, 1, 32, "Input"],
Cell[6097, 218, 70, 1, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6204, 224, 78, 1, 32, "Input"],
Cell[6285, 227, 75, 1, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6397, 233, 90, 1, 32, "Input"],
Cell[6490, 236, 119, 2, 62, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6646, 243, 89, 1, 32, "Input"],
Cell[6738, 246, 70, 1, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6845, 252, 83, 1, 32, "Input"],
Cell[6931, 255, 97, 2, 64, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7065, 262, 84, 1, 32, "Input"],
Cell[7152, 265, 71, 1, 34, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

