from operator import *
from util import import_object, OmakException, IndexedList
from constants import klass


class OmakBase(object):

    def __init__(self, omak=None):
        try:
            self.operators = omak.operators.copy()
        except AttributeError:
            self.operators = IndexedList()

    def __str__(self):
        return ''.join([str(e) for e in self.operators])

    def __repr__(self):
        return '<gremlin script: %s>' % str(self)

    def as_(self, index):
        operator = Operator('as', index, index=index, out=type(self))
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def back(self, index):
        if isinstance(index, int):
            new_index = self.index - index
        else:
            # isinstance(index, str)
            new_index = 0
            for operator in self.operators:
                if operator.index == index:
                    break
                new_index += 1
        self.operators.index = new_index
        OmakClass = self.operators.pick().out
        operator = Operator('back', index, out=OmakClass)
        omak = OmakClass(self)
        omak.operators.append(operator)
        return omak

    def loop(self, index, closure, emit):
        OmakClass = self.operators[-1].out
        operator = LoopOperator(index, closure, emit, out=OmakClass)
        omak = OmakClass(self)
        omak.operators.append(operator)
        return omak

    def unique(self):
        OmakClass = self.operators[-1].out
        operator = Operator('unique', out=OmakClass)
        omak = OmakClass(self)
        omak.operators.append(operator)
        return omak


class Omak(OmakBase):

    def random(self, double):
        operator = Operator('random', double, out=type(self))
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def filter(self, closure):
        operator = ClosureOperator('filter', closure, out=type(self))
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def sort(self, closure):
        operator = ClosureOperator('sort', closure, out=OmakBase)
        omak = OmakBase(self)
        omak.operators.append(operator)
        return omak

    def copy_split(self, *pipes):
        operator = SplitOperator(*pipes)
        omak = Omak(self)
        omak.operators.append(operator)
        return omak

    @property
    def exhaust_merge(self):
        operator = Property('exhaustMerge')
        omak = Omak(self)
        omak.operators.append(operator)
        return omak

    @property
    def fair_merge(self):
        operator = Property('fairMerge')
        omak = Omak(self)
        omak.operators.append(operator)
        return omak

    @property
    def dedup(self):
        operator = Property('dedup')
        omak = Omak(self)
        omak.operators.append(operator)
        return omak


class Element(Omak):

    @property
    def map(self):
        operator = Property('map', out=Omak)
        omak = Omak(self)
        omak.operators.append(operator)
        return omak

    def __getattribute__(self, attribute):
        try:
            return super(Element, self).__getattribute__(attribute)
        except AttributeError:
            operator = Property(attribute, out=type(self))
            omak = type(self)(self)
            omak.operators.append(operator)
            return omak

    def item(self, idx):
        operator = GetItem(idx, out=type(self))
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def range(self, start, end):
        operator = GetRange(start, end, out=type(self))
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def set_property(self, key, value):
        operator = Operator('setProperty', key, value, out=OmakBase)
        omak = OmakBase(self)
        omak.operators.append(operator)
        return omak

    def paths(self, *closures):
        operator = ClosureOperator('paths', *closures, out=OmakBase)
        omak = OmakBase(self)
        omak.operators.append(operator)
        return omak


class Index(object):
    def count(self, key, value):
        operator = Operator('count', key, value)
        self.operators.append(operator)

    def get(self, key, value):
        operator = Operator('get', key, value)
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def put(self, key, value, element):
        operator = Operator('put', key, value, element)
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def remove(self, key, value, element):
        operator = Operator('remove', key, value, element)
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak


class Graph(OmakBase):

    def __init__(self):
        self.operators = IndexedList([BaseProperty('g', out=type(self))])

    @property
    def V(self):
        omak = Vertex(self)
        operator = Property('V', out=Vertex)
        omak.operators.append(operator)
        return omak

    @property
    def E(self):
        operator = Property('E', out=Edge)
        omak = Edge(self)
        omak.operators.append(operator)
        return omak

    def v(self, *ids):
        operator = Operator('v', *ids, out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak


    def e(self, *ids):
        operator = Operator('e', *ids, out=Edge)
        omak = Edge(self)
        omak.operators.append(operator)
        return omak

    def create_manual_vertex_index(self, name):
        operator = Operator(
            'createManualIndex',
            name,
            klass.Vertex,
            out=Index
        )
        omak = Index(self)
        omak.operators.append(operator)
        return omak

    def create_manual_edge_index(self, name):
        operator = Operator('createManualIndex', name, klass.Edge, out=Index)
        omak = Index(self)
        omak.operators.append(operator)
        return omak

    def create_automatic_vertex_index(self, name, *keys):
        operator = Operator(
            'createAutomaticIndex',
            name,
            keys,
            klass.Vertex,
            out=Index
        )
        omak = Index(self)
        omak.operators.append(operator)
        return omak

    def create_automatic_edge_index(self, name, *keys):
        operator = Operator(
            'createAutomaticIndex',
            name,
            keys,
            klass.Edge,
            out=Index
        )
        omak = AutomaticIndex(self)
        omak.operators.append(operator)
        return omak

    def vertex_index(self, name):
        operator = Operator('getIndex', name, klass.Vertex, out=Index)
        omak = Index(self)
        omak.operators.append(operator)
        return omak

    def edge_index(self, name):
        operator = Operator('getIndex', name, klass.Edge, out=Index)
        omak = Index(self)
        omak.operators.append(operator)
        return omak

    def drop_index(self, name):
        operator = Operator('dropIndex', name)
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def create_vertex(self):
        operator = Operator('addVertex', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak

    def vertex(self, idx):
        operator = Operator('getVertex', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak

    def remove_vertex(self, vertex):
        operator = Operator('removeVertex', vertex)
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak

    def create_edge(self, outV, inV, label):
        operator = Operator('addEdge', outV, inV, label, out=Vertex)
        omak = Edge(self)
        omak.operators.append(operator)
        return omak

    def edge(self, idx):
        operator = Operator('getEdge', out=Edge)
        omak = Edge(self)
        omak.operators.append(operator)
        return omak

    def remove_edge(self, edge):
        operator = Operator('removeEdge', edge)
        omak = type(self)(self)
        omak = omak.operators.append(operator)
        return omak

    def clear(self):
        operator = Operator('clear')
        omak = type(self)(self)
        omak.operators.append(operator)
        return omak


class Edge(Element):

    @property
    def inV(self):
        operator = Property('inV', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak

    @property
    def outV(self):
        operator = Property('outV', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak

    @property
    def both(self):
        operator = Property('both', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak


class Vertex(Element):

    def outV(self):
        operator = Property('out', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak

    def outE(self):
        operator = Property('outE',  out=Edge)
        omak = Edge(self)
        omak.operators.append(operator)
        return omak

    def inV(self):
        operator = Property('in', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak

    def inE(self):
        operator = Property('inE', out=Edge)
        omak = Edge(self)
        omak.operators.append(operator)
        return omak

    def bothV(self):
        operator = Property('both', out=Vertex)
        omak = Vertex(self)
        omak.operators.append(operator)
        return omak

    def bothE(self):
        operator = Property('bothE', out=Edge)
        omak = Edge(self)
        omak = omak.operators.append(operator)
        return omak
