class DictWithMagicProperties(dict):
    """dict object which keys can be accessed as properties"""

    def __getattribute__(self, attribute):
        try: 
            return super(DictWithMagicProperties, self).__getattribute__(attribute)
        except AttributeError:
            return self[attribute]


def import_object(class_path):
    components = class_path.split('.')
    module_path = '.'.join(components[:-1])
    mod = __import__(module_path, {}, {}, [])
    for comp in components[1:]:
        mod = getattr(mod, comp)
    return mod


class OmakException(Exception):
    pass


class IndexedList(list):

    def __init__(self, l=None):
        if l is None:
            l = []
        super(IndexedList, self).__init__(l)
        self.index = -1

    def append(self, object):
        super(IndexedList, self).append(object)
        self.index += 1

    def pick(self):
        return self[self.index]

    def copy(self):
        return IndexedList(self)
