#!/usr/bin/env python
# -*- coding: utf-8 -*-

##############################################################################
#                                                                            #
# (C) 2014 Arulalan.T <arulalant@gmail.com>                                  #
#                                                                            #
# Author : Arulalan.T <arulalant@gmail.com>                                  #
# Date : 04.08.2014                                                          #
#                                                                            #
# This file is part of open-tamil/txt2uni                                    #
#                                                                            #
# txt2uni is free software: you can redistribute it and/or                   #  
# modify it under the terms of the GNU General Public License as published by#
# the Free Software Foundation, either version 3 of the License, or (at your #
# option) any later version. This program is distributed in the hope that it #
# will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty#
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General#
# Public License for more details. You should have received a copy of the GNU#
# General Public License along with this program. If not, see                #  
# <http://www.gnu.org/licenses/>.                                            #  
#                                                                            #
##############################################################################     
from orddic import OrderedDict

# begin of anjal2utf8 dictionary 
anjal2utf8 = OrderedDict([

    ("û", "க்ஷ"),
    ("û‘", "க்ஷா"),
    ("û’", "க்ஷி"),
    ("û“", "க்ஷீ"),
    ("û”", "க்ஷு"),
    ("û•", "க்ஷூ"),
    ("—û", "க்ஷெ"),
    ("þû", "க்ஷே"),
    ("—û‘", "க்ஷொ"),
    ("÷ñõ", "க்ஷோ"),
    ("—ûã", "க்ஷௌ"),
    ("û", "க்ஷை"),
    ("ü", "க்ஷ்"),

    ("—óó", "ஜௌ"),
    ("þó‘", "ஜோ"),
    ("—ó‘", "ஜொ"),
    ("ó‘", "ஜா"),
    ("ó", "ஜி"),
    ("ó’", "ஜி"),
    ("ó", "ஜீ"),
    ("ó”", "ஜு"),
    ("ó•", "ஜூ"),
    ("—ó", "ஜெ"),
    ("þó", "ஜே"),
    ("€ó", "ஜை"),
    ("ô", "ஜ்"),
    ("ó", "ஜ"),

    ("—ã", "கௌ"),
    ("þ‘", "கோ"),
    ("—‘", "கொ"),
    ("‘", "கா"),
    ("Ž", "கி"),
    ("", "கீ"),
    ("", "கு"),
    ("˜", "கூ"),
    ("—", "கெ"),
    ("þ", "கே"),
    ("€", "கை"),
    ("", "க்"),
    ("™", "க்"),
    ("", "க"),

    ("—šã", "ஙௌ"),
    ("þš‘", "ஙோ"),
    ("—š‘", "ஙொ"),
    ("š‘", "ஙா"),
    ("š", "ஙி"),
    ("š", "ஙீ"),
    ("—š", "ஙெ"),
    ("þš", "ஙே"),
    ("€š", "ஙை"),
    ("›", "ங்"),
    ("š", "ங"),

    ("—œã", "சௌ"),
    ("þœ‘", "சோ"),
    ("—œ‘", "சொ"),
    ("œ‘", "சா"),
    ("", "சி"),
    ("", "சீ"),
    ("Ÿ", "சு"),
    ("¡", "சூ"),
    ("—œ", "செ"),
    ("þœ", "சே"),
    ("€œ", "சை"),
    ("¢", "ச்"),
    ("œ", "ச"),
    ("œ", "ச"),
    ("—£ã", "ஞௌ"),
    ("þ£‘", "ஞோ"),
    ("—£‘", "ஞொ"),
    ("£‘", "ஞா"),
    ("£", "ஞி"),
    ("£", "ஞீ"),
    ("—£", "ஞெ"),
    ("þ£", "ஞே"),
    ("€£", "ஞை"),
    ("¤", "ஞ்"),
    ("£", "ஞ"),

    ("—¥ã", "டௌ"),
    ("þ¥‘", "டோ"),
    ("—¥‘", "டொ"),
    ("¥‘", "டா"),
    ("¦", "டி"),
    ("§", "டீ"),
    ("¨", "டு"),
    ("©", "டூ"),
    ("—¥", "டெ"),
    ("þ¥", "டே"),
    ("€¥", "டை"),
    ("ª", "ட்"),
    ("¥", "ட"),

    ("—«ã", "ணௌ"),
    ("þ«‘", "ணோ"),
    ("—«‘", "ணொ"),
    ("«‘", "ணா"),
    ("¬", "ணி"),
    ("−", "ணீ"),

    ("®–", "ணூ"),
    ("®", "ணு"),

    ("—«", "ணெ"),
    ("þ«", "ணே"),
    ("€«", "ணை"),
    ("¯", "ண்"),
    ("«", "ண"),
    ("—°ã", "தௌ"),
    ("þ°‘", "தோ"),
    ("—°‘", "தொ"),
    ("°‘", "தா"),
    ("±", "தி"),
    ("²", "தீ"),
    ("³–", "தூ"),
    ("³", "து"),

    ("—°", "தெ"),
    ("þ°", "தே"),
    ("€°", "தை"),
    ("´", "த்"),
    ("°", "த"),

    ("—µã", "நௌ"),
    ("þµ‘", "நோ"),
    ("—µ‘", "நொ"),
    ("µ‘", "நா"),
    ("¶", "நி"),
    ("ÿ", "நீ"),

    ("¸–", "நூ"),
    ("¸", "நு"),
    ("—µ", "நெ"),
    ("þµ", "நே"),
    ("€µ", "நை"),
    ("¹", "ந்"),
    ("µ", "ந"),

    ("—îã", "னௌ"),
    ("þî‘", "னோ"),
    ("—î‘", "னொ"),
    ("î‘", "னா"),
    ("ï", "னி"),
    ("ð", "னீ"),

    ("ñ–", "னூ"),
    ("ñ", "னு"),
    ("—î", "னெ"),
    ("þî", "னே"),
    ("€î", "னை"),
    ("ò", "ன்"),
    ("î", "ன"),

    ("—ºã", "பௌ"),
    ("þº‘", "போ"),
    ("—º‘", "பொ"),
    ("º‘", "பா"),

    ("»", "பி"),
    ("¼", "பீ"),
    ("½", "பு"),
    ("¾", "பூ"),
    ("—º", "பெ"),
    ("þº", "பே"),
    ("€º", "பை"),
    ("¿", "ப்"),
    ("º", "ப"),

    ("—Àã", "மௌ"),
    ("þÀ‘", "மோ"),
    ("—À‘", "மொ"),
    ("À‘", "மா"),
    ("Á", "மி"),
    ("Â", "மீ"),
    ("Ã", "மு"),
    ("Ä", "மூ"),
    ("—À", "மெ"),
    ("þÀ", "மே"),
    ("€À", "மை"),
    ("Å", "ம்"),
    ("À", "ம"),
    ("—Æã", "யௌ"),
    ("þÆ‘", "யோ"),
    ("—Æ‘", "யொ"),
    ("Æ‘", "யா"),
    ("Ç", "யி"),
    ("È", "யீ"),
    ("É", "யு"),
    ("Ê", "யூ"),
    ("—Æ", "யெ"),
    ("þÆ", "யே"),
    ("€Æ", "யை"),
    ("Ë", "ய்"),
    ("Æ", "ய"),

    ("—Ìã", "ரௌ"),
    ("þÌ‘", "ரோ"),
    ("—Ì‘", "ரொ"),
    ("Ì‘", "ரா"),
    ("Í", "ரி"),
    ("Î", "ரீ"),
    ("Ï", "ரு"),
    ("Ð", "ரூ"),
    ("—Ì", "ரெ"),
    ("þÌ", "ரே"),
    ("€Ì", "ரை"),
    ("Ñ", "ர்"),
    ("Ì", "ர"),

    ("—Òã", "லௌ"),
    ("þÒ‘", "லோ"),
    ("—Ò‘", "லொ"),
    ("Ò‘", "லா"),
    ("Ó", "லி"),
    ("Ô", "லீ"),
    ("Õ–", "லூ"),
    ("Õ", "லு"),

    ("—Ò", "லெ"),
    ("þÒ", "லே"),
    ("€Ò", "லை"),
    ("Ö", "ல்"),
    ("Ò", "ல"),

    ("—ãã", "ளௌ"),
    ("þã‘", "ளோ"),
    ("—ã‘", "ளொ"),
    ("ã‘", "ளா"),
    ("ä", "ளி"),
    ("å", "ளீ"),
    ("æ", "ளு"),
    ("ç", "ளூ"),
    ("—ã", "ளெ"),
    ("þã", "ளே"),
    ("€ã", "ளை"),
    ("è", "ள்"),
    ("ã", "ள"),
    ("€×", "வை"),
    ("—××", "வௌ"),
    ("þ×‘", "வோ"),
    ("—×‘", "வொ"),
    ("×‘", "வா"),
    ("Ø", "வி"),
    ("Ù", "வீ"),
    ("Ú", "வு"),
    ("Û", "வூ"),
    ("—×", "வெ"),
    ("þ×", "வே"),

    ("Ü", "வ்"),
    ("×", "வ"),

    ("—éé", "றௌ"),
    ("þé‘", "றோ"),
    ("—é‘", "றொ"),
    ("é‘", "றா"),
    ("ê", "றி"),
    ("ë", "றீ"),
    ("ì–", "றூ"),
    ("ì", "று"),

    ("—é", "றெ"),
    ("þé", "றே"),
    ("€é", "றை"),
    ("í", "ற்"),
    ("é", "ற"),

    ("—ùù", "ஹௌ"),
    ("þù‘", "ஹோ"),
    ("—ù‘", "ஹொ"),
    ("ù‘", "ஹா"),
    ("ù", "ஹி"),
    ("ù", "ஹீ"),
    ("ù”", "ஹு"),
    ("ù•", "ஹூ"),
    ("—ù", "ஹெ"),
    ("þù", "ஹே"),
    ("€ù", "ஹை"),
    ("ú", "ஹ்"),
    ("ù", "ஹ"),

    ("—ÝÝ", "ழௌ"),
    ("þÝ‘", "ழோ"),
    ("—Ý‘", "ழொ"),
    ("Ý‘", "ழா"),
    ("Þ", "ழி"),
    ("ß", "ழீ"),
    ("à", "ழு"),
    ("á", "ழூ"),
    ("—Ý", "ழெ"),
    ("þÝ", "ழே"),
    ("€Ý", "ழை"),
    ("â", "ழ்"),
    ("Ý", "ழ"),

    ("öåå", "ஷௌ"),
    ("÷åõ", "ஷோ"),
    ("öåõ", "ஷொ"),
    ("åõ", "ஷா"),
    ("æ", "ஷி"),
    ("ç", "ஷீ"),
    ("åú", "ஷு"),
    ("åü", "ஷூ"),
    ("öå", "ஷெ"),
    ("÷å", "ஷே"),
    ("øå", "ஷை"),
    ("è", "ஷ்"),
    ("å", "ஷ"),

    ("—õõ", "ஷௌ"),
    ("þõ‘", "ஷோ"),
    ("—õ‘", "ஷொ"),
    ("õ‘", "ஷா"),
    ("õ", "ஷி"),
    ("õ", "ஷீ"),
    ("—õ", "ஷெ"),
    ("þõ", "ஷே"),
    ("€õ", "ஷை"),
    ("ö", "ஷ்"),
    ("õ", "ஷ"),

    ("—÷÷", "ஸௌ"),
    ("þ÷‘", "ஸோ"),
    ("—÷‘", "ஸொ"),
    ("÷‘", "ஸா"),
    ("÷", "ஸி"),
    ("÷", "ஸீ"),
    ("—÷", "ஸெ"),
    ("þ÷", "ஸே"),
    ("€÷", "ஸை"),
    ("ø", "ஸ்"),
    ("÷", "ஸ"),

    ("", "அ"),
    ("‚", "ஆ"),

    ("„", "ஈ"),
    ("…", "உ"),
    ("†", "ஊ"),
    ("‡", "எ"),
    ("ˆ", "ஏ"),
    ("‰", "ஐ"),
    ("Š", "ஒ"),
    ("‹", "ஓ"),
    ("Šã", "ஔ"),

    ("Œ", "ஃ"),
    ("ƒ", "இ"),
    ("ý", "ஸ்ரீ"),

    ])
# end of anjal2utf8 dictionary 

     

# begin of bamini2utf8 dictionary 
bamini2utf8 = OrderedDict([

    ("sp", "ளி"),
    ("hp", "ரி"),
    ("hP", "ரீ"),
    ("uP", "ரீ"),
    ("u;", "ர்"),
    ("h;", "ர்"),
    ("H", "ர்"),
    ("\+", "10"),

    ("nfs", "கௌ"),
    ("Nfh", "கோ"),
    ("nfh", "கொ"),
    ("fh", "கா"),
    ("fp", "கி"),
    ("fP", "கீ"),
    ("F", "கு"),
    ("\$", "கூ"),
    ("nf", "கெ"),
    ("Nf", "கே"),
    ("if", "கை"),
    ("f;", "க்"),
    ("f", "க"),

    ("nqs", "ஙௌ"),
    ("Nqh", "ஙோ"),
    ("nqh", "ஙொ"),
    ("qh", "ஙா"),
    ("qp", "ஙி"),
    ("qP", "ஙீ"),
    ("nq", "ஙெ"),
    ("Nq", "ஙே"),
    ("iq", "ஙை"),
    ("q;", "ங்"),
    ("q", "ங"),

    ("nrs", "சௌ"),
    ("Nrh", "சோ"),
    ("nrh", "சொ"),
    ("rh", "சா"),
    ("rp", "சி"),
    ("rP", "சீ"),
    ("R", "சு"),
    ("#", "சூ"),
    ("nr", "செ"),
    ("Nr", "சே"),
    ("ir", "சை"),
    ("r;", "ச்"),
    ("r", "ச"),

    ("n\[s", "ஜௌ"),
    ("N\[h", "ஜோ"),
    ("n\[h", "ஜொ"),
    ("\[h", "ஜா"),
    ("\[p", "ஜி"),
    ("\[P", "ஜீ"),
    ("\[{", "ஜு"),
    ("\[_", "ஜூ"),

    ("n\[", "ஜெ"),
    ("N\[", "ஜே"),
    ("i\[", "ஜை"),
    ("\[;", "ஜ்"),
    ("\[", "ஜ"),

    ("nQs", "ஞௌ"),
    ("NQh", "ஞோ"),
    ("nQh", "ஞொ"),
    ("Qh", "ஞா"),
    ("Qp", "ஞி"),
    ("QP", "ஞீ"),
    ("nQ", "ஞெ"),
    ("NQ", "ஞே"),
    ("iQ", "ஞை"),
    ("Q;", "ஞ்"),
    ("Q", "ஞ"),

    ("nls", "டௌ"),
    ("Nlh", "டோ"),
    ("nlh", "டொ"),
    ("lp", "டி"),
    ("lP", "டீ"),
    ("lh", "டா"),
    ("b", "டி"),
    ("B", "டீ"),
    ("L", "டு"),
    ("\^", "டூ"),
    ("nl", "டெ"),
    ("Nl", "டே"),
    ("il", "டை"),
    ("l;", "ட்"),
    ("l", "ட"),

    ("nzs", "ணௌ"),
    ("Nzh", "ணோ"),
    ("nzh", "ணொ"),
    ("zh", "ணா"),
    ("zp", "ணி"),
    ("zP", "ணீ"),

    ("Zh", "ணூ"),
    ("Z}", "ணூ"),

    ("nz", "ணெ"),
    ("Nz", "ணே"),
    ("iz", "ணை"),

    ("z;", "ண்"),
    ("Z", "ணு"),
    ("z", "ண"),

    ("njs", "தௌ"),
    ("Njh", "தோ"),
    ("njh", "தொ"),
    ("jh", "தா"),
    ("jp", "தி"),
    ("jP", "தீ"),
    ("Jh", "தூ"),
    ("Jh", "தூ"),
    ("J}", "தூ"),
    ("J", "து"),
    ("nj", "தெ"),
    ("Nj", "தே"),
    ("ij", "தை"),
    ("j;", "த்"),
    ("j", "த"),

    ("nes", "நௌ"),
    ("Neh", "நோ"),
    ("neh", "நொ"),
    ("eh", "நா"),
    ("ep", "நி"),
    ("eP", "நீ"),
    ("E}", "நூ"),
    ("Eh", "நூ"),
    ("E", "நு"),
    ("ne", "நெ"),
    ("Ne", "நே"),
    ("ie", "நை"),
    ("e;", "ந்"),
    ("e", "ந"),

    ("nds", "னௌ"),
    ("Ndh", "னோ"),
    ("ndh", "னொ"),
    ("dh", "னா"),
    ("dp", "னி"),
    ("dP", "னீ"),
    ("D}", "னூ"),

    ("Dh", "னூ"),
    ("D", "னு"),
    ("nd", "னெ"),
    ("Nd", "னே"),
    ("id", "னை"),
    ("d;", "ன்"),
    ("d", "ன"),

    ("ngs", "பௌ"),
    ("Ngh", "போ"),
    ("ngh", "பொ"),
    ("h", "பா"),
    ("p", "பி"),
    ("P", "பீ"),

    ("G", "பு"),
    ("ng", "பெ"),
    ("Ng", "பே"),
    ("ig", "பை"),
    (";", "ப்"),
    ("g", "ப"),

    ("nks", "மௌ"),
    ("Nkh", "மோ"),
    ("nkh", "மொ"),
    ("kh", "மா"),
    ("kp", "மி"),
    ("kP", "மீ"),
    ("K", "மு"),
    ("%", "மூ"),
    ("nk", "மெ"),
    ("Nk", "மே"),
    ("ik", "மை"),
    ("k;", "ம்"),
    ("k", "ம"),

    ("nas", "யௌ"),
    ("Nah", "யோ"),
    ("nah", "யொ"),
    ("ah", "யா"),
    ("ap", "யி"),
    ("aP", "யீ"),
    ("A", "யு"),
    ("A+", "யூ"),
    ("na", "யெ"),
    ("Na", "யே"),
    ("ia", "யை"),
    ("a;", "ய்"),
    ("a", "ய"),

    ("nus", "ரௌ"),
    ("Nuh", "ரோ"),
    ("nuh", "ரொ"),
    ("uh", "ரா"),
    ("up", "ரி"),

    ("U", "ரு"),
    ("&", "ரூ"),
    ("nu", "ரெ"),
    ("Nu", "ரே"),
    ("iu", "ரை"),

    ("u", "ர"),

    ("nys", "லௌ"),
    ("Nyh", "லோ"),
    ("nyh", "லொ"),
    ("yh", "லா"),
    ("yp", "லி"),
    ("yP", "லீ"),
    ("Yh", "லூ"),
    ("Y}", "லூ"),
    ("Y", "லு"),
    ("ny", "லெ"),
    ("Ny", "லே"),
    ("iy", "லை"),
    ("y;", "ல்"),
    ("y", "ல"),

    ("nss", "ளௌ"),
    ("Nsh", "ளோ"),
    ("nsh", "ளொ"),
    ("sh", "ளா"),

    ("sP", "ளீ"),
    ("Sh", "ளூ"),
    ("S", "ளு"),
    ("ns", "ளெ"),
    ("Ns", "ளே"),
    ("is", "ளை"),
    ("s;", "ள்"),
    ("s", "ள"),

    ("ntt", "வௌ"),
    ("Nth", "வோ"),
    ("nth", "வொ"),
    ("th", "வா"),
    ("tp", "வி"),
    ("tP", "வீ"),

    ("nt", "வெ"),
    ("Nt", "வே"),
    ("it", "வை"),

    ("t;", "வ்"),
    ("t", "வ"),
    ("noo", "ழௌ"),
    ("Noh", "ழோ"),
    ("noh", "ழொ"),
    ("oh", "ழா"),
    ("op", "ழி"),
    ("oP", "ழீ"),
    ("\*", "ழூ"),
    ("O", "ழு"),
    ("no", "ழெ"),
    ("No", "ழே"),
    ("io", "ழை"),
    ("o;", "ழ்"),
    ("o", "ழ"),

    ("nws", "றௌ"),
    ("Nwh", "றோ"),
    ("nwh", "றொ"),
    ("wh", "றா"),
    ("wp", "றி"),
    ("wP", "றீ"),
    ("Wh", "றூ"),
    ("W}", "றூ"),

    ("W", "று"),
    ("nw", "றெ"),
    ("Nw", "றே"),
    ("iw", "றை"),
    ("w;", "ற்"),
    ("w", "ற"),

    ("n``", "ஹௌ"),
    ("N`h", "ஹோ"),
    ("n`h", "ஹொ"),
    ("`h", "ஹா"),
    ("`p", "ஹி"),
    ("`P", "ஹீ"),

    ("n`", "ஹெ"),
    ("N`", "ஹே"),
    ("i`", "ஹை"),
    ("`;", "ஹ்"),
    ("`", "ஹ"),

    ("n\\s", "ஷௌ"),
    ("N\\h", "ஷோ"),
    ("n\\h", "ஷொ"),
    ("\\h", "ஷா"),
    ("\\p", "ஷி"),
    ("\\P", "ஷீ"),

    ("n\\", "ஷெ"),
    ("N\\", "ஷே"),
    ("i\\", "ஷை"),
    ("\\;", "ஷ்"),
    ("\\", "ஷ"),

    ("n]s", "ஸௌ"),
    ("N]h", "ஸோ"),
    ("n]h", "ஸொ"),
    ("]h", "ஸா"),
    ("]p", "ஸி"),
    ("]P", "ஸீ"),

    ("n]", "ஸெ"),
    ("N]", "ஸே"),
    ("i]", "ஸை"),
    ("];", "ஸ்"),
    ("]", "ஸ"),

    (">", "ää"),
    ("m", "அ"),
    ("M", "ஆ"),
    ("<", "ஈ"),
    ("c", "உ"),
    ("C", "ஊ"),
    ("v", "எ"),
    ("V", "ஏ"),
    ("I", "ஐ"),
    ("x", "ஒ"),
    ("X", "ஓ"),
    ("xs", "ஔ"),

    ("\/", "ஃ"),

    (",", "இ"),

    ("=", "ஸ்ரீ"),

    (">", ","),

    ("T", "வு"),

    ("வு10", "வூ"),
    ("G\+", "பூ"),
    ("பு10", "பூ"),
    ("A\+", "யூ"),
    ("யு10", "யூ"),

    ])
# end of bamini2utf8 dictionary 

     
# begin of boomi2utf8 dictionary 
boomi2utf8 = OrderedDict([


    ("d", "க்ஷ"),
    ("d\"", "க்ஷா"),
    ("õ", "க்ஷி"),
    ("ö", "க்ஷீ"),
    ("d#", "க்ஷு"),
    ("d$", "க்ஷூ"),
    ("%d", "க்ஷெ"),
    ("&d", "க்ஷே"),
    ("%d\"", "க்ஷொ"),
    ("&d\"", "க்ஷோ"),
    ("%d\[", "க்ஷௌ"),
    ("\+d", "க்ஷை"),
    ("ô", "க்ஷ்"),

    ("%\^\[", "ஜௌ"),
    ("&\^\"", "ஜோ"),
    ("%\^\"", "ஜொ"),
    ("\^\"", "ஜா"),
    ("é", "ஜி"),
    ("ê", "ஜீ"),
    ("\^#", "ஜு"),
    ("\^\$", "ஜூ"),
    ("%\^", "ஜெ"),
    ("&\^", "ஜே"),
    ("\+\^", "ஜை"),
    ("è", "ஜ்"),
    ("\^", "ஜ"),

    ("%L\[", "கௌ"),
    ("&L\"", "கோ"),
    ("%L\"", "கொ"),
    ("L\"", "கா"),
    ("g", "கி"),
    ("h", "கீ"),
    ("j", "கு"),
    ("k", "கூ"),
    ("%L", "கெ"),
    ("&L", "கே"),
    ("\+L", "கை"),
    ("f", "க்"),
    ("L", "க"),

    ("%M\[", "ஙௌ"),
    ("&M\"", "ஙோ"),
    ("%M\"", "ஙொ"),
    ("M\"", "ஙா"),
    ("m", "ஙி"),
    ("p", "ஙீ"),
    ("r", "ஙு"),
    ("s", "ஙூ"),
    ("%M", "ஙெ"),
    ("&M", "ஙே"),
    ("\+M", "ஙை"),
    ("l", "ங்"),
    ("M", "ங"),

    ("%N\[", "சௌ"),
    ("&N\"", "சோ"),
    ("%N\"", "சொ"),
    ("N\"", "சா"),
    ("t", "சி"),
    ("u", "சீ"),
    ("v", "சு"),
    ("w", "சூ"),
    ("%N", "செ"),
    ("&N", "சே"),
    ("\+N", "சை"),
    ("o", "ச்"),
    ("N", "ச"),
    ("%O\[", "ஞௌ"),
    ("&O\"", "ஞோ"),
    ("%O\"", "ஞொ"),
    ("O\"", "ஞா"),
    ("y", "ஞி"),
    ("z", "ஞீ"),
    ("{", "ஞு"),
    ("\|", "ஞூ"),
    ("%O", "ஞெ"),
    ("&O", "ஞே"),
    ("\+O", "ஞை"),
    ("x", "ஞ்"),
    ("O", "ஞ"),

    ("%P\[", "டௌ"),
    ("&P\"", "டோ"),
    ("%P\"", "டொ"),
    ("P\"", "டா"),
    ("~", "டி"),
    ("e", "டீ"),
    ("i", "டு"),
    ("n", "டூ"),
    ("%P", "டெ"),
    ("&P", "டே"),
    ("\+P", "டை"),
    ("}", "ட்"),
    ("P", "ட"),

    ("%Q\[", "ணௌ"),
    ("&Q\"", "ணோ"),
    ("%Q\"", "ணொ"),
    ("Q\"", "ணா"),
    ("¢", "ணி"),
    ("£", "ணீ"),
    ("¤", "ணு"),
    ("¥", "ணூ"),
    ("%Q", "ணெ"),
    ("&Q", "ணே"),
    ("\+Q", "ணை"),
    ("¡", "ண்"),
    ("Q", "ண"),

    ("%R\[", "தௌ"),
    ("&R\"", "தோ"),
    ("%R\"", "தொ"),
    ("R\"", "தா"),
    ("§", "தி"),
    ("¨", "தீ"),
    ("©", "து"),
    ("ª", "தூ"),
    ("%R", "தெ"),
    ("&R", "தே"),
    ("\+R", "தை"),
    ("¦", "த்"),
    ("R", "த"),

    ("%S\[", "நௌ"),
    ("&S\"", "நோ"),
    ("%S\"", "நொ"),
    ("S\"", "நா"),
    ("¬", "நி"),
    ("­", "நீ"),
    ("®", "நு"),
    ("°", "நூ"),
    ("%S", "நெ"),
    ("&S", "நே"),
    ("\+S", "நை"),
    ("«", "ந்"),
    ("S", "ந"),

    ("%]\[", "னௌ"),
    ("&]\"", "னோ"),
    ("%]\"", "னொ"),
    ("]\"", "னா"),
    ("à", "னி"),
    ("á", "னீ"),
    ("â", "னு"),
    ("ç", "னூ"),
    ("%]", "னெ"),
    ("&]", "னே"),
    ("\+]", "னை"),
    ("ß", "ன்"),
    ("]", "ன"),

    ("%T\[", "பௌ"),
    ("&T\"", "போ"),
    ("%T\"", "பொ"),
    ("T\"", "பா"),
    ("²", "பி"),
    ("³", "பீ"),
    ("´", "பு"),
    ("µ", "பூ"),
    ("%T", "பெ"),
    ("&T", "பே"),
    ("\+T", "பை"),
    ("±", "ப்"),
    ("T", "ப"),

    ("%U\[", "மௌ"),
    ("&U\"", "மோ"),
    ("%U\"", "மொ"),
    ("U\"", "மா"),
    ("·", "மி"),
    ("¸", "மீ"),
    ("¹", "மு"),
    ("º", "மூ"),
    ("%U", "மெ"),
    ("&U", "மே"),
    ("\+U", "மை"),
    ("¶", "ம்"),
    ("U", "ம"),

    ("%V\[", "யௌ"),
    ("&V\"", "யோ"),
    ("%V\"", "யொ"),
    ("V\"", "யா"),
    ("¼", "யி"),
    ("½", "யீ"),
    ("¾", "யு"),
    ("¿", "யூ"),
    ("%V", "யெ"),
    ("&V", "யே"),
    ("\+V", "யை"),
    ("»", "ய்"),
    ("V", "ய"),

    ("%W\[", "ரௌ"),
    ("&W\"", "ரோ"),
    ("%W\"", "ரொ"),
    ("W\"", "ரா"),
    ("Á", "ரி"),
    ("Â", "ரீ"),
    ("Ã", "ரு"),
    ("Ä", "ரூ"),
    ("%W", "ரெ"),
    ("&W", "ரே"),
    ("\+W", "ரை"),
    ("À", "ர்"),
    ("W", "ர"),
    ("%X\[", "லௌ"),
    ("&X\"", "லோ"),
    ("%X\"", "லொ"),
    ("X\"", "லா"),
    ("Æ", "லி"),
    ("Ç", "லீ"),
    ("È", "லு"),
    ("É", "லூ"),
    ("%X", "லெ"),
    ("&X", "லே"),
    ("\+X", "லை"),
    ("Å", "ல்"),
    ("X", "ல"),

    ("%\[\[", "ளௌ"),
    ("&\[\"", "ளோ"),
    ("%\[\"", "ளொ"),
    ("\[\"", "ளா"),
    ("Õ", "ளி"),
    ("Ö", "ளீ"),
    ("Ø", "ளு"),
    ("Ù", "ளூ"),
    ("%\[", "ளெ"),
    ("&\[", "ளே"),
    ("\+\[", "ளை"),
    ("Ô", "ள்"),
    ("\[", "ள"),

    ("%Y\[", "வௌ"),
    ("&Y\"", "வோ"),
    ("%Y\"", "வொ"),
    ("Y\"", "வா"),
    ("Ë", "வி"),
    ("Ì", "வீ"),
    ("Í", "வு"),
    ("Î", "வூ"),
    ("%Y", "வெ"),
    ("&Y", "வே"),
    ("\+Y", "வை"),
    ("Ê", "வ்"),
    ("Y", "வ"),

    ("%Z\[", "ழௌ"),
    ("&Z\"", "ழோ"),
    ("%Z\"", "ழொ"),
    ("Z\"", "ழா"),
    ("Ð", "ழி"),
    ("Ñ", "ழீ"),
    ("Ò", "ழு"),
    ("Ó", "ழூ"),
    ("%Z", "ழெ"),
    ("&Z", "ழே"),
    ("\+Z", "ழை"),
    ("Ï", "ழ்"),
    ("Z", "ழ"),
     
    ("%\\\[", "றௌ"),
    ("&\\\"", "றோ"),
    ("%\\\"", "றொ"),
    ("\\\"", "றா"),
    ("Û", "றி"),
    ("Ü", "றீ"),
    ("Ý", "று"),
    ("Þ", "றூ"),
    ("%\\", "றெ"),
    ("&\\", "றே"),
    ("\+\\", "றை"),
    ("Ú", "ற்"),
    ("\\", "ற"),

    ("%a\[", "ஹௌ"),
    ("&a\"", "ஹோ"),
    ("%a\"", "ஹொ"),
    ("a\"", "ஹா"),
    ("ì", "ஹி"),
    ("í", "ஹீ"),
    ("a#", "ஹு"),
    ("a$", "ஹூ"),
    ("%a", "ஹெ"),
    ("&a", "ஹே"),
    ("\+a", "ஹை"),
    ("ë", "ஹ்"),
    ("a", "ஹ"),

    ("%c\[", "ஷௌ"),
    ("&c\"", "ஷோ"),
    ("%c\"", "ஷொ"),
    ("c\"", "ஷா"),
    ("ò", "ஷி"),
    ("ó", "ஷீ"),
    ("c#", "ஷு"),
    ("c$", "ஷூ"),
    ("%c", "ஷெ"),
    ("&c", "ஷே"),
    ("\+c", "ஷை"),
    ("ñ", "ஷ்"),
    ("c", "ஷ"),

    ("%b\[", "ஸௌ"),
    ("&b\"", "ஸோ"),
    ("%b\"", "ஸொ"),
    ("b\"", "ஸா"),
    ("ï", "ஸி"),
    ("ð", "ஸீ"),
    ("b#", "ஸு"),
    ("b$", "ஸூ"),
    ("%b", "ஸெ"),
    ("&b", "ஸே"),
    ("\+b", "ஸை"),
    ("î", "ஸ்"),
    ("b", "ஸ"),

    ("A", "அ"),
    ("B", "ஆ"),
    ("C", "இ"),
    ("D", "ஈ"),
    ("E", "உ"),
    ("F", "ஊ"),
    ("G", "எ"),
    ("H", "ஏ"),
    ("I", "ஐ"),
    ("J", "ஒ"),
    ("K", "ஓ"),
    ("J\[", "ஔ"),

    ("@", "ஃ"),

    ("q", "ஸ்ரீ"),
    ("å", "-"),
    ("æ", "-"),
    ("_", "_"),
    ("``", "\""),

    ])
# end of boomi2utf8 dictionary 

     
# begin of dinakaran2utf8 dictionary 
dinakaran2utf8 = OrderedDict([

    ("&", "க்ஷ"),
    ("&h", "க்ஷா"),
    ("i&", "க்ஷை"),
    ("&p", "க்ஷி"),
    ("&P", "க்ஷீ"),
    ("&%", "க்ஷு"),
    ("&\^", "க்ஷூ"),
    ("b&", "க்ஷெ"),
    ("n&", "க்ஷே"),
    ("b&h", "க்ஷொ"),
    ("n&h", "க்ஷோ"),
    ("b&s", "க்ஷௌ"),
    ("&‚", "க்ஷ்"),
    ("$\%", "ஜு"),
    ("\%", "ு"),
    ("\^", "ூ"),
    ("\/", "0000"),
    ("h;", "ர்"),
    ("#;", "ஷ்"),
    ("z;", "ண்"),
    ("J}", "தூ"),
    ("b\$", "ஜெ"),
    ("b$s", "ஜௌ"),
    ("n$h", "ஜோ"),
    ("b$h", "ஜொ"),
    ("$h", "ஜா"),
    ("$p", "ஜி"),
    ("$P", "ஜீ"),

    ("$\\^", "ஜூ"),
    ("n$", "ஜே"),
    ("i$", "ஜை"),
    ("$;", "ஜ்"),
    ("\$", "ஜ"),

    ("bfs", "கௌ"),
    ("nfh", "கோ"),
    ("bfh", "கொ"),
    ("fh", "கா"),
    ("fp", "கி"),
    ("fP", "கீ"),
    ("F", "கு"),
    ("T", "கூ"),
    ("bf", "கெ"),
    ("nf", "கே"),
    ("if", "கை"),
    ("f;", "க்"),
    ("f", "க"),

    ("b's", "ஙௌ"),
    ("n'h", "ஙோ"),
    ("b'h", "ஙொ"),
    ("'h", "ஙா"),
    ("'p", "ஙி"),
    ("'P", "ஙீ"),
    ("b'", "ஙெ"),
    ("n'", "ஙே"),
    ("i'", "ஙை"),
    ("';", "ங்"),
    ("'", "ங"),
    ("brs", "சௌ"),
    ("nrh", "சோ"),
    ("brh", "சொ"),
    ("rh", "சா"),
    ("rp", "சி"),
    ("rP", "சீ"),
    ("R", "சு"),
    ("r{", "சூ"),
    ("br", "செ"),
    ("nr", "சே"),
    ("ir", "சை"),
    ("r;", "ச்"),
    ("r@", "ச்"),
    ("r", "ச"),

    ("b\"s", "ஞௌ"),
    ("n\"h", "ஞோ"),
    ("b\"h", "ஞொ"),
    ("\"h", "ஞா"),
    ("\"p", "ஞி"),
    ("\"P", "ஞீ"),
    ("b\"", "ஞெ"),
    ("n\"", "ஞே"),
    ("i\"", "ஞை"),
    ("\";", "ஞ்"),
    ("\"", "ஞ"),

    ("bls", "டௌ"),
    ("nlh", "டோ"),
    ("blh", "டொ"),
    ("lh", "டா"),
    ("o", "டி"),
    ("O", "டீ"),
    ("L", "டு"),
    ("\?", "டூ"),
    ("bl", "டெ"),
    ("nl", "டே"),
    ("il", "டை"),
    ("l;", "ட்"),
    ("l", "ட"),

    ("bzs", "ணௌ"),
    ("nzh", "ணோ"),
    ("bzh", "ணொ"),
    ("zh", "ணா"),
    ("zp", "ணி"),
    ("zP", "ணீ"),
    ("q", "ணு"),
    ("q}", "ணூ"),
    ("bz", "ணெ"),
    ("nz", "ணே"),
    ("iz", "ணை"),

    ("z", "ண"),
    ("bjs", "தௌ"),
    ("njh", "தோ"),
    ("bjh", "தொ"),
    ("jh", "தா"),
    ("jp", "தி"),
    ("jP", "தீ"),
    ("J", "து"),
    ("bj", "தெ"),
    ("nj", "தே"),
    ("ij", "தை"),
    ("j;", "த்"),
    ("j", "த"),

    ("bes", "நௌ"),
    ("neh", "நோ"),
    ("beh", "நொ"),
    ("eh", "நா"),
    ("ep", "நி"),
    ("eP", "நீ"),
    ("E", "நு"),
    ("E}", "நூ"),
    ("be", "நெ"),
    ("ne", "நே"),
    ("ie", "நை"),
    ("e;", "ந்"),
    ("e", "ந"),
    ("bds", "னௌ"),
    ("ndh", "னோ"),
    ("bdh", "னொ"),
    ("dh", "னா"),
    ("dp", "னி"),
    ("dP", "னீ"),
    ("D", "னு"),
    ("D}", "னூ"),
    ("bd", "னெ"),
    ("nd", "னே"),
    ("id", "னை"),
    ("d;", "ன்"),
    ("d", "ன"),

    ("bgs", "பௌ"),
    ("ngh", "போ"),
    ("bgh", "பொ"),
    ("h", "பா"),
    ("p", "பி"),
    ("P", "பீ"),
    ("\[", "பு"),
    ("{", "பூ"),
    ("bg", "பெ"),
    ("ng", "பே"),
    ("ig", "பை"),
    (";", "ப்"),
    ("g", "ப"),
    ("bks", "மௌ"),
    ("nkh", "மோ"),
    ("bkh", "மொ"),
    ("kh", "மா"),
    ("kp", "மி"),
    ("kP", "மீ"),
    ("K", "மு"),
    ("\\", "மூ"),
    ("bk", "மெ"),
    ("nk", "மே"),
    ("ik", "மை"),
    ("k;", "ம்"),
    ("k", "ம"),

    ("bas", "யௌ"),
    ("nah", "யோ"),
    ("bah", "யொ"),
    ("ah", "யா"),
    ("ap", "யி"),
    ("aP", "யீ"),
    ("a\[", "யு"),
    ("a{", "யூ"),
    ("ba", "யெ"),
    ("na", "யே"),
    ("ia", "யை"),
    ("a;", "ய்"),
    ("a", "ய"),
    ("bus", "ரௌ"),
    ("nuh", "ரோ"),
    ("buh", "ரொ"),
    ("uh", "ரா"),
    ("up", "ரி"),
    ("uP", "ரீ"),
    ("U", "ரு"),
    ("\+", "ரூ"),
    ("bu", "ரெ"),
    ("nu", "ரே"),
    ("iu", "ரை"),
    ("u;", "ர்"),

    ("u", "ர"),

    ("bys", "லௌ"),
    ("nyh", "லோ"),
    ("byh", "லொ"),
    ("yh", "லா"),
    ("yp", "லி"),
    ("yP", "லீ"),
    ("Y", "லு"),
    ("Y}", "லூ"),
    ("by", "லெ"),
    ("ny", "லே"),
    ("iy", "லை"),
    ("y;", "ல்"),
    ("y", "ல"),

    ("bss", "ளௌ"),
    ("nsh", "ளோ"),
    ("bsh", "ளொ"),
    ("sh", "ளா"),
    ("sp", "ளி"),
    ("sP", "ளீ"),
    ("S", "ளு"),
    ("\~", "ளூ"),
    ("bs", "ளெ"),
    ("ns", "ளே"),
    ("is", "ளை"),
    ("s;", "ள்"),
    ("s", "ள"),

    ("btt", "வௌ"),
    ("nth", "வோ"),
    ("bth", "வொ"),
    ("th", "வா"),
    ("tp", "வி"),
    ("tP", "வீ"),
    ("t\[", "வு"),
    ("t{", "வூ"),
    ("bt", "வெ"),
    ("nt", "வே"),
    ("it", "வை"),
    ("t;", "வ்"),
    ("t", "வ"),

    ("bww", "றௌ"),
    ("nww", "றோ"),
    ("bww", "றொ"),
    ("ww", "றா"),
    ("wp", "றி"),
    ("wP", "றீ"),
    ("W", "று"),
    ("W}", "றூ"),
    ("bw", "றெ"),
    ("nw", "றே"),
    ("iw", "றை"),
    ("w;", "ற்"),
    ("w", "ற"),

    ("bQQ", "ஹௌ"),
    ("nQQ", "ஹோ"),
    ("bQQ", "ஹொ"),
    ("QQ", "ஹா"),
    ("Qp", "ஹி"),
    ("QP", "ஹீ"),
    ("Q%", "ஹு"),
    ("Q\^", "ஹூ"),
    ("bQ", "ஹெ"),
    ("nQ", "ஹே"),
    ("iQ", "ஹை"),
    ("Q;", "ஹ்"),
    ("Q", "ஹ"),

    ("t", "வ"),

    ("bHH", "ழௌ"),
    ("nHh", "ழோ"),
    ("bHh", "ழொ"),
    ("Hh", "ழா"),
    ("Hp", "ழி"),
    ("HP", "ழீ"),
    ("G", "ழு"),
    ("\=", "ழூ"),
    ("bH", "ழெ"),
    ("nH", "ழே"),
    ("iH", "ழை"),
    ("H;", "ழ்"),
    ("H", "ழ"),

    ("öåå", "ஷௌ"),
    ("÷åõ", "ஷோ"),
    ("öåõ", "ஷொ"),
    ("åõ", "ஷா"),
    ("æ", "ஷி"),
    ("ç", "ஷீ"),
    ("åú", "ஷு"),
    ("åü", "ஷூ"),
    ("öå", "ஷெ"),
    ("÷å", "ஷே"),
    ("øå", "ஷை"),
    ("è", "ஷ்"),
    ("å", "ஷ"),

    ("b##", "ஷௌ"),
    ("n##", "ஷோ"),
    ("b##", "ஷொ"),
    ("##", "ஷா"),
    ("#p", "ஷி"),
    ("#P", "ஷீ"),
    ("#%", "ஷு"),
    ("#^", "ஷூ"),
    ("b#", "ஷெ"),
    ("n#", "ஷே"),
    ("i#", "ஷை"),

    ("#", "ஷ"),

    ("b!!", "ஸௌ"),
    ("n!!", "ஸோ"),
    ("b!!", "ஸொ"),
    ("!!", "ஸா"),
    ("!p", "ஸி"),
    ("!P", "ஸீ"),
    ("!%", "ஸு"),
    ("!^", "ஸூ"),
    ("b!", "ஸெ"),
    ("n!", "ஸே"),
    ("i!", "ஸை"),
    ("!;", "ஸ்"),
    ("!", "ஸ"),

    ("m", "அ"),
    ("M", "ஆ"),

    ("<", "ஈ"),
    ("c", "உ"),
    ("C", "ஊ"),
    ("v", "எ"),
    ("V", "ஏ"),
    ("I", "ஐ"),
    ("x", "ஒ"),
    ("X", "ஓ"),
    ("cs", "ஔ"),

    ("`", "ஃ"),
    (",", "இ"),
    ("\|", "ஸ்ரீ"),
    ("ˆ", "="),
    ("‐", "-"),
    (">", "?"),
    (":", "்"),
    ("\^", "ூ"),
    ("\^", "ூ"),
    ("@", "்"),

    ("0000", ","),

    ])
# end of dinakaran2utf8 dictionary 


# begin of dinamani2utf8 dictionary 
dinamani2utf8 = OrderedDict([

    ("b", "க்ஷ"),
    ("bô", "க்ஷா"),
    ("·", "க்ஷி"),
    ("Î", "க்ஷீ"),
    ("bý", "க்ஷு"),
    ("bþ", "க்ஷூ"),
    ("ùb", "க்ஷெ"),
    ("úb", "க்ஷே"),
    ("ùbô", "க்ஷொ"),
    ("úbô", "க்ஷோ"),
    ("ùb\[", "க்ஷௌ"),
    ("ûb", "க்ஷை"),
    ("z", "க்ஷ்"),
    ("ù_\[", "ஜௌ"),
    ("ú_ô", "ஜோ"),
    ("ù_ô", "ஜொ"),
    ("_ô", "ஜா"),
    ("´", "ஜி"),
    ("Ë", "ஜீ"),
    ("_ý", "ஜு"),
    ("_þ", "ஜூ"),
    ("ù_", "ஜெ"),
    ("ú_", "ஜே"),
    ("û_", "ஜை"),
    ("w", "ஜ்"),
    ("_", "ஜ"),
    ("ùL\[", "கௌ"),
    ("úLô", "கோ"),
    ("ùLô", "கொ"),
    ("Lô", "கா"),
    ("¡", "கி"),
    ("¸", "கீ"),
    ("Ï", "கு"),
    ("á", "கூ"),
    ("ùL", "கெ"),
    ("úL", "கே"),
    ("ûL", "கை"),
    ("d", "க்"),
    ("L", "க"),

    ("ùM\[", "ஙௌ"),
    ("úMô", "ஙோ"),
    ("ùMô", "ஙொ"),
    ("Mô", "ஙா"),
    ("¢", "ஙி"),
    ("¹", "ஙீ"),
    ("Ð", "ஙு"),
    ("â", "ஙூ"),
    ("ùM", "ஙெ"),
    ("úM", "ஙே"),
    ("ûM", "ஙை"),
    ("e", "ங்"),
    ("M", "ங"),

    ("ùN\[", "சௌ"),
    ("úNô", "சோ"),
    ("ùNô", "சொ"),
    ("Nô", "சா"),
    ("£", "சி"),
    ("º", "சீ"),
    ("Ñ", "சு"),
    ("ã", "சூ"),
    ("ùN", "செ"),
    ("úN", "சே"),
    ("ûN", "சை"),
    ("f", "ச்"),
    ("N", "ச"),

    ("ùO\[", "ஞௌ"),
    ("úOô", "ஞோ"),
    ("ùOô", "ஞொ"),
    ("Oô", "ஞா"),
    ("¤", "ஞி"),
    ("»", "ஞீ"),
    ("Ò", "ஞு"),
    ("ä", "ஞூ"),
    ("ùO", "ஞெ"),
    ("úO", "ஞே"),
    ("ûO", "ஞை"),
    ("g", "ஞ்"),
    ("O", "ஞ"),

    ("ùP\[", "டௌ"),
    ("úPô", "டோ"),
    ("ùPô", "டொ"),
    ("Pô", "டா"),
    ("¥", "டி"),
    ("¼", "டீ"),
    ("Ó", "டு"),
    ("å", "டூ"),
    ("ùP", "டெ"),
    ("úP", "டே"),
    ("ûP", "டை"),
    ("h", "ட்"),
    ("P", "ட"),

    ("ùQ\[", "ணௌ"),
    ("úQô", "ணோ"),
    ("ùQô", "ணொ"),
    ("Qô", "ணா"),
    ("¦", "ணி"),
    ("½", "ணீ"),
    ("Ô", "ணு"),
    ("æ", "ணூ"),
    ("ùQ", "ணெ"),
    ("úQ", "ணே"),
    ("ûQ", "ணை"),
    ("i", "ண்"),
    ("Q", "ண"),

    ("ùR\[", "தௌ"),
    ("úRô", "தோ"),
    ("ùRô", "தொ"),
    ("Rô", "தா"),
    ("§", "தி"),
    ("¾", "தீ"),
    ("Õ", "து"),
    ("ç", "தூ"),
    ("ùR", "தெ"),
    ("úR", "தே"),
    ("ûR", "தை"),
    ("j", "த்"),
    ("R", "த"),

    ("ùS\[", "நௌ"),
    ("úSô", "நோ"),
    ("ùSô", "நொ"),
    ("Sô", "நா"),
    ("¨", "நி"),
    ("¿", "நீ"),
    ("Ö", "நு"),
    ("è", "நூ"),
    ("ùS", "நெ"),
    ("úS", "நே"),
    ("ûS", "நை"),
    ("k", "ந்"),
    ("S", "ந"),

    ("ù]\[", "னௌ"),
    ("ú]ô", "னோ"),
    ("ù]ô", "னொ"),
    ("]ô", "னா"),
    ("²", "னி"),
    ("É", "னீ"),
    ("à", "னு"),
    ("ò", "னூ"),
    ("ù]", "னெ"),
    ("ú]", "னே"),
    ("û]", "னை"),
    ("u", "ன்"),
    ("]", "ன"),

    ("ùT\[", "பௌ"),
    ("úTô", "போ"),
    ("ùTô", "பொ"),
    ("Tô", "பா"),
    ("©", "பி"),
    ("À", "பீ"),
    ("×", "பு"),
    ("é", "பூ"),
    ("ùT", "பெ"),
    ("úT", "பே"),
    ("ûT", "பை"),
    ("l", "ப்"),
    ("T", "ப"),

    ("ùU\[", "மௌ"),
    ("úUô", "மோ"),
    ("ùUô", "மொ"),
    ("Uô", "மா"),
    ("ª", "மி"),
    ("Á", "மீ"),
    ("Ø", "மு"),
    ("ê", "மூ"),
    ("ùU", "மெ"),
    ("úU", "மே"),
    ("ûU", "மை"),
    ("m", "ம்"),
    ("U", "ம"),

    ("ùV\[", "யௌ"),
    ("úVô", "யோ"),
    ("ùVô", "யொ"),
    ("Vô", "யா"),
    ("«", "யி"),
    ("Â", "யீ"),
    ("Ù", "யு"),
    ("ë", "யூ"),
    ("ùV", "யெ"),
    ("úV", "யே"),
    ("ûV", "யை"),
    ("n", "ய்"),
    ("V", "ய"),

    ("ùW\[", "ரௌ"),
    ("úWô", "ரோ"),
    ("ùWô", "ரொ"),
    ("Wô", "ரா"),
    ("¬", "ரி"),
    ("Ã", "ரீ"),
    ("Ú", "ரு"),
    ("ì", "ரூ"),
    ("ùW", "ரெ"),
    ("úW", "ரே"),
    ("ûW", "ரை"),
    ("o", "ர்"),
    ("W", "ர"),

    ("ùX\[", "லௌ"),
    ("úXô", "லோ"),
    ("ùXô", "லொ"),
    ("Xô", "லா"),
    ("­", "லி"),
    ("#", "லி"),
    ("Ä", "லீ"),
    ("Û", "லு"),
    ("í", "லூ"),
    ("ùX", "லெ"),
    ("úX", "லே"),
    ("ûX", "லை"),
    ("p", "ல்"),
    ("X", "ல"),

    ("ù\[\[", "ளௌ"),
    ("ú\[ô", "ளோ"),
    ("ù\[ô", "ளொ"),
    ("\[ô", "ளா"),
    ("°", "ளி"),
    ("Ç", "ளீ"),
    ("Þ", "ளு"),
    ("ð", "ளூ"),
    ("ù\[", "ளெ"),
    ("ú\[", "ளே"),
    ("û\[", "ளை"),
    ("s", "ள்"),
    ("\[", "ள"),

    ("ùY\[", "வௌ"),
    ("úYô", "வோ"),
    ("ùYô", "வொ"),
    ("Yô", "வா"),
    ("®", "வி"),
    ("Å", "வீ"),
    ("Ü", "வு"),
    ("î", "வூ"),
    ("ùY", "வெ"),
    ("úY", "வே"),
    ("ûY", "வை"),
    ("q", "வ்"),
    ("Y", "வ"),

    ("ùZ\[", "ழௌ"),
    ("úZô", "ழோ"),
    ("ùZô", "ழொ"),
    ("Zô", "ழா"),
    ("¯", "ழி"),
    ("Æ", "ழீ"),
    ("Ý", "ழு"),
    ("ï", "ழூ"),
    ("ùZ", "ழெ"),
    ("úZ", "ழே"),
    ("ûZ", "ழை"),
    ("r", "ழ்"),
    ("Z", "ழ"),
    ("ù\\\[", "றௌ"),
    ("ú\\ô", "றோ"),
    ("ù\\ô", "றொ"),
    ("\\ô", "றா"),
    ("±", "றி"),
    ("È", "றீ"),
    ("ß", "று"),
    ("ñ", "றூ"),
    ("ù\\", "றெ"),
    ("ú\\", "றே"),
    ("û\\", "றை"),
    ("t", "ற்"),
    ("\\", "ற"),
    ("ù^\[", "ஸௌ"),
    ("ú^ô", "ஸோ"),
    ("ù^ô", "ஸொ"),
    ("^ô", "ஸா"),
    ("³", "ஸி"),
    ("Ê", "ஸீ"),
    ("^ý", "ஸு"),
    ("^þ", "ஸூ"),
    ("ù^", "ஸெ"),
    ("ú^", "ஸே"),
    ("û^", "ஸை"),
    ("v", "ஸ்"),
    ("\^", "ஸ"),

    ("A", "அ"),
    ("B", "ஆ"),
    ("C", "இ"),
    ("D", "ஈ"),
    ("E", "உ"),
    ("F", "ஊ"),
    ("G", "எ"),
    ("H", "ஏ"),
    ("I", "ஐ"),
    ("J", "ஒ"),
    ("K", "ஓ"),
    ("J\[", "ஔ"),

    ("@", "ஃ"),

    ("c", "ஸ்ரீ"),

    ("ùa\[", "ஹௌ"),
    ("úaô", "ஹோ"),
    ("ùaô", "ஹொ"),
    ("aô", "ஹா"),
    ("¶", "ஹி"),
    ("Í", "ஹீ"),
    ("aý", "ஹு"),
    ("aþ", "ஹூ"),
    ("ùa", "ஹெ"),
    ("úa", "ஹே"),
    ("ûa", "ஹை"),
    ("y", "ஹ்"),
    ("a", "ஹ"),

    ("ù`\[", "ஷௌ"),
    ("ú`ô", "ஷோ"),
    ("ù`ô", "ஷொ"),
    ("`ô", "ஷா"),
    ("µ", "ஷி"),
    ("Ì", "ஷீ"),
    ("`ý", "ஷு"),
    ("`þ", "ஷூ"),
    ("ù`", "ஷெ"),
    ("ú`", "ஷே"),
    ("û`", "ஷை"),
    ("x", "ஷ்"),
    ("`", "ஷ"),

    ])
# end of dinamani2utf8 dictionary 

     
# begin of dinathanthy2utf8 dictionary 
dinathanthy2utf8 = OrderedDict([

    ("d", "க்ஷ"),
    ("dÖ", "க்ஷா"),
    ("Ûd", "க்ஷை"),
    ("Ô", "க்ஷி"),
    ("Õ", "க்ஷீ"),
    ("d×", "க்ஷு"),
    ("dØ", "க்ஷூ"),
    ("Ùd", "க்ஷெ"),
    ("Úd", "க்ஷே"),
    ("ÙdÖ", "க்ஷொ"),
    ("ÚdÖ", "க்ஷோ"),
    ("Ùd\[", "க்ஷௌ"),
    ("Ó", "க்ஷ்"),

    ("Ù\^\[", "ஜௌ"),
    ("Ú\^Ö", "ஜோ"),
    ("Ù\^Ö", "ஜொ"),
    ("\^Ö", "ஜா"),
    ("È", "ஜி"),
    ("É", "ஜீ"),
    ("\^Ø", "ஜு"),
    ("\^þ", "ஜூ"),
    ("Ù\^", "ஜெ"),
    ("Ú\^", "ஜே"),
    ("Û\^", "ஜை"),
    ("Ç", "ஜ்"),
    ("\^", "ஜ"),

    ("ÙL\[", "கௌ"),
    ("ÚLÖ", "கோ"),
    ("ÙLÖ", "கொ"),
    ("LÖ", "கா"),
    ("f", "கி"),
    ("g", "கீ"),
    ("h", "கு"),
    ("i", "கூ"),
    ("ÙL", "கெ"),
    ("ÚL", "கே"),
    ("ÛL", "கை"),
    ("e", "க்"),
    ("L", "க"),
    ("ÙM\[", "ஙௌ"),
    ("ÚMÖ", "ஙோ"),
    ("ÙMÖ", "ஙொ"),
    ("MÖ", "ஙா"),
    ("k", "ஙி"),
    ("l", "ஙீ"),
    ("m", "ஙு"),
    ("n", "ஙூ"),
    ("ÙM", "ஙெ"),
    ("ÚM", "ஙே"),
    ("ÛM", "ஙை"),
    ("j", "ங்"),
    ("M", "ங"),

    ("ÙN\[", "சௌ"),
    ("ÚNÖ", "சோ"),
    ("ÙNÖ", "சொ"),
    ("NÖ", "சா"),
    ("p", "சி"),
    ("q", "சீ"),
    ("r", "சு"),
    ("s", "சூ"),
    ("ÙN", "செ"),
    ("ÚN", "சே"),
    ("ÛN", "சை"),
    ("o", "ச்"),
    ("N", "ச"),

    ("ÙO\[", "ஞௌ"),
    ("ÚOÖ", "ஞோ"),
    ("ÙOÖ", "ஞொ"),
    ("OÖ", "ஞா"),
    ("u", "ஞி"),
    ("v", "ஞீ"),
    ("w", "ஞு"),
    ("x", "ஞூ"),
    ("ÙO", "ஞெ"),
    ("ÚO", "ஞே"),
    ("ÛO", "ஞை"),
    ("t", "ஞ்"),
    ("O", "ஞ"),

    ("ÙP\[", "டௌ"),
    ("ÚPÖ", "டோ"),
    ("ÙPÖ", "டொ"),
    ("PÖ", "டா"),
    ("z", "டி"),
    ("{", "டீ"),
    ("\|", "டு"),
    ("}", "டூ"),
    ("ÙP", "டெ"),
    ("ÚP", "டே"),
    ("ÛP", "டை"),
    ("y", "ட்"),
    ("P", "ட"),

    ("ÙQ\[", "ணௌ"),
    ("ÚQÖ", "ணோ"),
    ("ÙQÖ", "ணொ"),
    ("QÖ", "ணா"),
    ("‚", "ணி"),
    ("ƒ", "ணீ"),
    ("„", "ணு"),
    ("…", "ணூ"),
    ("ÙQ", "ணெ"),
    ("ÚQ", "ணே"),
    ("ÛQ", "ணை"),
    ("", "ண்"),
    ("Q", "ண"),
    ("ÙR\[", "தௌ"),
    ("ÚRÖ", "தோ"),
    ("ÙRÖ", "தொ"),
    ("RÖ", "தா"),
    ("‡", "தி"),
    ("ˆ", "தீ"),
    ("‰", "து"),
    ("Š", "தூ"),
    ("ÙR", "தெ"),
    ("ÚR", "தே"),
    ("ÛR", "தை"),
    ("†", "த்"),
    ("R", "த"),
    
    ("ÙS\[", "நௌ"),
    ("ÚSÖ", "நோ"),
    ("ÙSÖ", "நொ"),
    ("SÖ", "நா"),
    ("Œ", "நி"),
    ("", "நீ"),
    ("î", "நு"),
    ("", "நு"),
    ("", "நூ"),
    ("ÙS", "நெ"),
    ("ÚS", "நே"),
    ("ÛS", "நை"),
    ("‹", "ந்"),
    ("S", "ந"),

    ("Ù]\[", "னௌ"),
    ("Ú]Ö", "னோ"),
    ("Ù]Ö", "னொ"),
    ("]Ö", "னா"),
    ("Â", "னி"),
    ("Ã", "னீ"),
    ("Ä", "னு"),
    ("Å", "னூ"),
    ("Ù]", "னெ"),
    ("Ú]", "னே"),
    ("Û]", "னை"),
    ("Á", "ன்"),
    ("]", "ன"),
    ("ÙT\[", "பௌ"),
    ("ÚTÖ", "போ"),
    ("ÙTÖ", "பொ"),
    ("TÖ", "பா"),
    ("‘", "பி"),
    ("’", "பீ"),
    ("“", "பு"),
    ("”", "பூ"),
    ("ÙT", "பெ"),
    ("ÚT", "பே"),
    ("ÛT", "பை"),
    ("", "ப்"),
    ("T", "ப"),

    ("ÙU\[", "மௌ"),
    ("ÚUÖ", "மோ"),
    ("ÙUÖ", "மொ"),
    ("UÖ", "மா"),
    ("–", "மி"),
    ("—", "மீ"),
    ("˜", "மு"),
    ("™", "மூ"),
    ("ÙU", "மெ"),
    ("ÚU", "மே"),
    ("ÛU", "மை"),
    ("•", "ம்"),
    ("U", "ம"),

    ("ÙV\[", "யௌ"),
    ("ÚVÖ", "யோ"),
    ("ÙVÖ", "யொ"),
    ("VÖ", "யா"),
    ("›", "யி"),
    ("œ", "யீ"),
    ("", "யு"),
    ("", "யூ"),
    ("ÙV", "யெ"),
    ("ÚV", "யே"),
    ("ÛV", "யை"),
    ("š", "ய்"),
    ("V", "ய"),

    ("ÙW\[", "ரௌ"),
    ("ÚWÖ", "ரோ"),
    ("ÙWÖ", "ரொ"),
    ("WÖ", "ரா"),
    ("¡", "ரி"),
    ("¢", "ரீ"),
    ("£", "ரு"),
    ("¤", "ரூ"),
    ("ÙW", "ரெ"),
    ("ÚW", "ரே"),
    ("ÛW", "ரை"),
    ("Ÿ", "ர்"),
    ("W", "ர"),
    ("ÙX\[", "லௌ"),
    ("ÚXÖ", "லோ"),
    ("ÙXÖ", "லொ"),
    ("XÖ", "லா"),
    ("¦", "லி"),
    ("§", "லீ"),
    ("¨", "லு"),
    ("©", "லூ"),
    ("ÙX", "லெ"),
    ("ÚX", "லே"),
    ("ÛX", "லை"),
    ("¥", "ல்"),
    ("X", "ல"),

    ("Ù\[\[", "ளௌ"),
    ("Ú\[Ö", "ளோ"),
    ("Ù\[Ö", "ளொ"),
    ("\[Ö", "ளா"),
    ("¸", "ளி"),
    ("¹", "ளீ"),
    ("º", "ளு"),
    ("»", "ளூ"),
    ("Ù\[", "ளெ"),
    ("Ú\[", "ளே"),
    ("Û\[", "ளை"),
    ("·", "ள்"),
    ("\[", "ள"),

    ("ÙY\[", "வௌ"),
    ("ÚYÖ", "வோ"),
    ("ÙYÖ", "வொ"),
    ("YÖ", "வா"),
    ("«", "வி"),
    ("®", "வீ"),
    ("°", "வு"),
    ("±", "வூ"),
    ("ÙY", "வெ"),
    ("ÚY", "வே"),
    ("ÛY", "வை"),
    ("ª", "வ்"),
    ("Y", "வ"),

    ("ÙZ\[", "ழௌ"),
    ("ÚZÖ", "ழோ"),
    ("ÙZÖ", "ழொ"),
    ("ZÖ", "ழா"),
    ("³", "ழி"),
    ("´", "ழீ"),
    ("µ", "ழு"),
    ("¶", "ழூ"),
    ("ÙZ", "ழெ"),
    ("ÚZ", "ழே"),
    ("ÛZ", "ழை"),
    ("²", "ழ்"),
    ("Z", "ழ"),
    ("Ù\\\[", "றௌ"),
    ("Ú\\Ö", "றோ"),
    ("Ù\\Ö", "றொ"),
    ("\\Ö", "றா"),
    ("½", "றி"),
    ("¾", "றீ"),
    ("¿", "று"),
    ("À", "றூ"),
    ("Ù\\", "றெ"),
    ("Ú\\", "றே"),
    ("Û\\", "றை"),
    ("¼", "ற்"),
    ("\\", "ற"),

    ("Ùa\[", "ஹௌ"),
    ("ÚaÖ", "ஹோ"),
    ("ÙaÖ", "ஹொ"),
    ("aÖ", "ஹா"),
    ("Ë", "ஹி"),
    ("Ì", "ஹீ"),
    ("a×", "ஹு"),
    ("aØ", "ஹூ"),
    ("Ùa", "ஹெ"),
    ("Úa", "ஹே"),
    ("Ûa", "ஹை"),
    ("Ê", "ஹ்"),
    ("a", "ஹ"),

    ("Ùc\[", "ஷௌ"),
    ("ÚcÖ", "ஷோ"),
    ("ÙcÖ", "ஷொ"),
    ("cÖ", "ஷா"),
    ("Ñ", "ஷி"),
    ("Ò", "ஷீ"),
    ("c×", "ஷு"),
    ("cØ", "ஷூ"),
    ("Ùc", "ஷெ"),
    ("Úc", "ஷே"),
    ("Ûc", "ஷை"),
    ("Ð", "ஷ்"),
    ("c", "ஷ"),

    ("Ùb\[", "ஸௌ"),
    ("ÚbÖ", "ஸோ"),
    ("ÙbÖ", "ஸொ"),
    ("bÖ", "ஸா"),
    ("Î", "ஸி"),
    ("Ï", "ஸீ"),
    ("b×", "ஸு"),
    ("bØ", "ஸூ"),
    ("Ùb", "ஸெ"),
    ("Úb", "ஸே"),
    ("Ûb", "ஸை"),
    ("Í", "ஸ்"),
    ("b", "ஸ"),

    ("A", "அ"),
    ("B", "ஆ"),
    ("C", "இ"),
    ("D", "ஈ"),
    ("E", "உ"),
    ("F", "ஊ"),
    ("G", "எ"),
    ("H", "ஏ"),
    ("I", "ஐ"),
    ("J", "ஒ"),
    ("K", "ஓ"),
    ("J\[", "ஔ"),

    ("@", "ஃ"),
    ("Ü", "-"),
    ("Ý", "_"),
    ("~", "ஸ்ரீ"),

    ])
# end of dinathanthy2utf8 dictionary 

     
# begin of kavipriya2utf8 dictionary 
kavipriya2utf8 = OrderedDict([

    ("û", "க்ஷ"),
       
    ("b", "க்ஷ"),
    ("ùக்ஷ\[", "க்ஷௌ"),
    ("bô", "க்ஷா"),
    ("·", "க்ஷி"),
    ("Î", "க்ஷீ"),
    ("bý", "க்ஷு"),
    ("bþ", "க்ஷூ"),
    ("ùb", "க்ஷெ"),
    ("úb", "க்ஷே"),
    ("ùbô", "க்ஷொ"),
    ("úbô", "க்ஷோ"),
    ("ûb", "க்ஷை"),
    ("z", "க்ஷ்"),

    ("_", "ஜ"),
    ("ùஜ", "ஜெ"),
    ("ùஜ\[", "ஜௌ"),
    ("úஜô", "ஜோ"),
    ("ùஜô", "ஜொ"),
    ("ஜô", "ஜா"),
    ("´", "ஜி"),
    ("Ë", "ஜீ"),
    ("ஜý", "ஜு"),
    ("ஜþ", "ஜூ"),
    ("úஜ", "ஜே"),
    ("ûஜ", "ஜை"),
    ("w", "ஜ்"),

    ("ùL\[", "கௌ"),
    ("úLô", "கோ"),
    ("ùLô", "கொ"),
    ("Lô", "கா"),
    ("¡", "கி"),
    ("¸", "கீ"),
    ("Ï", "கு"),
    ("á", "கூ"),
    ("ùL", "கெ"),
    ("úL", "கே"),
    ("ûL", "கை"),
    ("d", "க்"),
    ("L", "க"),

    ("ùM\[", "ஙௌ"),
    ("úMô", "ஙோ"),
    ("ùMô", "ஙொ"),
    ("Mô", "ஙா"),
    ("¢", "ஙி"),
    ("¹", "ஙீ"),
    ("Ð", "ஙு"),
    ("â", "ஙூ"),
    ("ùM", "ஙெ"),
    ("úM", "ஙே"),
    ("ûM", "ஙை"),
    ("e", "ங்"),
    ("M", "ங"),

    ("ùN\[", "சௌ"),
    ("úNô", "சோ"),
    ("ùNô", "சொ"),
    ("Nô", "சா"),
    ("£", "சி"),
    ("º", "சீ"),
    ("Ñ", "சு"),
    ("ã", "சூ"),
    ("ùN", "செ"),
    ("úN", "சே"),
    ("ûN", "சை"),
    ("f", "ச்"),
    ("N", "ச"),

    ("ùO\[", "ஞௌ"),
    ("úOô", "ஞோ"),
    ("ùOô", "ஞொ"),
    ("Oô", "ஞா"),
    ("¤", "ஞி"),
    ("»", "ஞீ"),
    ("Ò", "ஞு"),
    ("ä", "ஞூ"),
    ("ùO", "ஞெ"),
    ("úO", "ஞே"),
    ("ûO", "ஞை"),
    ("g", "ஞ்"),
    ("O", "ஞ"),

    ("ùP\[", "டௌ"),
    ("úPô", "டோ"),
    ("ùPô", "டொ"),
    ("Pô", "டா"),
    ("¥", "டி"),
    ("¼", "டீ"),
    ("Ó", "டு"),
    ("å", "டூ"),
    ("ùP", "டெ"),
    ("úP", "டே"),
    ("ûP", "டை"),
    ("h", "ட்"),
    ("P", "ட"),

    ("ùQ\[", "ணௌ"),
    ("úQô", "ணோ"),
    ("ùQô", "ணொ"),
    ("Qô", "ணா"),
    ("¦", "ணி"),
    ("½", "ணீ"),
    ("Ô", "ணு"),
    ("æ", "ணூ"),
    ("ùQ", "ணெ"),
    ("úQ", "ணே"),
    ("ûQ", "ணை"),
    ("i", "ண்"),
    ("Q", "ண"),

    ("ùR\[", "தௌ"),
    ("úRô", "தோ"),
    ("ùRô", "தொ"),
    ("Rô", "தா"),
    ("§", "தி"),
    ("¾", "தீ"),
    ("Õ", "து"),
    ("ç", "தூ"),
    ("ùR", "தெ"),
    ("úR", "தே"),
    ("ûR", "தை"),
    ("j", "த்"),
    ("R", "த"),

    ("ùS\[", "நௌ"),
    ("úSô", "நோ"),
    ("ùSô", "நொ"),
    ("Sô", "நா"),
    ("¨", "நி"),
    ("¿", "நீ"),
    ("Ö", "நு"),
    ("è", "நூ"),
    ("ùS", "நெ"),
    ("úS", "நே"),
    ("ûS", "நை"),
    ("k", "ந்"),
    ("S", "ந"),

    ("ù]\[", "னௌ"),
    ("ú]ô", "னோ"),
    ("ù]ô", "னொ"),
    ("]ô", "னா"),
    ("²", "னி"),
    ("É", "னீ"),
    ("à", "னு"),
    ("ò", "னூ"),
    ("ù]", "னெ"),
    ("ú]", "னே"),
    ("û]", "னை"),
    ("u", "ன்"),
    ("]", "ன"),

    ("ùT\[", "பௌ"),
    ("úTô", "போ"),
    ("ùTô", "பொ"),
    ("Tô", "பா"),
    ("©", "பி"),
    ("À", "பீ"),
    ("×", "பு"),
    ("é", "பூ"),
    ("ùT", "பெ"),
    ("úT", "பே"),
    ("ûT", "பை"),
    ("l", "ப்"),
    ("T", "ப"),

    ("ùU\[", "மௌ"),
    ("úUô", "மோ"),
    ("ùUô", "மொ"),
    ("Uô", "மா"),
    ("ª", "மி"),
    ("Á", "மீ"),
    ("Ø", "மு"),
    ("ê", "மூ"),
    ("ùU", "மெ"),
    ("úU", "மே"),
    ("ûU", "மை"),
    ("m", "ம்"),
    ("U", "ம"),

    ("ùV\[", "யௌ"),
    ("úVô", "யோ"),
    ("ùVô", "யொ"),
    ("Vô", "யா"),
    ("«", "யி"),
    ("Â", "யீ"),
    ("Ù", "யு"),
    ("ë", "யூ"),
    ("ùV", "யெ"),
    ("úV", "யே"),
    ("ûV", "யை"),
    ("n", "ய்"),
    ("V", "ய"),

    ("ùW\[", "ரௌ"),
    ("úWô", "ரோ"),
    ("ùWô", "ரொ"),
    ("Wô", "ரா"),
    ("¬", "ரி"),
    ("Ã", "ரீ"),
    ("Ú", "ரு"),
    ("ì", "ரூ"),
    ("ùW", "ரெ"),
    ("úW", "ரே"),
    ("ûW", "ரை"),
    ("o", "ர்"),
    ("W", "ர"),

    ("ùX\[", "லௌ"),
    ("úXô", "லோ"),
    ("ùXô", "லொ"),
    ("Xô", "லா"),
    ("#", "லி"),
    ("\-", "லி"),
    ("Ä", "லீ"),
    ("Û", "லு"),
    ("í", "லூ"),
    ("ùX", "லெ"),
    ("úX", "லே"),
    ("ûX", "லை"),
    ("p", "ல்"),
    ("X", "ல"),

    ("ù\[\[", "ளௌ"),
    ("ú\[ô", "ளோ"),
    ("ù\[ô", "ளொ"),
    ("°", "ளி"),
    ("Ç", "ளீ"),
    ("Þ", "ளு"),
    ("ð", "ளூ"),
    ("ù\[", "ளெ"),
    ("ú\[", "ளே"),
    ("s", "ள்"),
    ("\[", "ள"),
    ("ûள", "ளை"),
    ("ளô", "ளா"),

    ("ùY\[", "வௌ"),
    ("úYô", "வோ"),
    ("ùYô", "வொ"),
    ("Yô", "வா"),
    ("®", "வி"),
    ("Å", "வீ"),
    ("Ü", "வு"),
    ("î", "வூ"),
    ("ùY", "வெ"),
    ("úY", "வே"),
    ("ûY", "வை"),
    ("q", "வ்"),
    ("Y", "வ"),

    ("ùZ\[", "ழௌ"),
    ("úZô", "ழோ"),
    ("ùZô", "ழொ"),
    ("Zô", "ழா"),
    ("¯", "ழி"),
    ("Æ", "ழீ"),
    ("Ý", "ழு"),
    ("ï", "ழூ"),
    ("ùZ", "ழெ"),
    ("úZ", "ழே"),
    ("ûZ", "ழை"),
    ("r", "ழ்"),
    ("Z", "ழ"),

    ("ù\\\[", "றௌ"),
    ("ú\\ô", "றோ"),
    ("ù\\ô", "றொ"),
    ("\\ô", "றா"),
    ("±", "றி"),
    ("È", "றீ"),
    ("ß", "று"),
    ("ñ", "றூ"),
    ("ù\\", "றெ"),
    ("ú\\", "றே"),
    ("û\\", "றை"),
    ("t", "ற்"),
    ("\\", "ற"),

    ("\^", "ஸ"),
    ("ெஸள", "ஸௌ"),
    ("ú^ô", "ஸோ"),
    ("ù^ô", "ஸொ"),
    ("ஸô", "ஸா"),
    ("³", "ஸி"),
    ("Ê", "ஸீ"),
    ("ஸý", "ஸு"),
    ("^þ", "ஸூ"),
    ("ù^", "ஸெ"),
    ("ú^", "ஸே"),
    ("ûஸ", "ஸை"),
    ("v", "ஸ்"),

    ("@", "அ"),
    ("A", "ஆ"),
    ("B", "இ"),
    ("C", "ஈ"),
    ("D", "உ"),
    ("E", "ஊ"),
    ("F", "எ"),
    ("G", "ஏ"),
    ("H", "ஐ"),
    ("I", "ஒ"),
    ("J", "ஓ"),
    ("K", "ஃ"),
    ("I\[", "ஔ"),

    ("c", "ஸ்ரீ"),
    
    ("a", "ஹ"),
    ("ùஹ\[", "ஹௌ"),
    ("úஹô", "ஹோ"),
    ("ùஹô", "ஹொ"),
    ("ஹô", "ஹா"),
    ("¶", "ஹி"),
    ("Í", "ஹீ"),
    ("ஹý", "ஹு"),
    ("ஹþ", "ஹூ"),
    ("ùஹ", "ஹெ"),
    ("úஹ", "ஹே"),
    ("ûஹ", "ஹை"),
    ("y", "ஹ்"),

    ("`", "ஷ"),
    ("ˆ", "ஷ"),
    ("ùஷ", "ஷெ"),
    ("ùஷ\[", "ஷௌ"),
    ("úஷô", "ஷோ"),
    ("ùஷô", "ஷொ"),
    ("ஷô", "ஷா"),
    ("µ", "ஷி"),
    ("Ì", "ஷீ"),
    ("ஷý", "ஷு"),
    ("ஷþ", "ஷூ"),
    ("úஷ", "ஷே"),
    ("ûஷ", "ஷை"),
    ("x", "ஷ்"),

    ("\‘", "'"),
    ("\’", "'"),
    ("\“", "'"),
    ("\”", "'"),
    ("\"", "'"),
    ("…", "..."),

    ])
# end of kavipriya2utf8 dictionary 

       
# begin of murasoli2utf8 dictionary 
murasoli2utf8 = OrderedDict([
     
    ("b#s", "ஜௌ"),
    ("n#h", "ஜோ"),
    ("b#h", "ஜொ"),
    ("#h", "ஜா"),
    ("í", "ஜி"),
    ("É", "ஜீ"),
    ("#&", "ஜு"),
    ("#]", "ஜூ"),
    ("b#", "ஜெ"),
    ("n#", "ஜே"),
    ("i#", "ஜை"),
    ("{", "ஜ்"),
    ("#", "ஜ"),

    ("bfs", "கௌ"),
    ("nfh", "கோ"),
    ("bfh", "கொ"),
    ("fh", "கா"),
    ("»", "கி"),
    ("Ñ", "கீ"),
    ("F", "கு"),
    ("T", "கூ"),
    ("bf", "கெ"),
    ("nf", "கே"),
    ("if", "கை"),
    ("¡", "க்"),
    ("f", "க"),

    ("b‡s", "ஙௌ"),
    ("n‡h", "ஙோ"),
    ("b‡h", "ஙொ"),
    ("‡h", "ஙா"),
    ("à", "ஙி"),
    ("†", "ஙீ"),
    ("¼", "ஙு"),
    ("½", "ஙூ"),
    ("b‡", "ஙெ"),
    ("n‡", "ஙே"),
    ("i‡", "ஙை"),
    ("§", "ங்"),
    ("‡", "ங"),

    ("brs", "சௌ"),
    ("nrh", "சோ"),
    ("brh", "சொ"),
    ("rh", "சா"),
    ("Á", "சி"),
    ("Ó", "சீ"),
    ("R", "சு"),
    ("N", "சூ"),
    ("br", "செ"),
    ("nr", "சே"),
    ("ir", "சை"),
    ("¢", "ச்"),
    ("r", "ச"),
    ("bPs", "ஞௌ"),
    ("nPh", "ஞோ"),
    ("bPh", "ஞொ"),
    ("Ph", "ஞா"),
    ("á", "ஞி"),
    ("Ø", "ஞீ"),
    ("\|", "ஞு"),
    ("ú", "ஞூ"),
    ("bP", "ஞெ"),
    ("nP", "ஞே"),
    ("iP", "ஞை"),
    ("Š", "ஞ்"),
    ("P", "ஞ"),

    ("bls", "டௌ"),
    ("nlh", "டோ"),
    ("blh", "டொ"),
    ("lh", "டா"),
    ("o", "டி"),
    ("O", "டீ"),
    ("L", "டு"),
    ("\^", "டூ"),
    ("bl", "டெ"),
    ("nl", "டே"),
    ("il", "டை"),
    ("£", "ட்"),
    ("l", "ட"),

    ("bzs", "ணௌ"),
    ("nzh", "ணோ"),
    ("bzh", "ணொ"),
    ("zh", "ணா"),
    ("â", "ணி"),
    ("Ù", "ணீ"),
    ("Q", "ணு"),
    ("û", "ணூ"),
    ("bz", "ணெ"),
    ("nz", "ணே"),
    ("iz", "ணை"),
    ("©", "ண்"),
    ("z", "ண"),

    ("bjs", "தௌ"),
    ("njh", "தோ"),
    ("bjh", "தொ"),
    ("jh", "தா"),
    ("Â", "தி"),
    ("Ô", "தீ"),
    ("J", "து"),
    ("ö", "தூ"),
    ("bj", "தெ"),
    ("nj", "தே"),
    ("ij", "தை"),
    ("¤", "த்"),
    ("j", "த"),

    ("bes", "நௌ"),
    ("neh", "நோ"),
    ("beh", "நொ"),
    ("eh", "நா"),
    ("ã", "நி"),
    ("Ú", "நீ"),
    ("E", "நு"),
    ("ü", "நூ"),
    ("be", "நெ"),
    ("ne", "நே"),
    ("ie", "நை"),
    ("ª", "ந்"),
    ("e", "ந"),

    ("bds", "னௌ"),
    ("ndh", "னோ"),
    ("bdh", "னொ"),
    ("dh", "னா"),
    ("å", "னி"),
    ("Ü", "னீ"),
    ("D", "னு"),
    ("}", "னூ"),
    ("bd", "னெ"),
    ("nd", "னே"),
    ("id", "னை"),
    ("‹", "ன்"),
    ("d", "ன"),

    ("bgs", "பௌ"),
    ("ngh", "போ"),
    ("bgh", "பொ"),
    ("h", "பா"),
    ("Ã", "பி"),
    ("Õ", "பீ"),
    ("ò", "பு"),
    ("ó", "பூ"),
    ("bg", "பெ"),
    ("ng", "பே"),
    ("ig", "பை"),
    ("¥", "ப்"),
    ("g", "ப"),

    ("bks", "மௌ"),
    ("nkh", "மோ"),
    ("bkh", "மொ"),
    ("kh", "மா"),
    ("ä", "மி"),
    ("Û", "மீ"),
    ("K", "மு"),
    ("_", "மூ"),
    ("bk", "மெ"),
    ("nk", "மே"),
    ("ik", "மை"),
    ("«", "ம்"),
    ("k", "ம"),

    ("bas", "யௌ"),
    ("nah", "யோ"),
    ("bah", "யொ"),
    ("ah", "யா"),
    ("æ", "யி"),
    ("p", "யீ"),
    ("Í", "யு"),
    ("ô", "யூ"),
    ("ba", "யெ"),
    ("na", "யே"),
    ("ia", "யை"),
    ("Œ", "ய்"),
    ("a", "ய"),

    ("bus", "ரௌ"),
    ("nuh", "ரோ"),
    ("buh", "ரொ"),
    ("uh", "ரா"),
    ("ç", "ரி"),
    ("ß", "ரீ"),
    ("U", "ரு"),
    ("%", "ரூ"),
    ("bu", "ரெ"),
    ("nu", "ரே"),
    ("iu", "ரை"),
    ("®", "ர்"),
    ("u", "ர"),

    ("bys", "லௌ"),
    ("nyh", "லோ"),
    ("byh", "லொ"),
    ("yh", "லா"),
    ("è", "லி"),
    ("Ä", "லீ"),
    ("Y", "லு"),
    ("ÿ", "லூ"),
    ("by", "லெ"),
    ("ny", "லே"),
    ("iy", "லை"),
    ("š", "ல்"),
    ("y", "ல"),

    ("bss", "ளௌ"),
    ("nsh", "ளோ"),
    ("bsh", "ளொ"),
    ("sh", "ளா"),
    ("ë", "ளி"),
    ("Ç", "ளீ"),
    ("S", "ளு"),
    ("q", "ளூ"),
    ("bs", "ளெ"),
    ("ns", "ளே"),
    ("is", "ளை"),
    ("Ÿ", "ள்"),
    ("s", "ள"),

    ("bts", "வௌ"),
    ("nth", "வோ"),
    ("bth", "வொ"),
    ("th", "வா"),
    ("é", "வி"),
    ("Å", "வீ"),
    ("Î", "வு"),
    ("ñ", "வூ"),
    ("bt", "வெ"),
    ("nt", "வே"),
    ("it", "வை"),
    ("›", "வ்"),
    ("t", "வ"),

    ("bHs", "ழௌ"),
    ("nHh", "ழோ"),
    ("bHh", "ழொ"),
    ("Hh", "ழா"),
    ("ê", "ழி"),
    ("Æ", "ழீ"),
    ("G", "ழு"),
    (">", "ழூ"),
    ("bH", "ழெ"),
    ("nH", "ழே"),
    ("iH", "ழை"),
    ("œ", "ழ்"),
    ("H", "ழ"),

    ("bws", "றௌ"),
    ("nwh", "றோ"),
    ("bwh", "றொ"),
    ("wh", "றா"),
    ("¿", "றி"),
    ("Ö", "றீ"),
    ("W", "று"),
    ("ù", "றூ"),
    ("bw", "றெ"),
    ("nw", "றே"),
    ("iw", "றை"),
    ("‰", "ற்"),
    ("w", "ற"),

    ("bAs", "ஹௌ"),
    ("nAh", "ஹோ"),
    ("bAh", "ஹொ"),
    ("Ah", "ஹா"),
    ("ï", "ஹி"),
    ("Ë", "ஹீ"),
    ("A&", "ஹு"),
    ("A\]", "ஹூ"),
    ("bA", "ஹெ"),
    ("nA", "ஹே"),
    ("iA", "ஹை"),
    ("À", "ஹ்"),
    ("A", "ஹ"),

    ("bõs", "ஷௌ"),
    ("nõh", "ஷோ"),
    ("bõh", "ஷொ"),
    ("õh", "ஷா"),
    ("î", "ஷி"),
    ("Ê", "ஷீ"),
    ("õ&", "ஷு"),
    ("õ]", "ஷூ"),
    ("bõ", "ஷெ"),
    ("nõ", "ஷே"),
    ("iõ", "ஷை"),
    ("Z", "ஷ்"),
    ("õ", "ஷ"),

    ("b\[s", "ஸௌ"),
    ("n\[h", "ஸோ"),
    ("b\[h", "ஸொ"),
    ("\[h", "ஸா"),
    ("ì", "ஸி"),
    ("È", "ஸீ"),
    ("\[&", "ஸு"),
    ("\[\]", "ஸூ"),
    ("b\[", "ஸெ"),
    ("n\[", "ஸே"),
    ("i\[", "ஸை"),
    ("°", "ஸ்"),
    ("\[", "ஸ"),

    ("m", "அ"),
    ("M", "ஆ"),
    ("Ï", "இ"),
    ("<", "ஈ"),
    ("c", "உ"),
    ("C", "ஊ"),
    ("v", "எ"),
    ("V", "ஏ"),
    ("I", "ஐ"),
    ("x", "ஒ"),
    ("X", "ஓ"),
    ("xs", "ஔ"),

    ("~", "ஃ"),

    ("\$", "ஸ்ரீ"),

    ("˜", "?"),

    ("B", "க்ஷ"),
    ("Bh", "க்ஷா"),
    ("iB", "க்ஷை"),
    ("ø", "க்ஷி"),
    ("Ì", "க்ஷீ"),
    ("B&", "க்ஷு"),
    ("B\]", "க்ஷூ"),
    ("bB", "க்ஷெ"),
    ("nB", "க்ஷே"),
    ("bBh", "க்ஷொ"),
    ("nBh", "க்ஷோ"),
    ("bBs", "க்ஷௌ"),
    ("º", "க்ஷ்"),

    ])
# end of murasoli2utf8 dictionary 



# begin of mylai2utf8 dictionary 
mylai2utf8 = OrderedDict([

    ("X", "க்ஷ"),
    ("Xa", "க்ஷா"),
    ("AX", "க்ஷை"),
    ("Xi", "க்ஷி"),
    ("XI  ", "க்ஷீ"),
    ("XH", "க்ஷு"),
    ("XJ", "க்ஷூ"),
    ("eX", "க்ஷெ"),
    ("EX", "க்ஷே"),
    ("eXa", "க்ஷொ"),
    ("EXa", "க்ஷோ"),
    ("eXq", "க்ஷௌ"),
    ("Xf", "க்ஷ்"),
    ("ai", "ரி"),
    ("af", "ர்"),
    ("ejq", "ஜௌ"),
    ("Eja", "ஜோ"),
    ("eja", "ஜொ"),
    ("ja", "ஜா"),
    ("ji", "ஜி"),
    ("jI", "ஜீ"),
    ("jH", "ஜு"),
    ("jJ", "ஜூ"),
    ("ej", "ஜெ"),
    ("Ej", "ஜே"),
    ("Aj", "ஜை"),
    ("jf", "ஜ்"),
    ("j", "ஜ"),
    ("ekq", "கௌ"),
    ("Eka", "கோ"),
    ("eka", "கொ"),
    ("ka", "கா"),
    ("ki", "கி"),
    ("kI", "கீ"),
    ("K", "கு"),
    ("P", "கூ"),
    ("ek", "கெ"),
    ("Ek", "கே"),
    ("Ak", "கை"),
    ("kf", "க்"),
    ("k", "க"),
    ("egq", "ஙௌ"),
    ("Ega", "ஙோ"),
    ("ega", "ஙொ"),
    ("a", "ஙா"),
    ("i", "ஙி"),
    ("I", "ஙீ"),

    ("eg", "ஙெ"),
    ("Eg", "ஙே"),
    ("Ag", "ஙை"),
    ("f", "ங்"),
    ("g", "ங"),
    ("ecq", "சௌ"),
    ("Eca", "சோ"),
    ("eca", "சொ"),
    ("ca", "சா"),
    ("ci", "சி"),
    ("cI", "சீ"),
    ("V", "சூ"),
    ("C", "சு"),

    ("ec", "செ"),
    ("Ec", "சே"),
    ("Ac", "சை"),
    ("cf", "ச்"),
    ("c", "ச"),

    ("ewq", "ஞௌ"),
    ("Ewa", "ஞோ"),
    ("ewa", "ஞொ"),
    ("wa", "ஞா"),
    ("wi", "ஞி"),
    ("wI", "ஞீ"),
    ("W\\", "ஞூ"),
    ("W", "ஞு"),

    ("ew", "ஞெ"),
    ("Ew", "ஞே"),
    ("Aw", "ஞை"),
    ("wf", "ஞ்"),
    ("w", "ஞ"),
    ("edq", "டௌ"),
    ("Eda", "டோ"),
    ("eda", "டொ"),
    ("da", "டா"),
    ("F", "டி"),
    ("G", "டீ"),
    ("D", "டு"),
    ("ed", "டெ"),
    ("Ed", "டே"),
    ("Ad", "டை"),
    ("df", "ட்"),
    ("d", "ட"),

    ("e]q", "ணௌ"),
    ("E]a", "ணோ"),
    ("e]a", "ணொ"),
    ("]a", "ணா"),
    ("]i", "ணி"),
    ("]I", "ணீ"),
    ("}\\", "ணூ"),
    ("}", "ணு"),

    ("e]", "ணெ"),
    ("E]", "ணே"),
    ("A]", "ணை"),
    ("]f", "ண்"),
    ("]", "ண"),
    ("etq", "தௌ"),
    ("Eta", "தோ"),
    ("eta", "தொ"),
    ("ta", "தா"),
    ("ti", "தி"),
    ("tI", "தீ"),
    ("T\\", "தூ"),
    ("T", "து"),

    ("et", "தெ"),
    ("Et", "தே"),
    ("At", "தை"),
    ("tf", "த்"),
    ("t", "த"),

    ("enq", "நௌ"),
    ("Ena", "நோ"),
    ("ena", "நொ"),
    ("na", "நா"),
    ("ni", "நி"),
    ("nI", "நீ"),
    ("N\\", "நூ"),
    ("N", "நு"),

    ("en", "நெ"),
    ("En", "நே"),
    ("An", "நை"),
    ("nf", "ந்"),
    ("n", "ந"),

    ("e\[q", "னௌ"),
    ("E\[a", "னோ"),
    ("e\[a", "னொ"),

    ("\[a", "னா"),
    ("\[i", "னி"),
    ("\[I", "னீ"),

    ("\{\\", "னூ"),
    ("\{", "னு"),

    ("e\[", "னெ"),
    ("E\[", "னே"),
    ("A\[", "னை"),
    ("\[f", "ன்"),
    ("\[", "ன"),

    ("epq", "பௌ"),
    ("Epa", "போ"),
    ("epa", "பொ"),
    ("pa", "பா"),
    ("pi", "பி"),
    ("pI", "பீ"),
    ("p<", "பு"),
    ("p>", "பூ"),
    ("ep", "பெ"),
    ("Ep", "பே"),
    ("Ap", "பை"),
    ("pf", "ப்"),
    ("p", "ப"),

    ("emq", "மௌ"),
    ("Ema", "மோ"),
    ("ema", "மொ"),
    ("ma", "மா"),
    ("mi", "மி"),
    ("mI", "மீ"),
    ("YM", "மூ"),
    ("M", "மு"),

    ("em", "மெ"),
    ("Em", "மே"),
    ("Am", "மை"),
    ("mf", "ம்"),
    ("m", "ம"),

    ("eyq", "யௌ"),
    ("Eya", "யோ"),
    ("eya", "யொ"),
    ("ya", "யா"),
    ("yi", "யி"),
    ("yI", "யீ"),
    ("y<", "யு"),
    ("y>", "யூ"),
    ("ey", "யெ"),
    ("Ey", "யே"),
    ("Ay", "யை"),
    ("yf", "ய்"),
    ("y", "ய"),

    ("erq", "ரௌ"),
    ("Era", "ரோ"),
    ("era", "ரொ"),
    ("ra", "ரா"),
    ("ri", "ரி"),
    ("rI", "ரீ"),
    ("YR", "ரூ"),
    ("R", "ரு"),

    ("er", "ரெ"),
    ("Er", "ரே"),
    ("Ar", "ரை"),
    ("rf", "ர்"),

    ("r", "ர"),

    ("elq", "லௌ"),
    ("Ela", "லோ"),
    ("ela", "லொ"),
    ("la", "லா"),
    ("li", "லி"),
    ("lI", "லீ"),
    ("L>", "லூ"),
    ("L", "லு"),

    ("el", "லெ"),
    ("El", "லே"),
    ("Al", "லை"),
    ("lf", "ல்"),
    ("l", "ல"),

    ("eqq", "ளௌ"),
    ("Eqa", "ளோ"),
    ("eqa", "ளொ"),
    ("qa", "ளா"),
    ("F", "ளி"),
    ("G", "ளீ"),
    ("YQ", "ளூ"),
    ("Q", "ளு"),

    ("eq", "ளெ"),
    ("Eq", "ளே"),
    ("Aq", "ளை"),
    ("qf", "ள்"),
    ("q", "ள"),

    ("evq", "வௌ"),
    ("Eva", "வோ"),
    ("eva", "வொ"),
    ("va", "வா"),
    ("vi", "வி"),
    ("vI", "வீ"),
    ("v<", "வு"),
    ("v>", "வூ"),
    ("ev", "வெ"),
    ("Ev", "வே"),
    ("Av", "வை"),
    ("vf", "வ்"),
    ("v", "வ"),

    ("ezq", "ழௌ"),
    ("Eza", "ழோ"),
    ("eza", "ழொ"),
    ("za", "ழா"),
    ("zi", "ழி"),
    ("zI", "ழீ"),
    ("YZ", "ழூ"),
    ("Z", "ழு"),

    ("ez", "ழெ"),
    ("Ez", "ழே"),
    ("Az", "ழை"),
    ("zf", "ழ்"),
    ("z", "ழ"),
    ("ebq", "றௌ"),
    ("Eba", "றோ"),
    ("eba", "றொ"),
    ("ba", "றா"),
    ("bi", "றி"),
    ("bI", "றீ"),
    ("b>", "றூ"),
    ("B", "று"),

    ("eb", "றெ"),
    ("Eb", "றே"),
    ("Ab", "றை"),
    ("bf", "ற்"),
    ("b", "ற"),

    ("ehq", "ஹௌ"),
    ("Eha", "ஹோ"),
    ("eha", "ஹொ"),
    ("ha", "ஹா"),
    ("hi", "ஹி"),
    ("hI", "ஹீ"),
    ("h", "ஹு"),
    ("h>", "ஹூ"),
    ("eh", "ஹெ"),
    ("Eh", "ஹே"),
    ("Ah", "ஹை"),
    ("hf", "ஹ்"),
    ("h", "ஹ"),
    ("exq", "ஷௌ"),
    ("Exa", "ஷோ"),
    ("exa", "ஷொ"),
    ("xa", "ஷா"),
    ("xi", "ஷி"),
    ("xI", "ஷீ"),
    ("ex", "ஷெ"),
    ("Ex", "ஷே"),
    ("Ax", "ஷை"),
    ("xf", "ஷ்"),
    ("x", "ஷ"),

    ("esq", "ஸௌ"),
    ("Esa", "ஸோ"),
    ("esa", "ஸொ"),
    ("sa", "ஸா"),
    ("si", "ஸி"),
    ("sI", "ஸீ"),
    ("es", "ஸெ"),
    ("Es", "ஸே"),
    ("As", "ஸை"),
    ("sf", "ஸ்"),
    ("s", "ஸ"),
    ("`", "அ"),
    ("~", "ஆ"),
    (";", "இ"),
    (":", "ஈ"),
    ("u", "உ"),
    ("U", "ஊ"),
    ("\'", "எ"),
    ("\"", "ஏ"),
    ("_", "ஐ"),
    ("o", "ஒ"),
    ("O", "ஓ"),
    ("oq", "ஔ"),

    ("!", "ஸ்ரீ"),
    ("#", "ஃ"),

    ])
# end of mylai2utf8 dictionary 


    
# begin of nakkeeran2utf8 dictionary 
nakkeeran2utf8 = OrderedDict([

    ("b", "க்ஷ"),
    ("bô", "க்ஷா"),
    ("·", "க்ஷி"),
    ("Î", "க்ஷீ"),
    ("bý", "க்ஷு"),
    ("bþ", "க்ஷூ"),
    ("ùb", "க்ஷெ"),
    ("úb", "க்ஷே"),
    ("ùbô", "க்ஷொ"),
    ("úbô", "க்ஷோ"),
    ("ùb\[", "க்ஷௌ"),
    ("ûb", "க்ஷை"),
    ("z", "க்ஷ்"),

    ("ù_\[", "ஜௌ"),
    ("ú_ô", "ஜோ"),
    ("ù_ô", "ஜொ"),
    ("_ô", "ஜா"),
    ("´", "ஜி"),
    ("Ë", "ஜீ"),
    ("_ý", "ஜு"),
    ("_þ", "ஜூ"),
    ("ù_", "ஜெ"),
    ("ú_", "ஜே"),
    ("û_", "ஜை"),
    ("w", "ஜ்"),
    ("_", "ஜ"),


    ("ùL\[", "கௌ"),
    ("úLô", "கோ"),
    ("ùLô", "கொ"),
    ("Lô", "கா"),
    ("¡", "கி"),
    ("¸", "கீ"),
    ("Ï", "கு"),
    ("á", "கூ"),
    ("ùL", "கெ"),
    ("úL", "கே"),
    ("ûL", "கை"),
    ("d", "க்"),
    ("L", "க"),

    ("ùM\[", "ஙௌ"),
    ("úMô", "ஙோ"),
    ("ùMô", "ஙொ"),
    ("Mô", "ஙா"),
    ("¢", "ஙி"),
    ("¹", "ஙீ"),
    ("Ð", "ஙு"),
    ("â", "ஙூ"),
    ("ùM", "ஙெ"),
    ("úM", "ஙே"),
    ("ûM", "ஙை"),
    ("e", "ங்"),
    ("M", "ங"),

    ("ùN\[", "சௌ"),
    ("úNô", "சோ"),
    ("ùNô", "சொ"),
    ("Nô", "சா"),
    ("£", "சி"),
    ("º", "சீ"),
    ("Ñ", "சு"),
    ("ã", "சூ"),
    ("ùN", "செ"),
    ("úN", "சே"),
    ("ûN", "சை"),
    ("f", "ச்"),
    ("N", "ச"),

    ("ùO\[", "ஞௌ"),
    ("úOô", "ஞோ"),
    ("ùOô", "ஞொ"),
    ("Oô", "ஞா"),
    ("¤", "ஞி"),
    ("»", "ஞீ"),
    ("Ò", "ஞு"),
    ("ä", "ஞூ"),
    ("ùO", "ஞெ"),
    ("úO", "ஞே"),
    ("ûO", "ஞை"),
    ("g", "ஞ்"),
    ("O", "ஞ"),

    ("ùP\[", "டௌ"),
    ("úPô", "டோ"),
    ("ùPô", "டொ"),
    ("Pô", "டா"),
    ("¥", "டி"),
    ("¼", "டீ"),
    ("Ó", "டு"),
    ("å", "டூ"),
    ("ùP", "டெ"),
    ("úP", "டே"),
    ("ûP", "டை"),
    ("h", "ட்"),
    ("P", "ட"),

    ("ùQ\[", "ணௌ"),
    ("úQô", "ணோ"),
    ("ùQô", "ணொ"),
    ("Qô", "ணா"),
    ("¦", "ணி"),
    ("½", "ணீ"),
    ("Ô", "ணு"),
    ("æ", "ணூ"),
    ("ùQ", "ணெ"),
    ("úQ", "ணே"),
    ("ûQ", "ணை"),
    ("i", "ண்"),
    ("Q", "ண"),

    ("ùR\[", "தௌ"),
    ("úRô", "தோ"),
    ("ùRô", "தொ"),
    ("Rô", "தா"),
    ("§", "தி"),
    ("¾", "தீ"),
    ("Õ", "து"),
    ("ç", "தூ"),
    ("ùR", "தெ"),
    ("úR", "தே"),
    ("ûR", "தை"),
    ("j", "த்"),
    ("R", "த"),

    ("ùS\[", "நௌ"),
    ("úSô", "நோ"),
    ("ùSô", "நொ"),
    ("Sô", "நா"),
    ("¨", "நி"),
    ("¿", "நீ"),
    ("Ö", "நு"),
    ("è", "நூ"),
    ("ùS", "நெ"),
    ("úS", "நே"),
    ("ûS", "நை"),
    ("k", "ந்"),
    ("S", "ந"),

    ("ù]\[", "னௌ"),
    ("ú]ô", "னோ"),
    ("ù]ô", "னொ"),
    ("]ô", "னா"),
    ("²", "னி"),
    ("É", "னீ"),
    ("à", "னு"),
    ("ò", "னூ"),
    ("ù]", "னெ"),
    ("ú]", "னே"),
    ("û]", "னை"),
    ("u", "ன்"),
    ("]", "ன"),

    ("ùT\[", "பௌ"),
    ("úTô", "போ"),
    ("ùTô", "பொ"),
    ("Tô", "பா"),
    ("©", "பி"),
    ("À", "பீ"),
    ("×", "பு"),
    ("é", "பூ"),
    ("ùT", "பெ"),
    ("úT", "பே"),
    ("ûT", "பை"),
    ("l", "ப்"),
    ("T", "ப"),

    ("ùU\[", "மௌ"),
    ("úUô", "மோ"),
    ("ùUô", "மொ"),
    ("Uô", "மா"),
    ("ª", "மி"),
    ("Á", "மீ"),
    ("Ø", "மு"),
    ("ê", "மூ"),
    ("ùU", "மெ"),
    ("úU", "மே"),
    ("ûU", "மை"),
    ("m", "ம்"),
    ("U", "ம"),

    ("ùV\[", "யௌ"),
    ("úVô", "யோ"),
    ("ùVô", "யொ"),
    ("Vô", "யா"),
    ("«", "யி"),
    ("Â", "யீ"),
    ("Ù", "யு"),
    ("ë", "யூ"),
    ("ùV", "யெ"),
    ("úV", "யே"),
    ("ûV", "யை"),
    ("n", "ய்"),
    ("V", "ய"),

    ("ùW\[", "ரௌ"),
    ("úWô", "ரோ"),
    ("ùWô", "ரொ"),
    ("Wô", "ரா"),
    ("¬", "ரி"),
    ("Ã", "ரீ"),
    ("Ú", "ரு"),
    ("ì", "ரூ"),
    ("ùW", "ரெ"),
    ("úW", "ரே"),
    ("ûW", "ரை"),
    ("o", "ர்"),
    ("W", "ர"),

    ("ùX\[", "லௌ"),
    ("úXô", "லோ"),
    ("ùXô", "லொ"),
    ("Xô", "லா"),
    ("­", "லி"),

    ("Ä", "லீ"),
    ("Û", "லு"),
    ("í", "லூ"),
    ("ùX", "லெ"),
    ("úX", "லே"),
    ("ûX", "லை"),
    ("p", "ல்"),
    ("X", "ல"),

    ("ù\[\[", "ளௌ"),
    ("ú\[ô", "ளோ"),
    ("ù\[ô", "ளொ"),
    ("\[ô", "ளா"),
    ("ü", "ளி"),

    ("°", "ளி"),
    ("Ç", "ளீ"),
    ("Þ", "ளு"),
    ("ð", "ளூ"),
    ("ù\[", "ளெ"),
    ("ú\[", "ளே"),
    ("û\[", "ளை"),
    ("s", "ள்"),
    ("\[", "ள"),

    ("ùY\[", "வௌ"),
    ("úYô", "வோ"),
    ("ùYô", "வொ"),
    ("Yô", "வா"),
    ("®", "வி"),
    ("Å", "வீ"),
    ("Ü", "வு"),
    ("î", "வூ"),
    ("ùY", "வெ"),
    ("úY", "வே"),
    ("ûY", "வை"),
    ("q", "வ்"),
    ("Y", "வ"),

    ("ùZ\[", "ழௌ"),
    ("úZô", "ழோ"),
    ("ùZô", "ழொ"),
    ("Zô", "ழா"),
    ("¯", "ழி"),
    ("Æ", "ழீ"),
    ("Ý", "ழு"),
    ("ï", "ழூ"),
    ("ùZ", "ழெ"),
    ("úZ", "ழே"),
    ("ûZ", "ழை"),
    ("r", "ழ்"),
    ("Z", "ழ"),

    ("ù\\\[", "றௌ"),
    ("ú\\ô", "றோ"),
    ("ù\\ô", "றொ"),
    ("\\ô", "றா"),
    ("±", "றி"),
    ("È", "றீ"),
    ("ß", "று"),
    ("ñ", "றூ"),
    ("ù\\", "றெ"),
    ("ú\\", "றே"),
    ("û\\", "றை"),
    ("t", "ற்"),
    ("\\", "ற"),
    ("ù^\[", "ஸௌ"),
    ("ú^ô", "ஸோ"),
    ("ù^ô", "ஸொ"),
    ("^ô", "ஸா"),
    ("³", "ஸி"),
    ("Ê", "ஸீ"),
    ("^ý", "ஸு"),
    ("^þ", "ஸூ"),
    ("ù^", "ஸெ"),
    ("ú^", "ஸே"),
    ("û^", "ஸை"),
    ("v", "ஸ்"),
    ("\^", "ஸ"),

    ("@", "அ"),
    ("A", "ஆ"),
    ("B", "இ"),
    ("C", "ஈ"),
    ("D", "உ"),
    ("E", "ஊ"),
    ("F", "எ"),
    ("G", "ஏ"),
    ("H", "ஐ"),
    ("I", "ஒ"),
    ("J", "ஓ"),
    ("I\[", "ஔ"),

    ("K", "ஃ"),

    ("c", "ஸ்ரீ"),

    ("ùa\[", "ஹௌ"),
    ("úaô", "ஹோ"),
    ("ùaô", "ஹொ"),
    ("aô", "ஹா"),
    ("¶", "ஹி"),
    ("Í", "ஹீ"),
    ("aý", "ஹு"),
    ("aþ", "ஹூ"),
    ("ùa", "ஹெ"),
    ("úa", "ஹே"),
    ("ûa", "ஹை"),
    ("y", "ஹ்"),
    ("a", "ஹ"),

    ("ù`\[", "ஷௌ"),
    ("ú`ô", "ஷோ"),
    ("ù`ô", "ஷொ"),
    ("`ô", "ஷா"),
    ("µ", "ஷி"),
    ("Ì", "ஷீ"),
    ("`ý", "ஷு"),
    ("`þ", "ஷூ"),
    ("ù`", "ஷெ"),
    ("ú`", "ஷே"),
    ("û`", "ஷை"),
    ("x", "ஷ்"),
    ("`", "ஷ"),

    ])
# end of nakkeeran2utf8 dictionary 



# begin of roman2utf8 dictionary 
roman2utf8 = OrderedDict([

    ("Xau", "க்ஷௌ"),
    ("Xai", "க்ஷை"),
    ("Xaa", "க்ஷா"),
    ("XA", "க்ஷா"),
    ("Xa", "க்ஷ"),
    ("Xii", "க்ஷீ"),
    ("Xi", "க்ஷி"),
    ("XI", "க்ஷீ"),

    ("Xuu", "க்ஷூ"),
    ("Xu", "க்ஷு"),
    ("XU", "க்ஷூ"),
    ("Xee", "க்ஷே"),
    ("Xe", "க்ஷெ"),
    ("XE", "க்ஷே"),
    ("Xoo", "க்ஷோ"),
    ("Xo", "க்ஷொ"),
    ("XO", "க்ஷோ"),

    ("X", "க்ஷ்"),

    ("njau", "ஞௌ"),
    ("njai", "ஞை"),
    ("njee", "ஞே"),
    ("njoo", "ஞோ"),
    ("njaa", "ஞா"),
    ("njuu", "ஞூ"),
    ("njii", "ஞீ"),
    ("nja", "ஞ"),
    ("nji", "ஞி"),
    ("njI", "ஞீ"),
    ("njA", "ஞா"),
    ("nje", "ஞெ"),
    ("njE", "ஞே"),
    ("njo", "ஞொ"),
    ("njO", "ஞோ"),
    ("nju", "ஞு"),
    ("njU", "ஞூ"),

    ("nj", "ஞ்"),

    ("ngau", "ஙௌ"),
    ("ngai", "ஙை"),
    ("ngee", "ஙே"),
    ("ngoo", "ஙோ"),
    ("ngaa", "ஙா"),
    ("nguu", "ஙூ"),
    ("ngii", "ஙீ"),
    ("nga", "ங"),
    ("ngi", "ஙி"),
    ("ngI", "ஙீ"),
    ("ngA", "ஙா"),
    ("nge", "ஙெ"),
    ("ngE", "ஙே"),
    ("ngo", "ஙொ"),
    ("ngO", "ஙோ"),
    ("ngu", "ஙு"),
    ("ngU", "ஙூ"),

    ("ng", "ங்"),

    ("shau", "ஷௌ"),
    ("shai", "ஷை"),
    ("shee", "ஷே"),
    ("shoo", "ஷோ"),
    ("shaa", "ஷா"),
    ("shuu", "ஷூ"),
    ("shii", "ஷீ"),
    ("sha", "ஷ"),
    ("shi", "ஷி"),
    ("shI", "ஷீ"),
    ("shA", "ஷா"),
    ("she", "ஷெ"),
    ("shE", "ஷே"),
    ("sho", "ஷொ"),
    ("shO", "ஷோ"),
    ("shu", "ஷு"),
    ("shU", "ஷூ"),

    ("sh", "ஷ்"),

    (" nau", " நௌ"),
    (" nai", " நை"),
    (" nee", " நே"),
    (" noo", " நோ"),
    (" naa", " நா"),
    (" nuu", " நூ"),
    (" nii", " நீ"),
    (" na", " ந"),
    (" ni", " நி"),
    (" nI", " நீ"),
    (" nA", " நா"),
    (" ne", " நெ"),
    (" nE", " நே"),
    (" no", " நொ"),
    (" nO", " நோ"),
    (" nu", " நு"),
    (" nU", " நூ"),

    (" nth", " ந்"),

    ("-nau", "நௌ"),
    ("-nai", "நை"),
    ("-nee", "நே"),
    ("-noo", "நோ"),
    ("-naa", "நா"),
    ("-nuu", "நூ"),
    ("-nii", "நீ"),
    ("-na", "ந"),
    ("-ni", "நி"),
    ("-nI", "நீ"),
    ("-nA", "நா"),
    ("-ne", "நெ"),
    ("-nE", "நே"),
    ("-no", "நொ"),
    ("-nO", "நோ"),
    ("-nu", "நு"),
    ("-nU", "நூ"),

    ("n-au", "நௌ"),
    ("n-ai", "நை"),
    ("n-ee", "நே"),
    ("n-oo", "நோ"),
    ("n-aa", "நா"),
    ("n-uu", "நூ"),
    ("n-ii", "நீ"),
    ("n-a", "ந"),
    ("n-i", "நி"),
    ("n-I", "நீ"),
    ("n-A", "நா"),
    ("n-e", "நெ"),
    ("n-E", "நே"),
    ("n-o", "நொ"),
    ("n-O", "நோ"),
    ("n-u", "நு"),
    ("n-U", "நூ"),

    ("wau", "நௌ"),
    ("wai", "நை"),
    ("wee", "நே"),
    ("woo", "நோ"),
    ("waa", "நா"),
    ("wuu", "நூ"),
    ("wii", "நீ"),
    ("wa", "ந"),
    ("wi", "நி"),
    ("wI", "நீ"),
    ("wA", "நா"),
    ("we", "நெ"),
    ("wE", "நே"),
    ("wo", "நொ"),
    ("wO", "நோ"),
    ("wu", "நு"),
    ("wU", "நூ"),

    (" n", " ந்"),
    ("n-", "ந்"),
    ("-n", "ந்"),
    ("w", "ந்"),

    ("nthau", "ந்தௌ"),
    ("nthai", "ந்தை"),
    ("nthee", "ந்தே"),
    ("nthoo", "ந்தோ"),
    ("nthaa", "ந்தா"),
    ("nthuu", "ந்தூ"),
    ("nthii", "ந்தீ"),
    ("ntha", "ந்த"),
    ("nthi", "ந்தி"),
    ("nthI", "ந்தீ"),
    ("nthA", "ந்தா"),
    ("nthe", "ந்தெ"),
    ("nthE", "ந்தே"),
    ("ntho", "ந்தொ"),
    ("nthO", "ந்தோ"),
    ("nthu", "ந்து"),
    ("nthU", "ந்தூ"),
    ("nth", "ந்"),

    ("dhau", "தௌ"),
    ("dhai", "தை"),
    ("dhee", "தே"),
    ("dhoo", "தோ"),
    ("dhaa", "தா"),
    ("dhuu", "தூ"),
    ("dhii", "தீ"),
    ("dha", "த"),
    ("dhi", "தி"),
    ("dhI", "தீ"),
    ("dhA", "தா"),
    ("dhe", "தெ"),
    ("dhE", "தே"),
    ("dho", "தொ"),
    ("dhO", "தோ"),
    ("dhu", "து"),
    ("dhU", "தூ"),

    ("dh", "த்"),

    ("chau", "சௌ"),
    ("chai", "சை"),
    ("chee", "சே"),
    ("choo", "சோ"),
    ("chaa", "சா"),
    ("chuu", "சூ"),
    ("chii", "சீ"),
    ("cha", "ச"),
    ("chi", "சி"),
    ("chI", "சீ"),
    ("chA", "சா"),
    ("che", "செ"),
    ("chE", "சே"),
    ("cho", "சொ"),
    ("chO", "சோ"),
    ("chu", "சு"),
    ("chU", "சூ"),

    ("ch", "ச்"),

    ("zhau", "ழௌ"),
    ("zhai", "ழை"),
    ("zhee", "ழே"),
    ("zhoo", "ழோ"),
    ("zhaa", "ழா"),
    ("zhuu", "ழூ"),
    ("zhii", "ழீ"),
    ("zha", "ழ"),
    ("zhi", "ழி"),
    ("zhI", "ழீ"),
    ("zhA", "ழா"),
    ("zhe", "ழெ"),
    ("zhE", "ழே"),
    ("zho", "ழொ"),
    ("zhO", "ழோ"),
    ("zhu", "ழு"),
    ("zhU", "ழூ"),

    ("zh", "ழ்"),
    ("zau", "ழௌ"),
    ("zai", "ழை"),
    ("zee", "ழே"),
    ("zoo", "ழோ"),
    ("zaa", "ழா"),
    ("zuu", "ழூ"),
    ("zii", "ழீ"),
    ("za", "ழ"),
    ("zi", "ழி"),
    ("zI", "ழீ"),
    ("zA", "ழா"),
    ("ze", "ழெ"),
    ("zE", "ழே"),
    ("zo", "ழொ"),
    ("zO", "ழோ"),
    ("zu", "ழு"),
    ("zU", "ழூ"),

    ("z", "ழ்"),

    ("jau", "ஜௌ"),
    ("jai", "ஜை"),
    ("jee", "ஜே"),
    ("joo", "ஜோ"),
    ("jaa", "ஜா"),
    ("juu", "ஜூ"),
    ("jii", "ஜீ"),
    ("ja", "ஜ"),
    ("ji", "ஜி"),
    ("jI", "ஜீ"),
    ("jA", "ஜா"),
    ("je", "ஜெ"),
    ("jE", "ஜே"),
    ("jo", "ஜொ"),
    ("jO", "ஜோ"),
    ("ju", "ஜு"),
    ("jU", "ஜூ"),

    ("j", "ஜ்"),

    ("thau", "தௌ"),
    ("thai", "தை"),
    ("thee", "தே"),
    ("thoo", "தோ"),
    ("thaa", "தா"),
    ("thuu", "தூ"),
    ("thii", "தீ"),
    ("tha", "த"),
    ("thi", "தி"),
    ("thI", "தீ"),
    ("thA", "தா"),
    ("the", "தெ"),
    ("thE", "தே"),
    ("tho", "தொ"),
    ("thO", "தோ"),
    ("thu", "து"),
    ("thU", "தூ"),

    ("th", "த்"),

    ("-hau", "ஹௌ"),
    ("-hai", "ஹை"),
    ("-hee", "ஹே"),
    ("-hoo", "ஹோ"),
    ("-haa", "ஹா"),
    ("-huu", "ஹூ"),
    ("-hii", "ஹீ"),
    ("-ha", "ஹ"),
    ("-hi", "ஹி"),
    ("-hI", "ஹீ"),
    ("-hA", "ஹா"),
    ("-he", "ஹெ"),
    ("-hE", "ஹே"),
    ("-ho", "ஹொ"),
    ("-hO", "ஹோ"),
    ("-hu", "ஹு"),
    ("-hU", "ஹூ"),

    ("-h", "ஹ்"),

    ("hau", "கௌ"),
    ("hai", "கை"),
    ("hee", "கே"),
    ("hoo", "கோ"),
    ("haa", "கா"),
    ("huu", "கூ"),
    ("hii", "கீ"),
    ("ha", "க"),
    ("hi", "கி"),
    ("hI", "கீ"),
    ("hA", "கா"),
    ("he", "கெ"),
    ("hE", "கே"),
    ("ho", "கொ"),
    ("hO", "கோ"),
    ("hu", "கு"),
    ("hU", "கூ"),

    ("h", "க்"),

    ("kau", "கௌ"),
    ("kai", "கை"),
    ("kee", "கே"),
    ("koo", "கோ"),
    ("kaa", "கா"),
    ("kuu", "கூ"),
    ("kii", "கீ"),
    ("ka", "க"),
    ("ki", "கி"),
    ("kI", "கீ"),
    ("kA", "கா"),
    ("ke", "கெ"),
    ("kE", "கே"),
    ("ko", "கொ"),
    ("kO", "கோ"),
    ("ku", "கு"),
    ("kU", "கூ"),

    ("k", "க்"),

    ("-sau", "ஸௌ"),
    ("-sai", "ஸை"),
    ("-see", "ஸே"),
    ("-soo", "ஸோ"),
    ("-saa", "ஸா"),
    ("-suu", "ஸூ"),
    ("-sii", "ஸீ"),
    ("-sa", "ஸ"),
    ("-si", "ஸி"),
    ("-sI", "ஸீ"),
    ("-sA", "ஸா"),
    ("-se", "ஸெ"),
    ("-sE", "ஸே"),
    ("-so", "ஸொ"),
    ("-sO", "ஸோ"),
    ("-su", "ஸு"),
    ("-sU", "ஸூ"),

    ("-s", "ஸ்"),

    ("Sau", "ஸௌ"),
    ("Sai", "ஸை"),
    ("See", "ஸே"),
    ("Soo", "ஸோ"),
    ("Saa", "ஸா"),
    ("Suu", "ஸூ"),
    ("Sii", "ஸீ"),
    ("Sa", "ஸ"),
    ("Si", "ஸி"),
    ("SI", "ஸீ"),
    ("SA", "ஸா"),
    ("Se", "ஸெ"),
    ("SE", "ஸே"),
    ("So", "ஸொ"),
    ("SO", "ஸோ"),
    ("Su", "ஸு"),
    ("SU", "ஸூ"),

    ("S", "ஸ்"),

    ("rau", "ரௌ"),
    ("rai", "ரை"),
    ("ree", "ரே"),
    ("roo", "ரோ"),
    ("raa", "ரா"),
    ("ruu", "ரூ"),
    ("rii", "ரீ"),
    ("ra", "ர"),
    ("ri", "ரி"),
    ("rI", "ரீ"),
    ("rA", "ரா"),
    ("re", "ரெ"),
    ("rE", "ரே"),
    ("ro", "ரொ"),
    ("rO", "ரோ"),
    ("ru", "ரு"),
    ("rU", "ரூ"),

    ("r", "ர்"),

    ("Rau", "றௌ"),
    ("Rai", "றை"),
    ("Ree", "றே"),
    ("Roo", "றோ"),
    ("Raa", "றா"),
    ("Ruu", "றூ"),
    ("Rii", "றீ"),
    ("Ra", "ற"),
    ("Ri", "றி"),
    ("RI", "றீ"),
    ("RA", "றா"),
    ("Re", "றெ"),
    ("RE", "றே"),
    ("Ro", "றொ"),
    ("RO", "றோ"),
    ("Ru", "று"),
    ("RU", "றூ"),

    ("R", "ற்"),

    ("tau", "டௌ"),
    ("tai", "டை"),
    ("tee", "டே"),
    ("too", "டோ"),
    ("taa", "டா"),
    ("tuu", "டூ"),
    ("tii", "டீ"),
    ("ta", "ட"),
    ("ti", "டி"),
    ("tI", "டீ"),
    ("tA", "டா"),
    ("te", "டெ"),
    ("tE", "டே"),
    ("to", "டொ"),
    ("tO", "டோ"),
    ("tu", "டு"),
    ("tU", "டூ"),

    ("t", "ட்"),

    ("sau", "சௌ"),
    ("sai", "சை"),
    ("see", "சே"),
    ("soo", "சோ"),
    ("saa", "சா"),
    ("suu", "சூ"),
    ("sii", "சீ"),
    ("sa", "ச"),
    ("si", "சி"),
    ("sI", "சீ"),
    ("sA", "சா"),
    ("se", "செ"),
    ("sE", "சே"),
    ("so", "சொ"),
    ("sO", "சோ"),
    ("su", "சு"),
    ("sU", "சூ"),

    ("s", "ச்"),
    ("pau", "பௌ"),
    ("pai", "பை"),
    ("pee", "பே"),
    ("poo", "போ"),
    ("paa", "பா"),
    ("puu", "பூ"),
    ("pii", "பீ"),
    ("pa", "ப"),
    ("pi", "பி"),
    ("pI", "பீ"),
    ("pA", "பா"),
    ("pe", "பெ"),
    ("pE", "பே"),
    ("po", "பொ"),
    ("pO", "போ"),
    ("pu", "பு"),
    ("pU", "பூ"),

    ("p", "ப்"),

    ("bau", "பௌ"),
    ("bai", "பை"),
    ("bee", "பே"),
    ("boo", "போ"),
    ("baa", "பா"),
    ("buu", "பூ"),
    ("bii", "பீ"),
    ("ba", "ப"),
    ("bi", "பி"),
    ("bI", "பீ"),
    ("bA", "பா"),
    ("be", "பெ"),
    ("bE", "பே"),
    ("bo", "பொ"),
    ("bO", "போ"),
    ("bu", "பு"),
    ("bU", "பூ"),

    ("b", "ப்"),
    ("mau", "மௌ"),
    ("mai", "மை"),
    ("mee", "மே"),
    ("moo", "மோ"),
    ("maa", "மா"),
    ("muu", "மூ"),
    ("mii", "மீ"),
    ("ma", "ம"),
    ("mi", "மி"),
    ("mI", "மீ"),
    ("mA", "மா"),
    ("me", "மெ"),
    ("mE", "மே"),
    ("mo", "மொ"),
    ("mO", "மோ"),
    ("mu", "மு"),
    ("mU", "மூ"),

    ("m", "ம்"),

    ("yau", "யௌ"),
    ("yai", "யை"),
    ("yee", "யே"),
    ("yoo", "யோ"),
    ("yaa", "யா"),
    ("yuu", "யூ"),
    ("yii", "யீ"),
    ("ya", "ய"),
    ("yi", "யி"),
    ("yI", "யீ"),
    ("yA", "யா"),
    ("ye", "யெ"),
    ("yE", "யே"),
    ("yo", "யொ"),
    ("yO", "யோ"),
    ("yu", "யு"),
    ("yU", "யூ"),

    ("y", "ய்"),

    ("dau", "டௌ"),
    ("dai", "டை"),
    ("dee", "டே"),
    ("doo", "டோ"),
    ("daa", "டா"),
    ("duu", "டூ"),
    ("dii", "டீ"),
    ("da", "ட"),
    ("di", "டி"),
    ("dI", "டீ"),
    ("dA", "டா"),
    ("de", "டெ"),
    ("dE", "டே"),
    ("do", "டொ"),
    ("dO", "டோ"),
    ("du", "டு"),
    ("dU", "டூ"),

    ("d", "ட்"),

    ("nau", "னௌ"),
    ("nai", "னை"),
    ("nee", "னே"),
    ("noo", "னோ"),
    ("naa", "னா"),
    ("nuu", "னூ"),
    ("nii", "னீ"),
    ("na", "ன"),
    ("ni", "னி"),
    ("nI", "னீ"),
    ("nA", "னா"),
    ("ne", "னெ"),
    ("nE", "னே"),
    ("no", "னொ"),
    ("nO", "னோ"),
    ("nu", "னு"),
    ("nU", "னூ"),

    ("n", "ன்"),

    ("Nau", "ணௌ"),
    ("Nai", "ணை"),
    ("Nee", "ணே"),
    ("Noo", "ணோ"),
    ("Naa", "ணா"),
    ("Nuu", "ணூ"),
    ("Nii", "ணீ"),
    ("Na", "ண"),
    ("Ni", "ணி"),
    ("NI", "ணீ"),
    ("NA", "ணா"),
    ("Ne", "ணெ"),
    ("NE", "ணே"),
    ("No", "ணொ"),
    ("NO", "ணோ"),
    ("Nu", "ணு"),
    ("NU", "ணூ"),

    ("N", "ண்"),
    ("lau", "லௌ"),
    ("lai", "லை"),
    ("lee", "லே"),
    ("loo", "லோ"),
    ("laa", "லா"),
    ("luu", "லூ"),
    ("lii", "லீ"),
    ("la", "ல"),
    ("li", "லி"),
    ("lI", "லீ"),
    ("lA", "லா"),
    ("le", "லெ"),
    ("lE", "லே"),
    ("lo", "லொ"),
    ("lO", "லோ"),
    ("lu", "லு"),
    ("lU", "லூ"),

    ("l", "ல்"),
    ("Lau", "ளௌ"),
    ("Lai", "ளை"),
    ("Lee", "ளே"),
    ("Loo", "ளோ"),
    ("Laa", "ளா"),
    ("Luu", "ளூ"),
    ("Lii", "ளீ"),
    ("La", "ள"),
    ("Li", "ளி"),
    ("LI", "ளீ"),
    ("LA", "ளா"),
    ("Le", "ளெ"),
    ("LE", "ளே"),
    ("Lo", "ளொ"),
    ("LO", "ளோ"),
    ("Lu", "ளு"),
    ("LU", "ளூ"),

    ("L", "ள்"),

    ("vau", "வௌ"),
    ("vai", "வை"),
    ("vee", "வே"),
    ("voo", "வோ"),
    ("vaa", "வா"),
    ("vuu", "வூ"),
    ("vii", "வீ"),
    ("va", "வ"),
    ("vi", "வி"),
    ("vI", "வீ"),
    ("vA", "வா"),
    ("ve", "வெ"),
    ("vE", "வே"),
    ("vo", "வொ"),
    ("vO", "வோ"),
    ("vu", "வு"),
    ("vU", "வூ"),

    ("v", "வ்"),

    ("au", "கௌ"),
    ("ai", "கை"),
    ("ee", "கே"),
    ("oo", "கோ"),
    ("aa", "கா"),
    ("uu", "கூ"),
    ("ii", "கீ"),
    ("a", "க"),
    ("i", "கி"),
    ("I", "கீ"),
    ("A", "கா"),
    ("e", "கெ"),
    ("E", "கே"),
    ("o", "கொ"),
    ("O", "கோ"),
    ("u", "கு"),
    ("U", "கூ"),

    ("g", "க்"),

    ("au", "ஔ"),
    ("ai", "ஐ"),
    ("aa", "ஆ"),
    ("ee", "ஏ"),
    ("ii", "ஈ"),
    ("uu", "ஊ"),
    ("oo", "ஓ"),

    ("-1000", "௲"),

    ("-100", "௱"),

    ("-10", "௰"),
    ("-1", "௧"),

    ("-2", "௨"),
    ("-3", "௩"),

    ("-4", "௪"),
    ("-5", "௫"),

    ("-6", "௬"),
    ("-7", "௭"),

    ("-8", "௮"),
    ("-9", "௯"),

    ("i", "இ"),
    ("I", "ஈ"),

    ("a", "அ"),

    ("A", "ஆ"),

    ("e", "எ"),
    ("E", "ஏ"),
    ("i", "இ"),
    ("I", "ஈ"),
    ("u", "உ"),
    ("U", "ஊ"),
    ("o", "ஒ"),
    ("O", "ஓ"),

    ("q", "ஃ"),

    ])
# end of roman2utf8 dictionary 



# begin of tab2utf8 dictionary 
tab2utf8 = OrderedDict([

    ("þ", "க்ஷ"),
    ("þ£", "க்ஷா"),

    ("þ¤", "க்ஷி"),
    ("þ¦", "க்ஷீ"),
    ("þ§", "க்ஷு"),
    ("þ¨", "க்ஷூ"),
    ("ªþ", "க்ஷெ"),
    ("«þ", "க்ஷே"),
    ("ªþ£", "க்ஷொ"),
    ("«þ£", "க்ஷோ"),
    ("ªþ÷", "க்ஷௌ"),
    ("¬þ", "க்ஷை"),
    ("þ¢", "க்ஷ்"),

    ("ªè÷", "கௌ"),
    ("«è£", "கோ"),
    ("ªè£", "கொ"),
    ("è£", "கா"),
    ("è¤", "கி"),
    ("è¦", "கீ"),
    ("°", "கு"),
    ("Ã", "கூ"),
    ("ªè", "கெ"),
    ("«è", "கே"),
    ("¬è", "கை"),
    ("è¢", "க்"),
    ("è", "க"),

    ("ªé÷", "ஙௌ"),
    ("«é£", "ஙோ"),
    ("ªé£", "ஙொ"),
    ("é£", "ஙா"),
    ("é¤", "ஙி"),
    ("é¦", "ஙீ"),
    ("±", "ஙு"),
    ("Ä", "ஙூ"),
    ("ªé", "ஙெ"),
    ("«é", "ஙே"),
    ("¬é", "ஙை"),
    ("é¢", "ங்"),
    ("é", "ங"),

    ("ªê÷", "சௌ"),
    ("«ê£", "சோ"),
    ("ªê£", "சொ"),
    ("ê£", "சா"),
    ("ê¤", "சி"),
    ("ê¦", "சீ"),
    ("²", "சு"),
    ("Å", "சூ"),
    ("ªê", "செ"),
    ("«ê", "சே"),
    ("¬ê", "சை"),
    ("ê¢", "ச்"),
    ("ê", "ச"),

    ("ªü÷", "ஜௌ"),
    ("«ü£", "ஜோ"),
    ("ªü£", "ஜொ"),
    ("ü£", "ஜா"),
    ("ü¤", "ஜி"),
    ("ü¦", "ஜீ"),
    ("ü§", "ஜு"),
    ("ü¨", "ஜூ"),
    ("ªü", "ஜெ"),
    ("«ü", "ஜே"),
    ("¬ü", "ஜை"),
    ("ü¢", "ஜ்"),
    ("ü", "ஜ"),

    ("ªë÷", "ஞௌ"),
    ("«ë£", "ஞோ"),
    ("ªë£", "ஞொ"),
    ("ë£", "ஞா"),
    ("ë¤", "ஞி"),
    ("ë¦", "ஞீ"),
    ("³", "ஞு"),
    ("Æ", "ஞூ"),
    ("ªë", "ஞெ"),
    ("«ë", "ஞே"),
    ("¬ë", "ஞை"),
    ("ë¢", "ஞ்"),
    ("ë", "ஞ"),

    ("ªì÷", "டௌ"),
    ("«ì£", "டோ"),
    ("ªì£", "டொ"),
    ("ì£", "டா"),
    ("ì¤", "டி"),
    ("®", "டி"),
    ("¯", "டீ"),
    ("ì¦", "டீ"),
    ("´", "டு"),
    ("Ç", "டூ"),
    ("ªì", "டெ"),
    ("«ì", "டே"),
    ("¬ì", "டை"),
    ("ì¢", "ட்"),
    ("ì", "ட"),

    ("ªí÷", "ணௌ"),
    ("«í£", "ணோ"),
    ("ªí£", "ணொ"),
    ("í£", "ணா"),
    ("í¤", "ணி"),
    ("í¦", "ணீ"),
    ("µ", "ணு"),
    ("È", "ணூ"),
    ("ªí", "ணெ"),
    ("«í", "ணே"),
    ("¬í", "ணை"),
    ("í¢", "ண்"),
    ("í", "ண"),

    ("ªî÷", "தௌ"),
    ("«î£", "தோ"),
    ("ªî£", "தொ"),
    ("î£", "தா"),
    ("î¤", "தி"),
    ("î¦", "தீ"),
    ("¶", "து"),
    ("É", "தூ"),
    ("ªî", "தெ"),
    ("«î", "தே"),
    ("¬î", "தை"),
    ("î¢", "த்"),
    ("î", "த"),

    ("ªï÷", "நௌ"),
    ("«ï£", "நோ"),
    ("ªï£", "நொ"),
    ("ï£", "நா"),
    ("ï¤", "நி"),
    ("ï¦", "நீ"),
    ("¸", "நு"),
    ("Ë", "நூ"),
    ("ªï", "நெ"),
    ("«ï", "நே"),
    ("¬ï", "நை"),
    ("ï¢", "ந்"),
    ("ï", "ந"),

    ("ªù÷", "னௌ"),
    ("«ù£", "னோ"),
    ("ªù£", "னொ"),
    ("ù£", "னா"),
    ("ù¤", "னி"),
    ("ù¦", "னீ"),
    ("Â", "னு"),
    ("Û", "னூ"),
    ("ªù", "னெ"),
    ("«ù", "னே"),
    ("¬ù", "னை"),
    ("ù¢", "ன்"),
    ("ù", "ன"),

    ("ªð÷", "பௌ"),
    ("«ð£", "போ"),
    ("ªð£", "பொ"),
    ("ð£", "பா"),
    ("ð¤", "பி"),
    ("ð¦", "பீ"),
    ("¹", "பு"),
    ("Ì", "பூ"),
    ("ªð", "பெ"),
    ("«ð", "பே"),
    ("¬ð", "பை"),
    ("ð¢", "ப்"),
    ("ð", "ப"),

    ("ªñ÷", "மௌ"),
    ("«ñ£", "மோ"),
    ("ªñ£", "மொ"),
    ("ñ£", "மா"),
    ("ñ¤", "மி"),
    ("ñ¦", "மீ"),
    ("º", "மு"),
    ("Í", "மூ"),
    ("ªñ", "மெ"),
    ("«ñ", "மே"),
    ("¬ñ", "மை"),
    ("ñ¢", "ம்"),
    ("ñ", "ம"),

    ("ªò÷", "யௌ"),
    ("«ò£", "யோ"),
    ("ªò£", "யொ"),
    ("ò£", "யா"),
    ("ò¤", "யி"),
    ("ò¦", "யீ"),
    ("»", "யு"),
    ("Î", "யூ"),
    ("ªò", "யெ"),
    ("«ò", "யே"),
    ("¬ò", "யை"),
    ("ò¢", "ய்"),
    ("ò", "ய"),

    ("ªó÷", "ரௌ"),
    ("«ó£", "ரோ"),
    ("ªó£", "ரொ"),
    ("ó£", "ரா"),
    ("ó¤", "ரி"),
    ("ó¦", "ரீ"),
    ("¼", "ரு"),
    ("Ï", "ரூ"),
    ("ªó", "ரெ"),
    ("«ó", "ரே"),
    ("¬ó", "ரை"),
    ("ó¢", "ர்"),
    ("ó", "ர"),

    ("ªô÷", "லௌ"),
    ("«ô£", "லோ"),
    ("ªô£", "லொ"),
    ("ô£", "லா"),
    ("ô¤", "லி"),
    ("ô¦", "லீ"),
    ("½", "லு"),
    ("Ö", "லூ"),
    ("ªô", "லெ"),
    ("«ô", "லே"),
    ("¬ô", "லை"),
    ("ô¢", "ல்"),
    ("ô", "ல"),

    ("ª÷÷", "ளௌ"),
    ("«÷£", "ளோ"),
    ("ª÷£", "ளொ"),
    ("÷£", "ளா"),
    ("÷¤", "ளி"),
    ("÷¦", "ளீ"),
    ("À", "ளு"),
    ("Ù", "ளூ"),
    ("ª÷", "ளெ"),
    ("«÷", "ளே"),
    ("¬÷", "ளை"),
    ("÷¢", "ள்"),
    ("÷", "ள"),

    ("ªõ÷", "வௌ"),
    ("«õ£", "வோ"),
    ("ªõ£", "வொ"),
    ("õ£", "வா"),
    ("õ¤", "வி"),
    ("õ¦", "வீ"),
    ("¾", "வு"),
    ("×", "வூ"),
    ("ªõ", "வெ"),
    ("«õ", "வே"),
    ("¬õ", "வை"),
    ("õ¢", "வ்"),
    ("õ", "வ"),

    ("ªö÷", "ழௌ"),
    ("«ö£", "ழோ"),
    ("ªö£", "ழொ"),
    ("ö£", "ழா"),
    ("ö¤", "ழி"),
    ("ö¦", "ழீ"),
    ("¿", "ழு"),
    ("Ø", "ழூ"),
    ("ªö", "ழெ"),
    ("«ö", "ழே"),
    ("¬ö", "ழை"),
    ("ö¢", "ழ்"),
    ("ö", "ழ"),

    ("ªø÷", "றௌ"),
    ("«ø£", "றோ"),
    ("ªø£", "றொ"),
    ("ø£", "றா"),
    ("ø¤", "றி"),
    ("ø¦", "றீ"),
    ("Á", "று"),
    ("Ú", "றூ"),
    ("ªø", "றெ"),
    ("«ø", "றே"),
    ("¬ø", "றை"),
    ("ø¢", "ற்"),
    ("ø", "ற"),
    ("ªý÷", "ஹௌ"),
    ("«ý£", "ஹோ"),
    ("ªý£", "ஹொ"),
    ("ý£", "ஹா"),
    ("ý¤", "ஹி"),
    ("ý¦", "ஹீ"),

    ("ªý", "ஹெ"),
    ("«ý", "ஹே"),
    ("¬ý", "ஹை"),
    ("ý¢", "ஹ்"),
    ("ý", "ஹ"),

    ("ªû÷", "ஷௌ"),
    ("«û£", "ஷோ"),
    ("ªû£", "ஷொ"),
    ("û£", "ஷா"),
    ("û¤", "ஷி"),
    ("û¦", "ஷீ"),

    ("ªû", "ஷெ"),
    ("«û", "ஷே"),
    ("¬û", "ஷை"),
    ("û¢", "ஷ்"),
    ("û", "ஷ"),

    ("ªú÷", "ஸௌ"),
    ("«ú£", "ஸோ"),
    ("ªú£", "ஸொ"),
    ("ú£", "ஸா"),
    ("ú¤", "ஸி"),
    ("ú¦", "ஸீ"),

    ("ªú", "ஸெ"),
    ("«ú", "ஸே"),
    ("¬ú", "ஸை"),
    ("ú¢", "ஸ்"),
    ("ú", "ஸ"),

    ("Ü", "அ"),
    ("Ý", "ஆ"),
    ("Þ", "இ"),
    ("ß", "ஈ"),
    ("à", "உ"),
    ("á", "ஊ"),
    ("â", "எ"),
    ("ã", "ஏ"),
    ("ä", "ஐ"),
    ("å", "ஒ"),
    ("æ", "ஓ"),
    ("å÷", "ஔ"),

    ("ç", "ஃ"),

    ("‚", "௧"),
    ("ƒ", "௨"),
    ("„", "௩"),
    ("…", "௪"),
    ("†", "௫"),
    ("—", "௰"),
    ("˜", "௱"),
    ("–", "௲"),
    ("", "௯"),
    ("ˆ", "௭"),
    ("‰", "௮"),
    ("Ã", "௬"),
    ("ÿ", "ஸ்ரீ"),

    ])
# end of tab2utf8 dictionary 



# begin of tam2utf8 dictionary 
tam2utf8 = OrderedDict([

    ("þ", "க்ஷ"),
    ("þ£", "க்ஷா"),
    ("¬þ", "க்ஷை"),
    ("V", "க்ஷி"),
    ("r", "க்ஷீ"),
    ("þ§", "க்ஷு"),
    ("þ¨", "க்ஷூ"),
    ("ªþ", "க்ஷெ"),
    ("«þ", "க்ஷே"),
    ("ªþ£", "க்ஷொ"),
    ("«þ£", "க்ஷோ"),
    ("ªþ÷", "க்ஷௌ"),
    ("z", "க்ஷ்"),

    ("ªü÷", "ஜௌ"),
    ("«ü£", "ஜோ"),
    ("ªü£", "ஜொ"),
    ("ü£", "ஜா"),
    ("T", "ஜி"),
    ("p", "ஜீ"),
    ("ü§", "ஜு"),
    ("ü¨", "ஜூ"),
    ("ªü", "ஜெ"),
    ("«ü", "ஜே"),
    ("¬ü", "ஜை"),
    ("ªü£", "ஜொ"),
    ("x", "ஜ்"),
    ("ü", "ஜ"),

    ("ªè÷", "கௌ"),
    ("«è£", "கோ"),
    ("ªè£", "கொ"),
    ("è£", "கா"),
    ("A", "கி"),
    ("W", "கீ"),
    ("°", "கு"),
    ("Ã", "கூ"),
    ("ªè", "கெ"),
    ("«è", "கே"),
    ("¬è", "கை"),
    ("‚", "க்"),
    ("è", "க"),

    ("ªé÷", "ஙௌ"),
    ("«é£", "ஙோ"),
    ("ªé£", "ஙொ"),
    ("é£", "ஙா"),
    ("B", "ஙி"),
    ("X", "ஙீ"),
    ("±", "ஙு"),
    ("Ä", "ஙூ"),
    ("ªé", "ஙெ"),
    ("«é", "ஙே"),
    ("¬é", "ஙை"),
    ("ƒ", "ங்"),
    ("é", "ங"),
    ("ªê÷", "சௌ"),
    ("«ê£", "சோ"),
    ("ªê£", "சொ"),
    ("ê£", "சா"),
    ("C", "சி"),
    ("Y", "சீ"),
    ("²", "சு"),
    ("Å", "சூ"),
    ("ªê", "செ"),
    ("«ê", "சே"),
    ("¬ê", "சை"),
    ("„", "ச்"),
    ("ê", "ச"),

    ("ªë\÷", "ஞௌ"),
    ("«ë£", "ஞோ"),
    ("ªë£", "ஞொ"),
    ("ë£", "ஞா"),
    ("D", "ஞி"),
    ("Z", "ஞீ"),
    ("³", "ஞு"),
    ("Æ", "ஞூ"),
    ("ªë", "ஞெ"),
    ("«ë", "ஞே"),
    ("¬ë", "ஞை"),
    ("…", "ஞ்"),
    ("ë", "ஞ"),

    ("ªì÷", "டௌ"),
    ("«ì£", "டோ"),
    ("ªì£", "டொ"),
    ("ì£", "டா"),
    ("®", "டி"),
    ("¯", "டீ"),
    ("´", "டு"),
    ("Ç", "டூ"),
    ("ªì", "டெ"),
    ("«ì", "டே"),
    ("¬ì", "டை"),
    ("†", "ட்"),
    ("ì", "ட"),
    ("ªí÷", "ணௌ"),
    ("«í£", "ணோ"),
    ("ªí£", "ணொ"),
    ("í£", "ணா"),
    ("E", "ணி"),
    ("a", "ணீ"),
    ("µ", "ணு"),
    ("È", "ணூ"),
    ("ªí", "ணெ"),
    ("«í", "ணே"),
    ("¬í", "ணை"),
    ("‡", "ண்"),
    ("í", "ண"),

    ("ªî÷", "தௌ"),
    ("«î£", "தோ"),
    ("ªî£", "தொ"),
    ("î£", "தா"),
    ("F", "தி"),
    ("b", "தீ"),
    ("¶", "து"),
    ("É", "தூ"),
    ("ªî", "தெ"),
    ("«î", "தே"),
    ("¬î", "தை"),
    ("ˆ", "த்"),
    ("î", "த"),


    ("ªï÷", "நௌ"),
    ("«ï£", "நோ"),
    ("ªï£", "நொ"),
    ("ï£", "நா"),
    ("G", "நி"),
    ("c", "நீ"),
    ("¸", "நு"),
    ("Ë", "நூ"),
    ("ªï", "நெ"),
    ("«ï", "நே"),
    ("¬ï", "நை"),
    ("ªï£", "நொ"),
    ("‰", "ந்"),
    ("ï", "ந"),
    ("ªù÷", "னௌ"),
    ("«ù£", "னோ"),
    ("ªù£", "னொ"),
    ("ù£", "னா"),
    ("Q", "னி"),
    ("m", "னீ"),
    ("Â", "னு"),
    ("Û", "னூ"),
    ("ªù", "னெ"),
    ("«ù", "னே"),
    ("¬ù", "னை"),
    ("ªù£", "னொ"),
    ("¡", "ன்"),
    ("ù", "ன"),

    ("ªð÷", "பௌ"),
    ("«ð£", "போ"),
    ("ªð£", "பொ"),
    ("ð£", "பா"),
    ("H", "பி"),
    ("d", "பீ"),
    ("¹", "பு"),
    ("Ì", "பூ"),
    ("ªð", "பெ"),
    ("«ð", "பே"),
    ("¬ð", "பை"),
    ("ªð£", "பொ"),
    ("Š", "ப்"),
    ("ð", "ப"),

    ("ªñ÷", "மௌ"),
    ("«ñ£", "மோ"),
    ("ªñ£", "மொ"),
    ("ñ£", "மா"),
    ("I", "மி"),
    ("e", "மீ"),
    ("º", "மு"),
    ("Í", "மூ"),
    ("ªñ", "மெ"),
    ("«ñ", "மே"),
    ("¬ñ", "மை"),
    ("ªñ£", "மொ"),
    ("‹", "ம்"),
    ("ñ", "ம"),

    ("ªò÷", "யௌ"),
    ("«ò£", "யோ"),
    ("ªò£", "ய"),
    ("ò£", "யா"),
    ("J", "யி"),
    ("f", "யீ"),
    ("»", "யு"),
    ("Î", "யூ"),
    ("ªò", "யெ"),
    ("«ò", "யே"),
    ("¬ò", "யை"),
    ("ªò£", "யொ"),
    ("Œ", "ய்"),
    ("ò", "ய"),

    ("ªó÷", "ரௌ"),
    ("«ó£", "ரோ"),
    ("ªó£", "ரொ"),
    ("ó£", "ரா"),
    ("K", "ரி"),
    ("g", "ரீ"),
    ("¼", "ரு"),
    ("Ï", "ரூ"),
    ("ªó", "ரெ"),
    ("«ó", "ரே"),
    ("¬ó", "ரை"),
    ("˜", "ர்"),
    ("ó", "ர"),

    ("ªô÷", "லௌ"),
    ("«ô£", "லோ"),
    ("ªô£", "லொ"),
    ("ô£", "லா"),
    ("L", "லி"),
    ("h", "லீ"),
    ("½", "லு"),
    ("Ö", "லூ"),
    ("ªô", "லெ"),
    ("«ô", "லே"),
    ("¬ô", "லை"),
    ("™", "ல்"),
    ("ô", "ல"),

    ("ª÷÷", "ளௌ"),
    ("«÷£", "ளோ"),
    ("ª÷£", "ள"),
    ("÷£", "ளா"),
    ("O", "ளி"),
    ("k", "ளீ"),
    ("À", "ளு"),
    ("Ù", "ளூ"),
    ("ª÷", "ளெ"),
    ("«÷", "ளே"),
    ("¬÷", "ளை"),
    ("œ", "ள்"),
    ("÷", "ள"),

    ("ªõ÷", "வௌ"),
    ("«õ£", "வோ"),
    ("ªõ£", "வொ"),
    ("õ£", "வா"),
    ("M", "வி"),
    ("i", "வீ"),
    ("¾", "வு"),
    ("×", "வூ"),
    ("ªõ", "வெ"),
    ("«õ", "வே"),
    ("¬õ", "வை"),
    ("ªõ£", "வொ"),
    ("š", "வ்"),
    ("õ", "வ"),
    ("ªö÷", "ழௌ"),
    ("«ö£", "ழோ"),
    ("ªö£", "ழொ"),
    ("ö£", "ழா"),
    ("N", "ழி"),
    ("j", "ழீ"),
    ("¿", "ழு"),
    ("Ø", "ழூ"),
    ("ªö", "ழெ"),
    ("«ö", "ழே"),
    ("¬ö", "ழை"),
    ("›", "ழ்"),
    ("ö", "ழ"),

    ("ªø÷", "றௌ"),
    ("«ø£", "றோ"),
    ("ªø£", "றொ"),
    ("ø£", "றா"),
    ("P", "றி"),
    ("l", "றீ"),
    ("Á", "று"),
    ("Ú", "றூ"),
    ("ªø", "றெ"),
    ("«ø", "றே"),
    ("¬ø", "றை"),
    ("ªø£", "றொ"),
    ("Ÿ", "ற்"),
    ("ø", "ற"),
    ("ªý÷", "ஹௌ"),
    ("«ý£", "ஹோ"),
    ("ªý£", "ஹொ"),
    ("ý£", "ஹா"),
    ("U", "ஹி"),
    ("q", "ஹீ"),
    ("ªý", "ஹெ"),
    ("«ý", "ஹே"),
    ("¬ý", "ஹை"),
    ("y", "ஹ்"),
    ("ý", "ஹ"),

    ("ªû÷", "ஷௌ"),
    ("«û£", "ஷோ"),
    ("ªû£", "ஷொ"),
    ("û£", "ஷா"),
    ("S", "ஷி"),
    ("o", "ஷீ"),

    ("ªû", "ஷெ"),
    ("«û", "ஷே"),
    ("¬û", "ஷை"),
    ("ªû£", "ஷொ"),
    ("w", "ஷ்"),
    ("û", "ஷ"),

    ("ªú÷", "ஸௌ"),
    ("«ú£", "ஸோ"),
    ("ªú£", "ஸொ"),
    ("ú£", "ஸா"),
    ("R", "ஸி"),
    ("n", "ஸீ"),
    ("ªú", "ஸெ"),
    ("«ú", "ஸே"),
    ("¬ú", "ஸை"),
    ("v", "ஸ்"),
    ("ú", "ஸ"),
    ("Ü", "அ"),
    ("Ý", "ஆ"),
    ("Þ", "இ"),
    ("ß", "ஈ"),
    ("à", "உ"),
    ("á", "ஊ"),
    ("â", "எ"),
    ("ã", "ஏ"),
    ("ä", "ஐ"),
    ("å", "ஒ"),
    ("æ", "ஓ"),
    ("å÷", "ஔ"),

    ("ç", "ஃ"),

    ("ÿ", "ஸ்ரீ"),
    ("ƒ", "‘"),

    ])

# end of tam2utf8 dictionary 



# begin of tscii2utf8 dictionary 
tscii2utf8 = OrderedDict([

    ("­", "இ"),
    ("þ", "இ"),
    ("‡", "க்ஷ"),
    ("‡¡", "க்ஷா"),
    ("‡¢", "க்ஷி"),
    ("‡£", "க்ஷீ"),
    ("‡¤", "க்ஷு"),
    ("‡¥", "க்ஷூ"),
    ("¦‡", "க்ஷெ"),
    ("§‡", "க்ஷே"),
    ("¨‡", "க்ஷை"),
    ("¦‡¡", "க்ஷொ"),
    ("§‡¡", "க்ஷோ"),
    ("¦‡Ç", "க்ஷௌ"),
    ("Œ", "க்ஷ்"),

    ("¦¸ª", "கௌ"),
    ("§¸¡", "கோ"),
    ("¦¸¡", "கொ"),
    ("¸¡", "கா"),
    ("¸¢", "கி"),
    ("¸£", "கீ"),
    ("Ì", "கு"),
    ("Ü", "கூ"),
    ("¦¸", "கெ"),
    ("§¸", "கே"),
    ("¨¸", "கை"),
    ("¦¸¡", "கொ"),
    ("ì", "க்"),
    ("¸", "க"),

    ("¦¹ª", "ஙௌ"),
    ("§¹¡", "ஙோ"),
    ("¦¹¡", "ஙொ"),
    ("¹¡", "ஙா"),
    ("¹¢", "ஙி"),
    ("¹£", "ஙீ"),
    ("™", "ஙு"),
    ("›", "ஙூ"),
    ("¦¹", "ஙெ"),
    ("§¹", "ஙே"),
    ("¨¹", "ஙை"),
    ("¦¹¡", "ஙொ"),
    ("í", "ங்"),
    ("¹", "ங"),

    ("¦ºª", "சௌ"),
    ("§º¡", "சோ"),
    ("¦º¡", "சொ"),
    ("º¡", "சா"),
    ("º¢", "சி"),
    ("º£", "சீ"),
    ("Í", "சு"),
    ("Ý", "சூ"),
    ("¦º", "செ"),
    ("§º", "சே"),
    ("¨º", "சை"),
    ("¦º¡", "சொ"),
    ("î", "ச்"),
    ("º", "ச"),

    ("¦ƒª", "ஜௌ"),
    ("§ƒ¡", "ஜோ"),
    ("¦ƒ¡", "ஜொ"),
    ("ƒ¡", "ஜா"),
    ("ƒ¢", "ஜி"),
    ("ƒ£", "ஜீ"),
    ("ƒ¤", "ஜு"),
    ("ƒ¥", "ஜூ"),
    ("¦ƒ", "ஜெ"),
    ("§ƒ", "ஜே"),
    ("¨ƒ", "ஜை"),
    ("¦ƒ¡", "ஜொ"),
    ("ˆ", "ஜ்"),
    ("ƒ", "ஜ"),

    ("¦»ª", "ஞௌ"),
    ("§»¡", "ஞோ"),
    ("¦»¡", "ஞொ"),
    ("»¡", "ஞா"),
    ("»¢", "ஞி"),
    ("»£", "ஞீ"),
    ("", "ஞு"),
    ("œ", "ஞூ"),
    ("¦»", "ஞெ"),
    ("§»", "ஞே"),
    ("¨»", "ஞை"),
    ("¦»¡", "ஞொ"),
    ("ï", "ஞ்"),
    ("»", "ஞ"),

    ("¦¼ª", "டௌ"),
    ("§¼¡", "டோ"),
    ("¦¼¡", "டொ"),
    ("¼¡", "டா"),
    ("Ê", "டி"),
    ("Ë", "டீ"),
    ("Î", "டு"),
    ("Þ", "டூ"),
    ("¦¼", "டெ"),
    ("§¼", "டே"),
    ("¨¼", "டை"),
    ("¦¼¡", "டொ"),
    ("ð", "ட்"),
    ("¼", "ட"),
    ("¦½ª", "ணௌ"),
    ("§½¡", "ணோ"),
    ("¦½¡", "ணொ"),
    ("½¡", "ணா"),
    ("½¢", "ணி"),
    ("½£", "ணீ"),
    ("Ï", "ணு"),
    ("ß", "ணூ"),
    ("¦½", "ணெ"),
    ("§½", "ணே"),
    ("¨½", "ணை"),
    ("¦½¡", "ணொ"),
    ("ñ", "ண்"),
    ("½", "ண"),


    ("¦¾ª", "தௌ"),
    ("§¾¡", "தோ"),
    ("¦¾¡", "தொ"),
    ("¾¡", "தா"),
    ("¾¢", "தி"),
    ("¾£", "தீ"),
    ("Ð", "து"),
    ("à", "தூ"),
    ("¦¾", "தெ"),
    ("§¾", "தே"),
    ("¨¾", "தை"),
    ("¦¾¡", "தொ"),
    ("ò", "த்"),
    ("¾", "த"),

    ("¦¿ª", "நௌ"),
    ("§¿¡", "நோ"),
    ("¦¿¡", "நொ"),
    ("¿¡", "நா"),
    ("¿¢", "நி"),
    ("¿£", "நீ"),
    ("Ñ", "நு"),
    ("á", "நூ"),
    ("¦¿", "நெ"),
    ("§¿", "நே"),
    ("¨¿", "நை"),
    ("¦¿¡", "நொ"),
    ("ó", "ந்"),
    ("¿", "ந"),

    ("¦Éª", "னௌ"),
    ("§É¡", "னோ"),
    ("¦É¡", "னொ"),
    ("É¡", "னா"),
    ("É¢", "னி"),
    ("É£", "னீ"),
    ("Û", "னு"),
    ("ë", "னூ"),
    ("¦É", "னெ"),
    ("§É", "னே"),
    ("¨É", "னை"),
    ("¦É¡", "னொ"),
    ("ý", "ன்"),
    ("É", "ன"),

    ("¦Àª", "பௌ"),
    ("§À¡", "போ"),
    ("¦À¡", "பொ"),
    ("À¡", "பா"),
    ("À¢", "பி"),
    ("À£", "பீ"),
    ("Ò", "பு"),
    ("â", "பூ"),
    ("¦À", "பெ"),
    ("§À", "பே"),
    ("¨À", "பை"),
    ("¦À¡", "பொ"),
    ("ô", "ப்"),
    ("À", "ப"),

    ("¦Áª", "மௌ"),
    ("§Á¡", "மோ"),
    ("¦Á¡", "மொ"),
    ("Á¡", "மா"),
    ("Á¢", "மி"),
    ("Á£", "மீ"),
    ("Ó", "மு"),
    ("ã", "மூ"),
    ("¦Á", "மெ"),
    ("§Á", "மே"),
    ("¨Á", "மை"),
    ("¦Á¡", "மொ"),
    ("õ", "ம்"),
    ("Á", "ம"),
    ("¦Âª", "யௌ"),
    ("§Â¡", "யோ"),
    ("¦Â¡", "யொ"),
    ("Â¡", "யா"),
    ("Â¢", "யி"),
    ("Â£", "யீ"),
    ("Ô", "யு"),
    ("ä", "யூ"),
    ("¦Â", "யெ"),
    ("§Â", "யே"),
    ("¨Â", "யை"),

    ("ö", "ய்"),
    ("Â", "ய"),

    ("¦Ãª", "ரௌ"),
    ("§Ã¡", "ரோ"),
    ("¦Ã¡", "ரொ"),
    ("Ã¡", "ரா"),
    ("Ã¢", "ரி"),
    ("Ã£", "ரீ"),
    ("Õ", "ரு"),
    ("å", "ரூ"),
    ("¦Ã", "ரெ"),
    ("§Ã", "ரே"),
    ("¨Ã", "ரை"),
    ("÷", "ர்"),
    ("Ã", "ர"),

    ("¦Äª", "லௌ"),
    ("§Ä¡", "லோ"),
    ("¦Ä¡", "லொ"),
    ("Ä¡", "லா"),
    ("Ä¢", "லி"),
    ("Ä£", "லீ"),
    ("Ö", "லு"),
    ("æ", "லூ"),
    ("¦Ä", "லெ"),
    ("§Ä", "லே"),
    ("¨Ä", "லை"),
    ("¦Ä¡", "லொ"),
    ("ø", "ல்"),
    ("Ä", "ல"),

    ("¦Çª", "ளௌ"),
    ("§Ç¡", "ளோ"),
    ("¦Ç¡", "ளொ"),
    ("Ç¡", "ளா"),
    ("Ç¢", "ளி"),
    ("Ç£", "ளீ"),
    ("Ù", "ளு"),
    ("é", "ளூ"),
    ("¦Ç", "ளெ"),
    ("§Ç", "ளே"),
    ("¨Ç", "ளை"),

    ("û", "ள்"),
    ("Ç", "ள"),
    ("¦Åª", "வௌ"),
    ("§Å¡", "வோ"),
    ("¦Å¡", "வொ"),
    ("Å¡", "வா"),
    ("Å¢", "வி"),
    ("Å£", "வீ"),
    ("×", "வு"),
    ("ç", "வூ"),
    ("¦Å", "வெ"),
    ("§Å", "வே"),
    ("¨Å", "வை"),
    ("¦Å¡", "வொ"),
    ("ù", "வ்"),
    ("Å", "வ"),


    ("¦Æª", "ழௌ"),
    ("§Æ¡", "ழோ"),
    ("¦Æ¡", "ழொ"),
    ("Æ¡", "ழா"),
    ("Æ¢", "ழி"),
    ("Æ£", "ழீ"),
    ("Ø", "ழு"),
    ("è", "ழூ"),
    ("¦Æ", "ழெ"),
    ("§Æ", "ழே"),
    ("¨Æ", "ழை"),
    ("¦Æ¡", "ழொ"),
    ("ú", "ழ்"),
    ("Æ", "ழ"),

    ("¦Èª", "றௌ"),
    ("§È¡", "றோ"),
    ("¦È¡", "றொ"),
    ("È¡", "றா"),
    ("È¢", "றி"),
    ("È£", "றீ"),
    ("Ú", "று"),
    ("ê", "றூ"),
    ("¦È", "றெ"),
    ("§È", "றே"),
    ("¨È", "றை"),
    ("¦È¡", "றொ"),
    ("ü", "ற்"),
    ("È", "ற"),

    ("¦†ª", "ஹௌ"),
    ("§†¡", "ஹோ"),
    ("¦†¡", "ஹொ"),
    ("†¡", "ஹா"),
    ("†¢", "ஹி"),
    ("†£", "ஹீ"),
    ("¦†", "ஹெ"),
    ("§†", "ஹே"),
    ("¨†", "ஹை"),
    ("¦†¡", "ஹொ"),
    ("‹", "ஹ்"),
    ("†", "ஹ"),


    ("¦„ª", "ஷௌ"),
    ("§„¡", "ஷோ"),
    ("¦„¡", "ஷொ"),
    ("„¡", "ஷா"),
    ("„¢", "ஷி"),
    ("„£", "ஷீ"),
    ("¦„", "ஷெ"),
    ("§„", "ஷே"),
    ("¨„", "ஷை"),
    ("¦„¡", "ஷொ"),
    ("‰", "ஷ்"),
    ("„", "ஷ"),

    ("¦…ª", "ஸௌ"),
    ("§…¡", "ஸோ"),
    ("¦…¡", "ஸொ"),
    ("…¡", "ஸா"),
    ("…¢", "ஸி"),
    ("…£", "ஸீ"),
    ("¦…", "ஸெ"),
    ("§…", "ஸே"),
    ("¨…", "ஸை"),
    ("¦…¡", "ஸொ"),
    ("Š", "ஸ்"),
    ("…", "ஸ"),

    ("«", "அ"),
    ("¬", "ஆ"),
    ("®", "ஈ"),
    ("¯", "உ"),
    ("°", "ஊ"),
    ("±", "எ"),
    ("²", "ஏ"),
    ("³", "ஐ"),
    ("´", "ஒ"),
    ("µ", "ஓ"),
    ("¶", "ஔ"),

    ("∙", "ஃ"),

    ("", "௧"),
    ("", "௨"),
    ("", "௩"),
    ("", "௪"),
    ("", "௫"),
    ("", "௰"),
    ("", "௱"),
    ("Ÿ", "௲"),
    ("", "௯"),
    ("", "௭"),
    ("", "௮"),
    ("", "௬"),
    ("‚", "ஸ்ரீ"),

    ])
# end of tscii2utf8 dictionary 



# begin of pallavar2utf8 dictionary 
pallavar2utf8 = OrderedDict([

    ("Øáe", "ளௌ"),
    ("¼áV", "ளோ"),
    ("ØáV", "ளொ"),
    ("áV", "ளா"), 
    ("eV", "ளா"),
    ("¹", "ளி"),
    ("C", "ளீ"),
    ("Ó", "ளு"),
    ("j", "ளூ"),
    ("Øá", "ளெ"),
    ("¼á", "ளே"),
    ("çá", "ளை"),
    ("\^", "ள்"),
    ("á", "ள"),

    ("Ö", "இ"),

    ("Ø³e", "க்ஷௌ"),
    ("¼³V", "க்ஷோ"),
    ("Ø³V", "க்ஷொ"),
    ("³V", "க்ஷா"),
    ("H", "க்ஷி"),
    ("È", "க்ஷீ"),
    ("Y", "க்ஷு"),
    ("f", "க்ஷூ"),
    ("Ø³", "க்ஷெ"),
    ("¼³", "க்ஷே"),
    ("ç³", "க்ஷை"),

    ("Õ", "க்ஷ்"),
    ("³", "க்ஷ"),

    ("Øïe", "கௌ"),
    ("¼ïV", "கோ"),
    ("ØïV", "கொ"),
    ("ïV", "கா"),
    ("þ", "கி"),
    ("ÿ", "கீ"),
    ("z", "கு"),
    ("í", "கூ"),
    ("Øï", "கெ"),
    ("¼ï", "கே"),
    ("çï", "கை"),

    ("Â", "க்"),
    ("ï", "க"),

    ("Øôe", "ஙௌ"),
    ("¼ôV", "ஙோ"),
    ("ØôV", "ஙொ"),
    ("ôV", "ஙா"),

    ("Øô", "ஙெ"),
    ("¼ô", "ஙே"),
    ("çô", "ஙை"),

    ("º", "ங்"),
    ("ô", "ங"),

    ("ØÄe", "சௌ"),
    ("¼ÄV", "சோ"),
    ("ØÄV", "சொ"),
    ("ÄV", "சா"),
    ("E", "சி"),
    ("æ", "சீ"),
    ("·", "சு"),
    ("ó", "சூ"),
    ("ØÄ", "செ"),
    ("¼Ä", "சே"),
    ("çÄ", "சை"),

    ("ß", "ச்"),
    ("Ä", "ச"),

    ("ØÛe", "ஜௌ"),
    ("¼ÛV", "ஜோ"),
    ("ØÛV", "ஜொ"),
    ("ÛV", "ஜா"),
    ("÷", "ஜி"),
    ("ý", "ஜீ"),
    ("h", "ஜு"),
    ("É", "ஜூ"),
    ("ØÛ", "ஜெ"),
    ("¼Û", "ஜே"),
    ("çÛ", "ஜை"),

    ("ë", "ஜ்"),
    ("Û", "ஜ"),

    ("ØQe", "ஞௌ"),
    ("¼QV", "ஞோ"),
    ("ØQV", "ஞொ"),
    ("QV", "ஞா"),

    ("ØQ", "ஞெ"),
    ("¼Q", "ஞே"),
    ("çQ", "ஞை"),

    ("Þ", "ஞ்"),
    ("Q", "ஞ"),

    ("Ø¦e", "டௌ"),
    ("¼¦V", "டோ"),
    ("Ø¦V", "டொ"),
    ("¦V", "டா"),
    ("½", "டி"),
    ("Ï", "டீ"),

    ("ù", "டூ"),
    ("Ø¦", "டெ"),
    ("¼¦", "டே"),
    ("ç¦", "டை"),

    ("â", "ட்"),
    ("¦", "ட"),

    ("Øðe", "ணௌ"),
    ("¼ðV", "ணோ"),
    ("ØðV", "ணொ"),
    ("ðV", "ணா"),
    ("è", "ணி"),
    ("§", "ணீ"),
    ("b", "ணு"),
    ("I", "ணூ"),
    ("Øð", "ணெ"),
    ("¼ð", "ணே"),
    ("çð", "ணை"),

    ("õ", "ண்"),
    ("ð", "ண"),

    ("Ø>e", "தௌ"),
    ("¼>V", "தோ"),
    ("Ø>V", "தொ"),
    (">V", "தா"),
    ("\]", "தி"),
    ("y", "தீ"),
    ("m", "து"),
    ("#", "தூ"),
    ("Ø>", "தெ"),
    ("¼>", "தே"),
    ("ç>", "தை"),

    ("Ý", "த்"),
    (">", "த"),

    ("Øåª", "நௌ"),
    ("¼åV", "நோ"),
    ("ØåV", "நொ"),
    ("åV", "நா"),
    ("W", "நி"),
    ("À", "நீ"),
    ("O", "நு"),
    ("±", "நூ"),
    ("Øå", "நெ"),
    ("¼å", "நே"),
    ("çå", "நை"),

    ("Í", "ந்"),
    ("å", "ந"),

    ("Ø\\á", "மௌ"),
    ("¼\\V", "மோ"),
    ("Ø\\V", "மொ"),
    ("\\V", "மா"),
    ("t", "மி"),
    ("\*", "மீ"),
    ("x", "மு"),
    ("J", "மூ"),
    ("Ø\\", "மெ"),
    ("¼\\", "மே"),
    ("ç\\", "மை"),

    ("D", "ம்"),
    ("\\", "ம"),

    ("Øªe", "னௌ"),
    ("¼ªV", "னோ"),
    ("ØªV", "னொ"),
    ("ªV", "னா"),
    ("M", "னி"),
    ("Ì", "னீ"),
    ("Ð", "னு"),
    ("û", "னூ"),
    ("Øª", "னெ"),
    ("¼ª", "னே"),
    ("çª", "னை"),

    ("\[", "ன்"),
    ("ª", "ன"),

    ("ØÃe", "பௌ"),
    ("¼ÃV", "போ"),
    ("ØÃV", "பொ"),
    ("ÃV", "பா"),
    ("¸", "பி"),
    ("¬", "பீ"),
    ("A", "பு"),
    ("¯", "பூ"),
    ("ØÃ", "பெ"),
    ("¼Ã", "பே"),
    ("çÃ", "பை"),

    ("©", "ப்"),
    ("Ã", "ப"),

    ("Ø«e", "ரௌ"),
    ("¼«V", "ரோ"), 
    ("Ø«V", "ரொ"),
    ("«V", "ரா"),
    ("ö", "ரி"),
    ("Z", "ரீ"),
    ("ò", "ரு"),
    ("Ô", "ரூ"),
    ("Ø«", "ரெ"),
    ("¼«", "ரே"),
    ("ç«", "ரை"),

    ("ú", "ர்"),
    ("ì", "ர்"),
    ("«", "ர"),

    ("Øée", "லௌ"),
    ("¼éV", "லோ"),
    ("ØéV", "லொ"),
    ("éV", "லா"),
    ("o", "லி"),
    ("Ü", "லீ"), 
    ("K", "லு"),
    ("Ù", "லூ"),
    ("Øé", "லெ"),
    ("¼é", "லே"),
    ("çé", "லை"),

    ("_", "ல்"),
    ("é", "ல"),

    ("Øke", "வௌ"),
    ("¼kV", "வோ"),
    ("ØkV", "வொ"),
    ("kV", "வா"),
    ("s", "வி"),
    ("T", "வீ"),
    ("¡", "வு"),
    ("Æ", "வூ"),
    ("Øk", "வெ"),
    ("¼k", "வே"),
    ("çk", "வை"),

    ("Ë", "வ்"),
    ("k", "வ"),

    ("Øwe", "ழௌ"),
    ("¼wV", "ழோ"),
    ("ØwV", "ழொ"),
    ("wV", "ழா"),
    ("a", "ழி"),
    ("Ñ", "ழீ"),
    ("¿", "ழு"),
    ("ñ", "ழூ"),
    ("Øw", "ழெ"),
    ("¼w", "ழே"),
    ("çw", "ழை"),

    ("µ", "ழ்"), 
    ("w", "ழ"),

    ("ØÅe", "றௌ"),
    ("¼ÅV", "றோ"),
    ("ØÅV", "றொ"),
    ("ÅV", "றா"),
    ("¤", "றி"),
    ("S", "றீ"), 
    ("®", "று"),
    ("G", "றூ"),
    ("ØÅ", "றெ"),
    ("¼Å", "றே"),
    ("çÅ", "றை"),

    ("u", "ற்"),
    ("Å", "ற"),

    ("ØBe", "யௌ"),
    ("¼BV", "யோ"),
    ("Ø", "ய"),
    ("BV", "யா"),
    ("l", "யி"),
    ("X", "யீ"),
    ("¥", "யு"),
    ("R", "யூ"),
    ("ØB", "யெ"),
    ("¼B", "யே"),
    ("çB", "யை"),

    ("F", "ய்"),
    ("B", "ய"),  

    ("Øve", "ஸௌ"),
    ("¼vV", "ஸோ"),
    ("ØvV", "ஸொ"),
    ("vV", "ஸா"),
    ("L", "ஸி"),
    ("¢", "ஸீ"),
    ("q", "ஸு"),
    ("`", "ஸூ"),
    ("Øv", "ஸெ"),
    ("¼v", "ஸே"),
    ("çv", "ஸை"),
    ("ü", "ஸ்"),
    ("v", "ஸ"),

    ("ØÇe", "ஹௌ"),
    ("¼ÇV", "ஹோ"),
    ("ØÇV", "ஹொ"),
    ("ÇV", "ஹா"),
    ("N", "ஹி"),
    ("ê", "ஹீ"),
    ("ø", "ஹு"),
    ("Ú", "ஹூ"),
    ("ØÇ", "ஹெ"),
    ("¼Ç", "ஹே"),
    ("çÇ", "ஹை"),
    ("ã", "ஹ்"),
    ("Ç", "ஹ"),

    ("Ø­e", "ஷௌ"),
    ("¼­V", "ஷோ"),
    ("Ø­V", "ஷொ"),
    ("­V", "ஷா"),
    ("×", "ஷி"),
    ("£", "ஷீ"),
    ("Ø­", "ஷெ"),
    ("¼­", "ஷே"),
    ("ç­", "ஷை"),

    ("i", "ஷ்"),
    ("1­", "ஷ"),

    ("ØBe", "யௌ"),
    ("¼BV", "யோ"),
    ("ØBV", "ய"),
    ("BV", "யா"),
    ("l", "யி"),
    ("X", "யீ"),
    ("¥", "யு"),
    ("R", "யூ"),
    ("ØB", "யெ"),
    ("¼B", "யே"),
    ("çB", "யை"),

    ("F", "ய்"),
    ("B", "ய"),  

    ("¶", "அ"),
    ("g", "ஆ"),
    ("~", "ஈ"),
    ("c", "உ"),
    ("»", "ஊ"),
    ("¨", "எ"),
    ("°", "ஏ"),
    ("n", "ஐ"),
    ("Î", "ஒ"),
    ("{", "ஓ"),
    ("Á", "ஔ"),

    ("à", "ஃ"),

    ("\|", "டு"),

    ("Š", "-"),
    ("p", "ஸ்ரீ"),

    ])
# end of pallavar2utf8 dictionary 

# begin of indoweb2utf8 dictionary 
indoweb2utf8 = OrderedDict([

    ("è¨", "ரி"),
    ("è©", "ரீ"),

    ("èÐ", "ர்"),
    ("èÐ", "ர்"),
    ("Â", "க்ஷ"),
    ("Âè", "க்ஷா"),

    ("Âð", "க்ஷி"),
    ("Â©", "க்ஷீ"),
    ("Â¦", "க்ஷு"),
    ("Âð", "க்ஷூ"),
    ("âÂ", "க்ஷெ"),
    ("îÂ", "க்ஷே"),
    ("âÂè", "க்ஷொ"),
    ("îÂè", "க்ஷோ"),
    ("âÂó", "க்ஷௌ"),
    ("éÂ", "க்ஷை"),
    ("ÂÐ", "க்ஷ்"),

    ("âæó", "கௌ"),
    ("îæè", "கோ"),
    ("âæè", "கொ"),
    ("æè", "கா"),
    ("æ¨", "கி"),
    ("æ©", "கீ"),
    ("Æ", "கு"),
    ("Ô", "கூ"),
    ("âæ", "கெ"),
    ("îæ", "கே"),
    ("éæ", "கை"),
    ("æÐ", "க்"),
    ("æ", "க"),

    ("â§ó", "ஙௌ"),
    ("î§è", "ஙோ"),
    ("â§è", "ஙொ"),
    ("§è", "ஙா"),
    ("§¨", "ஙி"),
    ("§©", "ஙீ"),
    ("³", "ஙு"),
    ("º", "ஙூ"),
    ("â§", "ஙெ"),
    ("î§", "ஙே"),
    ("é§", "ஙை"),
    ("§Ð", "ங்"),
    ("§", "ங"),

    ("âòó", "சௌ"),
    ("îòè", "சோ"),
    ("âòè", "சொ"),
    ("òè", "சா"),
    ("ò¨", "சி"),
    ("ò©", "சீ"),
    ("à", "சு"),
    ("Î", "சூ"),
    ("âò", "செ"),
    ("îò", "சே"),
    ("éò", "சை"),
    ("òÐ", "ச்"),
    ("ò", "ச"),

    ("â£ó", "ஜௌ"),
    ("î£è", "ஜோ"),
    ("â£è", "ஜொ"),
    ("£è", "ஜா"),
    ("£¨", "ஜி"),
    ("£©", "ஜீ"),
    ("£¦", "ஜு"),
    ("£ð", "ஜூ"),
    ("â£", "ஜெ"),
    ("î£", "ஜே"),
    ("é£", "ஜை"),
    ("£Ð", "ஜ்"),
    ("£", "ஜ"),

    ("â¢ó", "ஞௌ"),
    ("î¢è", "ஞோ"),
    ("â¢è", "ஞொ"),
    ("¢è", "ஞா"),
    ("¢¨", "ஞி"),
    ("¢©", "ஞீ"),
    ("ü", "ஞு"),
    ("»", "ஞூ"),
    ("â¢", "ஞெ"),
    ("î¢", "ஞே"),
    ("é¢", "ஞை"),
    ("¢Ð", "ஞ்"),
    ("¢", "ஞ"),

    ("âìó", "டௌ"),
    ("îìè", "டோ"),
    ("âìè", "டொ"),
    ("ìè", "டா"),
    ("ì¨", "டி"),
    ("ï", "டி"),
    ("Ï", "டீ"),
    ("ì©", "டீ"),
    ("Ì", "டு"),
    ("Þ", "டூ"),
    ("âì", "டெ"),
    ("îì", "டே"),
    ("éì", "டை"),
    ("ìÐ", "ட்"),
    ("ì", "ட"),

    ("âúó", "ணௌ"),
    ("îúè", "ணோ"),
    ("âúè", "ணொ"),
    ("úè", "ணா"),
    ("ú¨", "ணி"),
    ("ú©", "ணீ"),
    ("Ñ", "ணு"),
    ("½", "ணூ"),
    ("âú", "ணெ"),
    ("îú", "ணே"),
    ("éú", "ணை"),
    ("úÐ", "ண்"),
    ("ú", "ண"),

    ("âêó", "தௌ"),
    ("êêè", "தோ"),
    ("âêè", "தொ"),
    ("êè", "தா"),
    ("ê¨", "தி"),
    ("ê©", "தீ"),
    ("Ê", "து"),
    ("œ", "தூ"),
    ("âê", "தெ"),
    ("îê", "தே"),
    ("éê", "தை"),
    ("êÐ", "த்"),
    ("ê", "த"),

    ("âåó", "நௌ"),
    ("îåè", "நோ"),
    ("âåè", "நொ"),
    ("åè", "நா"),
    ("å¨", "நி"),
    ("å©", "நீ"),
    ("Å", "நு"),
    ("¿", "நூ"),
    ("âå", "நெ"),
    ("îå", "நே"),
    ("éå", "நை"),
    ("åÐ", "ந்"),
    ("å", "ந"),

    ("âäó", "னௌ"),
    ("îäè", "னோ"),
    ("âäè", "னொ"),
    ("äè", "னா"),
    ("ä¨", "னி"),
    ("ä©", "னீ"),
    ("Ä", "னு"),
    ("Û", "னூ"),
    ("âä", "னெ"),
    ("îä", "னே"),
    ("éä", "னை"),
    ("äÐ", "ன்"),
    ("ä", "ன"),

    ("âçó", "பௌ"),
    ("îçè", "போ"),
    ("âçè", "பொ"),
    ("çè", "பா"),
    ("ç¨", "பி"),
    ("ç©", "பீ"),
    ("µ", "பு"),
    ("—", "பூ"),
    ("∙", "பூ"),
    ("âç", "பெ"),
    ("îç", "பே"),
    ("éç", "பை"),
    ("çÐ", "ப்"),
    ("ç", "ப"),

    ("âëó", "மௌ"),
    ("îëè", "மோ"),
    ("âëè", "மொ"),
    ("ëè", "மா"),
    ("ë¨", "மி"),
    ("ë©", "மீ"),
    ("Ë", "மு"),
    ("ß", "மூ"),
    ("âë", "மெ"),
    ("îë", "மே"),
    ("éë", "மை"),
    ("ëÐ", "ம்"),
    ("ë", "ம"),

    ("âáó", "யௌ"),
    ("îáè", "யோ"),
    ("âáè", "யொ"),
    ("áè", "யா"),
    ("á¨", "யி"),
    ("á©", "யீ"),
    ("±", "யு"),
    ("¹", "யூ"),
    ("âá", "யெ"),
    ("îá", "யே"),
    ("éá", "யை"),
    ("áÐ", "ய்"),
    ("á", "ய"),

    ("âõõ", "ரௌ"),
    ("îõè", "ரோ"),
    ("âõè", "ரொ"),
    ("õè", "ரா"),
    ("õ¨", "ரி"),
    ("õ©", "ரீ"),
    ("Õ", "ரு"),
    ("¥", "ரூ"),
    ("âõ", "ரெ"),
    ("îõ", "ரே"),
    ("éõ", "ரை"),
    ("õÐ", "ர்"),
    ("õ", "ர"),

    ("âùó", "லௌ"),
    ("îùè", "லோ"),
    ("âùè", "லொ"),
    ("ùè", "லா"),
    ("ù¨", "லி"),
    ("ù©", "லீ"),
    ("Ù", "லு"),
    ("û", "லூ"),
    ("âù", "லெ"),
    ("îù", "லே"),
    ("éù", "லை"),
    ("ùÐ", "ல்"),
    ("ù", "ல"),

    ("âóó", "ளௌ"),
    ("îóè", "ளோ"),
    ("âóè", "ளொ"),
    ("óè", "ளா"),
    ("ó¨", "ளி"),
    ("ó©", "ளீ"),
    ("Ó", "ளு"),
    ("ñ", "ளூ"),
    ("âó", "ளெ"),
    ("îó", "ளே"),
    ("éó", "ளை"),
    ("óÐ", "ள்"),
    ("ó", "ள"),

    ("âôó", "வௌ"),
    ("îôè", "வோ"),
    ("âôè", "வொ"),
    ("ôè", "வா"),
    ("ô¨", "வி"),
    ("ô©", "வீ"),
    ("²", "வு"),
    ("´", "வூ"),
    ("âô", "வெ"),
    ("îô", "வே"),
    ("éô", "வை"),
    ("ôÐ", "வ்"),
    ("ô", "வ"),

    ("âÈó", "ழௌ"),
    ("îÈè", "ழோ"),
    ("âÈè", "ழொ"),
    ("Èè", "ழா"),
    ("È¨", "ழி"),
    ("È©", "ழீ"),
    ("Ç", "ழு"),
    ("¾", "ழூ"),
    ("âÈ", "ழெ"),
    ("îÈ", "ழே"),
    ("éÈ", "ழை"),
    ("ÈÐ", "ழ்"),
    ("È", "ழ"),

    ("â÷ó", "றௌ"),
    ("î÷è", "றோ"),
    ("â÷è", "றொ"),
    ("÷è", "றா"),
    ("÷¨", "றி"),
    ("÷©", "றீ"),
    ("×", "று"),
    ("®", "றூ"),
    ("â÷", "றெ"),
    ("î÷", "றே"),
    ("é÷", "றை"),
    ("÷Ð", "ற்"),
    ("÷", "ற"),

    ("âÁó", "ஹௌ"),
    ("îÁè", "ஹோ"),
    ("âÁè", "ஹொ"),
    ("Áè", "ஹா"),
    ("Á¨", "ஹி"),
    ("Á©", "ஹீ"),

    ("âÁ", "ஹெ"),
    ("îÁ", "ஹே"),
    ("éÁ", "ஹை"),
    ("ÁÐ", "ஹ்"),
    ("Á", "ஹ"),

    ("âÜó", "ஷௌ"),
    ("îÜè", "ஷோ"),
    ("âÜè", "ஷொ"),
    ("Üè", "ஷா"),
    ("Ü¨", "ஷி"),
    ("Ü©", "ஷீ"),

    ("âÜ", "ஷெ"),
    ("îÜ", "ஷே"),
    ("éÜ", "ஷை"),
    ("ÜÐ", "ஷ்"),
    ("Ü", "ஷ"),

    ("â¡ó", "ஸௌ"),
    ("î¡è", "ஸோ"),
    ("â¡è", "ஸொ"),
    ("¡è", "ஸா"),
    ("¡¨", "ஸி"),
    ("¡©", "ஸீ"),

    ("â¡", "ஸெ"),
    ("î¡", "ஸே"),
    ("é¡", "ஸை"),
    ("¡Ð", "ஸ்"),
    ("¡", "ஸ"),

    ("í", "அ"),
    ("Í", "ஆ"),
    ("¬", "இ"),
    ("¼", "ஈ"),
    ("ã", "உ"),
    ("Ã", "ஊ"),
    ("ö", "எ"),
    ("Ö", "ஏ"),
    ("É", "ஐ"),
    ("ø", "ஒ"),
    ("Ø", "ஓ"),
    ("øó", "ஔ"),
 
    ("þ", "ஃ"),
    ("ª", "்"),
    ("¤", "ஸ்ரீ"),

    ])
# end of indoweb2utf8 dictionary 

# begin of koeln2utf8 dictionary    
koeln2utf8 = OrderedDict([   
 
    ("Xau", "க்ஷௌ"),
    ("Xai", "க்ஷை"),
    ("Xaa", "க்ஷா"),
    ("XA", "க்ஷா"),
    ("Xa", "க்ஷ"),
    ("Xii", "க்ஷீ"),
    ("Xi", "க்ஷி"),
    ("XI", "க்ஷீ"),

    ("Xuu", "க்ஷூ"),
    ("Xu", "க்ஷு"),
    ("XU", "க்ஷூ"),
    ("Xee", "க்ஷே"),
    ("Xe", "க்ஷெ"),
    ("XE", "க்ஷே"),
    ("Xoo", "க்ஷோ"),
    ("Xo", "க்ஷொ"),
    ("XO", "க்ஷோ"),
    ("X", "க்ஷ்"),  
   
    ("jnau", "ஞௌ"),   
    ("jnai", "ஞை"),   
    ("jna", "ஞ"),   
    ("jni", "ஞி"),   
    ("jnI", "ஞீ"),   
    ("jnA", "ஞா"),   
    ("jne", "ஞெ"),   
    ("jnE", "ஞே"),   
    ("jno", "ஞொ"),   
    ("jnO", "ஞோ"),   
    ("jnu", "ஞு"),   
    ("jnU", "ஞூ"),   
   
    ("jn", "ஞ்"),   
    ("¤au", "ஞௌ"),   
    ("¤ai", "ஞை"),   

    ("¤a", "ஞ"),   
    ("¤i", "ஞி"),   
    ("¤I", "ஞீ"),   
    ("¤A", "ஞா"),   
    ("¤e", "ஞெ"),   
    ("¤E", "ஞே"),   
    ("¤o", "ஞொ"),   
    ("¤O", "ஞோ"),   
    ("¤u", "ஞு"),   
    ("¤U", "ஞூ"),   
   
    ("¤", "ஞ்"),   
    ("n^au", "ஞௌ"),   
    ("n^ai", "ஞை"),   
    ("n^a", "ஞ"),   
    ("n^i", "ஞி"),   
    ("n^I", "ஞீ"),   
    ("n^A", "ஞா"),   
    ("n^e", "ஞெ"),   
    ("n^E", "ஞே"),   
    ("n^o", "ஞொ"),   
    ("n^O", "ஞோ"),   
    ("n^u", "ஞு"),   
    ("n^U", "ஞூ"),   
   
    ("n^", "ஞ்"),      
   
    ("gau", "ஙௌ"),   
    ("gai", "ஙை"),   

    ("ga", "ங"),   
    ("gi", "ஙி"),   
    ("gI", "ஙீ"),   
    ("gA", "ஙா"),   
    ("ge", "ஙெ"),   
    ("gE", "ஙே"),   
    ("go", "ஙொ"),   
    ("gO", "ஙோ"),   
    ("gu", "ஙு"),   
    ("gU", "ஙூ"),      
    ("g", "ங்"),   
         
    ("Sau", "ஷௌ"),   
    ("Sai", "ஷை"),   

    ("Sa", "ஷ"),   
    ("Si", "ஷி"),   
    ("SI", "ஷீ"),   
    ("SA", "ஷா"),   
    ("Se", "ஷெ"),   
    ("SE", "ஷே"),   
    ("So", "ஷொ"),   
    ("SO", "ஷோ"),   
    ("Su", "ஷு"),   
    ("SU", "ஷூ"),   
   
    ("S", "ஷ்"),   
   
    ("nau", " நௌ"),   
    ("nai", " நை"),   

    ("na", " ந"),   
    ("ni", " நி"),   
    ("nI", " நீ"),   
    ("nA", " நா"),   
    ("ne", " நெ"),   
    ("nE", " நே"),   
    ("no", " நொ"),   
    ("nO", " நோ"),   
    ("nu", " நு"),   
    ("nU", " நூ"),        

    ("üau", "னௌ"),   
    ("üai", "னை"),   

    ("üa", "ன"),   
    ("üi", "னி"),   
    ("üI", "னீ"),   
    ("üA", "னா"),   
    ("üe", "னெ"),   
    ("üE", "னே"),   
    ("üo", "னொ"),   
    ("üO", "னோ"),   
    ("üu", "னு"),   
    ("üU", "னூ"),   
   
    ("ü", "ன்"), 
   
    ("tau", "தௌ"),   
    ("tai", "தை"),   

    ("ta", "த"),   
    ("ti", "தி"),   
    ("tI", "தீ"),   
    ("tA", "தா"),   
    ("te", "தெ"),   
    ("tE", "தே"),   
    ("to", "தொ"),   
    ("tO", "தோ"),   
    ("tu", "து"),   
    ("tU", "தூ"),   
   
    ("t", "த்"),   
   
    ("zau", "ழௌ"),   
    ("zai", "ழை"),   

    ("za", "ழ"),   
    ("zi", "ழி"),   
    ("zI", "ழீ"),   
    ("zA", "ழா"),   
    ("ze", "ழெ"),   
    ("zE", "ழே"),   
    ("zo", "ழொ"),   
    ("zO", "ழோ"),   
    ("zu", "ழு"),   
    ("zU", "ழூ"),   
   
    ("z", "ழ்"),   
   
    ("jau", "ஜௌ"),   
    ("jai", "ஜை"),   

    ("ja", "ஜ"),   
    ("ji", "ஜி"),   
    ("jI", "ஜீ"),   
    ("jA", "ஜா"),   
    ("je", "ஜெ"),   
    ("jE", "ஜே"),   
    ("jo", "ஜொ"),   
    ("jO", "ஜோ"),   
    ("ju", "ஜு"),   
    ("jU", "ஜூ"),   
   
    ("j", "ஜ்"),   
   
    ("hau", "ஹௌ"),   
    ("hai", "ஹை"),   

    ("ha", "ஹ"),   
    ("hi", "ஹி"),   
    ("hI", "ஹீ"),   
    ("hA", "ஹா"),   
    ("he", "ஹெ"),   
    ("hE", "ஹே"),   
    ("ho", "ஹொ"),   
    ("hO", "ஹோ"),   
    ("hu", "ஹு"),   
    ("hU", "ஹூ"),   
   
    ("h", "ஹ்"),   
   
    ("kau", "கௌ"),   
    ("kai", "கை"),   

    ("ka", "க"),   
    ("ki", "கி"),   
    ("kI", "கீ"),   
    ("kA", "கா"),   
    ("ke", "கெ"),   
    ("kE", "கே"),   
    ("ko", "கொ"),   
    ("kO", "கோ"),   
    ("ku", "கு"),   
    ("kU", "கூ"),   
   
    ("k", "க்"), 
      
    ("sau", "ஸௌ"),   
    ("sai", "ஸை"),   

    ("sa", "ஸ"),   
    ("si", "ஸி"),   
    ("sI", "ஸீ"),   
    ("sA", "ஸா"),   
    ("se", "ஸெ"),   
    ("sE", "ஸே"),   
    ("so", "ஸொ"),   
    ("sO", "ஸோ"),   
    ("su", "ஸு"),   
    ("sU", "ஸூ"),   
   
    ("s", "ஸ்"),   
   
    ("rau", "ரௌ"),   
    ("rai", "ரை"),   

    ("ra", "ர"),   
    ("ri", "ரி"),   
    ("rI", "ரீ"),   
    ("rA", "ரா"),   
    ("re", "ரெ"),   
    ("rE", "ரே"),   
    ("ro", "ரொ"),   
    ("rO", "ரோ"),   
    ("ru", "ரு"),   
    ("rU", "ரூ"),   
   
    ("r", "ர்"),   
   
    ("Rau", "றௌ"),   
    ("Rai", "றை"),   

    ("Ra", "ற"),   
    ("Ri", "றி"),   
    ("RI", "றீ"),   
    ("RA", "றா"),   
    ("Re", "றெ"),   
    ("RE", "றே"),   
    ("Ro", "றொ"),   
    ("RO", "றோ"),   
    ("Ru", "று"),   
    ("RU", "றூ"),   
   
    ("R", "ற்"),   
   
    ("cau", "சௌ"),   
    ("cai", "சை"),   

    ("ca", "ச"),   
    ("ci", "சி"),   
    ("cI", "சீ"),   
    ("cA", "சா"),   
    ("ce", "செ"),   
    ("cE", "சே"),   
    ("co", "சொ"),   
    ("cO", "சோ"),   
    ("cu", "சு"),   
    ("cU", "சூ"),   
    ("c", "ச்"),      

    ("pau", "பௌ"),   
    ("pai", "பை"),   

    ("pa", "ப"),   
    ("pi", "பி"),   
    ("pI", "பீ"),   
    ("pA", "பா"),   
    ("pe", "பெ"),   
    ("pE", "பே"),   
    ("po", "பொ"),   
    ("pO", "போ"),   
    ("pu", "பு"),   
    ("pU", "பூ"),   
   
    ("p", "ப்"),   
   
    ("bau", "பௌ"),   
    ("bai", "பை"),   

    ("ba", "ப"),   
    ("bi", "பி"),   
    ("bI", "பீ"),   
    ("bA", "பா"),   
    ("be", "பெ"),   
    ("bE", "பே"),   
    ("bo", "பொ"),   
    ("bO", "போ"),   
    ("bu", "பு"),   
    ("bU", "பூ"),   
   
    ("b", "ப்"),   

    ("mau", "மௌ"),   
    ("mai", "மை"),   

    ("ma", "ம"),   
    ("mi", "மி"),   
    ("mI", "மீ"),   
    ("mA", "மா"),   
    ("me", "மெ"),   
    ("mE", "மே"),   
    ("mo", "மொ"),   
    ("mO", "மோ"),   
    ("mu", "மு"),   
    ("mU", "மூ"),   
   
    ("m", "ம்"),   
   
    ("yau", "யௌ"),   
    ("yai", "யை"),   

    ("ya", "ய"),   
    ("yi", "யி"),   
    ("yI", "யீ"),   
    ("yA", "யா"),   
    ("ye", "யெ"),   
    ("yE", "யே"),   
    ("yo", "யொ"),   
    ("yO", "யோ"),   
    ("yu", "யு"),   
    ("yU", "யூ"),   
   
    ("y", "ய்"),  
    ("Tau", "டௌ"),   
    ("Tai", "டை"),   

    ("Ta", "ட"),   
    ("Ti", "டி"),   
    ("TI", "டீ"),   
    ("TA", "டா"),   
    ("Te", "டெ"),   
    ("TE", "டே"),   
    ("To", "டொ"),   
    ("TO", "டோ"),   
    ("Tu", "டு"),   
    ("TU", "டூ"),   
   
    ("T", "ட்"),   
   
    ("n2au", "னௌ"),   
    ("n2ai", "னை"),   

    ("n2a", "ன"),   
    ("n2i", "னி"),   
    ("n2I", "னீ"),   
    ("n2A", "னா"),   
    ("n2e", "னெ"),   
    ("n2E", "னே"),   
    ("n2o", "னொ"),   
    ("n2O", "னோ"),   
    ("n2u", "னு"),   
    ("n2U", "னூ"),   
   
    ("n2", "ன்"),   
    ("n_au", "னௌ"),   
    ("n_ai", "னை"),   

    ("n_a", "ன"),   
    ("n_i", "னி"),   
    ("n_I", "னீ"),   
    ("n_A", "னா"),   
    ("n_e", "னெ"),   
    ("n_E", "னே"),   
    ("n_o", "னொ"),   
    ("n_O", "னோ"),   
    ("n_u", "னு"),   
    ("n_U", "னூ"),   
   
    ("n_", "ன்"),     

    ("Nau", "ணௌ"),   
    ("Nai", "ணை"),   

    ("Na", "ண"),   
    ("Ni", "ணி"),   
    ("NI", "ணீ"),   
    ("NA", "ணா"),   
    ("Ne", "ணெ"),   
    ("NE", "ணே"),   
    ("No", "ணொ"),   
    ("NO", "ணோ"),   
    ("Nu", "ணு"),   
    ("NU", "ணூ"),   
   
    ("N", "ண்"),   
    ("lau", "லௌ"),   
    ("lai", "லை"),   

    ("la", "ல"),   
    ("li", "லி"),   
    ("lI", "லீ"),   
    ("lA", "லா"),   
    ("le", "லெ"),   
    ("lE", "லே"),   
    ("lo", "லொ"),   
    ("lO", "லோ"),   
    ("lu", "லு"),   
    ("lU", "லூ"),   
   
    ("l", "ல்"),   
    ("Lau", "ளௌ"),   
    ("Lai", "ளை"),   
    ("Lee", "ளே"),   
    ("Loo", "ளோ"),   
    ("Laa", "ளா"),   
    ("Luu", "ளூ"),   
    ("Lii", "ளீ"),   
    ("La", "ள"),   
    ("Li", "ளி"),   
    ("LI", "ளீ"),   
    ("LA", "ளா"),   
    ("Le", "ளெ"),   
    ("LE", "ளே"),   
    ("Lo", "ளொ"),   
    ("LO", "ளோ"),   
    ("Lu", "ளு"),   
    ("LU", "ளூ"),   
   
    ("L", "ள்"),   
   
    ("vau", "வௌ"),   
    ("vai", "வை"),   

    ("va", "வ"),   
    ("vi", "வி"),   
    ("vI", "வீ"),   
    ("vA", "வா"),   
    ("ve", "வெ"),   
    ("vE", "வே"),   
    ("vo", "வொ"),   
    ("vO", "வோ"),   
    ("vu", "வு"),   
    ("vU", "வூ"),   
   
    ("v", "வ்"),   
   
    ("au", "ஔ"),   
    ("ai", "ஐ"),   
    ("aa", "ஆ"),   
    ("ee", "ஏ"),   
    ("ii", "ஈ"),   
    ("uu", "ஊ"),   
    ("oo", "ஓ"),   
   
    ("-1000", "௲"),      
    ("-100", "௱"),      
    ("-10", "௰"),   
    ("-1", "௧"),      
    ("-2", "௨"),   
    ("-3", "௩"),      
    ("-4", "௪"),   
    ("-5", "௫"),      
    ("-6", "௬"),   
    ("-7", "௭"),      
    ("-8", "௮"),   
    ("-9", "௯"),      
   
    ("i", "இ"),   
    ("I", "ஈ"),      
    ("a", "அ"),      
    ("A", "ஆ"),      
    ("e", "எ"),   
    ("E", "ஏ"),   
    ("i", "இ"),   
    ("I", "ஈ"),   
    ("u", "உ"),   
    ("U", "ஊ"),   
    ("o", "ஒ"),   
    ("O", "ஓ"),   

    ("H", "ஃ"),   
    ("C", "ஸ்ரீ"),   
    ("n", " ந்"),   
   
    ])   
# end of koeln2utf8 dictionary    

# begin of libi2utf8 dictionary 
libi2utf8 = OrderedDict([ 

    ("ñ", "க்ஷ"),
    ("ñõ", "க்ஷா"),
    ("ò", "க்ஷி"),
    ("ó", "க்ஷீ"),
    ("ñú", "க்ஷு"),
    ("ñü", "க்ஷூ"),
    ("öñ", "க்ஷெ"),
    ("÷ñ", "க்ஷே"),
    ("öñõ", "க்ஷொ"),
    ("÷ñõ", "க்ஷோ"),
    ("öñÍ", "க்ஷௌ"),
    ("øñ", "க்ஷை"),
    ("ô", "க்ஷ்"),
    ("öáÍ", "ஜௌ"),
    ("÷áõ", "ஜோ"),
    ("öáõ", "ஜொ"),
    ("áõ", "ஜா"),
    ("â", "ஜி"),
    ("ã", "ஜீ"),
    ("áú", "ஜு"),
    ("áü", "ஜூ"),
    ("öá", "ஜெ"),
    ("÷á", "ஜே"),
    ("øá", "ஜை"),
    ("ä", "ஜ்"),
    ("á", "ஜ"),

    ("öPÍ", "கௌ"),
    ("÷Põ", "கோ"),
    ("öPõ", "கொ"),
    ("Põ", "கா"),
    ("Q", "கி"),
    ("R", "கீ"),
    ("S", "கு"),
    ("T", "கூ"),
    ("öP", "கெ"),
    ("÷P", "கே"),
    ("øP", "கை"),
    ("U", "க்"),
    ("P", "க"),
    ("öVÍ", "ஙௌ"),
    ("÷Võ", "ஙோ"),
    ("öVõ", "ஙொ"),
    ("Võ", "ஙா"),
    ("W", "ஙி"),
    ("X", "ஙீ"),
    ("Y", "ஙு"),
    ("Z", "ஙூ"),
    ("öV", "ஙெ"),
    ("÷V", "ஙே"),
    ("øV", "ஙை"),
    ("\[", "ங்"),
    ("V", "ங"),

    ("ö\\Í", "சௌ"),
    ("÷\\õ", "சோ"),
    ("ö\\õ", "சொ"),
    ("\\õ", "சா"),
    ("]", "சி"),
    ("\^", "சீ"),
    ("_", "சு"),
    ("`", "சூ"),
    ("ö\\", "செ"),
    ("÷\\", "சே"),
    ("ø\\", "சை"),
    ("a", "ச்"),
    ("\\", "ச"),

    ("öbÍ", "ஞௌ"),
    ("÷bõ", "ஞோ"),
    ("öbõ", "ஞொ"),
    ("bõ", "ஞா"),
    ("c", "ஞி"),
    ("d", "ஞீ"),
    ("e", "ஞு"),
    ("f", "ஞூ"),
    ("öb", "ஞெ"),
    ("÷b", "ஞே"),
    ("øb", "ஞை"),
    ("g", "ஞ்"),
    ("b", "ஞ"),

    ("öhÍ", "டௌ"),
    ("÷hõ", "டோ"),
    ("öhõ", "டொ"),
    ("hõ", "டா"),
    ("i", "டி"),
    ("j", "டீ"),
    ("k", "டு"),
    ("l", "டூ"),
    ("öh", "டெ"),
    ("÷h", "டே"),
    ("øh", "டை"),
    ("m", "ட்"),
    ("h", "ட"),

    ("önÍ", "ணௌ"),
    ("÷nõ", "ணோ"),
    ("önõ", "ணொ"),
    ("nõ", "ணா"),
    ("o", "ணி"),
    ("p", "ணீ"),
    ("q", "ணு"),
    ("r", "ணூ"),
    ("ön", "ணெ"),
    ("÷n", "ணே"),
    ("øn", "ணை"),
    ("s", "ண்"),
    ("n", "ண"),

    ("öuÍ", "தௌ"),
    ("÷uõ", "தோ"),
    ("öuõ", "தொ"),
    ("uõ", "தா"),
    ("v", "தி"),
    ("w", "தீ"),
    ("x", "து"),
    ("y", "தூ"),
    ("öu", "தெ"),
    ("÷u", "தே"),
    ("øu", "தை"),
    ("z", "த்"),
    ("u", "த"),
    ("ö\|Í", "நௌ"),
    ("÷\|õ", "நோ"),
    ("ö\|õ", "நொ"),
    ("\|õ", "நா"),
    ("{", "நி"),
    ("}", "நீ"),
    ("~", "நு"),
    ("¡", "நூ"),
    ("ö\|", "நெ"),
    ("÷\|", "நே"),
    ("ø\|", "நை"),
    ("¢", "ந்"),
    ("\|", "ந"),

    ("öÚÍ", "னௌ"),
    ("÷Úõ", "னோ"),
    ("öÚõ", "னொ"),
    ("Úõ", "னா"),
    ("Û", "னி"),
    ("Ü", "னீ"),
    ("Ý", "னு"),
    ("Þ", "னூ"),
    ("öÚ", "னெ"),
    ("÷Ú", "னே"),
    ("øÚ", "னை"),
    ("ß", "ன்"),
    ("Ú", "ன"),
    ("ö£Í", "பௌ"),
    ("÷£õ", "போ"),
    ("ö£õ", "பொ"),
    ("£õ", "பா"),
    ("¤", "பி"),
    ("¥", "பீ"),
    ("¦", "பு"),
    ("§", "பூ"),
    ("ö£", "பெ"),
    ("÷£", "பே"),
    ("ø£", "பை"),
    ("¨", "ப்"),
    ("£", "ப"),

    ("ö©Í", "மௌ"),
    ("÷©õ", "மோ"),
    ("ö©õ", "மொ"),
    ("©õ", "மா"),
    ("ª", "மி"),
    ("«", "மீ"),
    ("•", "மு"),
    ("‰", "மூ"),
    ("ö©", "மெ"),
    ("÷©", "மே"),
    ("ø©", "மை"),
    ("®", "ம்"),
    ("©", "ம"),

    ("ö¯Í", "யௌ"),
    ("÷¯õ", "யோ"),
    ("ö¯õ", "யொ"),
    ("¯õ", "யா"),
    ("°", "யி"),
    ("±", "யீ"),
    ("²", "யு"),
    ("³", "யூ"),
    ("ö¯", "யெ"),
    ("÷¯", "யே"),
    ("ø¯", "யை"),
    ("´", "ய்"),
    ("¯", "ய"),
    ("öµÍ", "ரௌ"),
    ("÷µõ", "ரோ"),
    ("öµõ", "ரொ"),
    ("µõ", "ரா"),
    ("›", "ரி"),
    ("Ÿ", "ரீ"),
    ("¸", "ரு"),
    ("¹", "ரூ"),
    ("öµ", "ரெ"),
    ("÷µ", "ரே"),
    ("øµ", "ரை"),
    ("º", "ர்"),
    ("µ", "ர"),

    ("ö»Í", "லௌ"),
    ("÷»õ", "லோ"),
    ("ö»õ", "லொ"),
    ("»õ", "லா"),
    ("¼", "லி"),
    ("½", "லீ"),
    ("¾", "லு"),
    ("¿", "லூ"),
    ("ö»", "லெ"),
    ("÷»", "லே"),
    ("ø»", "லை"),
    ("À", "ல்"),
    ("»", "ல"),

    ("öÍÍ", "ளௌ"),
    ("÷Íõ", "ளோ"),
    ("öÍõ", "ளொ"),
    ("Íõ", "ளா"),
    ("Î", "ளி"),
    ("Ï", "ளீ"),
    ("Ð", "ளு"),
    ("Ñ", "ளூ"),
    ("öÍ", "ளெ"),
    ("÷Í", "ளே"),
    ("øÍ", "ளை"),
    ("Ò", "ள்"),
    ("Í", "ள"),

    ("öÁÁ", "வௌ"),
    ("÷Áõ", "வோ"),
    ("öÁõ", "வொ"),
    ("Áõ", "வா"),
    ("Â", "வி"),
    ("Ã", "வீ"),
    ("Ä", "வு"),
    ("Å", "வூ"),
    ("öÁ", "வெ"),
    ("÷Á", "வே"),
    ("øÁ", "வை"),
    ("Æ", "வ்"),
    ("Á", "வ"),

    ("öÇÇ", "ழௌ"),
    ("÷Çõ", "ழோ"),
    ("öÇõ", "ழொ"),
    ("Çõ", "ழா"),
    ("È", "ழி"),
    ("É", "ழீ"),
    ("Ê", "ழு"),
    ("Ë", "ழூ"),
    ("öÇ", "ழெ"),
    ("÷Ç", "ழே"),
    ("øÇ", "ழை"),
    ("Ì", "ழ்"),
    ("Ç", "ழ"),

    ("öÓÓ", "றௌ"),
    ("÷Óõ", "றோ"),
    ("öÓõ", "றொ"),
    ("Óõ", "றா"),
    ("Ô", "றி"),
    ("Õ", "றீ"),
    ("Ö", "று"),
    ("Ë", "×"),
    ("öÓ", "றெ"),
    ("÷Ó", "றே"),
    ("øÓ", "றை"),
    ("Ø", "ற்"),
    ("Ó", "ற"),

    ("öíí", "ஹௌ"),
    ("÷íõ", "ஹோ"),
    ("öíõ", "ஹொ"),
    ("íõ", "ஹா"),
    ("î", "ஹி"),
    ("ï", "ஹீ"),
    ("íú", "ஹு"),
    ("íü", "ஹூ"),
    ("öí", "ஹெ"),
    ("÷í", "ஹே"),
    ("øí", "ஹை"),
    ("ð", "ஹ்"),
    ("í", "ஹ"),

    ("öåå", "ஷௌ"),
    ("÷åõ", "ஷோ"),
    ("öåõ", "ஷொ"),
    ("åõ", "ஷா"),
    ("æ", "ஷி"),
    ("ç", "ஷீ"),
    ("åú", "ஷு"),
    ("åü", "ஷூ"),
    ("öå", "ஷெ"),
    ("÷å", "ஷே"),
    ("øå", "ஷை"),
    ("è", "ஷ்"),
    ("å", "ஷ"),

    ("öéé", "ஸௌ"),
    ("÷éõ", "ஸோ"),
    ("öéõ", "ஸொ"),
    ("éõ", "ஸா"),
    ("ê", "ஸி"),
    ("ë", "ஸீ"),
    ("éú", "ஸு"),
    ("éü", "ஸூ"),
    ("öé", "ஸெ"),
    ("÷é", "ஸே"),
    ("øé", "ஸை"),
    ("ì", "ஸ்"),
    ("é", "ஸ"),

    ("A", "அ"),
    ("B", "ஆ"),
    ("C", "இ"),
    ("D", "ஈ"),
    ("E", "உ"),
    ("F", "ஊ"),
    ("G", "எ"),
    ("H", "ஏ"),
    ("I", "ஐ"),
    ("J", "ஒ"),
    ("K", "ஓ"),
    ("JÍ", "ஔ"),

    ("L", "ஃ"),

    ("ÿ", "ஸ்ரீ"),
    ("&", "-"),
    ("-", ""),
 
    ]) 

# end of libi2utf8 dictionary 

# begin of oldvikatan2utf8 dictionary 
oldvikatan2utf8 = OrderedDict([

    ("d", "க்ஷ"),
    ("d\"", "க்ஷா"),
    ("'d", "க்ஷை"),
    ("«", "க்ஷி"),
    ("»", "க்ஷீ"),
    ("d#", "க்ஷு"),
    ("d$", "க்ஷூ"),
    ("`d", "க்ஷெ"),
    ("&d", "க்ஷே"),
    ("`d\"", "க்ஷொ"),
    ("&d\"", "க்ஷோ"),
    ("`d\[", "க்ஷௌ"),
    ("º", "க்ஷ்"),

    ("`\^\[", "ஜௌ"),
    ("&\^\"", "ஜோ"),
    ("`\^\"", "ஜொ"),
    ("\^\"", "ஜா"),
    ("Õ", "ஜி"),
    ("õ", "ஜீ"),
    ("\^#", "ஜு"),
    ("\^$", "ஜூ"),
    ("`\^", "ஜெ"),
    ("&\^", "ஜே"),
    ("'\^", "ஜை"),
    ("`\^\"", "ஜொ"),
    ("Ò", "ஜ்"),
    ("\^", "ஜ"),
    ("`L\[", "கௌ"),
    ("&L\"", "கோ"),
    ("`L\"", "கொ"),
    ("L\"", "கா"),
    ("f", "கி"),
    ("g", "கீ"),
    ("h", "கு"),
    ("i", "கூ"),
    ("`L", "கெ"),
    ("&L", "கே"),
    ("'L", "கை"),
    ("e", "க்"),
    ("L", "க"),

    ("`M\[", "ஙௌ"),
    ("&M\"", "ஙோ"),
    ("`M\"", "ஙொ"),
    ("M\"", "ஙா"),
    ("›", "ஙி"),
    ("‰", "ஙீ"),
    ("Š", "ஙு"),
    ("š", "ஙூ"), 
    ("`M", "ஙெ"),
    ("&M", "ஙே"),
    ("'M", "ஙை"),
    ("‹", "ங்"),
    ("M", "ங"),

    ("`N\[", "சௌ"),
    ("&N\"", "சோ"),
    ("`N\"", "சொ"),
    ("N\"", "சா"),
    ("p", "சி"),
    ("q", "சீ"),
    ("r", "சு"),
    ("s", "சூ"),
    ("`N", "செ"),
    ("&N", "சே"),
    ("'N", "சை"),
    ("o", "ச்"),
    ("N", "ச"),

    ("`O\[", "ஞௌ"),
    ("&O\"", "ஞோ"),
    ("`O\"", "ஞொ"),
    ("O\"", "ஞா"),
    ("Œ", "ஞி"),
    ("œ", "ஞீ"),
    ("“", "ஞு"),
    ("”", "ஞூ"),
    ("`O", "ஞெ"),
    ("&O", "ஞே"),
    ("'O", "ஞை"),
    ("Ÿ", "ஞ்"),
    ("O", "ஞ"),

    ("`P\[", "டௌ"),
    ("&P\"", "டோ"),
    ("`P\"", "டொ"),
    ("P\"", "டா"),
    ("z", "டி"),
    ("{", "டீ"),
    ("\|", "டு"),
    ("}", "டூ"),
    ("`P", "டெ"),
    ("&P", "டே"),
    ("'P", "டை"),
    ("y", "ட்"),
    ("P", "ட"),

    ("`Q\[", "ணௌ"),
    ("&Q\"", "ணோ"),
    ("`Q\"", "ணொ"),
    ("Q\"", "ணா"),
    ("Â", "ணி"),
    ("È", "ணீ"),
    ("Ê", "ணு"),
    ("Ë", "ணூ"),
    ("`Q", "ணெ"),
    ("&Q", "ணே"),
    ("'Q", "ணை"),
    ("`Q\"", "ணொ"),
    ("À", "ண்"),
    ("Q", "ண"),

    ("`R\[", "தௌ"),
    ("&R\"", "தோ"),
    ("`R\"", "தொ"),
    ("R\"", "தா"),
    ("Ï", "தி"),
    ("©", "தீ"),
    ("®", "து"),
    ("_", "தூ"),
    ("`R", "தெ"),
    ("&R", "தே"),
    ("'R", "தை"),
    ("Î", "த்"),
    ("R", "த"),
    ("`S\[", "நௌ"),
    ("&S\"", "நோ"),
    ("`S\"", "நொ"),
    ("S\"", "நா"),
    ("k", "நி"),
    ("Ù", "நீ"),
    ("Û", "நு"),
    ("l", "நூ"),
    ("`S", "நெ"),
    ("&S", "நே"),
    ("'S", "நை"),
    ("`S\"", "நொ"),
    ("j", "ந்"),
    ("S", "ந"),
    ("`]\[", "னௌ"),
    ("&]\"", "னோ"),
    ("`]\"", "னொ"),
    ("]\"", "னா"),
    ("Á", "னி"),
    ("Ã", "னீ"),
    ("ã", "னு"),
    ("Ó", "னூ"),
    ("`]", "னெ"),
    ("&]", "னே"),
    ("']", "னை"),
    ("`]\"", "னொ"),
    ("Ô", "ன்"),
    ("]", "ன"),
    ("`T\[", "பௌ"),
    ("&T\"", "போ"),
    ("`T\"", "பொ"),
    ("T\"", "பா"),
    ("n", "பி"),
    ("t", "பீ"),
    ("Ç", "பு"),
    ("ç", "பூ"),
    ("`T", "பெ"),
    ("&T", "பே"),
    ("'T", "பை"),
    ("`T\"", "பொ"),
    ("m", "ப்"),
    ("T", "ப"),

    ("`U\[", "மௌ"),
    ("&U\"", "மோ"),
    ("`U\"", "மொ"),
    ("U\"", "மா"),
    ("ñ", "மி"),

    ("¿", "மு"),
    ("¤", "மூ"),
    ("`U", "மெ"),
    ("&U", "மே"),
    ("'U", "மை"),
    ("`U\"", "மொ"),
    ("Ñ", "ம்"),
    ("U", "ம"),

    ("`V\[", "யௌ"),
    ("&V\"", "யோ"),
    ("`V\"", "ய"),
    ("V\"", "யா"),
    ("¥", "யி"),

    ("u", "யு"),
    ("¢", "யூ"),
    ("`V", "யெ"),
    ("&V", "யே"),
    ("'V", "யை"),
    ("`V\"", "யொ"),
    ("£", "ய்"),
    ("V", "ய"),
    ("`W\[", "ரௌ"),
    ("&W\"", "ரோ"),
    ("`W\"", "ரொ"),
    ("W\"", "ரா"),
    ("ê", "ரி"),
    ("ô", "ரீ"),
    ("û", "ரு"),
    ("á", "ரூ"),
    ("`W", "ரெ"),
    ("&W", "ரே"),
    ("'W", "ரை"),
    ("â", "ர்"),
    ("W", "ர"),

    ("`X\[", "லௌ"),
    ("&X\"", "லோ"),
    ("`X\"", "லொ"),
    ("X\"", "லா"),
    ("ó", "லி"),
    ("ú", "லீ"),
    ("à", "லு"),
    ("è", "லூ"),
    ("`X", "லெ"),
    ("&X", "லே"),
    ("'X", "லை"),
    ("`X\"", "லொ"),
    ("é", "ல்"),
    ("X", "ல"),

    ("`\[\[", "ளௌ"),
    ("&\[\"", "ளோ"),
    ("`\[\"", "ள"),
    ("\[\"", "ளா"),
    ("í", "ளி"),
    ("ø", "ளீ"),
    ("Ä", "ளு"),
    ("ì", "ளூ"),
    ("`\[", "ளெ"),
    ("&\[", "ளே"),
    ("'\[", "ளை"),
    ("å", "ள்"),
    ("\[", "ள"),

    ("`Y\[", "வௌ"),
    ("&Y\"", "வோ"),
    ("`Y\"", "வொ"),
    ("Y\"", "வா"),
    ("ù", "வி"),
    ("ä", "வீ"),
    ("ë", "வு"),
    ("ö", "வூ"),
    ("`Y", "வெ"),
    ("&Y", "வே"),
    ("'Y", "வை"),
    ("`Y\"", "வொ"),
    ("ò", "வ்"),
    ("Y", "வ"),

    ("`Z\[", "ழௌ"),
    ("&Z\"", "ழோ"),
    ("`Z\"", "ழொ"),
    ("Z\"", "ழா"),
    ("Å", "ழி"),
    ("î", "ழீ"),
    ("Ø", "ழு"),
    ("Æ", "ழூ"),
    ("`Z", "ழெ"),
    ("&Z", "ழே"),
    ("'Z", "ழை"),
    ("ü", "ழ்"),
    ("Z", "ழ"),
    ("\`\\\[", "றௌ"),
    ("&\\\"", "றோ"),
    ("\`\\\"", "றொ"),
    ("\\\"", "றா"),
    ("Ü", "றி"),
    ("É", "றீ"),
    ("ï", "று"),
    ("ß", "றூ"),
    ("`\\", "றெ"),
    ("&\\", "றே"),
    ("'\\", "றை"),
    ("`\\\"", "றொ"),
    ("Ö", "ற்"),
    ("\\", "ற"),

    ("`a\[", "ஹௌ"),
    ("&a\"", "ஹோ"),
    ("`a\"", "ஹொ"),
    ("a\"", "ஹா"),
    ("w", "ஹி"),
    ("Ú", "ஹீ"),
    ("`a", "ஹெ"),
    ("&a", "ஹே"),
    ("'a", "ஹை"),
    ("v", "ஹ்"),
    ("a", "ஹ"),

    ("`c\[", "ஷௌ"),
    ("&c\"", "ஷோ"),
    ("`c\"", "ஷொ"),
    ("c\"", "ஷா"),

    ("ª", "ஷீ"),
    ("`c", "ஷெ"),
    ("&c", "ஷே"),
    ("'c", "ஷை"),
    ("`c\"", "ஷொ"),
    ("Ì", "ஷ்"),
    ("c", "ஷ"),
    ("`b\[", "ஸௌ"),
    ("&b\"", "ஸோ"),
    ("`b\"", "ஸொ"),
    ("b\"", "ஸா"),
    ("ÿ", "ஸி"),
    ("Í", "ஸீ"),
    ("`b", "ஸெ"),
    ("&b", "ஸே"),
    ("'b", "ஸை"),
    ("x", "ஸ்"),
    ("b", "ஸ"),

    ("A", "அ"),
    ("B", "ஆ"),
    ("C", "இ"),
    ("D", "ஈ"),
    ("E", "உ"),
    ("F", "ஊ"),
    ("G", "எ"),
    ("H", "ஏ"),
    ("I", "ஐ"),
    ("J", "ஒ"),
    ("K", "ஓ"),
    ("J\[", "ஔ"),

    ("¡", "மீ"),
    ("¶", "ஷி"),
    ("§", "யீ"),

    ("@", "ஃ"),

    ("~", "ஸ்ரீ"),
    ("ƒ", "‘"),
    ("†", "'"),
    ("…", "'"),
    ("º", "க்ஸ்"),
    ("d", "க்ஸ"),
    ("«", "க்ஸி"),
    ("»", "க்ஸீ"),
    (">", "-"),


    ])
# end of oldvikatan2utf8 dictionary 

# begin of webulagam2utf8 dictionary   
webulagam2utf8 = OrderedDict([      
   
    ("B", "க்ஷ"),
    ("Bh", "க்ஷா"),
    ("iB", "க்ஷை"),
    ("ø", "க்ஷி"),
    ("ì", "க்ஷீ"),
    ("B&", "க்ஷு"),
    ("B\]", "க்ஷூ"),
    ("bB", "க்ஷெ"),
    ("nB", "க்ஷே"),
    ("bBh", "க்ஷொ"),
    ("nBh", "க்ஷோ"),
    ("bBs", "க்ஷௌ"),
    ("º", "க்ஷ்"),  
 
    ("b#s", "ஜௌ"),
    ("n#h", "ஜோ"),
    ("b#h", "ஜொ"),
    ("#h", "ஜா"),
    ("Í", "ஜி"),
    ("é", "ஜீ"),
    ("#&", "ஜு"),
    ("#]", "ஜூ"),
    ("b#", "ஜெ"),
    ("n#", "ஜே"),
    ("i#", "ஜை"),
    ("{", "ஜ்"),
    ("#", "ஜ"),

    ("bfs", "கௌ"),
    ("nfh", "கோ"),
    ("bfh", "கொ"),
    ("fh", "கா"),
    ("»", "கி"),
    ("Ñ", "கீ"),
    ("F", "கு"),
    ("T", "கூ"),
    ("bf", "கெ"),
    ("nf", "கே"),
    ("if", "கை"),
    ("¡", "க்"),
    ("f", "க"),

    ("b‡s", "ஙௌ"),
    ("n‡h", "ஙோ"),
    ("b‡h", "ஙொ"),
    ("‡h", "ஙா"),
    ("À", "ஙி"),
    ("†", "ஙீ"),
    ("¼", "ஙு"),
    ("½", "ஙூ"),
    ("b‡", "ஙெ"),
    ("n‡", "ஙே"),
    ("i‡", "ஙை"),
    ("§", "ங்"),
    ("‡", "ங"),

    ("brs", "சௌ"),
    ("nrh", "சோ"),
    ("brh", "சொ"),
    ("rh", "சா"),
    ("á", "சி"),
    ("Ó", "சீ"),
    ("R", "சு"),
    ("N", "சூ"),
    ("br", "செ"),
    ("nr", "சே"),
    ("ir", "சை"),
    ("¢", "ச்"),
    ("r", "ச"),
    ("bPs", "ஞௌ"),
    ("nPh", "ஞோ"),
    ("bPh", "ஞொ"),
    ("Ph", "ஞா"),
    ("Á", "ஞி"),
    ("Ø", "ஞீ"),
    ("\|", "ஞு"),
    ("ú", "ஞூ"),
    ("bP", "ஞெ"),
    ("nP", "ஞே"),
    ("iP", "ஞை"),
    ("Š", "ஞ்"),
    ("P", "ஞ"),

    ("bls", "டௌ"),
    ("nlh", "டோ"),
    ("blh", "டொ"),
    ("lh", "டா"),
    ("o", "டி"),
    ("O", "டீ"),
    ("L", "டு"),
    ("\^", "டூ"),
    ("bl", "டெ"),
    ("nl", "டே"),
    ("il", "டை"),
    ("£", "ட்"),
    ("l", "ட"),

    ("bzs", "ணௌ"),
    ("nzh", "ணோ"),
    ("bzh", "ணொ"),
    ("zh", "ணா"),
    ("Â", "ணி"),
    ("Ù", "ணீ"),
    ("Q", "ணு"),
    ("û", "ணூ"),
    ("bz", "ணெ"),
    ("nz", "ணே"),
    ("iz", "ணை"),
    ("©", "ண்"),
    ("z", "ண"),

    ("bjs", "தௌ"),
    ("njh", "தோ"),
    ("bjh", "தொ"),
    ("jh", "தா"),
    ("â", "தி"),
    ("Ô", "தீ"),
    ("J", "து"),
    ("ö", "தூ"),
    ("bj", "தெ"),
    ("nj", "தே"),
    ("ij", "தை"),
    ("¤", "த்"),
    ("j", "த"),

    ("bes", "நௌ"),
    ("neh", "நோ"),
    ("beh", "நொ"),
    ("eh", "நா"),
    ("Ã", "நி"),
    ("Ú", "நீ"),
    ("E", "நு"),
    ("ü", "நூ"),
    ("be", "நெ"),
    ("ne", "நே"),
    ("ie", "நை"),
    ("ª", "ந்"),
    ("e", "ந"),

    ("bds", "னௌ"),
    ("ndh", "னோ"),
    ("bdh", "னொ"),
    ("dh", "னா"),
    ("Å", "னி"),
    ("Ü", "னீ"),
    ("D", "னு"),
    ("}", "னூ"),
    ("bd", "னெ"),
    ("nd", "னே"),
    ("id", "னை"),
    ("‹", "ன்"),
    ("d", "ன"),

    ("bgs", "பௌ"),
    ("ngh", "போ"),
    ("bgh", "பொ"),
    ("gh", "பா"),
    ("ã", "பி"),
    ("Õ", "பீ"),
    ("ò", "பு"),
    ("ó", "பூ"),
    ("bg", "பெ"),
    ("ng", "பே"),
    ("ig", "பை"),
    ("¥", "ப்"),
    ("g", "ப"),

    ("bks", "மௌ"),
    ("nkh", "மோ"),
    ("bkh", "மொ"),
    ("kh", "மா"),
    ("Ä", "மி"),
    ("Û", "மீ"),
    ("K", "மு"),
    ("_", "மூ"),
    ("bk", "மெ"),
    ("nk", "மே"),
    ("ik", "மை"),
    ("«", "ம்"),
    ("k", "ம"),

    ("bas", "யௌ"),
    ("nah", "யோ"),
    ("bah", "யொ"),
    ("ah", "யா"),
    ("Æ", "யி"),
    ("p", "யீ"),
    ("í", "யு"),
    ("ô", "யூ"),
    ("ba", "யெ"),
    ("na", "யே"),
    ("ia", "யை"),
    ("Œ", "ய்"),
    ("a", "ய"),

    ("bus", "ரௌ"),
    ("nuh", "ரோ"),
    ("buh", "ரொ"),
    ("uh", "ரா"),
    ("Ç", "ரி"),
    ("ß", "ரீ"),
    ("U", "ரு"),
    ("%", "ரூ"),
    ("bu", "ரெ"),
    ("nu", "ரே"),
    ("iu", "ரை"),
    ("®", "ர்"),
    ("u", "ர"),

    ("bys", "லௌ"),
    ("nyh", "லோ"),
    ("byh", "லொ"),
    ("yh", "லா"),
    ("È", "லி"),
    ("ä", "லீ"),
    ("Y", "லு"),
    ("ÿ", "லூ"),
    ("by", "லெ"),
    ("ny", "லே"),
    ("iy", "லை"),
    ("š", "ல்"),
    ("y", "ல"),

    ("bss", "ளௌ"),
    ("nsh", "ளோ"),
    ("bsh", "ளொ"),
    ("sh", "ளா"),
    ("Ë", "ளி"),
    ("ç", "ளீ"),
    ("S", "ளு"),
    ("q", "ளூ"),
    ("bs", "ளெ"),
    ("ns", "ளே"),
    ("is", "ளை"),
    ("Ÿ", "ள்"),
    ("s", "ள"),

    ("bts", "வௌ"),
    ("nth", "வோ"),
    ("bth", "வொ"),
    ("th", "வா"),
    ("É", "வி"),
    ("å", "வீ"),
    ("î", "வு"),
    ("ñ", "வூ"),
    ("bt", "வெ"),
    ("nt", "வே"),
    ("it", "வை"),
    ("›", "வ்"),
    ("t", "வ"),

    ("bHs", "ழௌ"),
    ("nHh", "ழோ"),
    ("bHh", "ழொ"),
    ("Hh", "ழா"),
    ("Ê", "ழி"),
    ("æ", "ழீ"),
    ("G", "ழு"),
    (">", "ழூ"),
    ("bH", "ழெ"),
    ("nH", "ழே"),
    ("iH", "ழை"),
    ("œ", "ழ்"),
    ("H", "ழ"),

    ("bws", "றௌ"),
    ("nwh", "றோ"),
    ("bwh", "றொ"),
    ("wh", "றா"),
    ("¿", "றி"),
    ("Ö", "றீ"),
    ("W", "று"),
    ("ù", "றூ"),
    ("bw", "றெ"),
    ("nw", "றே"),
    ("iw", "றை"),
    ("‰", "ற்"),
    ("w", "ற"),

    ("bAs", "ஹௌ"),
    ("nAh", "ஹோ"),
    ("bAh", "ஹொ"),
    ("Ah", "ஹா"),
    ("Ï", "ஹி"),
    ("ë", "ஹீ"),
    ("A&", "ஹு"),
    ("A\]", "ஹூ"),
    ("bA", "ஹெ"),
    ("nA", "ஹே"),
    ("iA", "ஹை"),
    ("à", "ஹ்"),
    ("A", "ஹ"),

    ("bõs", "ஷௌ"),
    ("nõh", "ஷோ"),
    ("bõh", "ஷொ"),
    ("õh", "ஷா"),
    ("Î", "ஷி"),
    ("ê", "ஷீ"),
    ("õ&", "ஷு"),
    ("õ]", "ஷூ"),
    ("bõ", "ஷெ"),
    ("nõ", "ஷே"),
    ("iõ", "ஷை"),
    ("Z", "ஷ்"),
    ("õ", "ஷ"),

    ("b\[s", "ஸௌ"),
    ("n\[h", "ஸோ"),
    ("b\[h", "ஸொ"),
    ("\[h", "ஸா"),
    ("Ì", "ஸி"),
    ("è", "ஸீ"),
    ("\[&", "ஸு"),
    ("\[\]", "ஸூ"),
    ("b\[", "ஸெ"),
    ("n\[", "ஸே"),
    ("i\[", "ஸை"),
    ("Þ", "ஸ்"),
    ("\[", "ஸ"),

    ("m", "அ"),
    ("M", "ஆ"),
    ("ï", "இ"),
    ("<", "ஈ"),
    ("c", "உ"),
    ("C", "ஊ"),
    ("v", "எ"),
    ("V", "ஏ"),
    ("I", "ஐ"),
    ("x", "ஒ"),
    ("X", "ஓ"),
    ("xs", "ஔ"),

    ("~", "ஃ"),
    ("\$", "ஸ்ரீ"),
    ("˜", "?"),
   
    ])   
# end of webulagam3utf8 dictionary   

# begin of diacritic2utf8 dictionary
diacritic2utf8 = OrderedDict([
    ("kṣau", "க்ஷௌ"),
    ("kṣai", "க்ஷை"),
    ("kṣō", "க்ஷோ"),
    ("ṇau", "ணௌ"),
    ("lau", "லௌ"),
    ("ṟau", "றௌ"),
    ("rau", "ரௌ"),
    ("vau", "வௌ"),
    ("ḷau", "ளௌ"),
    ("cau", "சௌ"),
    ("ñau", "ஞௌ"),
    ("ṣau", "ஷௌ"),
    ("ṭau", "டௌ"),
    ("mau", "மௌ"),
    ("tau", "தௌ"),
    ("ḻau", "ழௌ"),
    ("pau", "பௌ"),
    ("kau", "கௌ"),
    ("nau", "நௌ"),
    ("ṉau", "னௌ"),
    ("kṣo", "க்ஷொ"),
    ("yau", "யௌ"),
    ("hau", "ஹௌ"),
    ("ṅau", "ஙௌ"),
    ("sau", "ஸௌ"),
    ("jau", "ஜௌ"),
    ("kṣē", "க்ஷே"),
    ("ṇai", "ணை"),
    ("lai", "லை"),
    ("ṟai", "றை"),
    ("rai", "ரை"),
    ("vai", "வை"),
    ("ḷai", "ளை"),
    ("cai", "சை"),
    ("ñai", "ஞை"),
    ("ṣai", "ஷை"),
    ("ṭai", "டை"),
    ("mai", "மை"),
    ("tai", "தை"),
    ("ḻai", "ழை"),
    ("pai", "பை"),
    ("kai", "கை"),
    ("nai", "நை"),
    ("ṉai", "னை"),
    ("yai", "யை"),
    ("hai", "ஹை"),
    ("ṅai", "ஙை"),
    ("sai", "ஸை"),
    ("jai", "ஜை"),
    ("kṣā", "க்ஷா"),
    ("kṣe", "க்ஷெ"),
    ("kṣū", "க்ஷூ"),
    ("kṣu", "க்ஷு"),
    ("kṣi", "க்ஷி"),
    ("kṣī", "க்ஷீ"),
    ("kṣa", "க்ஷ"),
    ("šrī", "ஸ்ரீ"),
    ("ḷō", "ளோ"),
    ("ḷo", "ளொ"),
    ("ḷā", "ளா"),
    ("ḷi", "ளி"),
    ("ḷī", "ளீ"),
    ("ṇō", "ணோ"),
    ("lō", "லோ"),
    ("ṟō", "றோ"),
    ("rō", "ரோ"),
    ("vō", "வோ"),
    ("cō", "சோ"),
    ("ñō", "ஞோ"),
    ("ṣō", "ஷோ"),
    ("ṭō", "டோ"),
    ("mō", "மோ"),
    ("tō", "தோ"),
    ("ḻō", "ழோ"),
    ("pō", "போ"),
    ("kō", "கோ"),
    ("nō", "நோ"),
    ("ṉō", "னோ"),
    ("yō", "யோ"),
    ("hō", "ஹோ"),
    ("ṅō", "ஙோ"),
    ("sō", "ஸோ"),
    ("jō", "ஜோ"),
    ("ṇo", "ணொ"),
    ("lo", "லொ"),
    ("ṟo", "றொ"),
    ("ro", "ரொ"),
    ("vo", "வொ"),
    ("co", "சொ"),
    ("ño", "ஞொ"),
    ("ṣo", "ஷொ"),
    ("ṭo", "டொ"),
    ("mo", "மொ"),
    ("to", "தொ"),
    ("ḻo", "ழொ"),
    ("po", "பொ"),
    ("ko", "கொ"),
    ("no", "நொ"),
    ("ṉo", "னொ"),
    ("yo", "யொ"),
    ("ho", "ஹொ"),
    ("ṅo", "ஙொ"),
    ("so", "ஸொ"),
    ("jo", "ஜொ"),
    ("ṇā", "ணா"),
    ("lā", "லா"),
    ("au", "ஔ"),
    ("ṟā", "றா"),
    ("rā", "ரா"),
    ("vā", "வா"),
    ("cā", "சா"),
    ("ñā", "ஞா"),
    ("ṣā", "ஷா"),
    ("ṣū", "ஷூ"),
    ("ṣu", "ஷு"),
    ("ṇē", "ணே"),
    ("lē", "லே"),
    ("ṟē", "றே"),
    ("rē", "ரே"),
    ("vē", "வே"),
    ("ḷē", "ளே"),
    ("cē", "சே"),
    ("ñē", "ஞே"),
    ("ṣē", "ஷே"),
    ("ṭē", "டே"),
    ("mē", "மே"),
    ("tē", "தே"),
    ("ḻē", "ழே"),
    ("pē", "பே"),
    ("kē", "கே"),
    ("nē", "நே"),
    ("ṉē", "னே"),
    ("yē", "யே"),
    ("hē", "ஹே"),
    ("ṅē", "ஙே"),
    ("sē", "ஸே"),
    ("jē", "ஜே"),
    ("ṭā", "டா"),
    ("mā", "மா"),
    ("tā", "தா"),
    ("ḻā", "ழா"),
    ("pā", "பா"),
    ("kā", "கா"),
    ("nā", "நா"),
    ("ṉā", "னா"),
    ("ṇe", "ணெ"),
    ("le", "லெ"),
    ("ṟe", "றெ"),
    ("re", "ரெ"),
    ("ve", "வெ"),
    ("ḷe", "ளெ"),
    ("ce", "செ"),
    ("ñe", "ஞெ"),
    ("ṣe", "ஷெ"),
    ("ṭe", "டெ"),
    ("me", "மெ"),
    ("te", "தெ"),
    ("ḻe", "ழெ"),
    ("pe", "பெ"),
    ("ke", "கெ"),
    ("ne", "நெ"),
    ("ṉe", "னெ"),
    ("ye", "யெ"),
    ("he", "ஹெ"),
    ("ṅe", "ஙெ"),
    ("se", "ஸெ"),
    ("je", "ஜெ"),
    ("yā", "யா"),
    ("hā", "ஹா"),
    ("hū", "ஹூ"),
    ("hu", "ஹு"),
    ("ṅā", "ஙா"),
    ("sā", "ஸா"),
    ("sū", "ஸூ"),
    ("su", "ஸு"),
    ("jā", "ஜா"),
    ("jū", "ஜூ"),
    ("ju", "ஜு"),
    ("ṇa", "ண"),
    ("lū", "லூ"),
    ("lu", "லு"),
    ("la", "ல"),
    ("ṟu", "று"),
    ("ṟa", "ற"),
    ("ṉī", "னீ"),
    ("nū", "நூ"),
    ("mī", "மீ"),
    ("ṇū", "ணூ"),
    ("ṇī", "ணீ"),
    ("ṟū", "றூ"),
    ("nī", "நீ"),
    ("ñū", "ஞூ"),
    ("ru", "ரு"),
    ("ra", "ர"),
    ("kū", "கூ"),
    ("va", "வ"),
    ("rī", "ரீ"),
    ("ḷu", "ளு"),
    ("ḷa", "ள"),
    ("cu", "சு"),
    ("ca", "ச"),
    ("ṇu", "ணு"),
    ("ḷū", "ளூ"),
    ("yī", "யீ"),
    ("ña", "ஞ"),
    ("ñī", "ஞீ"),
    ("pī", "பீ"),
    ("ṣa", "ஷ"),
    ("ṟī", "றீ"),
    ("tū", "தூ"),
    ("tī", "தீ"),
    ("yū", "யூ"),
    ("pu", "பு"),
    ("cī", "சீ"),
    ("pū", "பூ"),
    ("kṣ", "க்ஷ்"),
    ("ṭi", "டி"),
    ("ṭī", "டீ"),
    ("kī", "கீ"),
    ("vū", "வூ"),
    ("cū", "சூ"),
    ("ṭu", "டு"),
    ("ṭa", "ட"),
    ("mu", "மு"),
    ("ma", "ம"),
    ("tu", "து"),
    ("ta", "த"),
    ("hi", "ஹி"),
    ("ṣi", "ஷி"),
    ("vu", "வு"),
    ("si", "ஸி"),
    ("ji", "ஜி"),
    ("yu", "யு"),
    ("ai", "ஐ"),
    ("ḻa", "ழ"),
    ("ḻu", "ழு"),
    ("pa", "ப"),
    ("ku", "கு"),
    ("ka", "க"),
    ("hī", "ஹீ"),
    ("ḻi", "ழி"),
    ("ṣī", "ஷீ"),
    ("li", "லி"),
    ("sī", "ஸீ"),
    ("vi", "வி"),
    ("jī", "ஜீ"),
    ("nu", "நு"),
    ("na", "ந"),
    ("ṉu", "னு"),
    ("ṉa", "ன"),
    ("ri", "ரி"),
    ("yi", "யி"),
    ("ḻī", "ழீ"),
    ("ṉi", "னி"),
    ("vī", "வீ"),
    ("ni", "நி"),
    ("pi", "பி"),
    ("mi", "மி"),
    ("lī", "லீ"),
    ("ṇi", "ணி"),
    ("ti", "தி"),
    ("ṅi", "ஙி"),
    ("ci", "சி"),
    ("ñi", "ஞி"),
    ("ya", "ய"),
    ("ha", "ஹ"),
    ("ṅū", "ஙூ"),
    ("ṅu", "ஙு"),
    ("ṅa", "ங"),
    ("ṅī", "ஙீ"),
    ("ki", "கி"),
    ("ḻū", "ழூ"),
    ("ṟi", "றி"),
    ("ṉū", "னூ"),
    ("ñu", "ஞு"),
    ("mū", "மூ"),
    ("ṭū", "டூ"),
    ("sa", "ஸ"),
    ("rū", "ரூ"),
    ("ja", "ஜ"),
    ("ṣ", "ஷ்"),
    ("ḷ", "ள்"),
    ("o", "ஒ"),
    ("ō", "ஓ"),
    ("e", "எ"),
    ("ē", "ஏ"),
    ("ñ", "ஞ்"),
    ("l", "ல்"),
    ("y", "ய்"),
    ("ḻ", "ழ்"),
    ("a", "அ"),
    ("ā", "ஆ"),
    ("i", "இ"),
    ("u", "உ"),
    ("ū", "ஊ"),
    ("h", "ஹ்"),
    ("n", "ந்"),
    ("ṟ", "ற்"),
    ("s", "ஸ்"),
    ("r", "ர்"),
    ("ṇ", "ண்"),
    ("ṅ", "ங்"),
    ("p", "ப்"),
    ("t", "த்"),
    ("ṭ", "ட்"),
    ("c", "ச்"),
    ("m", "ம்"),
    ("=", "="),
    ("ī", "ஈ"),
    ("+", "+"),
    ("v", "வ்"),
    ("ṉ", "ன்"),    
    ("k", "க்"),
    ("ḵ", "ஃ"),
    ("j", "ஜ்"),
    ])
# end of diacritic2utf8 dictionary

# begin of shreelipi2utf8 dictionary
shreelipi2utf8 = OrderedDict([
    ("÷Íõ", "ளோ"),
    ("öÍõ", "ளொ"),
    ("Íõ", "ளா"),
    ("Î", "ளி"),
    ("Ï", "ளீ"),
    ("öVõ", "ஙொ"),
    ("öVÍ", "ஙௌ"),
    ("öÚõ", "னொ"),
    ("öuõ", "தொ"),
    ("öÚÍ", "னௌ"),
    ("öuÍ", "தௌ"),
    ("öPõ", "கொ"),
    ("öPÍ", "கௌ"),
    ("öÓõ", "றொ"),
    ("öÓÍ", "றௌ"),
    ("öñõ", "க்ஷொ"),
    ("önõ", "ணொ"),
    ("öñÍ", "க்ஷௌ"),
    ("önÍ", "ணௌ"),
    ("öíõ", "ஹொ"),
    ("öÍÍ", "ளௌ"),
    ("öíÍ", "ஹௌ"),
    ("öhõ", "டொ"),
    ("öhÍ", "டௌ"),
    ("öéõ", "ஸொ"),
    ("öéÍ", "ஸௌ"),
    ("öÇõ", "ழொ"),
    ("öÇÍ", "ழௌ"),
    ("öbõ", "ஞொ"),
    ("öbÍ", "ஞௌ"),
    ("öåõ", "ஷொ"),
    ("öÁõ", "வொ"),
    ("öáõ", "ஜொ"),
    ("öåÍ", "ஷௌ"),
    ("öÁÍ", "வௌ"),
    ("öáÍ", "ஜௌ"),
    ("öµõ", "ரொ"),
    ("öµÍ", "ரௌ"),
    ("ö©õ", "மொ"),
    ("ö©Í", "மௌ"),
    ("ö£õ", "பொ"),
    ("ö£Í", "பௌ"),
    ("ö»õ", "லொ"),
    ("ö»Í", "லௌ"),
    ("ö¯õ", "யொ"),
    ("ö¯Í", "யௌ"),
    ("ö|õ", "நொ"),
    ("ö|Í", "நௌ"),
    ("ö\õ", "சொ"),
    ("ö\Í", "சௌ"),
    ("÷Võ", "ஙோ"),
    ("÷Úõ", "னோ"),
    ("÷uõ", "தோ"),
    ("÷Põ", "கோ"),
    ("÷Óõ", "றோ"),
    ("÷ñõ", "க்ஷோ"),
    ("÷nõ", "ணோ"),
    ("÷íõ", "ஹோ"),
    ("÷hõ", "டோ"),
    ("÷éõ", "ஸோ"),
    ("÷Çõ", "ழோ"),
    ("÷bõ", "ஞோ"),
    ("÷åõ", "ஷோ"),
    ("÷Áõ", "வோ"),
    ("÷áõ", "ஜோ"),
    ("÷µõ", "ரோ"),
    ("÷©õ", "மோ"),
    ("÷£õ", "போ"),
    ("÷»õ", "லோ"),
    ("÷¯õ", "யோ"),
    ("÷|õ", "நோ"),
    ("÷\õ", "சோ"),
    ("Võ", "ஙா"),
    ("Úõ", "னா"),
    ("uõ", "தா"),
    ("Põ", "கா"),
    ("øV", "ஙை"),
    ("öV", "ஙெ"),
    ("øÚ", "னை"),
    ("øu", "தை"),
    ("öÚ", "னெ"),
    ("öu", "தெ"),
    ("øP", "கை"),
    ("öP", "கெ"),
    ("øÓ", "றை"),
    ("öÓ", "றெ"),
    ("Óõ", "றா"),
    ("øñ", "க்ஷை"),
    ("øn", "ணை"),
    ("öñ", "க்ஷெ"),
    ("ön", "ணெ"),
    ("øÍ", "ளை"),
    ("øí", "ஹை"),
    ("öÍ", "ளெ"),
    ("öí", "ஹெ"),
    ("øh", "டை"),
    ("öh", "டெ"),
    ("øé", "ஸை"),
    ("öé", "ஸெ"),
    ("øÇ", "ழை"),
    ("öÇ", "ழெ"),
    ("øb", "ஞை"),
    ("öb", "ஞெ"),
    ("øå", "ஷை"),
    ("øÁ", "வை"),
    ("øá", "ஜை"),
    ("öå", "ஷெ"),
    ("öÁ", "வெ"),
    ("öá", "ஜெ"),
    ("øµ", "ரை"),
    ("öµ", "ரெ"),
    ("ø©", "மை"),
    ("ö©", "மெ"),
    ("ø£", "பை"),
    ("ö£", "பெ"),
    ("ø»", "லை"),
    ("ö»", "லெ"),
    ("ø¯", "யை"),
    ("ö¯", "யெ"),
    ("ø|", "நை"),
    ("ö|", "நெ"),
    ("ø\\", "சை"),
    ("ö\\", "செ"),
    ("ñü", "க்ஷூ"),
    ("ñú", "க்ஷு"),
    ("ñõ", "க்ஷா"),
    ("nõ", "ணா"),
    ("JÍ", "ஔ"),
    ("íü", "ஹூ"),
    ("íú", "ஹு"),
    ("íõ", "ஹா"),
    ("hõ", "டா"),
    ("éü", "ஸூ"),
    ("éú", "ஸு"),
    ("éõ", "ஸா"),
    ("Çõ", "ழா"),
    ("bõ", "ஞா"),
    ("åü", "ஷூ"),
    ("åú", "ஷு"),
    ("áü", "ஜூ"),
    ("áú", "ஜு"),
    ("åõ", "ஷா"),
    ("Áõ", "வா"),
    ("áõ", "ஜா"),
    ("µõ", "ரா"),
    ("©õ", "மா"),
    ("£õ", "பா"),
    ("÷V", "ஙே"),
    ("÷Ú", "னே"),
    ("÷u", "தே"),
    ("÷P", "கே"),
    ("÷Ó", "றே"),
    ("÷ñ", "க்ஷே"),
    ("÷n", "ணே"),
    ("÷Í", "ளே"),
    ("÷í", "ஹே"),
    ("÷h", "டே"),
    ("÷é", "ஸே"),
    ("÷Ç", "ழே"),
    ("÷b", "ஞே"),
    ("÷å", "ஷே"),
    ("÷Á", "வே"),
    ("÷á", "ஜே"),
    ("÷µ", "ரே"),
    ("÷©", "மே"),
    ("÷£", "பே"),
    ("÷»", "லே"),
    ("÷¯", "யே"),
    ("÷|", "நே"),
    ("÷\\", "சே"),
    ("»õ", "லா"),
    ("¯õ", "யா"),
    ("|õ", "நா"),
    ("\õ", "சா"),
    ("\"\"", "“"),
    ("\'\'", "”"),
    ("z", "த்"),
    ("Z", "ஙூ"),
    ("ÿ", "ஸ்ரீ"),
    ("Ÿ", "ரீ"),
    ("", "ரீ"),
    ("Ý", "னு"),
    ("Y", "ஙு"),
    ("y", "தூ"),
    ("X", "ஙீ"),
    ("x", "து"),
    ("W", "ஙி"),
    ("w", "தீ"),
    ("V", "ங"),
    ("v", "தி"),
    ("Ü", "னீ"),
    ("Û", "னி"),
    ("Ú", "ன"),
    ("u", "த"),
    ("U", "க்"),
    ("Þ", "னூ"),
    ("T", "கூ"),
    ("ß", "ன்"),
    ("s", "ண்"),
    ("S", "கு"),
    ("R", "கீ"),
    ("r", "ணூ"),
    ("Q", "கி"),
    ("q", "ணு"),
    ("P", "க"),
    ("p", "ணீ"),
    ("Ø", "ற்"),
    ("Õ", "றீ"),
    ("Ö", "று"),
    ("ô", "க்ஷ்"),
    ("Ô", "றி"),
    ("Ò", "ள்"),
    ("ò", "க்ஷி"),
    ("Ó", "ற"),
    ("ó", "க்ஷீ"),
    ("º", "ர்"),
    ("º", "ர்"),
    ("o", "ணி"),
    ("ñ", "க்ஷ"),
    ("Ñ", "ளூ"),
    ("n", "ண"),
    ("m", "ட்"),
    ("L", "ஃ"),
    ("l", "டூ"),
    ("K", "ஓ"),
    ("k", "டு"),
    ("J", "ஒ"),
    ("j", "டீ"),
    ("ï", "ஹீ"),
    ("î", "ஹி"),
    ("Ì", "ழ்"),
    ("ì", "ஸ்"),
    ("Í", "ள"),
    ("í", "ஹ"),
    ("I", "ஐ"),
    ("i", "டி"),
    ("H", "ஏ"),
    ("h", "ட"),
    ("G", "எ"),
    ("g", "ஞ்"),
    ("F", "ஊ"),
    ("f", "ஞூ"),
    ("ë", "ஸீ"),
    ("Ë", "ழூ"),
    ("ê", "ஸி"),
    ("Ê", "ழு"),
    ("è", "ஷ்"),
    ("È", "ழி"),
    ("é", "ஸ"),
    ("É", "ழீ"),
    ("E", "உ"),
    ("e", "ஞு"),
    ("ð", "ஹ்"),
    ("Ð", "ளு"),
    ("D", "ஈ"),
    ("d", "ஞீ"),
    ("Ç", "ழ"),
    ("ç", "ஷீ"),
    ("C", "இ"),
    ("c", "ஞி"),
    ("B", "ஆ"),
    ("b", "ஞ"),
    ("Æ", "வ்"),
    ("æ", "ஷி"),
    ("å", "ஷ"),
    ("Å", "வூ"),
    ("Ã", "வீ"),
    ("ã", "ஜீ"),
    ("ä", "ஜ்"),
    ("Ä", "வு"),
    ("Â", "வி"),
    ("â", "ஜி"),
    ("À", "ல்"),
    ("Á", "வ"),
    ("á", "ஜ"),
    ("ª", "மி"),
    ("A", "அ"),
    ("a", "ச்"),
    ("³", "யூ"),
    ("²", "யு"),
    ("¹", "ரூ"),
    ("¾", "லு"),
    ("½", "லீ"),
    ("¼", "லி"),
    ("‰", "மூ"),
    ("•", "மு"),
    ("", "மூ"),
    ("", "மு"),
    ("µ", "ர"),
    ("°", "யி"),
    ("®", "ம்"),
    ("©", "ம"),
    ("§", "பூ"),
    ("¥", "பீ"),
    ("¤", "பி"),
    ("£", "ப"),
    ("¢", "ந்"),
    ("×", "றூ"),
    ("»", "ல"),
    ("«", "மீ"),
    ("±", "யீ"),
    ("=", "="),
    ("+", "+"),
    ("›", "ரி"),
    ("", "ரி"),
    ("¿", "லூ"),
    ("¸", "ரு"),
    ("´", "ய்"),
    ("¯", "ய"),
    ("¨", "ப்"),
    ("¦", "பு"),
    ("¡", "நூ"),
    ("~", "நு"),
    ("}", "நீ"),
    ("|", "ந"),
    ("{", "நி"),
    ("`", "சூ"),
    ("_", "சு"),
    ("^", "சீ"),
    ("]", "சி"),
    ("\\", "ச"),
    ("[", "ங்"), 
    ])
# end of shreelipi2utf8 dictionary

# begin of softview2utf8 dictionary
softview2utf8 = OrderedDict([
    ("ú[ô", "ளோ"),
    ("ù[ô", "ளொ"),
    ("[ô", "ளா"),
    ("°", "ளி"),
    ("Ç", "ளீ"),
    ("úQô", "ணோ"),
    ("úXô", "லோ"),
    ("ú\ô", "றோ"),
    ("úWô", "ரோ"),
    ("úYô", "வோ"),
    ("úNô", "சோ"),
    ("úOô", "ஞோ"),
    ("ú`ô", "ஷோ"),
    ("úPô", "டோ"),
    ("úUô", "மோ"),
    ("úRô", "தோ"),
    ("úZô", "ழோ"),
    ("úTô", "போ"),
    ("úLô", "கோ"),
    ("úSô", "நோ"),
    ("ú]ô", "னோ"),
    ("úbô", "க்ஷோ"),
    ("úVô", "யோ"),
    ("úaô", "ஹோ"),
    ("úMô", "ஙோ"),
    ("ú^ô", "ஸோ"),
    ("ú_ô", "ஜோ"),
    ("ùQ[", "ணௌ"),
    ("ùQô", "ணொ"),
    ("ùX[", "லௌ"),
    ("ùXô", "லொ"),
    ("ù\[", "றௌ"),
    ("ù\ô", "றொ"),
    ("ùW[", "ரௌ"),
    ("ùWô", "ரொ"),
    ("ùY[", "வௌ"),
    ("ùYô", "வொ"),
    ("ù[[", "ளௌ"),
    ("ùN[", "சௌ"),
    ("ùNô", "சொ"),
    ("ùO[", "ஞௌ"),
    ("ùOô", "ஞொ"),
    ("ù`[", "ஷௌ"),
    ("ù`ô", "ஷொ"),
    ("ùP[", "டௌ"),
    ("ùPô", "டொ"),
    ("ùU[", "மௌ"),
    ("ùUô", "மொ"),
    ("ùR[", "தௌ"),
    ("ùRô", "தொ"),
    ("ùZ[", "ழௌ"),
    ("ùZô", "ழொ"),
    ("ùT[", "பௌ"),
    ("ùTô", "பொ"),
    ("ùL[", "கௌ"),
    ("ùLô", "கொ"),
    ("ùS[", "நௌ"),
    ("ùSô", "நொ"),
    ("ù][", "னௌ"),
    ("ù]ô", "னொ"),
    ("ùb[", "க்ஷௌ"),
    ("ùbô", "க்ஷொ"),
    ("ùV[", "யௌ"),
    ("ùa[", "ஹௌ"),
    ("ùVô", "யொ"),
    ("ùaô", "ஹொ"),
    ("ùM[", "ஙௌ"),
    ("ùMô", "ஙொ"),
    ("ù^[", "ஸௌ"),
    ("ù^ô", "ஸொ"),
    ("ù_[", "ஜௌ"),
    ("ù_ô", "ஜொ"),
    ("Qô", "ணா"),
    ("Xô", "லா"),
    ("I[", "ஔ"),
    ("\ô", "றா"),
    ("Wô", "ரா"),
    ("Yô", "வா"),
    ("Nô", "சா"),
    ("Oô", "ஞா"),
    ("`ô", "ஷா"),
    ("`þ", "ஷூ"),
    ("`ý", "ஷு"),
    ("úQ", "ணே"),
    ("úX", "லே"),
    ("ú\\", "றே"),
    ("úW", "ரே"),
    ("úY", "வே"),
    ("ú[", "ளே"),
    ("úN", "சே"),
    ("úO", "ஞே"),
    ("ú`", "ஷே"),
    ("úP", "டே"),
    ("úU", "மே"),
    ("úR", "தே"),
    ("úZ", "ழே"),
    ("úT", "பே"),
    ("úL", "கே"),
    ("úS", "நே"),
    ("ú]", "னே"),
    ("úb", "க்ஷே"),
    ("úV", "யே"),
    ("úa", "ஹே"),
    ("úM", "ஙே"),
    ("ú^", "ஸே"),
    ("ú_", "ஜே"),
    ("Pô", "டா"),
    ("Uô", "மா"),
    ("Rô", "தா"),
    ("ûQ", "ணை"),
    ("ûX", "லை"),
    ("û\\", "றை"),
    ("ûW", "ரை"),
    ("ûY", "வை"),
    ("û[", "ளை"),
    ("ûN", "சை"),
    ("ûO", "ஞை"),
    ("û`", "ஷை"),
    ("ûP", "டை"),
    ("ûU", "மை"),
    ("ûR", "தை"),
    ("ûZ", "ழை"),
    ("ûT", "பை"),
    ("ûL", "கை"),
    ("ûS", "நை"),
    ("û]", "னை"),
    ("ûb", "க்ஷை"),
    ("ûV", "யை"),
    ("ûa", "ஹை"),
    ("ûM", "ஙை"),
    ("û^", "ஸை"),
    ("û_", "ஜை"),
    ("Zô", "ழா"),
    ("Tô", "பா"),
    ("Lô", "கா"),
    ("Sô", "நா"),
    ("]ô", "னா"),
    ("ùQ", "ணெ"),
    ("ùX", "லெ"),
    ("ù\\", "றெ"),
    ("ùW", "ரெ"),
    ("ùY", "வெ"),
    ("ù[", "ளெ"),
    ("ùN", "செ"),
    ("ùO", "ஞெ"),
    ("ù`", "ஷெ"),
    ("ùP", "டெ"),
    ("ùU", "மெ"),
    ("ùR", "தெ"),
    ("bô", "க்ஷா"),
    ("ùZ", "ழெ"),
    ("ùT", "பெ"),
    ("ùL", "கெ"),
    ("ùS", "நெ"),
    ("ù]", "னெ"),
    ("ùb", "க்ஷெ"),
    ("ùV", "யெ"),
    ("ùa", "ஹெ"),
    ("ùM", "ஙெ"),
    ("bþ", "க்ஷூ"),
    ("ù^", "ஸெ"),
    ("bý", "க்ஷு"),
    ("ù_", "ஜெ"),
    ("Vô", "யா"),
    ("aô", "ஹா"),
    ("aþ", "ஹூ"),
    ("aý", "ஹு"),
    ("Mô", "ஙா"),
    ("^ô", "ஸா"),
    ("^þ", "ஸூ"),
    ("^ý", "ஸு"),
    ("_ô", "ஜா"),
    ("_þ", "ஜூ"),
    ("_ý", "ஜு"),
    ("\"\"", "\""),
    ("’’", "”"),
    ("", "”"),
    ("x", "ஷ்"),
    ("Q", "ண"),
    ("s", "ள்"),
    ("í", "லூ"),
    ("Û", "லு"),
    ("X", "ல"),
    ("I", "ஒ"),
    ("J", "ஓ"),
    ("ß", "று"),
    ("\\", "ற"),
    ("F", "எ"),
    ("G", "ஏ"),
    ("É", "னீ"),
    ("è", "நூ"),
    ("Á", "மீ"),
    ("æ", "ணூ"),
    ("½", "ணீ"),
    ("ñ", "றூ"),
    ("¿", "நீ"),
    ("ä", "ஞூ"),
    ("Ú", "ரு"),
    ("W", "ர"),
    ("á", "கூ"),
    ("Y", "வ"),
    ("Ã", "ரீ"),
    ("g", "ஞ்"),
    ("p", "ல்"),
    ("Þ", "ளு"),
    ("[", "ள"),
    ("Ñ", "சு"),
    ("N", "ச"),
    ("Ô", "ணு"),
    ("ð", "ளூ"),
    ("Â", "யீ"),
    ("O", "ஞ"),
    ("n", "ய்"),
    ("r", "ழ்"),
    ("·", "க்ஷி"),
    ("»", "ஞீ"),
    ("À", "பீ"),
    ("`", "ஷ"),
    ("È", "றீ"),
    ("ç", "தூ"),
    ("¾", "தீ"),
    ("ë", "யூ"),
    ("×", "பு"),
    ("º", "சீ"),
    ("é", "பூ"),
    ("z", "க்ஷ்"),
    ("¥", "டி"),
    ("¼", "டீ"),
    ("¸", "கீ"),
    ("î", "வூ"),
    ("ã", "சூ"),
    ("@", "அ"),
    ("A", "ஆ"),
    ("Ó", "டு"),
    ("P", "ட"),
    ("Ø", "மு"),
    ("U", "ம"),
    ("Õ", "து"),
    ("R", "த"),
    ("¶", "ஹி"),
    ("B", "இ"),
    ("µ", "ஷி"),
    ("Ü", "வு"),
    ("Î", "க்ஷீ"),
    ("³", "ஸி"),
    ("´", "ஜி"),
    ("Ù", "யு"),
    ("H", "ஐ"),
    ("Z", "ழ"),
    ("Ý", "ழு"),
    ("T", "ப"),
    ("Ï", "கு"),
    ("L", "க"),
    ("Í", "ஹீ"),
    ("¯", "ழி"),
    ("Ì", "ஷீ"),
    ("­", "லி"),
    ("Ê", "ஸீ"),
    ("®", "வி"),
    ("Ë", "ஜீ"),
    ("Ö", "நு"),
    ("S", "ந"),
    ("à", "னு"),
    ("]", "ன"),
    ("¬", "ரி"),
    ("D", "உ"),
    ("E", "ஊ"),
    ("b", "க்ஷ"),
    ("«", "யி"),
    ("Æ", "ழீ"),
    ("²", "னி"),
    ("Å", "வீ"),
    ("¨", "நி"),
    ("©", "பி"),
    ("ª", "மி"),
    ("Ä", "லீ"),
    ("¦", "ணி"),
    ("§", "தி"),
    ("y", "ஹ்"),
    ("¢", "ஙி"),
    ("£", "சி"),
    ("¤", "ஞி"),
    ("k", "ந்"),
    ("V", "ய"),
    ("a", "ஹ"),
    ("â", "ஙூ"),
    ("Ð", "ஙு"),
    ("t", "ற்"),
    ("M", "ங"),
    ("¹", "ஙீ"),
    ("v", "ஸ்"),
    ("o", "ர்"),
    ("i", "ண்"),
    ("e", "ங்"),
    ("l", "ப்"),
    ("j", "த்"),
    ("h", "ட்"),
    ("f", "ச்"),
    ("¡", "கி"),
    ("m", "ம்"),
    ("ï", "ழூ"),
    ("=", "="),
    ("C", "ஈ"),
    ("+", "+"),
    ("q", "வ்"),
    ("u", "ன்"),
    ("“", "\""),
    ("’", "'"),
    ("‘", "'"),
    ("", "\""),
    ("", "'"),
    ("", "'"),
    ("±", "றி"),
    ("d", "க்"),
    ("K", "ஃ"),
    ("ò", "னூ"),
    ("Ò", "ஞு"),
    ("w", "ஜ்"),
    ("ê", "மூ"),
    ("å", "டூ"),
    ("^", "ஸ"),    
    ("ì", "ரூ"),
    ("c", "ஸ்ரீ"),
    ("_", "ஜ"),
    ("#", "-"),
    ])
# end of softview2utf8 dictionary

# begin of tace2utf8 dictionary
tace2utf8 = OrderedDict([    
    ("“", "\""),
    ("”", "\""),
    ("‘", "'"),
    ("’", "'"),  
    ("", "க்ஷீ"),
    ("", "க்ஷே"),
    ("", "க்ஷை"),
    ("", "க்ஷொ"),
    ("", "க்ஷோ"),
    ("", "ஸ்ரீ"),
    ("", "க்ஷ்"),
    ("", "க்ஷா"),
    ("", "க்ஷி"),
    ("", "க்ஷு"),
    ("", "க்ஷூ"),
    ("", "க்ஷெ"),
    ("", "க்ஷௌ"),
    ("", "க்ஷ"),
    ("", "க்"),
    ("", "ங்"),
    ("", "ச்"),
    ("", "ஞ்"),
    ("", "ட்"),
    ("", "ண்"),
    ("", "த்"),
    ("", "ந்"),
    ("", "ப்"),
    ("", "ம்"),
    ("", "ய்"),
    ("", "ர்"),
    ("", "ல்"),
    ("", "வ்"),
    ("", "ழ்"),
    ("", "ள்"),
    ("", "ற்"),
    ("", "ன்"),
    ("", "ஸ்"),
    ("", "ஷ்"),
    ("", "ஜ்"),
    ("", "ஹ்"),
    ("", "கா"),
    ("", "ஙா"),
    ("", "சா"),
    ("", "ஞா"),
    ("", "டா"),
    ("", "ணா"),
    ("", "தா"),
    ("", "நா"),
    ("", "பா"),
    ("", "மா"),
    ("", "யா"),
    ("", "ரா"),
    ("", "லா"),
    ("", "வா"),
    ("", "ழா"),
    ("", "ளா"),
    ("", "றா"),
    ("", "னா"),
    ("", "ஸா"),
    ("", "ஷா"),
    ("", "ஜா"),
    ("", "ஹா"),
    ("", "கி"),
    ("", "ஙி"),
    ("", "சி"),
    ("", "ஞி"),
    ("", "டி"),
    ("", "ணி"),
    ("", "தி"),
    ("", "நி"),
    ("", "பி"),
    ("", "மி"),
    ("", "யி"),
    ("", "ரி"),
    ("", "லி"),
    ("", "வி"),
    ("", "ழி"),
    ("", "ளி"),
    ("", "றி"),
    ("", "னி"),
    ("", "ஸி"),
    ("", "ஷி"),
    ("", "ஜி"),
    ("", "ஹி"),
    ("", "கீ"),
    ("", "ஙீ"),
    ("", "சீ"),
    ("", "ஞீ"),
    ("", "டீ"),
    ("", "ணீ"),
    ("", "தீ"),
    ("", "நீ"),
    ("", "பீ"),
    ("", "மீ"),
    ("", "யீ"),
    ("", "ரீ"),
    ("", "லீ"),
    ("", "வீ"),
    ("", "ழீ"),
    ("", "ளீ"),
    ("", "றீ"),
    ("", "னீ"),
    ("", "ஸீ"),
    ("", "ஷீ"),
    ("", "ஜீ"),
    ("", "ஹீ"),
    ("", "கு"),
    ("", "ஙு"),
    ("", "சு"),
    ("", "ஞு"),
    ("", "டு"),
    ("", "ணு"),
    ("", "து"),
    ("", "நு"),
    ("", "பு"),
    ("", "மு"),
    ("", "யு"),
    ("", "ரு"),
    ("", "லு"),
    ("", "வு"),
    ("", "ழு"),
    ("", "ளு"),
    ("", "று"),
    ("", "னு"),
    ("", "ஸு"),
    ("", "ஷு"),
    ("", "ஜு"),
    ("", "ஹு"),
    ("", "கூ"),
    ("", "ஙூ"),
    ("", "சூ"),
    ("", "ஞூ"),
    ("", "டூ"),
    ("", "ணூ"),
    ("", "தூ"),
    ("", "நூ"),
    ("", "பூ"),
    ("", "மூ"),
    ("", "யூ"),
    ("", "ரூ"),
    ("", "லூ"),
    ("", "வூ"),
    ("", "ழூ"),
    ("", "ளூ"),
    ("", "றூ"),
    ("", "னூ"),
    ("", "ஸூ"),
    ("", "ஷூ"),
    ("", "ஜூ"),
    ("", "ஹூ"),
    ("", "கெ"),
    ("", "ஙெ"),
    ("", "செ"),
    ("", "ஞெ"),
    ("", "டெ"),
    ("", "ணெ"),
    ("", "தெ"),
    ("", "நெ"),
    ("", "பெ"),
    ("", "மெ"),
    ("", "யெ"),
    ("", "ரெ"),
    ("", "லெ"),
    ("", "வெ"),
    ("", "ழெ"),
    ("", "ளெ"),
    ("", "றெ"),
    ("", "னெ"),
    ("", "ஸெ"),
    ("", "ஷெ"),
    ("", "ஜெ"),
    ("", "ஹெ"),
    ("", "கே"),
    ("", "ஙே"),
    ("", "சே"),
    ("", "ஞே"),
    ("", "டே"),
    ("", "ணே"),
    ("", "தே"),
    ("", "நே"),
    ("", "பே"),
    ("", "மே"),
    ("", "யே"),
    ("", "ரே"),
    ("", "லே"),
    ("", "வே"),
    ("", "ழே"),
    ("", "ளே"),
    ("", "றே"),
    ("", "னே"),
    ("", "ஸே"),
    ("", "ஷே"),
    ("", "ஜே"),
    ("", "ஹே"),
    ("", "கை"),
    ("", "ஙை"),
    ("", "சை"),
    ("", "ஞை"),
    ("", "டை"),
    ("", "ணை"),
    ("", "தை"),
    ("", "நை"),
    ("", "பை"),
    ("", "மை"),
    ("", "யை"),
    ("", "ரை"),
    ("", "லை"),
    ("", "வை"),
    ("", "ழை"),
    ("", "ளை"),
    ("", "றை"),
    ("", "னை"),
    ("", "ஸை"),
    ("", "ஷை"),
    ("", "ஜை"),
    ("", "ஹை"),
    ("", "கொ"),
    ("", "ஙொ"),
    ("", "சொ"),
    ("", "ஞொ"),
    ("", "டொ"),
    ("", "ணொ"),
    ("", "தொ"),
    ("", "நொ"),
    ("", "பொ"),
    ("", "மொ"),
    ("", "யொ"),
    ("", "ரொ"),
    ("", "லொ"),
    ("", "வொ"),
    ("", "ழொ"),
    ("", "ளொ"),
    ("", "றொ"),
    ("", "னொ"),
    ("", "ஸொ"),
    ("", "ஷொ"),
    ("", "ஜொ"),
    ("", "ஹொ"),
    ("", "கோ"),
    ("", "ஙோ"),
    ("", "சோ"),
    ("", "ஞோ"),
    ("", "டோ"),
    ("", "ணோ"),
    ("", "தோ"),
    ("", "நோ"),
    ("", "போ"),
    ("", "மோ"),
    ("", "யோ"),
    ("", "ரோ"),
    ("", "லோ"),
    ("", "வோ"),
    ("", "ழோ"),
    ("", "ளோ"),
    ("", "றோ"),
    ("", "னோ"),
    ("", "ஸோ"),
    ("", "ஷோ"),
    ("", "ஜோ"),
    ("", "ஹோ"),
    ("", "கௌ"),
    ("", "ஙௌ"),
    ("", "சௌ"),
    ("", "ஞௌ"),
    ("", "டௌ"),
    ("", "ணௌ"),
    ("", "தௌ"),
    ("", "நௌ"),
    ("", "பௌ"),
    ("", "மௌ"),
    ("", "யௌ"),
    ("", "ரௌ"),
    ("", "லௌ"),
    ("", "வௌ"),
    ("", "ழௌ"),
    ("", "ளௌ"),
    ("", "றௌ"),
    ("", "னௌ"),
    ("", "ஸௌ"),
    ("", "ஷௌ"),
    ("", "ஜௌ"),
    ("", "ஹௌ"),
    ("", "அ"),
    ("", "ஆ"),
    ("", "இ"),
    ("", "ஈ"),
    ("", "உ"),
    ("", "ஊ"),
    ("", "எ"),
    ("", "ஏ"),
    ("", "ஐ"),
    ("", "ஒ"),
    ("", "ஓ"),
    ("", "ஔ"),
    ("", "ஃ"),
    ("", "க"),
    ("", "ங"),
    ("", "ச"),
    ("", "ஞ"),
    ("", "ட"),
    ("", "ண"),
    ("", "த"),
    ("", "ந"),
    ("", "ப"),
    ("", "ம"),
    ("", "ய"),
    ("", "ர"),
    ("", "ல"),
    ("", "வ"),
    ("", "ழ"),
    ("", "ள"),
    ("", "ற"),
    ("", "ன"),
    ("", "ஸ"),
    ("", "ஷ"),
    ("", "ஜ"),
    ("", "ஹ"),
    ])
# end of tace2utf8 dictionary

# begin of vanavil2utf8 dictionary
vanavil2utf8 = OrderedDict([
    ("nsh", "ளோ"),
    ("bsh", "ளொ"),
    ("sh", "ளா"),
    ("ë", "ளி"),
    ("Ç", "ளீ"),
    ("nzh", "ணோ"),
    ("nyh", "லோ"),
    ("nwh", "றோ"),
    ("nuh", "ரோ"),
    ("nth", "வோ"),
    ("nrh", "சோ"),
    ("nPh", "ஞோ"),
    ("nõh", "ஷோ"),
    ("nlh", "டோ"),
    ("nkh", "மோ"),
    ("njh", "தோ"),
    ("nHh", "ழோ"),
    ("ngh", "போ"),
    ("nfh", "கோ"),
    ("neh", "நோ"),
    ("ndh", "னோ"),
    ("nBh", "க்ஷோ"),
    ("nah", "யோ"),
    ("nAh", "ஹோ"),
    ("n‡h", "ஙோ"),
    ("nh", "ஙோ"),
    ("n[h", "ஸோ"),
    ("n#h", "ஜோ"),
    ("bzs", "ணௌ"),
    ("bzh", "ணொ"),
    ("bys", "லௌ"),
    ("byh", "லொ"),
    ("bws", "றௌ"),
    ("bwh", "றொ"),
    ("bus", "ரௌ"),
    ("buh", "ரொ"),
    ("bts", "வௌ"),
    ("bth", "வொ"),
    ("bss", "ளௌ"),
    ("brs", "சௌ"),
    ("brh", "சொ"),
    ("bPs", "ஞௌ"),
    ("bPh", "ஞொ"),
    ("bõs", "ஷௌ"),
    ("bõh", "ஷொ"),
    ("bls", "டௌ"),
    ("blh", "டொ"),
    ("bks", "மௌ"),
    ("bkh", "மொ"),
    ("bjs", "தௌ"),
    ("bjh", "தொ"),
    ("bHs", "ழௌ"),
    ("bHh", "ழொ"),
    ("bgs", "பௌ"),
    ("bgh", "பொ"),
    ("bfs", "கௌ"),
    ("bfh", "கொ"),
    ("bes", "நௌ"),
    ("beh", "நொ"),
    ("bds", "னௌ"),
    ("bdh", "னொ"),
    ("bBs", "க்ஷௌ"),
    ("bBh", "க்ஷொ"),
    ("bas", "யௌ"),
    ("bAs", "ஹௌ"),
    ("bah", "யொ"),
    ("bAh", "ஹொ"),
    ("b‡s", "ஙௌ"),
    ("b‡h", "ஙொ"),
    ("bs", "ஙௌ"),
    ("bh", "ஙொ"),
    ("b[s", "ஸௌ"),
    ("b[h", "ஸொ"),
    ("b#s", "ஜௌ"),
    ("b#h", "ஜொ"),
    ("zh", "ணா"),
    ("yh", "லா"),
    ("xs", "ஔ"),
    ("wh", "றா"),
    ("uh", "ரா"),
    ("th", "வா"),
    ("rh", "சா"),
    ("Ph", "ஞா"),
    ("õh", "ஷா"),
    ("õ]", "ஷூ"),
    ("õ&", "ஷு"),
    ("nz", "ணே"),
    ("ny", "லே"),
    ("nw", "றே"),
    ("nu", "ரே"),
    ("nt", "வே"),
    ("ns", "ளே"),
    ("nr", "சே"),
    ("nP", "ஞே"),
    ("nõ", "ஷே"),
    ("nl", "டே"),
    ("nk", "மே"),
    ("nj", "தே"),
    ("nH", "ழே"),
    ("ng", "பே"),
    ("nf", "கே"),
    ("ne", "நே"),
    ("nd", "னே"),
    ("nB", "க்ஷே"),
    ("na", "யே"),
    ("nA", "ஹே"),
    ("n‡", "ஙே"),
    ("n", "ஙே"),
    ("n[", "ஸே"),
    ("n#", "ஜே"),
    ("lh", "டா"),
    ("kh", "மா"),
    ("jh", "தா"),
    ("iz", "ணை"),
    ("iy", "லை"),
    ("iw", "றை"),
    ("iu", "ரை"),
    ("it", "வை"),
    ("is", "ளை"),
    ("ir", "சை"),
    ("iP", "ஞை"),
    ("iõ", "ஷை"),
    ("il", "டை"),
    ("ik", "மை"),
    ("ij", "தை"),
    ("iH", "ழை"),
    ("ig", "பை"),
    ("if", "கை"),
    ("ie", "நை"),
    ("id", "னை"),
    ("iB", "க்ஷை"),
    ("ia", "யை"),
    ("iA", "ஹை"),
    ("i‡", "ஙை"),
    ("i", "ஙை"),
    ("i[", "ஸை"),
    ("i#", "ஜை"),
    ("Hh", "ழா"),
    ("gh", "பா"),
    ("fh", "கா"),
    ("eh", "நா"),
    ("dh", "னா"),
    ("bz", "ணெ"),
    ("by", "லெ"),
    ("bw", "றெ"),
    ("bu", "ரெ"),
    ("bt", "வெ"),
    ("bs", "ளெ"),
    ("br", "செ"),
    ("bP", "ஞெ"),
    ("bõ", "ஷெ"),
    ("bl", "டெ"),
    ("bk", "மெ"),
    ("bj", "தெ"),
    ("Bh", "க்ஷா"),
    ("bH", "ழெ"),
    ("bg", "பெ"),
    ("bf", "கெ"),
    ("be", "நெ"),
    ("bd", "னெ"),
    ("bB", "க்ஷெ"),
    ("ba", "யெ"),
    ("bA", "ஹெ"),
    ("b‡", "ஙெ"),
    ("b", "ஙெ"),
    ("B]", "க்ஷூ"),
    ("b[", "ஸெ"),
    ("B&", "க்ஷு"),
    ("b#", "ஜெ"),
    ("ah", "யா"),
    ("Ah", "ஹா"),
    ("A]", "ஹூ"),
    ("A&", "ஹு"),
    ("‡h", "ஙா"),
    ("h", "ஙா"),
    ("[h", "ஸா"),
    ("[]", "ஸூ"),
    ("[&", "ஸு"),
    ("#h", "ஜா"),
    ("#]", "ஜூ"),
    ("#&", "ஜு"),
    ("Z", "ஷ்"),
    ("z", "ண"),
    ("Ÿ", "ள்"),
    ("", "ள்"),
    ("ÿ", "லூ"),
    ("Y", "லு"),
    ("y", "ல"),
    ("x", "ஒ"),
    ("X", "ஓ"),
    ("W", "று"),
    ("w", "ற"),
    ("v", "எ"),
    ("V", "ஏ"),
    ("Ü", "னீ"),
    ("ü", "நூ"),
    ("Û", "மீ"),
    ("û", "ணூ"),
    ("Ù", "ணீ"),
    ("ù", "றூ"),
    ("Ú", "நீ"),
    ("ú", "ஞூ"),
    ("U", "ரு"),
    ("u", "ர"),
    ("T", "கூ"),
    ("t", "வ"),
    ("ß", "ரீ"),
    ("Š", "ஞ்"),
    ("š", "ல்"),
    ("", "ஞ்"),
    ("", "ல்"),
    ("S", "ளு"),
    ("s", "ள"),
    ("R", "சு"),
    ("r", "ச"),
    ("Q", "ணு"),
    ("q", "ளூ"),
    ("p", "யீ"),
    ("P", "ஞ"),
    ("Œ", "ய்"),
    ("œ", "ழ்"),
    ("", "ய்"),
    ("", "ழ்"),
    ("ø", "க்ஷி"),
    ("Ø", "ஞீ"),
    ("Õ", "பீ"),
    ("õ", "ஷ"),
    ("Ö", "றீ"),
    ("ö", "தூ"),
    ("Ô", "தீ"),
    ("ô", "யூ"),
    ("ò", "பு"),
    ("Ó", "சீ"),
    ("ó", "பூ"),
    ("º", "க்ஷ்"),
    ("o", "டி"),
    ("O", "டீ"),
    ("Ñ", "கீ"),
    ("ñ", "வூ"),
    ("N", "சூ"),
    ("m", "அ"),
    ("M", "ஆ"),
    ("L", "டு"),
    ("l", "ட"),
    ("K", "மு"),
    ("k", "ம"),
    ("J", "து"),
    ("j", "த"),
    ("ï", "ஹி"),
    ("Ï", "இ"),
    ("î", "ஷி"),
    ("Î", "வு"),
    ("Ì", "க்ஷீ"),
    ("ì", "ஸி"),
    ("í", "ஜி"),
    ("Í", "யு"),
    ("I", "ஐ"),
    ("H", "ழ"),
    ("G", "ழு"),
    ("g", "ப"),
    ("F", "கு"),
    ("f", "க"),
    ("Ë", "ஹீ"),
    ("ê", "ழி"),
    ("Ê", "ஷீ"),
    ("è", "லி"),
    ("È", "ஸீ"),
    ("é", "வி"),
    ("É", "ஜீ"),
    ("E", "நு"),
    ("e", "ந"),
    ("D", "னு"),
    ("d", "ன"),
    ("ç", "ரி"),
    ("c", "உ"),
    ("C", "ஊ"),
    ("B", "க்ஷ"),
    ("æ", "யி"),
    ("Æ", "ழீ"),
    ("å", "னி"),
    ("Å", "வீ"),
    ("ã", "நி"),
    ("Ã", "பி"),
    ("ä", "மி"),
    ("Ä", "லீ"),
    ("â", "ணி"),
    ("Â", "தி"),
    ("À", "ஹ்"),
    ("à", "ஙி"),
    ("Á", "சி"),
    ("á", "ஞி"),
    ("ª", "ந்"),
    ("a", "ய"),
    ("A", "ஹ"),
    ("½", "ஙூ"),
    ("¼", "ஙு"),
    ("‰", "ற்"),
    ("‡", "ங"),
    ("†", "ஙீ"),
    ("", "ற்"),
    ("", "ங"),
    ("", "ஙீ"),
    ("°", "ஸ்"),
    ("®", "ர்"),
    ("©", "ண்"),
    ("§", "ங்"),
    ("¥", "ப்"),
    ("¤", "த்"),
    ("£", "ட்"),
    ("¢", "ச்"),
    ("»", "கி"),
    ("«", "ம்"),
    (">", "ழூ"),
    ("=", "="),
    ("<", "ஈ"),
    ("+", "+"),
    ("›", "வ்"),
    ("‹", "ன்"),
    

    ("", "வ்"),
    ("", "ன்"),
    ("", "\""),
    ("", "”"),
    ("", "“"),
    ("", "’"),
    ("", "‘"),
    ("¿", "றி"),
    ("¡", "க்"),
    ("~", "ஃ"),
    ("}", "னூ"),
    ("|", "ஞு"),
    ("{", "ஜ்"),
    ("`", "`"),
    ("_", "மூ"),
    ("^", "டூ"),
    ("[", "ஸ"),
    
    ("%", "ரூ"),
    ("$", "ஸ்ரீ"),
    ("#", "ஜ"),
    ("”", "\""),
    ("“", "\""),
    ("", "\"\""),
    ])
# end of vanavil2utf8 dictionary
 
