"""
Represents an aperture.
"""
from orangecontrib.srw.util.OpticalElement import OpticalElement

class ApertureType(object)   :
    def __init__(self, name):
        self.__name = name
        
    def description(self):
        return self.__name
    
    def __eq__(self, candidate):
        return (self.__name == candidate.__name)
    
    def __ne__(self, candidate):
        return not self.__eq__(candidate)

class Disc(ApertureType):
    def __init__(self):
        ApertureType.__init__(self, "Disc")
        
class Rectangle(ApertureType):
    def __init__(self):
        ApertureType.__init__(self, "Rectangle")


class OpticalElementAperture(OpticalElement): 
    def __init__(self, name):
        OpticalElement.__init__(self, "Aperture", name)

    def setApertureType(self, aperture_type): 
        self.__aperture_type = aperture_type         
               
    def apertureType(self): 
        return self.__aperture_type         
        
    def setDiameter(self, diameter):
        self.__diameter = diameter
        
    def diameter(self):
        return self.__diameter
    
    def setHeight(self, height):
        self.__height = height
        
    def height(self):
        return self.__height
    
    def setWidth(self, width):
        self.__width = width
        
    def width(self):
        return self.__width
