"""
Represents an optical screen.
"""
from orangecontrib.srw.util.OpticalElement import OpticalElement

class OpticalElementScreen(OpticalElement):
    def __init__(self, name):
        OpticalElement.__init__(self, "Screen", name)
        
    def calculateIntensity3D(self, driver):
        result = {}
        print("OE SCREEN:", list(self._OpticalElement__stored_data.keys()))
        for key in list(self._OpticalElement__stored_data.keys()):
            in_data = self._dataByRoute(key)
            result[key] = driver.calculateIntensity3D(in_data)
        
        return result

    def calculatePhase3D(self, driver):
        result = {}
        for key in list(self._OpticalElement__stored_data.keys()):
            in_data = self._dataByRoute(key)
            result[key] = driver.calculatePhase3D(in_data)
        
        return result
