from Undulator import Undulator
from Orientations import Vertical, Horizontal
from math import pi
import scipy.constants.codata

class PlanarUndulator(Undulator):
    def __init__(self,K , period_length, period_number, orientation=Vertical()):

        if orientation==Vertical():
            K_vertical = K
            K_horizontal = 0.0
        elif orientation==Horizontal():
            K_vertical = 0.0
            K_horizontal = K
        else:
            raise Exception("Unknown orientation.")

        self._orientation = orientation

        Undulator.__init__(self, K_vertical, K_horizontal, period_length, period_number)

    def orientation(self):
        return self._orientation

    def K(self):
        if self.orientation() == Vertical():
            K = self.K_vertical()
        if self.orientation() == Horizontal():
            K = self.K_horizontal()

        return K

    def B(self):
        return self._magneticFieldStrengthFromK(self.K())