from math import pi
import scipy.constants.codata

class Undulator(object):
    def __init__(self, K_vertical, K_horizontal, period_length, periods_number):
        self._K_vertical = K_vertical
        self._K_horizontal = K_horizontal
        self._period_length = period_length
        self._periods_number = periods_number

    def periodLength(self):
        return self._period_length

    def periodNumber(self):
        return self._periods_number

    def length(self):
        return self.periodNumber() * self.periodLength()

    def K_vertical(self):
        return self._K_vertical

    def K_horizontal(self):
        return self._K_horizontal

    def resonanceWavelength(self, gamma, theta_x, theta_z):
        wavelength = (self.periodLength() / (2.0*gamma **2)) * \
                     (1 + self.K_vertical()**2 / 2.0 + self.K_horizontal()**2 / 2.0 + \
                      gamma**2 * (theta_x**2 + theta_z ** 2))

        print("res wavelength", wavelength)
        return wavelength

    def resonanceFrequency(self, gamma, theta_x, theta_z):
        codata = scipy.constants.codata.physical_constants
        speed_of_light = codata["speed of light in vacuum"][0]

        frequency = 2*pi*speed_of_light / self.resonanceWavelength(gamma, theta_x, theta_z)
        print("res freq", frequency)
        return frequency

    def resonanceEnergy(self, energy_in_GeV, theta_x, theta_y):
        codata = scipy.constants.codata.physical_constants
        energy_in_ev = codata["Planck constant"][0] * self.resonanceFrequency(energy_in_GeV/0.51099890221e-03, theta_x, theta_y) / codata["elementary charge"][0]
        energy_in_ev = 1000*0.950 * (energy_in_GeV**2.0)/((1 + (self.K_vertical()**2)/2.0 + (self.K_horizontal()**2)/2.0)*self.periodLength()*100.0)
        print("res energy", energy_in_ev)
        return energy_in_ev

    def _magneticFieldStrengthFromK(self, K):
        codata = scipy.constants.codata.physical_constants
        speed_of_light = codata["speed of light in vacuum"][0]
        mass_electron = codata["electron mass"][0]
        elementary_charge=codata["elementary charge"][0]

        B = K * 2 * pi * mass_electron * speed_of_light / (elementary_charge * self.periodLength())

        return B

    def B_vertical(self):
        return self._magneticFieldStrengthFromK(self.K_vertical())

    def B_horizontal(self):
        return self._magneticFieldStrengthFromK(self.K_horizontal())
