from srwlib import *

from Wavefront import Wavefront
from PlanarUndulator import PlanarUndulator
from SRWAdapter import SRWAdapter
from Intensities import Intensities

print('Calculating synchrotron (undulator) radiation electric field (from one electron)')

def wavefrontForEnergy(undulator, Electron_E_in_GeV, energy):
    adapter = SRWAdapter()

    magFldCnt = adapter.magnetFieldFromUndulator(undulator)
    electron_beam = adapter.zeroEmittanceElectronBeam(E_in_GeV=Electron_E_in_GeV)

    print(electron_beam.partStatMom1.gamma)

    wfr = adapter.createQuadraticSRWWavefrontSingleEnergy(grid_size=1000,
                                                          grid_length=0.0025,
                                                          z_start=20.0,
                                                          electron_beam=electron_beam,
                                                          energy=energy)

    optical_beamline = adapter.createBeamlineOneToOneSourceImage(wfr)

    precision_parameter = adapter.normalPrecisionParameter()

    #**********************Calculation (SRWLIB function calls) and post-processing
    print('   Performing Initial Electric Field calculation ... ')
    srwl.CalcElecFieldSR(wfr, 0, magFldCnt, precision_parameter)
    print('done')

    print('   Simulating Electric Field Wavefront Propagation ... ', end='')
    #srwl.PropagElecField(wfr, optical_beamline)
    print('done')

    #srwl.SetRepresElecField(wfr, 'A')

    return Wavefront(wfr)

def calcualteIntensitiesAroundFirstHarmonic(undulator, number_deviation_points):
    resonance_energy = int(undulator.resonanceEnergy(6.0, 0, 0))
    #shifted_energy = int(resonance_energy*(1.0-1.0/(undulator.periodNumber())))

    energies = range(resonance_energy-number_deviation_points,resonance_energy+number_deviation_points)
    energies = range(resonance_energy+1,resonance_energy+number_deviation_points)

    intensities = Intensities()

    for energy in energies:
        my_wavefront = wavefrontForEnergy(undulator, 6.0, energy)

        y_index=int(my_wavefront.dim_y()/2)
        y_intensity = my_wavefront.intensity_at_y(y_index)
        y_coordinates = my_wavefront.absolute_x_coordinates()

        x_index=int(my_wavefront.dim_x()/2)
        x_intensity = my_wavefront.intensity_at_x(x_index)
        x_coordinates = my_wavefront.absolute_y_coordinates()

        intensity_plane = my_wavefront.intensity_plane()[:,:,0]

        intensities.addHorizontalCut(energy, x_coordinates, x_intensity)
        intensities.addVerticalCut(energy, y_coordinates, y_intensity)
        intensities.addPlane(energy, x_coordinates, y_coordinates, intensity_plane)

    return intensities


undulator = PlanarUndulator(1.68,
                            0.018,
                            int(4.0/0.018),
                            )

undulator2 = PlanarUndulator(1.87,
                            0.035,
                            14,
                            )

filename="calcualation_save.dat"

if Intensities.tryLoad(filename):
    print("Previous calculation file found: %s" % filename)
    print("Recalculate? [y/n]")

    choice = input().lower()

    if choice=='y':
        calculate = True
    else:
        calculate = False
else:
    calculate = True

if calculate:
    intensities = calcualteIntensitiesAroundFirstHarmonic(undulator, 2)
    intensities.save(filename)
else:
    intensities = Intensities.load(filename)

for energy in intensities.energies():
    intensities.plotXYCuts(energy)
    intensities.plotPlane(energy)
