"""
<name>Optical drift space</name>
<description>Drift space</description>
<icon>icons/drift_space.svg</icon>
<priority>10</priority>
"""
import sys
import Orange
from PyQt4 import *
from PyQt4.Qt import *

from Orange.widgets import widget, settings, gui
import Orange.data

from orangecontrib.srw.util.OpticalElementSpace import OpticalElementSpace
from orangecontrib.srw.util.OpticalBeam import OpticalBeam

from orangecontrib.srw.widgets.drivers.DriverSettingsWidget import DriverSettingsWidget

class OpticalElementSpaceWidget(widget.OWWidget):
    name = "Drift space"
    description = "Drift space"
    icon = "icons/drift_space.svg"
    
    inputs  = [("Optical beam", OpticalBeam, "onOpticalBeam",widget.Multiple)]
    outputs = [("Optical beam", OpticalBeam)]
    
    value_le_length = settings.Setting(1.0)
    
    value_le_driver_settings = settings.Setting("")
        
    def __init__(self, parent=None, signalManager=None):
        widget.OWWidget.__init__(self, parent, signalManager)

        self.__optical_space = OpticalElementSpace("space")
       
        self.le_length = gui.lineEdit(self,
                                      self,
                                      "value_le_length",
                                      label="Length [m]",
                                      validator=QDoubleValidator(bottom=0.0))

        self.__driver_settings_widget = DriverSettingsWidget(self.__optical_space,
                                                             self,
                                                             "value_le_driver_settings")
        
        self.__optical_space.setOnSynchronize(self.synchronizeToOpticalElement)      
        self.__optical_space.setOnCalculationStart(self.calculationStart)      
        self.__optical_space.setOnCalculationFinished(self.calculationFinished)      

    def calculationStart(self):
        self.progressBarInit()
        self.progressBarSet(0)
        QApplication.processEvents()

    def calculationFinished(self):
        self.progressBarSet(100)
        QApplication.processEvents()

    def synchronizeToOpticalElement(self):
        length = float(self.value_le_length)
        self.__optical_space.setLength(length)
                
    def onOpticalBeam(self, optical_beam, sender):
        optical_beam.sender().addOutput(self.__optical_space)
        
        sender = OpticalBeam(self.__optical_space)
        self.send("Optical beam", sender)


if __name__=="__main__":
    appl = QApplication(sys.argv)
    ow = OpticalElementSpaceWidget()
    ow.show()
    appl.exec_()
