"""
<name>Gaussian source</name>
<description>A Gaussian source</description>
<icon>icons/gaussian.svg</icon>
<priority>1</priority>
"""
import sys
import Orange
from PyQt4 import *
from PyQt4.Qt import *
from PyQt4.QtCore import *

from Orange.widgets import widget, settings, gui
import Orange.data

from orangecontrib.srw.util.OpticalElementSourceGaussian import OpticalElementSourceGaussian
from orangecontrib.srw.util.OpticalBeam import OpticalBeam
from orangecontrib.srw.util.Polarization import Polarization

from orangecontrib.srw.drivers.srw.SRWDriver import SRWDriver
from orangecontrib.srw.widgets.drivers.DriverSettingsWidget import DriverSettingsWidget

class OpticalElementSourceGaussianWidget(widget.OWWidget):
    name = "Gaussian source"
    description = "Gaussian source"
    icon = "icons/gaussian.svg"
    
    outputs = [("Optical beam", OpticalBeam)]

    value_le_x = settings.Setting(0)
    value_le_y = settings.Setting(0)
    value_le_z = settings.Setting(0)

    value_le_sigma_x = settings.Setting(23e-06/2.35)
    value_le_sigma_y = settings.Setting(23e-06/2.35)
    value_le_sigma_t = settings.Setting(10e-15)


    value_le_xp = settings.Setting(0)
    value_le_yp = settings.Setting(0)
    
    value_le_average_photon_energy = settings.Setting(8000.0)
    value_le_pulse_energy = settings.Setting(0.001)
    
    value_le_repetition_rate = settings.Setting(1)
    value_cb_polarization = settings.Setting(1)
    value_le_driver_settings = settings.Setting("")
         
    def __init__(self, parent=None, signalManager=None):
        widget.OWWidget.__init__(self, parent, signalManager)

        self.__optical_source_gaussian = OpticalElementSourceGaussian("source")
       
        self.le_x = gui.lineEdit(self,
                                 self,
                                 "value_le_x",
                                 label="X [m]",
                                 validator=QDoubleValidator(bottom=0.0))
        
        self.le_y = gui.lineEdit(self,
                                 self,
                                 "value_le_y",
                                 label="Y [m]",
                                 validator=QDoubleValidator(bottom=0.0))

        self.le_z = gui.lineEdit(self,
                                 self,
                                 "value_le_z",
                                 label="Z [m]",
                                 validator=QDoubleValidator(bottom=0.0))

        self.le_sigma_x = gui.lineEdit(self,
                                       self,
                                       "value_le_sigma_x",
                                       label="sigma X [m]",
                                       validator=QDoubleValidator(bottom=0.0))
        
        self.le_sigma_y = gui.lineEdit(self,
                                       self,
                                       "value_le_sigma_y",
                                       label="sigma Y [m]",
                                       validator=QDoubleValidator(bottom=0.0))

        self.le_sigma_t = gui.lineEdit(self,
                                       self,
                                       "value_le_sigma_t",
                                       label="sigma t [m]",
                                       validator=QDoubleValidator(bottom=0.0))


        self.le_xp = gui.lineEdit(self,
                                 self,
                                 "value_le_xp",
                                 label="Xp [m]",
                                 validator=QDoubleValidator(bottom=0.0))
        
        self.le_yp = gui.lineEdit(self,
                                 self,
                                 "value_le_yp",
                                 label="Yp [m]",
                                 validator=QDoubleValidator(bottom=0.0))

        self.le_average_photon_energy = gui.lineEdit(self,
                                                     self,
                                                     "value_le_average_photon_energy",
                                                     label="Average photon energy [eV]",
                                                     validator=QDoubleValidator(bottom=0.0))
        
        self.le_pulse_energy = gui.lineEdit(self,
                                            self,
                                            "value_le_pulse_energy",
                                            label="Pulse energy [J]",
                                            validator=QDoubleValidator(bottom=0.0))

        self.le_repetition_rate = gui.lineEdit(self,
                                               self,
                                               "value_le_repetition_rate",
                                               label="Repetition rate",
                                               validator=QIntValidator(bottom=0))
        
        self.polarizations=Polarization.all()
        self.cb_polarization = gui.comboBox(self,
                                            self,
                                            "value_cb_polarization",
                                            label="Polarization",
                                            items=[p.description() for p in self.polarizations])
        
        self.__driver_settings_widget = DriverSettingsWidget(self.__optical_source_gaussian, 
                                                             self,
                                                             "value_le_driver_settings")

        self.btn_display = gui.button(self,
                                      self,
                                      "Fire",
                                      self.onFire)  
        
        
        self.__optical_source_gaussian.setOnSynchronize(self.synchronizeToOpticalElement)      

        self.__optical_source_gaussian.setOnCalculationStart(self.calculationStart)      
        self.__optical_source_gaussian.setOnCalculationFinished(self.calculationFinished)      


    def calculationStart(self):
        return
        self.progressBarInit()
        self.progressBarSet(0)
        QApplication.processEvents()

    def calculationFinished(self):
        #self.progressBarInit()
        #self.progressBarSet(100)
        return

    def synchronizeToOpticalElement(self):
        source = self.__optical_source_gaussian
        
        source.setX(float(self.value_le_x))
        source.setY(float(self.value_le_y))
        source.setZ(float(self.value_le_z))
        
        source.setSigmaX(float(self.value_le_sigma_x))
        source.setSigmaY(float(self.value_le_sigma_y))
        source.setSigmaT(float(self.value_le_sigma_t))

        source.setXp(float(self.value_le_xp))
        source.setYp(float(self.value_le_yp))
        
        source.setAveragePhotonEnergy(float(self.value_le_average_photon_energy))
        source.setPulseEnergy(float(self.value_le_pulse_energy))
        source.setRepititionRate(float(self.value_le_repetition_rate))
        source.setPolarization(self.polarizations[int(self.value_cb_polarization)])
                
    def onFire(self):
        
        beam = OpticalBeam(self.__optical_source_gaussian)
        
        self.send("Optical beam", beam)
        for i in range(10000):
            QApplication.processEvents()
               
        driver = SRWDriver()
        self.__optical_source_gaussian.startTravers(driver)


if __name__=="__main__":
    appl = QApplication(sys.argv)
    ow = OpticalElementSourceGaussianWidget()
    ow.show()
    appl.exec_()
