__author__ = 'labx'

from Orange.menus.menu import OMenu
from Orange.canvas.scheme.link import SchemeLink

from orangecontrib.shadow.widgets.user_defined.ow_distance_calculator import MonochromatorDistanceCalculator
from orangecontrib.shadow.widgets.sources.ow_bending_magnet import BendingMagnet
from orangecontrib.shadow.widgets.optical_elements.ow_spheric_mirror import SphericMirror

class SingleFileImportMenu(OMenu):

    def __init__(self):
        super().__init__(name="Shadow Tools")

        self.addSubMenu("Import Shadow File")
        self.addSubMenu("Import Shadow Workspace")

    def executeAction_1(self, action):
        widget_desc = self.canvas_main_window.widget_registry.widget("orangecontrib.shadow.widgets.user_defined.ow_distance_calculator.MonochromatorDistanceCalculator")

        print(widget_desc)

        self.canvas_main_window.scheme_widget.createNewNode(widget_desc)

    def executeAction_2(self, action):
        widget_desc_1 = self.canvas_main_window.widget_registry.widget("orangecontrib.shadow.widgets.sources.ow_bending_magnet.BendingMagnet")
        widget_desc_2 = self.canvas_main_window.widget_registry.widget("orangecontrib.shadow.widgets.optical_elements.ow_spheric_mirror.SphericMirror")


        node_1 = self.canvas_main_window.scheme_widget.createNewNode(widget_desc_1)
        node_2 = self.canvas_main_window.scheme_widget.createNewNode(widget_desc_2)

        link = SchemeLink(source_node=node_1, source_channel="Beam", sink_node=node_2, sink_channel="Input Beam")

        self.canvas_main_window.scheme_widget.addLink(link=link)