import sys, numpy, gc, time
from Orange.widgets import gui

from PyQt4 import QtGui
from PyQt4.QtGui import QApplication, qApp

from Orange.widgets.settings import Setting

from orangecontrib.shadow.util.shadow_util import ShadowPlot, ShadowGui
from orangecontrib.shadow.widgets.gui import ow_automatic_element

from PyMca5.PyMcaGui.plotting.PlotWindow import PlotWindow

class GenericElement(ow_automatic_element.AutomaticElement):

    IMAGE_WIDTH = 900
    IMAGE_HEIGHT = 545

    want_main_area=1
    view_type=Setting(2)

    plotted_beam=None
    tab=[]

    def __init__(self, show_automatic_box=True):
        super().__init__(show_automatic_box)

        view_box = ShadowGui.widgetBox(self.mainArea, "Plotting Style", addSpace=False, orientation="horizontal")
        view_box_1 = ShadowGui.widgetBox(view_box, "", addSpace=False, orientation="vertical", width=350)

        self.view_type_combo = gui.comboBox(view_box_1, self, "view_type", label="Select level of Plotting",
                                            labelWidth=220,
                                            items=["Detailed Plot", "Preview", "None"],
                                            callback=self.set_PlotQuality, sendSelectedValue=False, orientation="horizontal")

        self.tabs = gui.tabWidget(self.mainArea)

        self.initializeTabs()

        self.shadow_output = QtGui.QTextEdit()

        out_box = gui.widgetBox(self.mainArea, "Shadow Output", addSpace=True, orientation="horizontal")
        out_box.layout().addWidget(self.shadow_output)

        self.shadow_output.setFixedHeight(150)
        self.shadow_output.setFixedWidth(850)

    def initializeTabs(self):
        size = len(self.tab)
        indexes = range(0, size)
        for index in indexes:
            self.tabs.removeTab(size-1-index)

        self.tab = [gui.createTabPage(self.tabs, "X,Z"),
                    gui.createTabPage(self.tabs, "X',Z'"),
                    gui.createTabPage(self.tabs, "X,X'"),
                    gui.createTabPage(self.tabs, "Z,Z'"),
                    gui.createTabPage(self.tabs, "Energy")]

        for tab in self.tab:
            tab.setFixedHeight(self.IMAGE_HEIGHT)
            tab.setFixedWidth(self.IMAGE_WIDTH)

        self.plot_canvas = [None, None, None, None, None]
        self.plot_upper_canvas = [None, None, None, None, None]
        self.plot_right_canvas = [None, None, None, None, None]


    def set_PlotQuality(self):
        self.progressBarInit()

        if not self.plotted_beam==None:

            self.initializeTabs()
            self.plot_results(self.plotted_beam, 80)

        self.progressBarFinished()


    def plot_xy(self, beam_out, progressBarValue, var_x, var_y, plot_canvas_index, title, xtitle, ytitle):

        if self.plot_canvas[plot_canvas_index] is None:
            self.plot_canvas[plot_canvas_index] = ShadowPlot.DetailedPlotWidget()

            self.tab[plot_canvas_index].layout().addWidget(self.plot_canvas[plot_canvas_index])

        self.plot_canvas[plot_canvas_index].plotxy(beam_out.beam, var_x, var_y, title, xtitle, ytitle)

        self.progressBarSet(progressBarValue)

    def plot_xy_fast(self, beam_out, progressBarValue, var_x, var_y, plot_canvas_index, title, xtitle, ytitle):

        if self.plot_canvas[plot_canvas_index] is None:
            self.plot_canvas[plot_canvas_index] = PlotWindow(roi=False, control=False, position=False, plugins=False)
            self.plot_canvas[plot_canvas_index].setDefaultPlotLines(False)
            self.plot_canvas[plot_canvas_index].setActiveCurveColor(color='darkblue')

            self.tab[plot_canvas_index].layout().addWidget(self.plot_canvas[plot_canvas_index])

        ShadowPlot.plotxy_preview(self.plot_canvas[plot_canvas_index], beam_out.beam, var_x, var_y, nolost=1, title=title, xtitle=xtitle, ytitle=ytitle)

        self.progressBarSet(progressBarValue)

    def plot_histo(self, beam_out, progressBarValue, var, plot_canvas_index, title, xtitle, ytitle):

        if self.plot_canvas[plot_canvas_index] is None:
            self.plot_canvas[plot_canvas_index] = PlotWindow(roi=False, control=False, position=False, plugins=False)
            self.plot_canvas[plot_canvas_index].setDefaultPlotLines(True)
            self.plot_canvas[plot_canvas_index].setActiveCurveColor(color='darkblue')
            self.tab[plot_canvas_index].layout().addWidget(self.plot_canvas[plot_canvas_index])

        ShadowPlot.plot_histo(self.plot_canvas[plot_canvas_index], beam_out.beam, var, 1, None, None, 1, title, xtitle, ytitle)
        self.progressBarSet(progressBarValue)

    def plot_results(self, beam_out, progressBarValue=80):
        if not self.view_type == 2:

            self.view_type_combo.setEnabled(False)

            if self.view_type == 1:
                self.plot_xy_fast(beam_out, progressBarValue+4, 1, 3, plot_canvas_index=0, title="X,Z", xtitle="X", ytitle="Z")
                self.plot_xy_fast(beam_out, progressBarValue+8, 4, 6, plot_canvas_index=1, title="X',Z'", xtitle="X'", ytitle="Z'")
                self.plot_xy_fast(beam_out, progressBarValue+12, 1, 4, plot_canvas_index=2, title="X,X'", xtitle="X", ytitle="X'")
                self.plot_xy_fast(beam_out, progressBarValue+16, 3, 6, plot_canvas_index=3, title="Z,Z'", xtitle="Z", ytitle="Z'")
            elif self.view_type == 0:
                self.plot_xy(beam_out, progressBarValue+4, 1, 3, plot_canvas_index=0, title="X,Z", xtitle="X", ytitle="Z")
                self.plot_xy(beam_out, progressBarValue+8, 4, 6, plot_canvas_index=1, title="X',Z'", xtitle="X'", ytitle="Z'")
                self.plot_xy(beam_out, progressBarValue+12, 1, 4, plot_canvas_index=2, title="X,X'", xtitle="X", ytitle="X'")
                self.plot_xy(beam_out, progressBarValue+16, 3, 6, plot_canvas_index=3, title="Z,Z'", xtitle="Z", ytitle="Z'")

            self.plot_histo(beam_out, progressBarValue+20, 11, plot_canvas_index=4, title="Energy", xtitle="Energy", ytitle="Number of Rays")

            self.view_type_combo.setEnabled(True)

        self.plotted_beam = beam_out

    def writeStdOut(self, text):
        cursor = self.shadow_output.textCursor()
        cursor.movePosition(QtGui.QTextCursor.End)
        cursor.insertText(text)
        self.shadow_output.setTextCursor(cursor)
        self.shadow_output.ensureCursorVisible()
        qApp.processEvents()

    def onReceivingInput(self):
        self.initializeTabs()

if __name__ == "__main__":
    a = QApplication(sys.argv)
    ow = GenericElement()
    ow.show()
    a.exec_()
    ow.saveSettings()