import sys
from PyQt4.QtGui import QIntValidator, QDoubleValidator, QApplication, QSizePolicy
from Orange.widgets import widget, gui
from Orange.widgets.settings import Setting
from Orange.data import Table, Domain, ContinuousVariable
import numpy as np

try:
    from orangecontrib.xoppy.util.xoppy_calc import xoppy_doc
except ImportError:
    print("Error importing: xoppy_doc")
    raise

try:
    from orangecontrib.xoppy.util.xoppy_calc import xoppy_calc_nsources
except ImportError:
    print("compute pressed.")
    print("Error importing: xoppy_calc_nsources")
    raise

class OWnsources(widget.OWWidget):
    name = "nsources"
    id = "orange.widgets.datansources"
    description = "xoppy application to compute..."
    icon = "icons/xoppy_nsources.png"
    author = "create_widget.py"
    maintainer_email = "srio@esrf.eu"
    priority = 10
    category = ""
    keywords = ["xoppy", "nsources"]
    outputs = [#{"name": "xoppy_data",
               # "type": np.ndarray,
               # "doc": ""},
               {"name": "xoppy_table",
                "type": Table,
                "doc": ""},
               {"name": "xoppy_specfile",
                "type": str,
                "doc": ""}]

    #inputs = [{"name": "Name",
    #           "type": type,
    #           "handler": None,
    #           "doc": ""}]

    want_main_area = False

    TEMPERATURE = Setting(300.0)
    ZONE = Setting(0)
    MAXFLUX_F = Setting(200000000000000.0)
    MAXFLUX_EPI = Setting(20000000000000.0)
    MAXFLUX_TH = Setting(200000000000000.0)
    NPOINTS = Setting(500)


    def __init__(self):
        super().__init__()

        box0 = gui.widgetBox(self.controlArea, " ",orientation="horizontal") 
        #widget buttons: compute, set defaults, help
        gui.button(box0, self, "Compute", callback=self.compute)
        gui.button(box0, self, "Defaults", callback=self.defaults)
        gui.button(box0, self, "Help", callback=self.help1)
        self.process_showers()
        box = gui.widgetBox(self.controlArea, " ",orientation="vertical") 
        
        
        idx = -1 
        
        #widget index 0 
        idx += 1 
        box1 = gui.widgetBox(box) 
        gui.lineEdit(box1, self, "TEMPERATURE",
                     label=self.unitLabels()[idx], addSpace=True,
                    valueType=float, validator=QDoubleValidator())
        self.show_at(self.unitFlags()[idx], box1) 
        
        #widget index 1 
        idx += 1 
        box1 = gui.widgetBox(box) 
        gui.comboBox(box1, self, "ZONE",
                     label=self.unitLabels()[idx], addSpace=True,
                    items=['Thermal Neutrons', 'Epithermal Neutrons', 'Fast Neutrons'],
                    valueType=int, orientation="horizontal")
        self.show_at(self.unitFlags()[idx], box1) 
        
        #widget index 2 
        idx += 1 
        box1 = gui.widgetBox(box) 
        gui.lineEdit(box1, self, "MAXFLUX_F",
                     label=self.unitLabels()[idx], addSpace=True,
                    valueType=float, validator=QDoubleValidator())
        self.show_at(self.unitFlags()[idx], box1) 
        
        #widget index 3 
        idx += 1 
        box1 = gui.widgetBox(box) 
        gui.lineEdit(box1, self, "MAXFLUX_EPI",
                     label=self.unitLabels()[idx], addSpace=True,
                    valueType=float, validator=QDoubleValidator())
        self.show_at(self.unitFlags()[idx], box1) 
        
        #widget index 4 
        idx += 1 
        box1 = gui.widgetBox(box) 
        gui.lineEdit(box1, self, "MAXFLUX_TH",
                     label=self.unitLabels()[idx], addSpace=True,
                    valueType=float, validator=QDoubleValidator())
        self.show_at(self.unitFlags()[idx], box1) 
        
        #widget index 5 
        idx += 1 
        box1 = gui.widgetBox(box) 
        gui.lineEdit(box1, self, "NPOINTS",
                     label=self.unitLabels()[idx], addSpace=True,
                    valueType=int, validator=QIntValidator())
        self.show_at(self.unitFlags()[idx], box1) 

        gui.rubber(self.controlArea)

    def unitLabels(self):
         return ['Moderator temperature [K]','Spectrum','Max flux (fast) [n/cm2/s]','Max flux (epithermal) [n/cm2/s]','Max flux (thermal) [n/cm2/s]','Number of points ']


    def unitFlags(self):
         return ['True','True','self.ZONE  ==  2','self.ZONE  ==  1','self.ZONE  ==  0','True']


    #def unitNames(self):
    #     return ['TEMPERATURE','ZONE','MAXFLUX_F','MAXFLUX_EPI','MAXFLUX_TH','NPOINTS']


    def compute(self):
        fileName = xoppy_calc_nsources(TEMPERATURE=self.TEMPERATURE,ZONE=self.ZONE,MAXFLUX_F=self.MAXFLUX_F,MAXFLUX_EPI=self.MAXFLUX_EPI,MAXFLUX_TH=self.MAXFLUX_TH,NPOINTS=self.NPOINTS)
        #send specfile
        self.send("xoppy_specfile",fileName)

        print("Loading file:  ",fileName)
        #load spec file with one scan, # is comment
        out = np.loadtxt(fileName)
        print("data shape: ",out.shape)
        #get labels
        txt = open(fileName).readlines()
        tmp = [ line.find("#L") for line in txt]
        itmp = np.where(np.array(tmp) != (-1))
        labels = txt[itmp[0]].replace("#L ","").split("  ")
        print("data labels: ",labels)
        #
        # build and send orange table
        #
        domain = Domain([ ContinuousVariable(i) for i in labels ])
        table = Table.from_numpy(domain, out)
        self.send("xoppy_table",table)

    def defaults(self):
         self.resetSettings()
         self.compute()
         return

    def help1(self):
        print("help pressed.")
        xoppy_doc('nsources')





if __name__ == "__main__":
    app = QApplication(sys.argv)
    w = OWnsources()
    w.show()
    app.exec()
    w.saveSettings()
