import Orange.statistics.contingency

monks = Orange.data.Table("monks-1.tab")
cont = Orange.statistics.contingency.VarClass("e", monks)

print "Inner variable: ", cont.inner_variable.name
print "Outer variable: ", cont.outer_variable.name
print
print "Class variable: ", cont.class_var.name
print "Feature:      ", cont.variable.name
print

print "Distributions:"
for val in cont.variable:
    print "  p(.|%s) = %s" % (val.native(), cont.p_class(val))
print

first_class = Orange.data.Value(cont.class_var, 1)
first_native = first_class.native()
print "Probabilities of class '%s'" % first_native
for val in cont.variable:
    print "  p(%s|%s) = %5.3f" % (first_native, val.native(), 
                                  cont.p_class(val, first_class))
print

cont = Orange.statistics.contingency.VarClass(monks.domain["e"],
                                              monks.domain.class_var)
for ins in monks:
    cont.add_var_class(ins["e"], ins.getclass())

print "Distributions from a matrix computed manually:"
for val in cont.variable:
    print "  p(.|%s) = %s" % (val.native(), cont.p_class(val))
print
