import urllib2
from optparse import OptionParser
import ConfigParser
import os.path
import os

def _build_parser():
    p = OptionParser()
    p.add_option("-o", "--output", dest="output", default=".")
    p.add_option("-c", "--config", dest="config", default=".ovenrc")
    p.add_option("-s", "--server", dest="server")
    return p

def compile_single(fname, f, url, output_dir):

    opener = urllib2.build_opener(urllib2.HTTPHandler)
    request = urllib2.Request(url, data = f)
    request.add_header('Content-Type', 'text/html')
    request.get_method = lambda: 'PUT'
    response = opener.open(request)

    f = response.read()


    d = os.path.expanduser(os.path.normpath(output_dir))

    with open("%s/%s.js" % (d, fname), "w") as x:
        x.write(f)

def main():

    (opts, args) = _build_parser().parse_args()

    # Try to import the server from a config file
    try:
        c = ConfigParser.ConfigParser()
        c.read(opts.config)
        url = c.get('server', 'server')
    except ConfigParser.Error as e:
        if opts.server:
            url = opts.server
        else:
            url = raw_input("Enter a server: ")

    # now we have a valid url
    if len(args) < 1:
        print("Please provide a filename")

    if os.path.isdir(args[0]):
        for root, dirs, files in os.walk(args[0]):
            for fname in files:
                if fname.endswith(".coffee"):
                    froot = fname.rsplit(".")[0]
                    f = open("%s/%s" % (root, fname)).read()
                    compile_single(froot, f, url, opts.output)
    elif os.path.isfile(args[0]):
        if args[0].endswith(".coffee"):
            f = open(args[0]).read()
            froot = args[0].rsplit(".")[0]
            compile_single(froot, f, url, opts.output)
    else:
        print("The first argument does not exist")


if __name__ == "__main__":
    main()
