--usage:
--sqlite3.exe pywofost.db
--sqlite> .read layeredWaterbalance_Testdata.sql

delete from soil_physical_group where soil_group_no = 1;
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_01',-1,1.8451);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_02',1,1.02119);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_03',1.3,0.51055);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_04',1.7,-0.52288);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_05',2,-1.50864);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_06',2.3,-2.56864);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_07',2.4,-2.92082);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_08',2.7,-4.01773);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_09',3,-5.11919);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_10',3.3,-6.22185);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_11',3.7,-7.69897);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_12',4,-8.79588);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_13',4.17,-9.4318);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_14',4.2,-9.5376);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'CONTAB_15',6,-11.5376);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'CRITICAL_AIR_CONTENT',0.09);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'HYDR_CONDUCT_SATUR',70);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'MAX_PERCOL_ROOT_ZONE',70);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'MAX_PERCOL_SUBSOIL',70);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'RQ_MOISTURE_DEFICIT_DEEP',0);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'SEEPAGE_1_DEEP',0.8);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'SEEPAGE_1_SHALLOW',0.9);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'SEEPAGE_2_DEEP',0.04);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'SEEPAGE_2_SHALLOW',0.07);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_01',-1,0.366);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_02',1,0.338);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_03',1.3,0.304);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_04',1.7,0.233);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_05',2,0.179);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_06',2.3,0.135);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_07',2.4,0.123);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_08',2.7,0.094);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_09',3,0.073);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_10',3.3,0.059);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_11',3.7,0.046);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_12',4,0.039);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_13',4.17,0.037);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_14',4.2,0.036);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue, parameter_yvalue) values(1,'SMTAB_15',6,0.02);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'SOIL_MOISTURE_CONTENT_FC',0.179);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'SOIL_MOISTURE_CONTENT_SAT',0.366);
insert into soil_physical_group (soil_group_no, parameter_code, parameter_xvalue) values(1,'SOIL_MOISTURE_CONTENT_WP',0.036);

delete from soil_layers where soil_type_no = 2;
insert into soil_layers (soil_type_no, LAYER_NO, THICKNESS, soil_group_no) values(2,1,10,1);
insert into soil_layers (soil_type_no, LAYER_NO, THICKNESS, soil_group_no) values(2,2,10,1);
insert into soil_layers (soil_type_no, LAYER_NO, THICKNESS, soil_group_no) values(2,3,10,1);
insert into soil_layers (soil_type_no, LAYER_NO, THICKNESS, soil_group_no) values(2,4,20,1);
insert into soil_layers (soil_type_no, LAYER_NO, THICKNESS, soil_group_no) values(2,5,30,1);
insert into soil_layers (soil_type_no, LAYER_NO, THICKNESS, soil_group_no) values(2,6,45,1);

-- grid 35042
delete from site where grid_no=35042 and year=2000;
insert into site (grid_no, "year", ifunrn, max_surface_storage, not_infiltrating_fraction, initial_surface_storage, inital_water_availability,smlim) 
values (35042,2000,0,0,0,0,22,0.179);

delete from soil_type where grid_no=35042 and soil_type_no=1;
insert into soil_type (grid_no, soil_type_no) values (35042, 1);

delete from crop_calendar where grid_no=35042 and year=2000 and crop_no=3;
insert into crop_calendar(grid_no, crop_no,variety_no, "year", start_date, crop_start_type, crop_start_date, crop_end_type, crop_end_date, max_duration) 
values (35042,3,1,2000,'2000-01-01','emergence','2000-03-06','maturity','2000-12-31',365);

-- grid 1
delete from grid where grid_no=1;
insert into grid (grid_no, latitude, longitude, altitude, climate_barrier_no, distance_to_coast) values (1,40.18,-0.14,327, 0, 0);

delete from soil_type where grid_no=1;
insert into soil_type (grid_no, soil_type_no) values (1, 1);

delete from site where grid_no=1 and year=1965;
insert into site (grid_no, "year", ifunrn, max_surface_storage, not_infiltrating_fraction, initial_surface_storage, inital_water_availability,smlim) values (1,1965,0,100,0,0,22,0.179);

delete from crop_calendar where grid_no=1 and year=1965;
insert into crop_calendar(grid_no, crop_no,variety_no, "year", start_date, crop_start_type, crop_start_date, crop_end_type, crop_end_date, max_duration) 
values (1,3,1,1965,'1965-01-01','sowing','1965-02-24','harvest','1965-09-30',365);

delete from grid_weather where grid_no=1;
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-01",9.69,5.09,10.02,1.94,0.10,0.16,0.08,0.42,3938
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-02",13.60,5.90,8.57,3.48,0.00,0.77,0.65,1.31,5639
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-03",15.50,6.09,7.82,4.45,0.00,1.16,0.98,1.96,8044
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-04",17.00,5.19,8.13,1.67,0.00,0.51,0.30,1.13,9081
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-05",16.39,2.50,9.07,1.25,0.00,0.31,0.11,0.80,9206
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-06",12.39,4.00,10.02,1.11,0.00,0.22,0.09,0.53,6158
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-07",18.00,1.60,9.02,1.53,0.00,0.39,0.18,0.99,9514
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-08",19.00,6.69,8.22,3.75,0.00,1.26,1.06,2.23,8229
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-09",13.89,9.30,9.97,3.06,0.00,0.80,0.69,1.24,4843
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-10",10.10,5.30,5.88,6.26,0.00,1.64,1.50,2.14,6471
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-11",10.19,1.79,4.57,3.48,0.00,0.96,0.77,1.68,9161
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-12",9.50,1.50,5.23,2.64,0.00,0.68,0.52,1.24,8419
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-13",16.60,-0.40,6.78,1.94,0.00,0.55,0.33,1.30,10138
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-14",12.89,2.20,8.43,1.80,0.00,0.42,0.28,0.82,6692
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-15",14.10,4.80,8.68,2.08,0.00,0.59,0.39,1.05,9056
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-16",14.30,-0.10,7.88,1.94,0.00,0.46,0.26,0.98,9655
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-17",11.69,4.19,9.07,2.36,0.10,0.46,0.35,0.79,5160
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-18",12.39,3.50,6.67,3.34,0.00,0.94,0.77,1.52,8021
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-19",14.39,3.40,6.13,2.36,0.00,0.86,0.64,1.54,10027
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-20",15.10,-0.20,7.38,1.53,0.00,0.53,0.32,1.04,9979
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-21",12.60,1.79,9.63,1.80,0.00,0.33,0.20,0.64,6189
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-22",12.80,8.69,11.93,2.78,0.10,0.43,0.35,0.67,3516
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-23",11.69,8.39,11.43,1.53,0.00,0.42,0.30,0.64,5420
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-24",14.10,4.50,9.88,1.80,0.00,0.61,0.39,0.93,9825
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-25",14.10,3.09,9.02,2.36,0.00,0.70,0.46,1.09,10847
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-26",17.89,3.29,8.13,4.03,0.00,1.33,1.10,2.15,9941
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-27",16.60,9.60,8.43,5.42,0.00,2.04,1.88,2.70,6355
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-28",19.39,9.69,8.63,6.54,0.00,2.64,2.37,3.49,10822
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-29",19.20,10.80,8.38,6.26,0.00,2.72,2.49,3.57,9107
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-30",14.30,9.50,7.63,3.75,0.00,1.60,1.37,2.18,9744
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-01-31",10.80,3.29,4.42,3.75,0.00,1.52,1.33,2.14,9076
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-01",9.30,-2.09,3.82,3.34,0.00,1.17,0.96,1.76,11659
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-02",11.60,-0.69,4.98,3.06,0.00,1.14,0.91,1.72,11847
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-03",13.89,1.10,6.48,2.36,0.00,1.04,0.79,1.55,11729
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-04",18.00,1.00,7.28,1.53,0.00,1.01,0.74,1.54,12115
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-05",21.50,4.69,7.17,3.48,0.00,1.89,1.57,2.98,13168
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-06",18.20,9.39,6.88,2.78,0.00,1.76,1.48,2.50,11420
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-07",15.80,5.59,6.78,3.34,0.00,1.60,1.40,2.24,8970
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-08",15.50,6.09,6.63,3.06,0.00,1.61,1.37,2.21,10652
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-09",14.19,3.00,7.03,4.03,0.00,1.46,1.28,1.98,8292
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-10",10.30,2.79,4.38,5.84,0.00,2.25,2.02,2.67,11431
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-11",10.89,2.09,4.48,5.56,0.00,2.17,1.93,2.62,11955
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-12",12.39,4.19,4.88,4.45,0.00,2.07,1.81,2.62,11975
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-13",10.39,0.60,3.82,3.06,0.00,1.55,1.31,2.07,12096
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-14",9.50,0.40,3.93,3.61,0.00,1.65,1.41,2.11,12469
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-15",11.19,-0.89,5.53,2.64,0.00,1.21,0.99,1.59,11070
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-16",15.10,2.40,6.88,1.94,0.00,1.29,1.05,1.69,10844
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-17",14.89,5.00,8.56,3.61,0.00,1.65,1.37,1.94,12599
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-18",18.89,5.90,7.73,4.17,0.00,2.37,2.03,3.01,14301
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-19",19.70,7.90,8.47,3.48,0.00,2.27,1.94,2.86,13263
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-20",22.00,6.69,6.98,3.34,0.00,2.38,2.09,3.33,11483
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-21",21.89,10.19,8.68,4.73,0.00,3.12,2.74,3.88,14557
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-22",17.20,11.80,8.72,5.56,0.00,2.97,2.67,3.36,11815
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-23",18.20,10.00,7.82,3.48,0.00,2.44,2.13,2.96,12484
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-24",19.29,9.89,9.72,2.36,0.00,1.93,1.66,2.30,10988
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-25",13.10,9.60,11.72,1.94,0.10,0.85,0.73,1.00,5311
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-26",16.20,7.19,10.32,2.78,0.00,1.71,1.42,1.85,12082
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-27",12.89,7.00,10.93,1.94,0.10,0.93,0.77,1.04,7047
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-02-28",15.69,9.89,10.47,2.50,0.10,1.59,1.37,1.78,8988
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-01",16.89,7.69,9.02,2.36,0.00,1.99,1.67,2.20,13364
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-02",20.39,4.80,8.82,1.94,0.00,2.18,1.79,2.49,16308
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-03",19.89,4.09,8.68,3.06,0.00,2.20,1.88,2.67,13617
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-04",14.80,7.59,5.78,6.54,0.00,3.53,3.23,3.79,13204
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-05",14.50,7.80,4.98,6.40,0.00,3.73,3.41,4.04,13974
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-06",15.30,4.19,5.28,3.75,0.00,2.69,2.33,3.10,15872
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-07",16.50,3.20,5.67,3.20,0.00,2.42,2.10,2.89,14424
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-08",16.89,6.00,9.50,3.34,0.00,2.16,1.84,2.30,13504
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-09",16.70,4.69,10.88,1.94,0.00,1.80,1.47,1.80,14157
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-10",19.20,7.19,11.72,1.53,0.00,1.96,1.63,2.00,13605
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-11",18.60,7.90,12.22,1.80,10.00,1.86,1.56,1.89,12348
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-12",14.80,10.50,13.32,1.67,0.10,1.11,0.94,1.16,7030
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-13",14.80,10.10,13.18,1.67,0.10,1.36,1.14,1.34,9257
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-14",11.30,9.69,12.93,2.78,0.10,0.71,0.59,0.65,5111
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-15",15.00,9.50,12.72,2.92,0.10,1.49,1.27,1.42,9428
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-16",20.89,8.10,11.38,2.78,0.00,2.89,2.45,2.91,17407
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-17",21.20,9.39,10.88,3.06,0.00,3.04,2.62,3.15,16523
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-18",18.89,7.40,10.97,3.06,0.00,2.78,2.36,2.70,17319
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-19",19.89,8.60,9.02,5.15,0.00,3.72,3.30,3.86,17117
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-20",18.39,6.09,9.38,3.20,0.00,2.98,2.54,2.96,18493
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-21",18.20,6.59,10.77,2.50,0.00,2.55,2.15,2.47,16414
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-22",19.39,8.10,9.13,3.34,0.00,3.36,2.90,3.40,18854
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-23",17.70,7.30,9.13,2.64,0.00,2.97,2.53,2.91,18397
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-24",12.69,5.80,11.27,1.67,0.10,1.08,0.91,1.09,7917
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-25",19.39,8.10,11.27,3.20,0.00,2.58,2.24,2.61,13638
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-26",15.10,7.59,6.67,6.54,0.00,3.95,3.58,3.81,15721
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-27",15.69,8.30,6.38,6.68,0.00,4.12,3.78,4.10,14425
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-28",18.20,6.69,6.78,5.01,0.00,4.04,3.59,4.14,18959
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-29",20.60,7.09,7.57,3.06,0.00,3.66,3.17,3.85,19779
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-30",21.10,4.80,8.88,1.80,0.00,3.22,2.72,3.22,20636
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-03-31",18.60,6.90,12.02,2.08,10.00,2.44,2.08,2.30,15227
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-01",19.60,8.19,12.32,2.78,0.00,3.02,2.59,2.77,17731
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-02",23.00,7.59,9.88,2.50,0.00,3.51,3.03,3.63,18704
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-03",25.29,9.39,10.77,2.22,0.00,3.79,3.27,3.89,19460
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-04",23.60,11.00,12.82,2.36,0.00,3.73,3.22,3.57,19299
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-05",24.20,9.89,13.38,1.39,0.00,3.55,3.03,3.31,19875
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-06",25.29,9.10,12.63,1.80,0.00,3.81,3.26,3.67,20667
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-07",20.89,10.69,9.97,4.45,0.00,3.98,3.55,4.00,16617
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-08",22.79,9.69,6.98,6.26,0.00,5.75,5.20,5.99,21392
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-09",20.60,8.30,8.02,3.34,0.00,4.18,3.65,4.18,21227
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-10",24.29,5.90,9.72,2.64,0.00,4.24,3.64,4.27,23349
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-11",21.39,10.50,9.07,4.03,0.00,4.65,4.09,4.55,21491
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-12",19.10,8.89,8.57,2.92,0.00,3.59,3.14,3.55,17905
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-13",20.39,10.89,8.32,4.03,0.00,4.72,4.16,4.61,21682
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-14",19.70,7.30,9.68,2.64,0.00,3.63,3.13,3.44,19998
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-15",12.39,8.10,9.38,3.06,0.10,2.20,1.93,2.03,11876
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-16",16.79,3.29,7.38,4.03,0.10,3.54,3.11,3.40,19388
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-17",17.20,8.30,6.42,7.09,0.00,5.37,4.88,4.93,20429
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-18",19.50,6.80,6.98,4.03,0.00,4.47,3.94,4.42,21551
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-19",21.29,5.80,10.32,2.36,0.00,3.99,3.42,3.71,23068
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-20",26.50,9.89,11.22,3.20,30.00,3.94,3.52,4.31,15784
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-21",24.70,15.69,11.43,4.59,0.00,5.33,4.79,5.31,19325
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-22",24.89,13.19,9.38,3.06,0.00,4.73,4.19,4.86,19720
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-23",23.79,10.19,9.77,4.17,0.00,4.79,4.26,4.85,19835
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-24",22.00,10.30,9.77,3.20,0.00,4.78,4.17,4.51,23194
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-25",21.60,7.69,12.47,2.08,0.00,3.42,2.96,3.16,18538
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-26",22.89,9.69,11.63,1.94,0.10,3.91,3.39,3.67,19918
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-27",15.10,11.10,13.02,3.06,0.10,1.97,1.73,1.76,9947
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-28",14.80,11.39,13.22,2.50,0.10,2.07,1.80,1.82,11062
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-29",20.00,7.00,12.32,2.36,0.10,3.43,2.96,3.05,19380
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-04-30",23.00,9.10,13.18,1.94,0.00,4.17,3.60,3.74,22155
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-01",21.79,11.10,12.13,2.78,0.00,3.95,3.47,3.67,18564
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-02",20.79,12.10,14.57,1.80,0.00,3.14,2.73,2.82,15643
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-03",19.10,12.60,15.18,2.36,0.10,2.64,2.30,2.33,12951
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-04",24.70,12.50,12.13,5.70,0.00,5.99,5.36,5.54,23274
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-05",28.29,15.89,13.82,4.45,0.00,5.73,5.15,5.72,20073
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-06",25.00,14.10,15.77,2.78,0.10,4.66,4.08,4.15,20724
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-07",23.39,14.69,17.97,2.36,0.00,3.94,3.43,3.34,18349
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-08",24.89,14.30,16.07,2.50,0.00,4.72,4.12,4.14,21380
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-09",22.50,13.50,16.72,2.36,0.00,3.99,3.47,3.38,19241
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-10",24.60,14.50,17.87,1.94,60.00,4.10,3.57,3.55,18948
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-11",26.70,14.39,18.87,1.80,0.00,4.93,4.29,4.20,22791
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-12",25.39,14.80,19.57,1.67,0.00,4.66,4.05,3.90,21976
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-13",24.50,15.50,18.62,1.80,0.00,3.97,3.47,3.42,18044
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-14",32.59,14.89,15.63,3.48,0.00,6.69,5.92,6.54,25886
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-15",24.10,15.60,18.43,2.36,0.10,4.18,3.66,3.55,18753
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-16",19.70,16.29,17.37,3.20,0.10,2.62,2.32,2.30,11038
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-17",23.50,15.30,13.07,3.61,0.00,4.89,4.36,4.55,19298
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-18",22.60,12.39,11.77,4.73,0.00,5.28,4.71,4.79,21365
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-19",21.60,10.60,10.57,3.89,0.10,4.24,3.79,4.10,17119
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-20",24.29,11.89,9.63,4.17,0.00,6.17,5.47,5.83,25928
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-21",23.39,13.30,10.43,4.45,0.00,5.95,5.30,5.53,23824
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-22",26.60,13.19,10.88,3.48,0.00,6.05,5.35,5.82,25003
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-23",24.79,12.80,13.07,2.64,0.00,5.70,4.98,5.04,26481
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-24",24.10,13.50,15.18,2.64,0.00,5.09,4.45,4.39,23427
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-25",25.29,12.39,15.52,2.50,0.00,5.47,4.76,4.69,25744
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-26",25.20,13.69,15.22,2.92,0.00,4.77,4.21,4.30,20448
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-27",25.39,16.29,16.12,2.36,0.00,4.10,3.64,3.80,16320
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-28",23.89,14.30,16.97,2.92,0.00,4.53,3.98,3.86,20198
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-29",23.00,17.50,19.12,2.08,0.00,3.33,2.94,2.91,14029
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-30",25.20,16.20,19.57,2.36,50.00,3.13,2.78,2.86,12549
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-05-31",24.50,17.70,20.57,1.94,0.00,4.16,3.65,3.49,18052
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-01",27.50,16.50,19.62,2.64,0.00,4.86,4.28,4.23,19841
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-02",31.29,18.39,15.02,3.34,0.00,6.78,6.03,6.50,24740
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-03",31.50,15.19,13.72,2.92,0.00,6.76,5.97,6.49,26981
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-04",25.39,16.89,14.82,3.06,0.00,5.65,5.00,5.05,22957
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-05",27.50,19.50,20.03,3.06,0.00,6.35,5.60,5.31,25320
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-06",23.39,16.50,15.63,3.34,0.00,4.11,3.67,3.77,15541
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-07",23.10,15.69,17.22,2.36,0.00,3.55,3.13,3.15,14951
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-08",24.10,14.89,15.72,2.64,0.00,4.93,4.33,4.27,21603
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-09",23.70,14.10,17.32,1.67,0.10,4.00,3.49,3.45,18535
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-10",26.00,13.50,16.32,2.64,0.00,5.27,4.62,4.58,23370
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-11",26.39,14.19,16.22,2.50,0.00,5.49,4.81,4.79,24124
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-12",26.39,14.80,17.22,2.64,0.00,4.99,4.39,4.38,21169
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-13",26.29,16.89,18.18,2.50,0.00,4.53,4.01,4.03,18159
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-14",26.89,16.60,17.22,3.20,0.00,5.96,5.26,5.16,24356
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-15",27.20,15.50,17.43,2.64,0.00,5.93,5.21,5.09,25440
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-16",27.89,16.20,19.97,2.50,0.00,5.77,5.06,4.85,24507
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-17",28.10,17.10,14.47,4.45,0.00,7.28,6.48,6.60,27328
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-18",27.79,16.50,16.47,2.64,0.00,5.67,5.01,5.08,23020
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-19",22.60,18.89,21.18,2.78,10.00,3.18,2.81,2.67,13070
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-20",28.10,16.79,17.22,3.34,0.00,6.55,5.78,5.70,26428
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-21",30.10,18.29,15.77,4.03,0.00,7.45,6.63,6.83,27463
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-22",23.89,17.10,16.68,3.34,0.10,4.29,3.82,3.85,16398
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-23",24.20,18.00,19.28,2.78,0.00,3.95,3.50,3.43,15785
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-24",27.39,15.80,17.53,2.50,0.00,5.54,4.88,4.84,23317
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-25",27.70,16.20,18.32,2.36,0.00,6.13,5.37,5.20,26357
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-26",28.20,16.70,19.68,2.78,0.00,6.08,5.35,5.13,25295
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-27",29.20,17.50,20.68,2.22,0.00,6.37,5.58,5.34,26545
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-28",25.89,18.00,19.12,3.06,0.00,4.65,4.13,4.06,18136
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-29",29.29,17.39,19.87,2.22,0.00,6.12,5.37,5.23,25256
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-06-30",29.10,18.60,21.78,2.64,0.00,6.18,5.45,5.16,24859
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-01",29.89,18.89,21.18,3.06,0.00,6.25,5.54,5.37,24052
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-02",30.10,18.70,22.28,2.92,0.00,6.38,5.63,5.37,25034
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-03",30.20,18.29,22.72,2.36,0.00,6.33,5.57,5.27,25583
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-04",30.29,19.20,22.22,2.64,0.00,5.96,5.27,5.11,23008
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-05",30.39,20.10,21.72,3.48,0.00,6.69,5.94,5.73,24824
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-06",28.60,19.60,19.18,3.34,0.00,6.21,5.51,5.44,23391
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-07",30.10,19.70,18.72,3.34,0.00,6.44,5.73,5.81,23583
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-08",29.89,18.70,18.57,2.78,0.00,6.76,5.96,5.91,26730
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-09",30.00,17.89,19.97,2.64,10.00,5.95,5.26,5.22,23441
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-10",29.50,18.39,20.62,3.06,0.00,6.51,5.75,5.53,25804
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-11",29.10,19.89,20.53,3.06,0.00,6.05,5.36,5.24,22925
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-12",28.39,18.70,20.68,2.36,0.00,5.55,4.89,4.74,22328
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-13",30.10,18.79,20.82,1.94,0.00,5.33,4.70,4.67,20995
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-14",30.50,19.70,17.28,2.92,0.00,6.72,5.95,6.10,25520
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-15",29.89,17.89,21.62,2.78,0.00,6.43,5.66,5.40,26045
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-16",29.20,20.00,22.72,2.92,0.00,5.46,4.84,4.66,20721
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-17",28.89,21.20,23.53,3.20,0.00,5.12,4.56,4.40,18619
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-18",28.70,20.10,23.07,3.06,0.00,5.45,4.82,4.58,20849
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-19",30.50,19.50,21.93,2.92,0.00,6.20,5.49,5.34,23757
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-20",30.79,19.70,23.28,2.92,0.00,6.41,5.66,5.40,24701
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-21",31.70,19.39,22.47,2.92,0.00,6.63,5.86,5.70,25339
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-22",30.70,20.50,21.68,2.92,0.00,6.59,5.83,5.67,25015
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-23",29.89,19.79,18.93,3.48,0.00,6.14,5.47,5.58,22276
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-24",29.89,20.00,22.57,3.06,0.00,5.61,4.97,4.85,21030
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-25",29.89,20.70,22.93,3.61,0.00,5.82,5.18,5.02,21134
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-26",29.70,21.00,21.62,3.75,0.00,5.98,5.34,5.26,21324
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-27",31.70,19.50,20.28,2.36,0.00,6.34,5.59,5.61,24691
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-28",30.20,16.00,19.22,2.08,0.00,5.45,4.78,4.85,22807
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-29",28.89,20.50,21.18,2.50,10.00,4.61,4.10,4.17,16924
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-30",31.29,20.10,22.37,2.78,0.00,5.63,4.99,5.00,20823
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-07-31",25.29,20.39,23.28,2.64,0.10,3.20,2.84,2.78,12296
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-01",28.79,17.10,22.87,1.94,0.00,5.33,4.65,4.42,22956
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-02",29.39,20.10,24.53,2.92,0.00,5.31,4.69,4.43,20644
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-03",27.50,20.20,25.18,2.50,0.00,3.42,3.03,2.94,13176
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-04",31.70,20.60,24.87,2.08,0.00,6.15,5.42,5.15,24077
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-05",30.89,21.10,26.22,2.36,0.00,5.64,4.97,4.67,21716
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-06",30.89,22.10,26.57,2.36,0.00,5.09,4.51,4.30,18876
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-07",31.00,22.20,25.97,3.06,0.00,6.01,5.33,5.01,22198
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-08",32.70,21.89,19.72,4.03,0.00,7.00,6.26,6.58,23679
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-09",34.00,20.79,18.97,2.64,0.00,6.25,5.55,5.94,22672
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-10",31.70,20.79,17.93,2.36,0.00,5.78,5.11,5.40,21791
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-11",30.00,19.70,21.28,2.64,0.00,5.65,4.99,4.95,22227
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-12",31.60,19.60,21.87,2.64,0.00,5.24,4.65,4.77,19572
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-13",28.70,20.70,21.57,3.48,0.00,4.63,4.14,4.24,16315
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-14",31.00,20.10,23.12,2.64,0.00,5.81,5.12,5.00,22633
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-15",30.00,19.79,24.28,3.06,0.00,5.20,4.59,4.42,20169
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-16",33.00,20.60,25.87,2.78,0.00,6.11,5.40,5.22,23014
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-17",30.00,23.20,26.22,2.78,0.00,4.90,4.35,4.18,17764
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-18",28.10,23.39,22.37,3.34,10.00,4.00,3.62,3.81,12681
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-19",31.60,20.79,26.03,2.22,0.00,5.16,4.55,4.39,19918
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-20",31.10,19.70,21.62,2.22,0.00,5.24,4.61,4.67,20669
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-21",30.00,20.89,24.32,2.36,0.00,4.40,3.89,3.87,16696
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-22",30.89,20.29,25.12,2.36,0.00,4.89,4.31,4.20,19059
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-23",30.89,20.50,25.62,2.92,0.00,5.48,4.83,4.60,21345
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-24",30.20,20.70,25.78,2.64,0.00,4.52,3.99,3.87,17393
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-25",32.50,20.89,24.78,1.94,0.10,4.56,4.03,4.08,17101
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-26",33.09,22.79,23.47,2.36,0.00,5.03,4.48,4.64,17712
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-27",31.29,20.79,25.87,2.08,0.00,4.81,4.24,4.12,18855
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-28",31.20,21.39,26.22,2.50,0.00,4.68,4.14,4.05,17708
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-29",29.89,20.60,23.87,2.78,0.00,4.83,4.26,4.20,18788
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-30",30.39,20.29,23.47,2.36,0.10,4.24,3.75,3.83,16240
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-08-31",29.89,19.79,22.82,2.64,0.00,4.22,3.73,3.84,16176
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-01",29.29,20.39,24.57,2.64,0.00,4.03,3.56,3.54,15684
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-02",33.20,19.79,22.47,2.36,0.00,5.44,4.79,4.94,21354
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-03",34.59,19.10,22.72,3.34,0.00,5.57,4.94,5.37,20218
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-04",26.29,20.79,22.62,2.36,0.10,2.70,2.41,2.55,9936
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-05",27.70,18.00,21.78,2.08,0.10,3.72,3.25,3.30,16081
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-06",27.60,18.00,22.47,2.36,0.10,4.14,3.61,3.54,18338
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-07",27.29,16.60,20.03,2.64,10.00,3.39,2.98,3.19,14213
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-08",27.79,16.60,20.22,2.36,0.00,4.21,3.66,3.74,19064
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-09",29.89,17.20,20.87,1.80,0.00,4.45,3.86,3.96,19929
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-10",29.60,16.70,20.12,2.22,0.00,4.45,3.87,4.04,19791
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-11",29.29,16.79,21.03,2.36,0.00,4.25,3.70,3.83,18782
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-12",28.39,17.70,21.47,2.50,0.00,4.13,3.60,3.67,18090
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-13",27.20,17.70,21.12,2.78,2.00,3.47,3.04,3.17,14706
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-14",24.39,17.20,19.28,3.75,8.00,2.98,2.64,2.80,12068
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-15",27.70,15.00,15.68,3.34,0.00,4.46,3.90,4.39,19687
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-16",30.70,14.39,16.97,2.50,0.00,4.41,3.83,4.39,20051
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-17",28.50,16.20,16.07,3.75,0.00,4.32,3.83,4.46,17017
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-18",25.89,15.10,14.93,2.92,0.00,3.50,3.08,3.59,14989
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-19",17.89,17.29,15.82,2.64,6.00,1.63,1.46,1.73,6146
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-20",24.29,13.39,11.52,4.45,0.00,4.32,3.82,4.52,18193
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-21",26.50,14.00,14.77,4.45,0.00,3.64,3.26,3.98,13385
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-22",27.00,13.89,17.97,2.08,0.00,3.54,3.03,3.30,18031
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-23",29.20,13.80,19.57,1.80,0.00,3.52,3.02,3.30,17515
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-24",29.39,15.89,20.07,1.94,0.00,3.63,3.13,3.40,17158
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-25",24.10,16.50,18.82,2.78,0.00,2.22,1.96,2.24,9306
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-26",26.50,15.80,14.68,2.78,0.00,3.44,3.02,3.61,15047
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-27",27.20,14.00,17.43,2.08,0.00,2.98,2.57,2.97,14594
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-28",29.60,14.30,16.53,2.22,0.00,3.58,3.09,3.67,17210
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-29",30.10,14.30,16.47,2.22,0.00,3.74,3.21,3.82,18230
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-09-30",27.29,16.00,13.18,4.31,0.00,4.16,3.71,4.67,15790
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-01",25.89,14.80,13.88,2.64,0.00,3.40,2.94,3.55,16635
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-02",26.29,12.89,17.07,1.25,0.00,2.35,2.00,2.33,12665
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-03",27.89,13.60,13.88,3.06,0.00,3.41,2.97,3.83,15389
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-04",22.50,15.00,10.43,3.06,0.00,3.13,2.75,3.53,14017
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-05",20.10,13.50,11.68,1.94,0.00,1.94,1.70,2.18,8820
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-06",15.80,14.10,15.52,1.53,16.00,0.85,0.73,0.98,4482
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-07",17.50,13.19,16.62,1.53,6.00,1.09,0.91,1.12,6885
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-08",20.20,12.60,14.93,2.64,0.00,2.00,1.70,2.00,11429
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-09",22.39,11.10,13.63,1.94,0.00,2.37,1.98,2.42,14822
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-10",23.79,9.30,13.47,1.80,0.00,2.30,1.91,2.44,14801
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-11",22.39,11.60,16.93,1.67,0.30,1.48,1.25,1.57,8808
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-12",17.89,14.39,18.28,1.94,7.00,0.78,0.65,0.84,4927
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-13",24.89,13.39,18.62,1.53,0.00,2.13,1.78,2.07,12764
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-14",24.60,13.60,18.47,1.25,0.00,1.89,1.58,1.87,11257
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-15",25.20,12.80,17.07,1.67,0.00,2.22,1.85,2.24,13445
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-16",24.70,11.89,16.93,1.80,0.00,2.19,1.81,2.20,13917
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-17",22.60,14.60,18.03,1.53,2.00,1.53,1.29,1.59,8783
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-18",20.00,11.89,12.82,3.20,0.00,1.96,1.69,2.21,10464
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-19",21.50,10.00,12.02,2.78,0.00,1.89,1.63,2.28,10334
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-20",16.10,11.00,13.43,2.36,0.69,0.93,0.80,1.11,5298
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-21",21.89,11.69,12.02,4.45,0.00,2.52,2.22,3.00,11666
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-22",23.60,13.60,14.52,3.48,0.00,2.02,1.80,2.48,8198
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-23",23.00,13.50,13.88,3.75,0.00,2.26,1.98,2.68,10317
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-24",18.39,16.10,14.43,3.34,0.00,1.44,1.32,1.77,4734
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-25",21.29,10.89,12.02,2.78,0.00,1.94,1.63,2.32,12052
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-26",16.10,10.30,14.27,1.67,1.20,0.71,0.58,0.87,5450
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-27",20.00,12.60,16.57,1.39,0.10,1.03,0.84,1.16,7173
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-28",22.50,12.39,17.03,0.83,0.00,1.12,0.92,1.25,7785
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-29",20.10,14.39,17.97,1.25,0.00,0.87,0.72,1.01,5616
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-30",24.79,14.00,15.13,2.78,0.00,1.99,1.69,2.40,10640
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-10-31",23.39,13.60,13.47,2.08,0.00,1.70,1.44,2.10,9788
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-01",22.00,10.10,15.38,2.08,0.00,1.45,1.14,1.63,11892
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-02",22.60,11.69,14.63,3.06,0.00,1.61,1.35,1.99,9608
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-03",19.20,12.30,10.38,2.92,0.00,1.71,1.47,2.24,9053
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-04",20.50,7.00,10.97,2.08,0.00,1.34,1.04,1.78,12167
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-05",17.89,5.59,11.27,1.53,0.00,0.86,0.66,1.18,8533
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-06",20.39,13.69,10.72,5.15,0.00,2.42,2.22,3.15,7448
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-07",19.39,11.80,7.92,4.87,0.00,2.53,2.25,3.44,10875
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-08",20.39,8.30,7.63,2.64,0.00,1.59,1.30,2.42,11524
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-09",17.70,8.00,9.22,2.64,0.00,1.32,1.05,1.85,11108
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-10",17.29,8.10,9.68,2.36,0.00,1.16,0.92,1.62,10010
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-11",9.60,7.50,10.22,3.61,3.00,0.48,0.40,0.66,3720
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-12",10.30,6.90,10.32,3.06,9.00,0.48,0.37,0.66,4757
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-13",18.00,6.30,8.13,4.03,0.00,1.57,1.38,2.36,8236
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-14",14.10,4.69,7.73,3.34,0.40,1.09,0.91,1.62,8059
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-15",12.60,6.69,8.97,2.92,0.50,0.84,0.69,1.21,7092
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-16",13.30,6.69,7.03,4.73,0.00,1.57,1.41,2.15,7158
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-17",15.00,5.40,8.80,4.73,0.00,1.23,0.99,1.76,10536
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-18",17.39,6.90,8.18,5.01,0.00,1.71,1.50,2.51,9076
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-19",16.29,11.50,6.28,6.26,0.00,2.79,2.58,3.72,8493
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-20",10.30,5.59,4.53,4.31,0.00,1.58,1.40,2.28,8384
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-21",7.69,1.29,4.53,3.06,0.00,0.90,0.74,1.41,8097
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-22",11.30,1.60,4.82,4.17,0.00,1.23,1.04,1.96,9753
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-23",14.10,0.60,6.23,2.08,0.00,0.66,0.45,1.29,9683
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-24",16.10,1.00,7.88,1.39,0.00,0.48,0.26,1.00,10151
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-25",14.10,2.50,8.43,1.94,0.00,0.50,0.29,0.97,9646
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-26",11.69,3.00,8.77,1.67,0.00,0.36,0.23,0.70,6469
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-27",11.69,3.00,8.52,3.75,0.00,0.54,0.35,0.95,8902
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-28",12.50,2.70,8.77,2.50,0.00,0.42,0.23,0.83,8694
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-29",12.60,5.50,10.57,1.94,0.20,0.31,0.22,0.61,4197
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-11-30",14.30,6.80,10.13,3.06,0.00,0.63,0.47,1.06,7200
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-01",16.20,9.60,10.02,2.22,0.00,0.77,0.59,1.27,7141
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-02",17.39,5.69,9.52,2.36,0.00,0.65,0.44,1.27,9294
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-03",15.39,4.40,9.72,2.50,0.00,0.50,0.31,1.00,8143
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-04",12.89,3.90,9.97,2.36,2.00,0.31,0.21,0.66,4615
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-05",16.10,7.00,8.93,3.89,0.00,0.99,0.80,1.70,8353
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-06",14.30,4.59,7.78,2.08,0.00,0.52,0.33,1.10,8700
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-07",15.89,0.50,7.82,1.53,0.00,0.31,0.11,0.90,9526
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-08",13.89,1.39,8.63,1.53,0.00,0.26,0.10,0.71,7791
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-09",14.30,2.50,8.18,3.48,0.00,0.63,0.48,1.26,6758
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-10",13.30,5.80,6.32,6.96,0.00,1.85,1.67,2.59,8402
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-11",15.50,8.69,8.07,5.56,0.00,1.70,1.58,2.43,5104
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-12",16.79,9.89,9.43,6.12,0.00,1.74,1.60,2.45,5761
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-13",17.70,7.50,9.43,2.78,0.00,0.74,0.53,1.47,8863
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-14",16.60,5.90,10.63,5.56,0.00,0.86,0.72,1.47,6111
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-15",14.00,11.89,7.28,6.12,0.00,2.17,2.04,2.94,5612
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-16",8.30,2.79,3.63,6.68,0.00,1.91,1.76,2.55,7614
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-17",11.30,-0.40,4.23,2.36,0.00,0.61,0.45,1.35,7811
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-18",11.69,2.20,7.13,2.08,0.40,0.47,0.37,0.94,4666
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-19",13.39,8.10,9.02,3.48,0.00,0.84,0.74,1.35,4378
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-20",16.10,7.59,5.92,4.17,0.00,1.38,1.17,2.49,8857
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-21",14.39,2.40,5.98,1.80,0.00,0.45,0.26,1.14,8443
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-22",14.00,1.70,7.88,1.67,0.00,0.29,0.13,0.82,7778
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-23",11.69,1.00,8.13,1.39,0.00,0.16,0.01,0.57,7472
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-24",14.39,0.60,8.27,2.64,0.00,0.33,0.16,0.95,8275
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-25",16.39,5.80,9.57,3.75,0.00,0.83,0.72,1.47,4807
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-26",18.00,10.19,10.82,6.40,0.00,1.67,1.57,2.32,3982
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-27",20.20,16.29,10.22,6.54,0.00,2.82,2.70,3.80,4660
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-28",15.60,11.00,6.48,4.73,0.00,1.80,1.62,2.82,7457
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-29",10.39,8.10,7.32,2.64,4.00,0.83,0.76,1.29,3250
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-30",11.69,3.50,6.38,2.64,0.00,0.65,0.51,1.25,6793
);
insert into grid_weather(grid_no,"day",MAXIMUM_TEMPERATURE,MINIMUM_TEMPERATURE,VAPOUR_PRESSURE,WINDSPEED,RAINFALL,E0,ES0,ET0,CALCULATED_RADIATION) values (1,"1965-12-31",12.69,3.20,6.73,2.08,0.00,0.48,0.31,1.07,8152
);

-- variety for spring-barley 1965
insert into variety_parameter_value
select
  crop_no,
  1 as variety_no,
  parameter_code,
  parameter_xvalue,
  parameter_yvalue
from 
  crop_parameter_value
where
  crop_no=3;
  
  
update variety_parameter_value set parameter_xvalue=1 where crop_no=3 and variety_no=1 and parameter_code='DEPNR';
update variety_parameter_value set parameter_xvalue=1.5 where crop_no=3 and variety_no=1 and parameter_code='FLTB_06';
update variety_parameter_value set parameter_xvalue=2 where crop_no=3 and variety_no=1 and parameter_code='FLTB_07';
update variety_parameter_value set parameter_xvalue=1.5 where crop_no=3 and variety_no=1 and parameter_code='FOTB_06';
update variety_parameter_value set parameter_xvalue=2, parameter_yvalue=1  where crop_no=3 and variety_no=1 and parameter_code='FOTB_07';
update variety_parameter_value set parameter_xvalue=1.5 where crop_no=3 and variety_no=1 and parameter_code='FSTB_06';
update variety_parameter_value set parameter_xvalue=2 where crop_no=3 and variety_no=1 and parameter_code='FSTB_07';
update variety_parameter_value set parameter_xvalue=0.007 where crop_no=3 and variety_no=1 and parameter_code='RGRLAI';
update variety_parameter_value set parameter_xvalue=27 where crop_no=3 and variety_no=1 and parameter_code='SPAN';
update variety_parameter_value set parameter_xvalue=50 where crop_no=3 and variety_no=1 and parameter_code='TDWI';
update variety_parameter_value set parameter_xvalue=1050 where crop_no=3 and variety_no=1 and parameter_code='TSUM1';
update variety_parameter_value set parameter_xvalue=1000 where crop_no=3 and variety_no=1 and parameter_code='TSUM2';

delete from pywofost_unittest_benchmarks_ln where grid_no=1 and crop_no=3 and "year"=1965;
insert into pywofost_unittest_benchmarks_ln(grid_no,crop_no, "year","day",simulation_mode, ensemble_id,development_stage, leaf_area_index, total_aboveground_biomass, total_weight_storage_organs, total_weight_leaves, total_weight_stems, total_weight_roots, profile_moisture_content, rootzone_moisture_content, transpiration, rooting_depth)  
select grid_no,crop_no, "year","day",simulation_mode, member_id,round(ifnull(dvs,0),4), round(ifnull(lai,0),4), round(ifnull(tagp,0),2), round(ifnull(twso,0),2), round(ifnull(twlv,0),2), round(ifnull(twst,0),2), round(ifnull(twrt,0),2), -9, round(sm,4), round(ifnull(tra,0),4), ifnull(rd,0) from pywofost_output;
