BEGIN TRANSACTION;
CREATE TABLE crop (
	crop_no INTEGER NOT NULL, 
	crop_name VARCHAR(40) NOT NULL, 
	cropgroup_no INTEGER NOT NULL, 
	crop_model INTEGER NOT NULL, 
	PRIMARY KEY (crop_no)
);
INSERT INTO "crop" VALUES(1,'WINTER WHEAT',1,0);
INSERT INTO "crop" VALUES(2,'GRAIN MAIZE',3,0);
INSERT INTO "crop" VALUES(3,'SPRING BARLEY',1,0);
INSERT INTO "crop" VALUES(5,'RICE',1,0);
INSERT INTO "crop" VALUES(6,'SUGAR BEETS',2,0);
INSERT INTO "crop" VALUES(7,'POTATO',2,0);
INSERT INTO "crop" VALUES(8,'FIELD BEANS',1,0);
INSERT INTO "crop" VALUES(9,'SOY BEAN',1,0);
INSERT INTO "crop" VALUES(10,'WINTER RAPESEED',1,0);
INSERT INTO "crop" VALUES(11,'SUNFLOWER',1,0);
INSERT INTO "crop" VALUES(12,'FODDER MAIZE',4,1);
INSERT INTO "crop" VALUES(13,'WINTER BARLEY',1,0);
INSERT INTO "crop" VALUES(14,'SPRING WHEAT',1,0);
INSERT INTO "crop" VALUES(15,'SPRING RAPESEED',1,0);
INSERT INTO "crop" VALUES(50,'FORAGE PERMANENT',4,1);
INSERT INTO "crop" VALUES(51,'FORAGE TEMPORARY',4,1);
INSERT INTO "crop" VALUES(99,'wheat_morocco',1,0);
CREATE TABLE crop_calendar (

	grid_no INTEGER NOT NULL, 

	crop_no INTEGER NOT NULL, 

	variety_no INTEGER NOT NULL, 

	year INTEGER NOT NULL, 

	start_date DATE NOT NULL, 

	crop_start_type VARCHAR(20) NOT NULL, 

	crop_start_date DATE NOT NULL, 

	crop_end_type VARCHAR(20) NOT NULL, 

	crop_end_date DATE NOT NULL, 

	max_duration INTEGER NOT NULL, 

	PRIMARY KEY (grid_no, crop_no, year)

);
INSERT INTO "crop_calendar" VALUES(31031,1,2542,2000,'2000-01-01','emergence','2000-01-01','maturity','2000-12-31',365);
INSERT INTO "crop_calendar" VALUES(31031,2,2650,2000,'2000-04-30','emergence','2000-04-30','maturity','2000-12-31',365);
INSERT INTO "crop_calendar" VALUES(31031,3,2770,2000,'2000-03-06','emergence','2000-03-06','maturity','2000-12-31',365);
INSERT INTO "crop_calendar" VALUES(31031,7,2830,2000,'2000-02-20','emergence','2000-02-20','maturity','2000-12-31',365);
INSERT INTO "crop_calendar" VALUES(31031,10,2602,2000,'2000-01-01','emergence','2000-01-01','maturity','2000-12-31',365);
INSERT INTO "crop_calendar" VALUES(31031,11,2854,2000,'2000-04-14','emergence','2000-04-14','maturity','2000-12-31',365);
INSERT INTO "crop_calendar" VALUES(35042,3,1,2000,'2000-01-01','emergence','2000-03-06','maturity','2000-12-31',365);
INSERT INTO "crop_calendar" VALUES(1,3,1,1965,'1965-01-01','sowing','1965-02-24','harvest','1965-09-30',365);
CREATE TABLE crop_parameter_value (
	crop_no INTEGER NOT NULL, 
	parameter_code VARCHAR(20) NOT NULL, 
	parameter_xvalue NUMERIC(10, 5) NOT NULL, 
	parameter_yvalue NUMERIC(10, 5), 
	PRIMARY KEY (crop_no, parameter_code)
);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_01',0,35.83);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_02',1,35.83);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_03',1.3,35.83);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_04',2,4.48);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'AMAXTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'CFET',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'CVL',0.685,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'CVO',0.709,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'CVR',0.694,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'CVS',0.662,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'DEPNR',4.5,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'DLC',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'DLO',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_02',25,25);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_03',45,25);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DTSMTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'DVSEND',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'EFF',0.45,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_01',0,0.65);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_02',0.1,0.65);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_03',0.25,0.7);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_04',0.5,0.5);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_05',0.646,0.3);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_06',0.95,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_07',1,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_08',2,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FLTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_02',0.1,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_03',0.25,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_04',0.5,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_05',0.646,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_06',0.95,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_07',1,1);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_08',2,1);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FOTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_01',0,0.5);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_02',0.1,0.5);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_03',0.2,0.4);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_04',0.35,0.22);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_05',0.4,0.17);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_06',0.5,0.13);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_07',0.7,0.07);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_08',0.9,0.03);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_09',1.2,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FRTB_10',2,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_01',0,0.35);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_02',0.1,0.35);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_03',0.25,0.3);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_04',0.5,0.5);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_05',0.646,0.7);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_06',0.95,1);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_07',1,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_08',2,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'FSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'IAIRDU',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'IDSL',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'KDIF',0.6,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'LAIEM',0.1365,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'PERDL',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'Q10',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RDI',10,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RDMCR',125,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RDRSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_01',0,1);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_02',2,1);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RFSETB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'RGRLAI',0.00817,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RML',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RMO',0.01,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RMR',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RMS',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'RRI',1.2,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_01',0,0.00212);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_02',0.5,0.00212);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_03',2,0.00212);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'SLATB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'SPA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'SPAN',31.3,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'SSA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'STARTDAY_ISTART',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'STARTDAY_ISTOP',160,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TBASE',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TBASEM',-10,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TDWI',210,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TEFFMX',30,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TEMP_WINTERKILL',-6,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_02',3,1);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMNFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_01',0,0.01);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_02',10,0.6);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_03',15,1);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_04',25,1);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_05',35,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TMPFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(1,'TSUM1',600,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TSUM2',970,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'TSUMEM',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_01',0,70);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_02',1.25,70);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_03',1.5,63);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_04',1.75,49);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_05',2,21);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'AMAXTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'CFET',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'CVL',0.68,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'CVO',0.671,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'CVR',0.69,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'CVS',0.658,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'DEPNR',4.5,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'DLC',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'DLO',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_02',6,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_03',30,24);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_04',35,24);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DTSMTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'DVSEND',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'EFF',0.45,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_01',0,0.62);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_02',0.33,0.62);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_03',0.88,0.15);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_04',0.95,0.15);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_05',1.1,0.1);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_06',1.2,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_07',2,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FLTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_02',0.33,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_03',0.88,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_04',0.95,0.5);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_05',1.1,0.9);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_06',1.2,1);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_07',2,1);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FOTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_01',0,0.4);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_02',0.1,0.37);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_03',0.2,0.34);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_04',0.3,0.31);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_05',0.4,0.27);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_06',0.5,0.23);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_07',0.6,0.19);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_08',0.7,0.15);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_09',0.8,0.1);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_10',0.9,0.06);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_11',1,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FRTB_12',2,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_01',0,0.38);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_02',0.33,0.38);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_03',0.88,0.85);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_04',0.95,0.35);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_05',1.1,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_06',1.2,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_07',2,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'FSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'IAIRDU',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'IDSL',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'KDIF',0.6,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'LAIEM',0.04836,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'PERDL',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'Q10',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RDI',10,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RDMCR',100,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RDRSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_01',0,1);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_02',1.5,1);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_03',1.75,0.75);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_04',2,0.25);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RFSETB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'RGRLAI',0.0294,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RML',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RMO',0.01,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RMR',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RMS',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'RRI',2.2,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_01',0,0.0026);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_02',0.78,0.0012);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_03',2,0.0012);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'SLATB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'SPA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'SPAN',40,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'SSA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'TBASE',10,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'TBASEM',4,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'TDWI',50,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'TEFFMX',30,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_01',5,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_02',8,1);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMNFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_01',0,0.01);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_02',9,0.05);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_03',16,0.8);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_04',18,0.94);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_05',20,1);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_06',30,1);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_07',36,0.95);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_08',42,0.56);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TMPFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(2,'TSUM1',750,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'TSUM2',700,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'TSUMEM',110,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_01',0,35);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_02',1.2,35);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_03',2,5);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'AMAXTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'CFET',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'CVL',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'CVO',0.74,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'CVR',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'CVS',0.69,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'DEPNR',4.5,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'DLC',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'DLO',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_02',35,35);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_03',45,35);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DTSMTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'DVSEND',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'EFF',0.4,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_01',0,1);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_02',0.33,1);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_03',0.8,0.4);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_04',1,0.1);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_05',1.01,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_06',2,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FLTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_02',0.33,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_03',0.8,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_04',1,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_05',1.01,0.85);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_06',2,1);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FOTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_01',0,0.6);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_02',0.4,0.55);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_03',1,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_04',2,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_02',0.33,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_03',0.8,0.6);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_04',1,0.9);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_05',1.01,0.15);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_06',2,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'FSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'IAIRDU',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'IDSL',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'KDIF',0.44,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'LAIEM',0.274,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'PERDL',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'Q10',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RDI',10,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RDMCR',125,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RDRSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_01',0,1);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_02',2,1);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RFSETB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'RGRLAI',0.0075,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RML',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RMO',0.01,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RMR',0.01,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RMS',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'RRI',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_01',0,0.002);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_02',0.3,0.0035);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_03',0.9,0.0025);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_04',1.45,0.0022);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_05',2,0.0022);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'SLATB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'SPA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'SPAN',25,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'SSA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'TBASE',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'TBASEM',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'TDWI',60,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'TEFFMX',30,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_02',3,1);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMNFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_02',10,1);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_03',30,1);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_04',35,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TMPFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(3,'TSUM1',620,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'TSUM2',750,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'TSUMEM',110,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RDRSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_01',0,1);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_02',2,1);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RFSETB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'RGRLAI',0.012,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RML',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RMO',0.0045,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RMR',0.01,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RMS',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RRI',1.2,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_01',0,0.003);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_02',1.1,0.003);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_03',2,0.0015);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'SLATB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'SPA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'SPAN',37,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'SSA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'TBASE',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'TBASEM',3,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'TDWI',75,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'TEFFMX',18,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_02',3,1);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMNFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_01',0,0.01);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_02',3,0.01);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_03',10,0.75);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_04',15,1);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_05',20,1);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_06',26,0.75);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_07',33,0.01);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TMPFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'TSUM1',150,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'TSUM2',1550,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'TSUMEM',170,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_01',0,40);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_02',0.8,40);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_03',1,30);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_04',1.2,35);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_05',1.4,20);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_06',2,0);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'AMAXTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'CFET',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'CVL',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'CVO',0.45,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'CVR',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'CVS',0.69,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'DEPNR',4.5,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'DLC',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'DLO',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_02',4,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_03',35,31);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_04',45,31);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DTSMTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'DVSEND',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'EFF',0.5,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_01',0,0.6);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_02',0.2,0.6);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_03',0.3,0.4);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_04',0.7,0.2);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_05',1,0.15);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_06',1.2,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_07',1.35,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_08',1.7,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_09',2,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FLTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_02',0.2,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_03',0.3,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_04',0.7,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_05',1,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_06',1.2,0.3);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_07',1.35,0.7);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_08',1.7,1);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_09',2,1);
INSERT INTO "crop_parameter_value" VALUES(10,'FOTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_01',0,0.2);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_02',0.3,0.2);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_03',1,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_04',2,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_01',0,0.4);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_02',0.2,0.4);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_03',0.3,0.6);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_04',0.7,0.8);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_05',1,0.85);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_06',1.2,0.7);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_07',1.35,0.3);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_08',1.7,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_09',2,0);
INSERT INTO "crop_parameter_value" VALUES(10,'FSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'IAIRDU',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'IDSL',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'KDIF',0.54,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'LAIEM',0.3,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'PERDL',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'Q10',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RDI',10,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RDMCR',125,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_02',1,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_03',1.0001,0.02);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_04',1.4,0.03);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_05',2,0.04);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RDRSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_01',0,1);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_02',2,1);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RFSETB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'RGRLAI',0.008,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RML',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RMO',0.012,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RMR',0.01,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RMS',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'RRI',1.2,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_01',0,0.0022);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_02',2,0.0019);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SLATB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'SPA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'SPAN',17,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'SSA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'STARTDAY_ISTART',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'STARTDAY_ISTOP',160,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TBASE',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TBASEM',-10,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TDWI',244,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TEFFMX',30,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TEMP_WINTERKILL',-6,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_02',1,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_03',4,1);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMNFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_02',10,1);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_03',30,1);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_04',35,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TMPFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(10,'TSUM1',230,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TSUM2',650,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'TSUMEM',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_01',0,36);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_02',1.22,36);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_03',2,12);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'AMAXTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'CFET',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'CVL',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'CVO',0.45,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'CVR',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'CVS',0.69,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'DEPNR',3.5,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'DLC',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'DLO',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_02',2,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_03',18,16);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_04',40,38);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DTSMTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'DVSEND',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'EFF',0.4,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_01',0,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_02',0.85,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_03',0.91,0.41);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_04',1,0.2);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_05',1.22,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_06',1.35,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_07',2,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FLTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_02',0.85,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_03',0.91,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_04',1,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_05',1.22,0.72);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_06',1.35,1);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_07',2,1);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FOTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_01',0,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_02',0.65,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_03',1.1,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_04',2,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_01',0,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_02',0.85,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_03',0.91,0.59);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_04',1,0.8);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_05',1.22,0.28);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_06',1.35,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_07',2,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'FSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'IAIRDU',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'IDSL',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'KDIF',0.9,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'LAIEM',0.0053,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'PERDL',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'Q10',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RDI',10,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RDMCR',150,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_02',1.5,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_03',1.5001,0.02);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_04',2,0.02);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RDRSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_01',0,1);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_02',2,1);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RFSETB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'RGRLAI',0.0294,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RML',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RMO',0.012,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RMR',0.01,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RMS',0.015,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'RRI',1.2,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_01',0,0.0035);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_02',1,0.0025);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_03',2,0.0025);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'SLATB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'SPA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'SPAN',30,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'SSA',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'TBASE',3,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'TBASEM',3,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'TDWI',6,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'TEFFMX',32,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_02',3,1);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_03',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMNFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_02',10,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_03',20,1);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_04',30,1);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_05',40,0.5);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TMPFTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(11,'TSUM1',500,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'TSUM2',1000,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'TSUMEM',130,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_01',0,30);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_02',1.57,30);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_03',2,0);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_04',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'AMAXTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'CFET',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'CVL',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'CVO',0.85,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'CVR',0.72,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'CVS',0.69,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'DEPNR',3,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'DLC',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'DLO',-99,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_02',2,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_03',13,11);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_04',30,28);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DTSMTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'DVSEND',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'EFF',0.45,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_01',0,0.8);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_02',1,0.8);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_03',1.27,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_04',1.36,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_05',2,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FLTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_01',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_02',1,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_03',1.27,0.75);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_04',1.36,1);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_05',2,1);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FOTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_01',0,0.2);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_02',1,0.2);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_03',1.36,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_04',2,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_05',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FRTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_01',0,0.2);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_02',1,0.2);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_03',1.27,0.25);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_04',1.36,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_05',2,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_06',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_07',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_08',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_09',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'FSTB_10',0,0);
INSERT INTO "crop_parameter_value" VALUES(7,'IAIRDU',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'IDSL',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'KDIF',1,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'LAIEM',0.0589,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'PERDL',0.03,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'Q10',2,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RDI',10,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'RDMCR',50,NULL);
INSERT INTO "crop_parameter_value" VALUES(1,'IOX',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(2,'IOX',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(3,'IOX',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(7,'IOX',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(10,'IOX',0,NULL);
INSERT INTO "crop_parameter_value" VALUES(11,'IOX',0,NULL);
CREATE TABLE "ensemble_grid_weather" (
grid_no INTEGER NOT NULL, 
day DATE NOT NULL, 
member_id INTEGER NOT NULL, 
rainfall NUMERIC(10, 5) NOT NULL, 
PRIMARY KEY (grid_no, day, member_id)
);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',4,1.98454);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',16,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',30,3.48853);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',46,2.27912);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',47,6.11179);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-01',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',0,3.80218);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',2,1.26916);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',5,2.9272);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',8,2.0202);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',9,5.23153);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',12,2.39014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',21,1.81467);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',25,2.73592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',39,4.30085);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',40,1.63052);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',45,1.11233);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-02',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',0,3.46003);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',1,7.31017);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',2,2.97724);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',3,7.83494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',4,11.5171);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',5,10.852);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',6,1.28954);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',7,2.06453);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',8,4.5888);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',9,4.90308);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',10,5.954);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',11,4.82349);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',12,7.20687);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',13,5.14964);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',14,3.79664);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',15,13.7843);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',16,7.22963);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',17,8.49616);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',18,1.95684);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',19,2.18461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',20,8.18884);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',21,2.74135);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',22,4.22671);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',23,7.33924);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',24,7.22204);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',25,5.91652);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',26,9.69839);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',27,2.64422);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',28,15.1264);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',29,3.7795);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',30,5.78434);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',31,13.1566);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',32,11.1299);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',33,16.7206);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',34,10.782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',35,8.46803);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',36,1.24492);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',37,15.1264);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',38,3.82749);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',39,2.66756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',40,10.5716);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',41,12.4702);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',42,8.06152);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',43,1.61735);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',44,0.16556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',45,9.89403);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',46,4.18133);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',47,3.93693);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',48,9.66852);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-03',49,4.66558);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',0,0.97645);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',1,1.35572);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',2,0.73584);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',3,0.1046);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',4,1.08017);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',5,0.63412);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',6,0.87457);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',7,0.74396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',8,5.77788);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',10,1.28658);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',11,1.23321);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',12,2.74288);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',13,0.26877);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',14,0.9167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',15,4.53628);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',16,1.72854);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',17,1.84657);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',18,2.00257);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',19,2.45554);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',20,0.26004);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',21,2.06371);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',22,5.59078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',23,1.5167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',24,5.90298);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',25,2.44865);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',26,2.45323);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',27,2.24639);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',28,1.97258);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',29,7.58796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',30,0.48869);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',31,1.50435);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',32,3.13301);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',33,1.57731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',34,0.72682);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',35,0.68533);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',36,0.87878);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',37,1.94651);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',38,0.53176);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',39,6.72015);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',40,12.722);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',41,0.90195);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',42,0.74666);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',43,1.86783);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',45,0.65377);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',46,1.06751);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',47,1.7942);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',48,1.04914);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-04',49,1.25479);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',3,2.03133);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',21,5.88506);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',23,3.17817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',25,1.14044);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',38,4.1069);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',43,1.15014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',46,14.0514);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',0,1.12964);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',7,1.3279);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',16,1.0454);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',21,1.64988);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',25,3.26475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',37,1.84634);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',47,1.44338);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-06',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',5,1.17916);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',13,1.0821);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',19,1.49784);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',21,1.68584);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',23,2.37281);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',25,3.43058);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',44,2.27239);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-07',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',12,1.96208);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',13,1.98072);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',16,3.2201);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',18,4.42695);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',21,6.85878);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',24,2.80195);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',25,1.67978);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',29,1.87399);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',30,1.06675);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',38,1.53776);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',41,4.46354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',44,2.43737);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',48,1.89769);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-08',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',0,5.17934);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',1,3.97677);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',2,0.40037);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',3,5.62823);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',4,2.96003);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',5,6.96761);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',6,3.31225);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',7,0.38082);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',8,0.96343);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',9,2.1834);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',10,3.71592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',11,0.39565);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',12,1.27731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',13,1.81785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',14,0.33735);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',15,0.28747);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',16,1.61494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',17,1.75534);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',18,3.68283);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',19,3.18252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',20,2.17081);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',21,1.57731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',23,2.56296);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',24,1.95759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',25,1.62905);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',26,1.29982);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',27,0.30867);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',28,1.76548);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',29,4.48854);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',30,1.61965);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',31,2.88269);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',32,4.13492);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',33,4.24809);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',34,0.33735);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',35,3.49405);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',36,3.09107);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',37,2.04754);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',38,3.99417);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',39,0.41588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',40,2.2191);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',41,3.64975);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',42,1.99507);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',43,5.77215);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',44,6.78922);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',45,1.54293);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',46,8.6712);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',47,1.39884);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',48,2.49477);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-09',49,0.14856);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',16,1.42004);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',23,2.36042);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',31,2.53202);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',44,1.13656);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',45,1.48466);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',47,2.80432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-10',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',1,2.01256);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',14,9.59489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',15,1.14127);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',29,2.06126);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',47,5.03274);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-11',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',0,2.01569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',1,0.45815);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',2,3.1653);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',3,2.32631);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',4,1.03938);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',5,0.20782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',6,0.15134);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',7,1.92327);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',8,1.45806);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',9,1.72854);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',10,0.20096);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',11,0.22472);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',13,0.45189);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',14,0.67902);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',15,2.34314);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',16,1.61494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',17,3.38641);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',18,1.07556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',19,0.43544);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',20,1.39327);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',22,4.5884);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',23,1.24074);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',24,1.51052);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',25,1.33028);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',26,0.92512);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',27,0.44084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',28,1.47657);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',29,2.504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',30,2.37648);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',31,0.16612);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',32,1.08247);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',33,0.24161);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',34,2.80422);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',35,11.8088);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',36,2.504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',37,2.62429);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',38,1.33028);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',39,1.51978);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',40,0.59194);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',41,2.63707);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',42,0.21944);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',43,0.6691);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',44,2.29897);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',45,1.28923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',46,6.74594);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',47,2.32421);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',48,0.90827);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-12',49,0.53881);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',0,0.21469);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',1,0.05953);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',2,0.84444);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',3,1.27333);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',4,2.63707);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',5,0.43342);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',6,0.7856);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',7,10.7001);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',8,0.72682);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',9,1.03504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',10,1.6696);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',11,1.68511);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',12,2.94923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',13,9.16336);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',14,1.27996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',15,0.72502);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',16,0.20941);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',17,0.44218);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',18,2.82623);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',19,2.24639);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',20,4.51241);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',21,0.27874);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',22,1.5275);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',23,0.40982);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',24,1.0629);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',25,7.82983);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',26,1.30379);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',27,1.4812);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',28,0.57253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',29,3.38032);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',30,2.5604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',31,2.73786);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',32,2.70265);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',33,0.4746);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',34,7.19816);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',35,1.86068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',36,3.21122);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',37,1.65099);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',38,4.03246);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',39,6.30566);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',40,1.62435);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',41,1.61337);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',42,3.89259);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',43,0.83365);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',44,0.20466);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',45,1.92505);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',46,2.27373);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',47,2.14777);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',48,0.69796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-13',49,3.08508);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',0,4.90283);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',1,17.3184);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',2,4.27739);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',3,1.25161);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',4,4.3402);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',5,0.23075);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',6,12.3837);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',7,2.59262);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',8,4.23897);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',9,3.01633);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',10,12.3113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',11,3.66095);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',12,7.82784);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',13,0.86263);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',14,5.71252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',15,0.83995);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',16,0.89054);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',17,5.13221);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',18,5.1129);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',19,0.32368);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',20,3.9872);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',21,5.96596);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',22,5.61848);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',23,9.92023);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',24,1.94461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',25,0.67281);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',26,4.81634);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',27,5.41704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',28,3.6236);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',29,7.28359);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',30,8.51002);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',31,2.69252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',32,9.94368);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',33,3.85673);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',34,0.303);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',35,4.07565);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',36,2.83956);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',37,0.40881);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',38,0.71783);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',39,1.78465);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',40,6.88292);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',41,2.0362);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',42,0.33827);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',43,4.74782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',44,0.63152);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',45,5.41704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',46,2.68277);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',47,7.18133);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',48,7.67087);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-14',49,0.15554);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',2,2.71897);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',6,2.40759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',12,1.78124);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',35,2.50966);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',43,2.46556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',48,10.2418);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-15',49,1.23509);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',0,1.5396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',23,3.41796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',26,1.60554);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',30,2.28089);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',42,1.43917);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',46,1.03721);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-16',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',3,8.84639);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',9,1.11414);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',14,3.54378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',15,10.0779);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',23,3.19127);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',25,1.56078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',30,15.4533);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',43,1.29303);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',48,2.11376);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',0,1.3113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',11,2.35216);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',15,1.89637);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',19,1.21092);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',28,1.95937);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',29,17.3821);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',36,1.672);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',48,2.62516);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',2,4.73272);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',5,10.0072);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',24,9.91822);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',27,3.6572);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',35,5.83782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',40,1.47284);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',4,2.30042);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',7,2.27912);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',15,1.27876);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',20,2.68882);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',23,1.36157);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',25,1.0851);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',29,7.09811);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',41,2.38578);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',5,2.1298);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',6,4.20861);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',17,1.99982);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',24,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',27,1.4909);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',30,6.51705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',34,1.27159);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',39,1.15457);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-21',49,1.66462);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',5,1.52074);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',9,3.16564);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',20,2.31462);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',35,1.3889);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-22',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',9,5.13359);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',10,3.32994);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',11,4.35382);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',15,3.12872);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',25,2.5026);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',28,1.13269);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',35,3.73173);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',37,2.75482);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',48,10.6482);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-23',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',9,3.51395);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',11,3.9504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',18,1.04628);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',22,9.88056);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',23,1.80567);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',31,1.87274);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',37,1.46302);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',41,1.40224);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-24',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',17,3.02257);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',27,6.26012);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',38,1.65356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-25',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',10,1.87022);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',14,2.27734);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',20,1.8121);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',22,1.15042);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',23,1.33544);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',24,1.4805);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',32,3.76193);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-26',49,1.43286);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',1,3.98581);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',6,1.63789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',30,1.13601);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',34,1.26105);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',42,3.02752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',46,1.04982);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-27',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',1,1.66001);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',2,1.39843);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',11,2.08356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',17,1.12134);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',18,39.3958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',20,1.63882);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',35,1.85262);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',36,2.16216);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',42,1.2647);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',45,1.39716);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-28',49,2.92949);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',0,2.72683);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',1,6.70154);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',2,12.5773);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',3,5.48147);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',4,6.22605);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',5,5.38632);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',6,4.31455);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',7,1.4916);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',8,2.78105);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',9,5.61121);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',10,9.7447);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',11,19.8588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',12,4.45799);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',13,7.98318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',14,2.12704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',15,4.20889);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',16,5.69771);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',17,5.61986);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',18,10.0029);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',19,3.51199);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',20,9.72062);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',21,0.2106);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',22,15.536);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',24,8.04443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',26,0.24961);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',27,14.8877);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',28,5.57662);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',29,9.73507);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',30,4.58754);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',31,8.72398);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',32,6.43182);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',33,11.7261);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',34,32.0937);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',35,10.346);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',36,4.36545);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',37,4.5459);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',38,3.706);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',39,4.20435);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',40,6.91006);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',41,10.8994);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',42,6.46179);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',43,8.89409);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',44,8.62828);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',45,6.30339);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',46,7.35406);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',47,5.11238);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',48,6.51745);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-29',49,16.6225);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',0,2.77592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',2,1.65356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',5,3.81281);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',6,3.10123);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',21,1.25496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',24,1.22311);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',36,1.99855);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',38,2.14059);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',46,10.4402);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-30',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',10,3.08316);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',26,1.73214);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',40,4.74747);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'1999-12-31',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',6,5.69475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',8,2.28977);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',13,5.63476);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',15,13.8526);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',18,1.90956);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',21,13.1341);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',25,1.07689);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',48,1.40097);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-01',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',1,1.15873);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',12,1.87274);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',13,2.47084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',14,4.39602);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',15,2.1823);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',37,3.08316);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',41,1.11734);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',44,1.65356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',48,1.57725);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-02',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',0,2.77829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',11,1.85262);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',37,3.46855);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',41,2.48848);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',44,10.4114);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',47,7.78461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-03',49,1.3488);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',26,1.41432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',28,4.33372);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',33,1.11654);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',35,2.93408);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',38,1.27819);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',47,1.41114);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-04',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',0,1.40542);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',8,1.09271);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',16,2.17475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',28,1.39843);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',30,5.36016);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',34,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',0,7.76913);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',6,5.98926);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',16,1.18137);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',26,1.17731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',27,1.41877);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',28,4.40047);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',36,1.77286);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',37,2.52778);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',41,6.27306);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-06',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',3,2.20782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',6,3.32342);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',7,1.36621);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',19,2.41414);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',26,2.47789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',27,4.09546);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',30,7.24705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',36,1.36679);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',39,1.36737);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',40,1.53868);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',43,1.20797);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-07',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',1,2.60482);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',14,1.37086);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',18,1.07439);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',21,1.54328);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',40,1.704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',48,3.54995);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-08',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',3,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',10,1.75598);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',12,2.35629);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',22,1.56998);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',32,1.19135);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',40,1.68483);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',41,1.93492);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',43,1.456);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-09',49,7.72065);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',8,1.15983);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',25,1.41686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',30,1.0569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',46,1.19763);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-10',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',1,2.0448);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',6,1.46302);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',11,3.36057);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',39,3.5894);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-11',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',2,5.52356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',5,1.60819);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',11,1.3073);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',24,2.6099);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',29,1.41496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',40,2.15317);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',43,2.16216);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-12',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',0,17.8812);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',1,2.55607);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',2,3.91696);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',3,4.93673);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',4,0.7597);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',5,3.74782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',6,0.59482);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',7,3.01153);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',8,9.31118);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',9,8.95866);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',10,6.68749);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',11,2.39635);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',12,4.17859);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',13,3.63356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',14,6.53362);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',15,2.58774);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',16,3.53145);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',17,28.0833);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',18,10.416);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',19,6.93203);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',20,4.33475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',21,2.13857);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',22,7.49952);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',23,4.85805);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',24,10.0609);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',25,4.67208);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',27,2.73299);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',28,5.99241);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',29,11.3268);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',30,2.15024);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',31,2.62186);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',32,4.00541);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',33,1.50398);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',34,0.21622);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',35,3.42578);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',36,3.12553);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',38,4.54021);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',39,2.92275);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',40,2.78983);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',41,7.45122);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',42,5.58186);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',43,5.19656);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',44,5.94329);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',45,2.64622);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',46,2.22258);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',47,2.3065);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',48,1.75901);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-13',49,5.53525);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',0,2.30738);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',1,4.60046);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',2,1.8875);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',3,2.504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',4,1.67581);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',5,1.70217);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',6,4.22464);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',7,2.0438);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',8,0.25256);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',9,1.52441);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',10,1.53213);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',11,0.3525);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',12,2.29056);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',13,1.7942);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',14,2.92527);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',15,0.89564);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',16,1.38076);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',17,0.24267);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',18,3.1653);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',19,0.79933);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',20,0.36935);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',21,0.91881);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',22,1.25877);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',23,1.62121);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',24,0.30929);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',25,1.50744);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',26,0.61219);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',27,2.46246);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',28,3.68944);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',29,2.12112);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',30,1.22694);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',31,9.89885);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',32,1.25082);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',33,1.49355);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',34,0.77285);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',35,1.68976);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',36,3.74239);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',37,1.61494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',38,0.77677);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',39,9.72926);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',40,4.08852);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',41,0.63581);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',42,0.47225);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',43,6.65567);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',44,0.38352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',45,2.47862);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',46,1.95759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',47,0.97211);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',48,2.51093);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-14',49,10.8322);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',4,10.4589);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',12,1.84256);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',22,1.23996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',23,1.035);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',30,1.09692);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',33,6.50472);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',44,1.3113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',46,1.21166);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-15',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',0,5.71233);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',1,8.61611);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',2,3.73355);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',3,12.6833);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',4,8.81613);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',5,5.47871);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',6,12.6948);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',7,7.32697);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',8,17.2899);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',9,4.24084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',10,7.29971);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',11,6.17957);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',12,2.76487);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',13,8.92964);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',14,14.8999);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',15,23.6289);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',16,21.0638);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',17,9.29723);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',18,10.0046);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',19,14.1189);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',20,3.18411);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',21,9.59646);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',22,10.8818);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',23,7.26699);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',24,12.2292);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',25,12.8681);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',26,17.1357);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',27,5.60614);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',28,12.6024);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',29,11.6908);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',30,15.6238);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',31,10.9094);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',32,33.2032);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',33,7.67558);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',34,10.2693);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',35,13.0067);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',36,10.5782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',37,7.01614);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',38,8.14351);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',39,11.8254);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',40,2.98994);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',41,4.64534);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',42,2.72957);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',43,3.25031);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',44,12.089);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',45,33.2807);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',46,4.32949);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',47,1.68843);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',48,7.35969);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-16',49,4.75681);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',4,2.16216);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',21,7.43208);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',2,1.24766);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',6,1.93627);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',24,1.8121);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',25,1.9648);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',40,2.40323);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',45,1.54236);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',1,1.99345);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',3,3.48853);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',30,1.10272);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',46,7.0861);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',15,5.09586);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',20,1.45671);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',26,1.47494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',31,1.16122);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',38,1.42935);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',40,2.24913);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',7,3.00368);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',14,2.43913);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',19,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',25,3.30042);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',29,4.29671);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',32,2.47084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',35,6.55105);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',37,7.40058);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',39,1.12604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-21',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',0,3.16228);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',1,2.49025);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',3,1.33428);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',5,7.93013);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',9,5.63476);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',13,1.11374);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',16,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',23,1.70804);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',32,1.96887);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',36,1.38);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',38,13.7108);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-22',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',0,2.62007);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',15,1.56262);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',26,1.96616);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',29,1.24523);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',31,3.53762);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',41,2.14958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',47,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-23',49,1.43005);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',3,7.41996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',4,2.05677);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',10,2.74222);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',28,3.84352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',29,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',45,6.95542);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',47,7.49195);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-24',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',3,1.38699);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',7,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',15,1.75697);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',17,1.27534);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',22,1.20243);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',28,2.56383);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',36,1.77386);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',42,1.05535);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',46,1.4546);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-25',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',0,7.39565);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',1,1.18062);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',2,5.14891);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',3,8.35584);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',4,8.73014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',5,6.40998);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',6,6.70305);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',7,12.626);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',8,7.35879);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',9,4.31176);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',10,9.33676);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',11,12.0398);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',12,6.80127);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',13,5.33039);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',14,14.4869);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',15,3.01405);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',16,6.87917);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',17,8.90213);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',18,6.64051);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',19,1.25425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',20,8.4721);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',21,4.34969);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',22,6.68226);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',23,4.9063);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',24,7.59816);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',25,15.913);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',26,9.58734);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',27,9.03938);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',28,23.2492);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',29,6.19592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',30,10.8071);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',31,20.2216);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',32,7.37353);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',33,5.9722);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',34,5.53205);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',35,3.94354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',36,5.65557);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',37,9.17504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',38,9.34613);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',39,6.97785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',40,8.26756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',41,7.05963);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',42,9.03053);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',43,1.44867);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',44,9.13823);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',45,6.23558);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',46,12.9098);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',47,5.86156);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',48,5.34658);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-26',49,2.82551);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',7,1.79024);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',15,3.28317);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',28,2.26154);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',29,1.06067);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',31,1.09051);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',35,2.44089);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',36,1.04031);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',46,2.52025);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',48,2.77372);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-27',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',2,1.06963);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',4,2.3945);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',5,3.18341);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',21,2.67806);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',22,8.89091);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',31,1.30958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',36,1.94442);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',37,1.19356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',40,1.4532);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',41,5.62905);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-28',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',36,8.52595);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',40,1.73512);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',42,4.69888);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',44,1.95529);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-29',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',13,1.2076);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',19,1.11253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',37,4.43508);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',40,1.04971);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',41,1.44829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',45,2.26154);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',48,1.05137);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-30',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',1,4.908);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',11,4.18431);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',28,1.19947);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',29,1.71308);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',36,2.08889);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-01-31',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',18,1.46021);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',24,6.98731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',30,3.75287);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',43,1.25253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-01',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',0,4.04165);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',18,2.25689);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',21,1.11994);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',25,5.73049);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',44,2.98008);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-02',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',0,1.36737);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',20,6.51705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',22,3.71951);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',23,1.68987);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',26,1.65356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',32,1.94714);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-03',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',12,2.1316);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',13,3.29179);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',36,1.12034);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',38,1.27078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',41,3.46563);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-04',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',10,1.12415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',22,13.3344);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',24,2.34803);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',25,2.59973);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',26,3.02257);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',37,5.73049);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',42,1.50617);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',47,15.7926);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-05',49,1.04296);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',0,1.62591);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',19,3.01313);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',34,3.39439);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',36,1.24036);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',39,11.2369);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',45,3.56846);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-06',49,2.50084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',0,1.67776);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',3,1.47424);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',17,4.70701);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',29,2.48672);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',38,1.32043);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',43,1.13989);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-07',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',28,1.22052);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',35,1.25983);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',42,1.92812);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-08',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',0,1.3908);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',1,6.47406);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',4,2.19731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',12,2.6099);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',27,2.33151);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',29,3.28604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',37,1.63605);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',48,1.20723);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-09',49,2.06575);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',5,1.52213);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',14,3.52836);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',23,3.58198);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',26,5.81502);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',30,1.55986);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',32,1.42514);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',33,8.87618);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',45,1.25496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',46,1.75399);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-10',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',0,15.6518);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',4,2.17929);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',7,2.15497);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',15,1.8121);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',20,3.38093);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',22,3.30329);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',32,7.70748);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',38,5.42222);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-11',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',0,1.14238);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',7,1.3113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',8,4.45541);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',10,1.2124);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',12,1.22311);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',15,6.82236);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',18,2.44794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',21,4.19819);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',27,1.80567);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',29,1.10312);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',31,7.06798);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',32,1.035);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-12',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',2,1.50686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',3,1.07494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',5,3.10425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',12,1.36911);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',20,1.04108);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',21,3.7071);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',39,8.89827);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-13',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',8,1.76492);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',16,1.79796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',17,1.12214);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',24,1.35344);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',30,2.62784);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',39,1.95393);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',42,1.6508);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-14',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',3,1.43707);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',7,1.36215);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',8,5.42676);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',9,5.56751);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',13,3.10726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',15,8.50928);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',27,1.06443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',31,1.94171);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',32,1.59759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',35,1.21794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',36,8.95867);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',37,5.92666);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',38,3.04829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',42,1.54789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-15',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',11,1.04186);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',16,5.77095);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',21,6.51088);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',30,2.15497);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',43,3.704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',48,3.10726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-16',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',2,2.25689);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',5,4.30085);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',6,6.40996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',7,1.62057);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',20,2.47613);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',22,1.40352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',28,4.53641);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',43,8.65866);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',2,1.37318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',6,1.81339);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',18,4.62132);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',11,2.39668);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',12,4.83669);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',15,19.3824);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',21,1.49715);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',31,2.69313);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',38,2.59973);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',15,1.0589);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',21,1.14155);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',40,1.40161);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',16,2.46027);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',27,1.60908);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',34,1.96752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',37,4.91258);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',38,1.2724);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',42,1.20317);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',46,3.0405);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-21',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',3,2.21833);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',9,3.79509);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',20,4.16277);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',22,1.57725);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',25,4.47167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',46,4.21556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',47,3.26475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',48,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-22',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',6,3.26968);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',17,1.39207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',18,1.61438);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',24,2.11376);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',33,4.17014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',43,4.18083);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-23',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',6,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',14,2.52202);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',34,2.17475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',36,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',41,7.36189);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',42,4.38713);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',43,1.4518);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',46,3.10726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-24',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',4,2.07174);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',7,8.52595);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',23,3.93296);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',42,10.6569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',45,1.0506);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-25',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',0,2.49378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',3,1.73015);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',6,1.05469);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',12,1.48813);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',25,9.59489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',26,1.13213);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',30,1.72817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',34,1.44618);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',35,2.33151);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',38,5.43105);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',42,3.788);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',44,2.02402);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-26',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',8,6.48006);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',15,2.03432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',21,4.59372);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',28,1.04031);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',36,13.1729);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',42,2.26154);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-27',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',0,2.37075);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',6,4.08022);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',8,1.67292);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',19,2.01383);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',23,4.47167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',38,1.96887);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',44,1.25415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-28',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',11,1.1349);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',12,2.17475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',19,1.56354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',21,1.10813);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-02-29',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',14,4.59372);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',18,1.02847);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',24,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',40,1.58698);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-01',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',14,20.2556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',33,5.66901);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',34,1.15873);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',41,2.31817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-02',49,3.40786);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',1,1.67776);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',6,1.38762);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',9,2.23517);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',10,6.78034);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',22,1.15097);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',23,1.79538);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-03',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',3,5.57237);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',6,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',8,2.75272);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',12,4.19125);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',15,1.54328);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',28,1.25212);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',37,1.70804);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',44,5.77095);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',46,1.13767);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-04',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',5,3.74079);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',6,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',11,1.44268);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',13,1.37318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',41,1.71006);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',45,9.11739);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',48,2.03881);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',10,1.35402);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',17,2.06425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',32,3.87604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',33,1.75598);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',34,6.95542);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',35,9.46313);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',37,1.64988);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',39,3.28029);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',40,1.704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',44,4.33372);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',48,2.95242);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-06',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',3,3.76495);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',11,6.1063);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',13,1.22576);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',16,1.50547);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',28,14.6219);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',41,2.47789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',46,9.47278);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-07',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',1,1.71106);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',2,4.83669);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',13,1.56722);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',36,2.89161);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-08',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',1,1.89241);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',4,1.94171);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',7,1.98327);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',16,1.14681);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',22,1.3337);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',24,1.83251);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',33,14.2858);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',42,1.55249);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',43,2.75902);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-09',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',4,1.06354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',10,1.46863);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',15,1.47633);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',21,2.07646);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',23,7.2323);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',27,2.00237);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',38,1.79153);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',42,2.14778);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-10',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',1,7.97286);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',7,2.4726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',8,3.52528);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',9,1.94714);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',16,1.04894);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',19,3.61167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',20,1.46021);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',29,2.51672);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',31,1.27705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',33,1.10773);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',37,6.30841);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-11',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',0,2.51792);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',1,3.19061);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',2,1.27143);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',3,0.14278);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',4,5.67642);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',5,1.87144);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',6,1.71588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',8,1.53203);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',9,4.03867);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',10,1.39006);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',11,1.40068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',12,4.83818);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',13,0.14071);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',14,4.56138);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',15,3.47123);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',16,0.23792);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',17,1.66553);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',18,8.75278);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',19,3.6178);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',20,8.02413);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',22,4.76549);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',23,2.04337);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',24,9.09058);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',25,2.80861);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',26,1.62102);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',27,0.77253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',28,0.23459);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',29,0.79427);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',30,3.71089);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',31,3.33134);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',32,7.3639);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',33,1.59816);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',34,1.24625);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',35,0.25152);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',36,2.57429);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',37,8.62344);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',38,2.48386);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',39,1.75443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',40,3.19061);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',41,4.22761);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',42,2.7591);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',43,4.4912);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',44,2.16955);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',45,1.84409);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',46,1.11312);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',47,1.92313);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',48,1.48516);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-12',49,5.18688);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',1,1.46162);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',30,1.07251);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',33,7.43789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',40,4.33774);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',42,1.62868);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-13',49,2.95242);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',4,1.70905);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',5,1.10693);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',8,2.08711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',10,2.51143);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',19,3.66485);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',20,9.70111);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',21,3.02021);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',22,6.61787);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',25,6.93224);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',28,1.64803);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',37,1.04573);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',38,1.03477);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',43,1.11153);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-14',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',8,2.05378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',14,1.25537);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',15,1.2976);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',19,1.87658);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',23,1.64711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',33,2.14778);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',45,1.85388);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-15',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',0,2.0433);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',6,1.1277);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',8,1.6425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-16',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',6,1.11494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',7,1.64895);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',9,4.01147);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',12,1.03334);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',20,3.03531);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',36,1.21461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',38,1.41432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',40,1.03112);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',2,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',4,2.81142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',5,1.60643);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',8,1.40161);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',15,3.41123);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',19,1.78252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',23,9.43417);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',26,2.50966);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',30,5.11448);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',35,4.5138);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',4,4.32156);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',9,2.93866);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',12,2.03582);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',29,1.41496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',40,14.0792);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',26,3.15893);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',29,2.48142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',39,1.0857);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',41,4.17014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',44,1.49784);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',1,1.56078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',6,1.15817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',21,1.28276);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',27,2.90548);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',35,5.22585);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',41,2.05079);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',44,1.62499);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-21',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',1,10.7722);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',2,11.6271);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',3,18.7722);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',4,12.2634);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',5,15.5262);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',6,7.09249);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',7,11.1237);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',8,26.9931);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',9,32.2832);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',10,12.5379);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',11,15.1736);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',12,25.0759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',13,11.0572);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',14,3.39168);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',15,8.00443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',16,16.1472);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',17,15.2788);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',18,22.112);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',19,21.8486);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',20,13.663);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',21,9.16616);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',22,3.36831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',24,6.38446);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',25,39.6132);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',26,7.50349);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',27,3.10354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',28,15.5627);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',29,21.7977);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',30,21.4419);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',31,9.75606);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',32,38.4443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',33,18.1597);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',34,9.9292);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',35,20.403);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',36,34.5807);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',37,4.36259);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',38,15.5171);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',39,21.0583);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',40,28.4493);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',41,11.2092);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',42,22.4093);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',43,12.4914);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',44,18.9251);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',45,10.4102);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',46,32.4396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',47,14.4378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',48,21.3252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-22',49,16.9168);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',0,1.03511);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',10,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',11,1.24117);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',15,1.20501);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',16,1.50964);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',21,1.44057);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',22,2.63857);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-23',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',6,7.98752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',12,2.70605);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',16,1.95122);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',47,1.40034);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',48,2.13879);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-24',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',0,1.47074);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',14,7.91483);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',16,2.81615);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',17,1.62499);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',18,3.0084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',19,2.51849);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',36,1.47424);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',39,2.27912);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',41,4.25344);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',42,2.14958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',43,1.76988);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',44,1.5396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',45,1.21425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-25',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',4,3.32994);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',5,2.55958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',8,3.12872);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',13,1.31643);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',25,3.01785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',28,1.60643);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',29,4.01514);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',32,2.45499);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-26',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',7,1.21794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',16,2.95471);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',19,2.1316);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',27,1.39334);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',37,1.2428);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',39,4.9643);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',44,3.60796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',46,4.79197);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',47,2.8695);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-27',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',2,9.78485);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',8,4.28014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',12,2.73382);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',15,2.01128);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',25,2.45675);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',33,1.36447);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',34,4.80694);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',44,1.23793);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-28',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',11,6.17961);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',12,1.32328);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',15,3.07425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',17,2.47084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',19,3.25736);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',31,1.67978);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',47,1.15513);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-29',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',6,1.0745);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',9,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',14,1.15845);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',24,1.3726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',29,1.4805);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',30,1.16094);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',35,1.42654);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',36,3.91364);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',37,4.24438);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',39,5.57736);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',42,1.25699);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',46,2.33977);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-30',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',4,1.80181);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',6,1.25212);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',17,1.03334);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',19,6.33831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',22,2.80432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',23,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',35,3.22532);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',36,1.51311);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',41,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',43,1.07461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',45,1.19615);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-03-31',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',0,1.73164);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',1,0.54351);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',2,0.81796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',3,6.26912);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',4,1.17425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',5,4.45672);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',6,1.7942);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',7,3.00327);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',8,3.73577);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',9,0.80521);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',10,0.18987);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',11,0.1809);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',12,3.34412);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',13,2.29687);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',14,2.45785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',15,5.14547);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',16,0.51767);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',17,0.7178);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',18,1.08247);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',19,0.77383);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',20,1.55066);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',21,2.74288);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',22,2.53862);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',23,1.37936);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',24,2.01194);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',25,3.21696);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',26,0.20149);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',27,1.12045);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',28,0.62737);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',29,0.65377);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',30,2.59362);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',31,2.47631);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',32,0.05931);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',33,0.07046);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',34,1.03721);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',35,3.97329);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',36,4.89686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',37,1.53213);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',38,0.07515);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',39,0.14989);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',40,3.15669);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',41,0.0814);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',42,1.47349);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',43,1.02527);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',44,0.51923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',45,1.26142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',46,5.85803);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',47,8.47635);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',48,2.05346);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-01',49,0.79344);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',1,25.0797);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',2,7.97832);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',3,1.51366);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',4,7.38949);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',5,20.8024);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',6,12.0968);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',7,1.69843);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',8,31.9593);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',9,1.54627);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',10,14.0375);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',11,1.44845);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',12,16.5381);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',13,34.4151);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',14,63.1466);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',15,22.031);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',16,9.95614);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',17,16.2856);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',18,29.8587);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',19,3.0098);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',20,60.3712);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',21,17.578);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',22,24.9712);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',23,32.3547);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',26,4.52364);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',27,28.5942);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',28,75.7919);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',29,22.1068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',30,12.7684);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',31,13.3943);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',32,30.7321);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',33,31.9048);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',34,0.079);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',35,35.2395);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',36,7.44557);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',37,6.76018);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',38,10.5508);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',39,6.88827);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',40,37.253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',41,24.747);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',42,30.9367);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',43,8.13253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',45,5.21033);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',46,41.8743);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',47,26.8315);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',48,7.92224);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-02',49,34.229);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',6,1.67978);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',11,1.27362);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',15,1.40352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',16,1.32385);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',22,2.29332);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',26,3.22532);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',27,3.55304);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',28,2.81142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',31,2.75482);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',32,1.43496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-03',49,3.96436);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',0,0.28249);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',1,3.94891);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',2,2.78955);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',3,2.95192);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',4,10.3853);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',5,7.15484);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',7,4.61655);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',8,1.23321);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',9,3.35903);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',10,0.08541);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',11,1.55223);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',12,1.20687);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',13,3.5526);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',14,3.16243);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',15,2.56296);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',16,1.16672);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',17,1.36267);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',18,2.73031);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',19,1.94294);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',20,0.64762);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',21,3.2688);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',22,3.48237);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',23,2.46939);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',24,3.10605);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',25,3.58707);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',26,3.2659);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',27,2.30528);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',28,0.1191);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',29,0.14811);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',30,1.92684);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',31,4.70572);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',32,4.40572);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',33,1.03287);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',36,0.0843);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',37,1.99132);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',38,1.1124);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',39,0.14521);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',40,1.37241);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',41,1.5167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',42,0.29807);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',43,4.93226);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',44,1.31439);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',45,0.59616);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',46,0.14789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',47,0.54821);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',48,2.07601);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-04',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',11,1.74704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',25,3.11328);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',27,2.16756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',28,3.12537);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',32,1.22385);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',40,1.39589);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',43,1.79153);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',12,10.5128);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',15,4.50906);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',29,12.9503);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',46,1.13573);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-06',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',0,4.45663);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',1,8.83737);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',2,17.9863);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',3,5.28846);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',4,7.79302);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',5,6.48043);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',6,6.45463);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',7,7.16893);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',8,2.46774);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',9,6.59448);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',10,4.6756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',11,4.14243);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',12,16.2069);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',13,8.43052);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',15,3.61428);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',16,4.64555);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',17,5.69269);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',18,9.92846);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',19,9.41817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',20,1.8361);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',21,0.39958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',22,29.9664);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',23,2.48761);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',24,8.07923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',25,12.2666);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',26,10.1531);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',27,6.82607);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',29,6.31825);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',30,16.9685);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',31,5.49794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',32,3.41866);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',33,9.95749);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',34,8.75763);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',35,4.74045);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',36,5.18931);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',37,8.00396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',38,20.8581);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',39,8.56192);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',40,0.52489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',41,5.75724);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',42,4.97565);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',43,11.9501);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',44,1.0024);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',45,1.43579);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',46,6.35511);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',47,1.47484);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',48,3.44624);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-07',49,4.5888);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',0,0.61894);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',1,0.30306);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',2,0.48321);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',3,1.87677);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',4,0.24742);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',5,0.27625);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',6,0.30493);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',7,3.09407);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',8,2.38324);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',9,0.11107);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',10,2.79199);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',11,6.24479);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',12,0.8415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',13,11.8742);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',14,1.90538);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',15,0.93355);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',16,0.40307);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',17,1.36963);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',18,0.98079);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',19,0.38486);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',20,3.5028);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',21,3.92779);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',22,1.2985);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',23,4.45672);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',24,1.21314);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',25,3.11803);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',26,0.56325);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',27,1.26406);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',28,2.08626);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',29,1.19432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',30,0.54273);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',31,0.765);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',32,2.41256);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',33,5.06168);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',34,0.76402);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',35,2.41482);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',36,6.75228);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',37,6.03955);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',38,0.43544);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',39,0.53176);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',40,2.90132);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',42,2.06986);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',43,0.51062);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',44,1.66495);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',45,2.2023);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',46,2.54555);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',47,0.06645);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',48,1.13427);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-08',49,4.54025);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',0,10.0598);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',1,2.25051);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',2,16.9494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',3,8.66929);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',4,8.84343);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',5,14.8696);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',6,7.66494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',7,6.88824);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',8,5.108);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',9,5.48147);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',10,6.80533);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',11,0.09603);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',12,3.84094);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',13,10.1012);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',14,2.46786);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',15,8.15817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',16,12.0595);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',17,12.5559);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',18,2.99425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',19,3.44145);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',20,15.7019);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',21,6.98861);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',23,8.44144);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',24,10.7717);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',25,10.246);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',27,21.3323);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',28,3.26949);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',29,0.11065);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',30,10.5579);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',31,3.99085);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',32,9.73989);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',33,28.5387);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',34,1.40783);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',35,12.9767);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',36,7.32815);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',37,4.85444);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',38,6.16974);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',39,2.66209);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',40,9.66764);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',41,6.54313);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',42,14.0034);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',43,14.9511);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',44,5.61121);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',45,11.4893);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',46,9.03684);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',47,1.09727);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',48,17.4944);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-09',49,7.9613);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',13,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',16,2.12441);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',23,3.33334);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',31,1.17768);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-10',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',8,2.1883);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',20,2.28089);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',35,2.96159);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',40,1.87274);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',43,13.4428);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',44,1.54328);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-11',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',33,3.17817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',42,5.09586);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',48,1.05148);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-12',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',0,2.58036);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',1,2.36226);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',2,4.08322);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',3,3.19753);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',4,3.9898);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',5,0.19669);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',6,5.4708);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',7,1.11881);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',8,0.31884);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',9,6.23805);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',10,1.91452);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',11,3.24829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',13,2.98391);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',14,1.76606);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',15,1.52266);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',16,1.50234);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',17,0.69334);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',18,2.57834);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',20,0.7565);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',21,0.91483);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',22,1.106);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',23,1.69406);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',24,3.65765);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',25,5.92974);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',26,2.34538);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',27,3.32461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',28,5.03442);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',29,3.04393);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',30,3.7389);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',31,5.09348);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',32,0.64575);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',33,12.1437);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',34,1.25202);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',35,8.55389);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',36,6.32697);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',37,1.9059);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',38,1.72259);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',39,3.25507);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',40,3.13027);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',41,0.68782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',42,1.85248);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',43,0.81831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',44,3.13966);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',45,3.12087);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',46,0.32965);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',47,4.91484);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',48,3.2206);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-13',49,11.8785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',0,12.6751);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',1,18.7932);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',2,10.9678);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',3,16.3399);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',4,9.89568);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',5,12.869);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',6,29.2617);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',7,9.30656);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',8,11.9098);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',9,10.1538);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',10,10.6374);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',11,15.6392);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',12,1.22884);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',13,9.60449);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',14,18.1662);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',15,20.5602);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',16,16.3487);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',17,2.04239);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',18,6.61068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',19,6.93751);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',20,9.85631);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',21,13.2836);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',22,8.61163);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',23,10.0619);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',24,0.77815);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',25,2.97649);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',26,9.83881);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',27,0.71112);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',28,22.252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',29,2.55057);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',30,9.97005);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',31,6.24977);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',32,2.47066);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',33,5.10085);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',34,3.40343);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',35,1.20818);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',36,10.11);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',37,11.5183);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',38,2.09603);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',39,2.76999);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',40,15.7879);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',41,8.09611);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',42,6.8457);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',43,6.78887);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',44,6.55053);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',45,7.76694);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',46,7.0468);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',47,8.30339);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',48,9.63472);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-14',49,15.9786);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',1,18.8996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',2,15.988);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',3,17.4205);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',4,13.764);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',5,3.4813);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',6,6.50596);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',7,16.3747);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',8,24.0039);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',9,2.57248);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',10,13.3663);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',11,37.098);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',12,21.9346);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',13,15.0785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',14,16.8423);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',15,12.3457);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',16,9.56575);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',17,17.2278);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',18,14.4292);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',19,23.8527);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',21,24.166);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',22,5.7793);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',23,10.4003);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',24,9.34889);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',25,16.9387);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',26,32.5275);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',27,12.1544);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',28,7.47749);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',30,17);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',31,2.01591);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',32,9.3204);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',33,17.4731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',34,3.05669);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',35,22.9142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',36,17.6412);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',37,14.1955);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',38,14.8079);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',39,17.7997);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',40,7.82922);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',41,5.61889);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',42,16.1769);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',43,18.3168);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',44,22.6379);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',45,7.48711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',46,15.295);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',47,9.83466);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',48,31.7069);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-15',49,21.6144);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',0,1.34014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',1,1.67895);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',2,2.83543);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',3,2.60669);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',4,2.59049);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',5,5.14897);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',6,2.08554);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',7,1.43862);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',8,2.66518);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',9,1.14729);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',10,2.78798);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',11,1.58673);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',12,2.45982);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',13,4.16012);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',14,2.06276);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',15,3.05275);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',16,2.37748);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',17,4.12146);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',18,2.23752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',19,0.79999);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',20,1.67056);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',21,3.53693);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',22,3.16523);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',23,8.27116);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',24,12.3147);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',25,1.94037);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',26,0.82746);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',27,2.49789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',28,1.79428);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',29,0.14175);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',30,11.5726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',31,4.65587);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',32,1.62265);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',33,1.83247);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',34,4.70826);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',35,1.39613);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',36,3.20215);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',37,1.66385);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',38,4.50375);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',39,4.89183);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',40,0.56287);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',41,3.0504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',42,0.06567);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',43,5.59443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',44,1.41434);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',45,0.21597);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',46,0.26814);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',47,1.69742);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',48,3.88377);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-16',49,2.40794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',13,3.6191);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',35,2.58957);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',42,1.24685);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',17,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',20,6.87704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',31,1.12687);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',34,1.47074);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',44,2.16756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',47,2.44618);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',11,1.87022);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',15,1.84759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',16,7.52442);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',38,11.4867);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',42,6.2791);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',7,1.2172);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',8,5.13359);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',9,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',11,1.49576);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',14,5.33508);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',25,5.10517);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',26,1.21388);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',35,1.71207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',36,2.1853);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',37,1.13047);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',44,1.70501);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',1,3.61539);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',11,1.22536);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',14,3.85165);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',18,1.12275);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',24,1.09852);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',36,3.50266);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',37,6.40415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',44,1.88582);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-21',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',0,6.71951);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',1,4.4016);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',2,2.90647);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',3,2.63756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',4,5.47426);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',5,0.31635);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',6,5.5605);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',7,5.28846);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',8,3.82407);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',9,3.65413);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',10,2.60088);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',11,2.84918);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',12,2.27454);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',13,22.9751);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',14,8.76826);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',15,10.6716);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',16,6.41777);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',17,6.84077);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',18,3.87892);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',19,6.52093);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',20,8.26246);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',21,4.90308);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',23,1.78317);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',24,4.24292);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',25,4.76467);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',26,11.6055);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',27,9.55502);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',28,9.26279);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',29,1.16203);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',30,2.54754);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',31,4.87886);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',32,7.10064);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',33,4.63887);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',34,1.54681);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',35,8.11063);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',36,14.081);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',37,7.86848);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',38,10.0678);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',39,0.68501);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',41,2.08472);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',42,8.88522);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',43,4.92036);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',44,8.59751);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',45,15.3003);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',46,5.08279);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',47,1.46508);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',48,6.45831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-22',49,6.96902);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',7,1.40034);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',15,2.43561);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',19,5.9317);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',36,3.84758);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',40,1.97023);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',47,1.88186);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-23',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',6,4.10309);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',11,1.04529);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',12,2.49554);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',16,1.0517);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',31,1.30901);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',36,2.09067);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',37,1.97431);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',47,2.72962);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-24',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',10,3.07165);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',15,1.44198);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',16,3.72261);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',17,4.91258);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',25,1.7381);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-25',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',0,2.70193);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',1,4.32338);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',2,0.87728);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',3,3.02331);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',4,7.73468);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',5,5.5775);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',6,0.43567);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',7,28.4745);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',8,1.46305);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',9,3.77891);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',10,1.50831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',11,1.91772);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',12,4.6068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',13,2.92992);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',14,1.94311);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',15,3.13835);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',16,6.92604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',17,2.36562);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',18,4.06297);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',19,3.08841);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',20,2.35374);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',21,0.75388);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',22,4.18849);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',23,2.50421);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',24,7.78108);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',25,4.64994);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',26,3.90179);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',27,5.0814);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',28,0.49549);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',29,1.33475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',30,3.00842);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',31,4.03543);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',32,3.9347);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',33,1.65209);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',34,2.98075);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',35,0.69958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',36,1.01485);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',37,4.16561);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',38,7.93689);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',39,1.96751);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',40,1.56357);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',41,4.92997);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',42,7.21483);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',43,4.51364);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',44,1.16078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',45,3.01906);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',46,0.25503);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',47,0.91449);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',48,0.89588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-26',49,5.57001);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',0,11.1844);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',1,11.9201);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',2,3.75681);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',3,8.99355);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',4,9.48439);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',5,9.22518);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',6,12.1511);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',7,9.51198);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',8,11.4873);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',9,10.1578);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',10,8.0756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',11,15.0352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',12,5.48752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',13,11.0722);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',14,9.36306);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',15,3.53917);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',16,0.95448);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',17,1.2037);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',18,20.7301);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',19,22.4421);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',20,8.89428);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',21,11.1788);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',22,10.859);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',23,13.0662);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',24,8.25939);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',25,5.37602);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',26,1.29463);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',27,22.9875);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',28,1.64131);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',29,4.22923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',30,6.39786);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',31,12.5679);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',32,6.95307);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',33,10.2682);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',34,11.9836);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',35,8.42156);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',36,11.5215);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',37,9.60582);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',38,23.4149);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',39,8.73985);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',40,6.4633);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',41,6.56676);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',42,10.1357);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',43,18.5218);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',44,7.43732);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',45,10.0033);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',46,16.2436);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',47,9.18106);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',48,5.1955);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-27',49,9.29688);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',15,1.73413);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',16,2.20782);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',19,2.45146);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',20,4.55802);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',22,1.42195);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',45,4.01147);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-28',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',8,24.5207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',16,1.16371);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',21,1.76293);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',30,8.13674);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',37,2.45499);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',38,1.46793);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-29',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',1,7.03999);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',2,0.02675);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',3,8.00334);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',4,5.44956);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',5,4.16133);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',6,8.17041);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',7,19.0527);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',8,2.49318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',9,10.3037);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',10,11.9082);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',11,13.9172);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',12,17.3534);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',13,1.04319);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',14,8.53891);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',15,13.1632);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',16,30.1286);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',17,9.03894);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',18,9.23758);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',19,15.7194);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',20,15.7194);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',21,7.28111);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',22,11.069);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',23,28.3868);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',24,18.0122);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',25,7.37488);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',26,13.8066);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',27,16.8661);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',28,18.0389);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',29,18.7632);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',30,0.90981);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',31,19.1554);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',32,17.4711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',33,11.9478);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',34,3.93903);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',35,14.3467);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',36,14.1254);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',37,1.30212);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',38,0.17372);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',39,5.58793);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',40,15.7118);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',41,4.54741);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',42,10.044);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',43,11.7171);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',44,12.3498);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',45,17.9499);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',46,6.10862);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',47,24.7961);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',48,18.7912);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-04-30',49,11.2747);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',0,2.77148);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',1,1.85937);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',2,4.12146);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',3,3.44855);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',4,3.61255);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',5,1.66385);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',6,0.29973);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',7,3.9126);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',8,0.44836);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',9,1.39158);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',10,10.8596);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',11,1.20102);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',12,4.12735);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',13,1.91969);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',14,4.48493);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',15,1.03351);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',16,1.54766);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',17,8.29969);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',18,2.707);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',19,7.91967);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',20,1.18265);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',21,1.62918);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',22,5.10141);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',23,4.32569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',24,0.21863);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',25,3.23214);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',26,7.96225);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',27,3.08094);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',28,1.93347);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',29,5.31821);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',30,2.61885);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',31,4.52883);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',32,4.259);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',33,5.55371);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',34,2.12234);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',35,0.06567);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',36,1.65545);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',37,3.79823);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',38,1.31027);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',39,2.14688);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',40,5.81057);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',41,11.9134);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',42,2.36987);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',43,1.20244);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',44,4.58238);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',45,2.5079);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',46,0.23127);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',47,1.93692);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-01',49,1.48516);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',2,2.5794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',5,2.63589);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',15,1.49437);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',22,5.46968);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',37,2.98716);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-02',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',0,0.85772);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',1,2.40129);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',2,5.60014);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',3,1.36128);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',4,3.27749);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',5,0.48713);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',6,0.55651);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',7,0.21258);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',8,0.49339);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',9,1.81109);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',10,2.44639);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',11,0.79246);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',12,5.04279);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',13,4.66906);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',14,0.45815);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',15,0.09055);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',16,0.25506);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',17,0.27563);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',18,2.38775);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',19,4.64067);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',20,1.30909);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',21,0.83758);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',22,0.20571);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',23,0.12111);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',24,0.58688);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',25,5.06168);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',26,4.85261);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',27,0.73674);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',28,1.09398);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',29,4.24027);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',30,1.23823);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',31,0.32675);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',32,0.10683);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',33,9.34894);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',34,0.59447);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',35,2.78465);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',37,2.12112);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',38,5.85242);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',39,0.06154);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',40,12.7592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',41,2.93592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',42,2.12932);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',43,5.64696);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',44,2.2569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',45,0.64003);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',46,3.00868);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',47,3.23706);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',48,0.79835);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-03',49,1.45034);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',9,2.5794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',11,1.76988);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',12,3.72569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',15,1.03035);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',35,2.52566);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',36,3.49418);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',45,4.05325);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-04',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',0,15.6115);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',1,7.19248);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',2,31.6759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',3,7.26865);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',4,0.49801);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',5,8.12425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',6,4.46279);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',7,6.545);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',8,11.4704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',9,8.31345);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',10,14.5458);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',11,7.72423);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',12,13.4882);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',13,15.2693);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',14,11.5966);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',15,11.689);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',16,6.56132);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',17,7.11086);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',19,8.44859);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',20,8.454);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',21,13.9824);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',22,3.5551);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',23,6.26699);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',24,7.09998);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',25,8.81706);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',26,4.87692);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',27,14.2109);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',28,9.07627);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',29,12.3359);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',30,8.35129);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',31,1.18686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',32,13.0076);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',33,8.73434);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',34,20.5936);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',35,1.78252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',36,10.0474);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',37,10.573);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',38,2.3165);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',39,17.9179);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',40,4.46279);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',41,5.95616);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',42,1.19023);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',43,4.60083);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',44,1.96787);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',45,10.9207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',46,7.31762);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',47,2.38711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',48,8.61852);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',0,9.8951);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',1,13.9381);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',2,12.6051);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',3,10.7643);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',4,6.13348);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',6,7.06248);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',7,10.5845);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',8,10.7177);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',9,8.71599);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',10,17.0394);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',11,1.06027);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',12,18.5673);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',13,15.503);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',14,4.32419);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',15,15.6598);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',16,11.8505);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',17,10.6911);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',18,9.27065);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',19,2.01181);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',20,19.9593);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',21,3.66285);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',22,11.4103);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',23,0.37346);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',24,19.3415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',25,14.7936);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',26,24.39);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',27,4.8475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',28,20.9923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',29,4.8998);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',30,1.26913);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',31,9.8951);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',32,10.2513);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',33,8.28111);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',34,8.7494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',35,9.05012);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',36,4.99134);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',37,13.733);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',38,8.26102);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',39,8.24762);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',40,14.5983);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',41,15.9394);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',42,15.5235);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',43,9.33748);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',44,12.1205);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',45,8.11366);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',46,15.3662);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',47,12.3711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',48,23.8149);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-06',49,4.73635);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',0,0.96452);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',1,1.66805);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',2,1.84488);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',3,1.92505);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',4,1.31969);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',5,2.47862);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',6,2.86139);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',7,0.65648);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',8,1.28923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',9,4.86588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',10,1.92863);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',11,3.67952);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',12,2.05756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',13,0.05574);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',14,0.47773);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',15,1.90181);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',16,4.90571);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',18,3.62154);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',19,2.51093);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',20,2.49708);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',21,1.26804);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',22,1.59142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',23,1.66495);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',24,1.22945);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',25,1.44335);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',26,0.13918);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',27,0.9656);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',28,1.29055);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',29,1.58829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',30,2.76753);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',31,3.49113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',32,1.51207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',33,2.08831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',34,0.4511);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',35,1.10549);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',36,1.5383);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',37,5.67745);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',38,0.91354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',39,2.04192);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',40,1.07902);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',41,0.24478);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',42,6.51222);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',43,0.36733);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',44,12.214);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',45,0.79344);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',46,1.78068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',47,1.11355);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',48,7.67504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-07',49,1.39884);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',0,4.89253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',1,7.51311);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',2,6.41016);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',3,20.1823);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',4,18.078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',5,15.5444);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',6,18.7699);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',7,13.3034);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',8,3.47204);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',9,4.86422);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',10,8.71411);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',11,29.1105);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',12,9.79528);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',13,5.73682);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',14,15.5795);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',15,34.9733);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',16,5.27939);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',17,22.2103);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',18,17.5853);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',19,12.1928);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',20,13.4292);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',21,25.0538);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',22,26.7393);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',23,15.5795);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',24,3.96865);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',25,34.4443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',26,19.175);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',27,23.0256);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',28,5.1756);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',29,11.4414);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',30,47.1845);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',31,22.9715);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',35,6.48711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',36,18.7699);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',37,20.0509);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',38,16.3767);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',39,20.0039);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',40,8.80684);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',41,23.7381);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',42,2.74392);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',43,12.065);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',44,0.93283);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',45,2.54253);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',46,1.16545);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',47,0.99099);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',48,13.5282);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-08',49,16.6078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',0,0.87819);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',1,8.23518);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',2,4.32236);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',3,1.00529);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',4,1.73434);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',5,2.66318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',6,2.63303);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',7,4.04783);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',8,1.84907);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',9,7.45114);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',10,6.02561);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',11,5.06574);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',12,3.81804);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',13,3.28423);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',14,1.04481);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',15,0.77024);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',16,7.32473);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',17,1.60633);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',18,0.79885);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',19,14.3715);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',20,3.21368);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',21,2.06626);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',22,3.25058);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',23,0.60715);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',24,7.67235);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',25,0.84692);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',26,6.46662);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',27,3.4965);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',28,0.55492);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',29,3.66605);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',30,1.31624);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',31,1.85937);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',32,11.8436);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',33,1.33566);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',34,8.48906);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',35,0.82975);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',36,1.34313);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',37,2.631);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',38,2.07327);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',39,2.76322);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',40,2.09606);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',41,0.48226);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',42,2.18872);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',43,5.7457);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',44,4.26234);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',45,4.58588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',46,7.23195);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',47,0.85166);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',48,1.87661);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-09',49,3.01178);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',0,1.13733);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',1,7.22559);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',2,3.16984);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',3,8.90747);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',4,0.09735);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',5,1.8542);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',6,2.75085);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',7,7.40207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',8,1.36882);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',9,1.23353);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',10,0.86303);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',11,2.78592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',12,1.13305);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',13,0.87693);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',14,4.28568);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',15,4.27234);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',16,10.77);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',17,4.13029);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',18,1.177);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',19,0.13032);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',20,3.98064);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',21,2.00061);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',23,2.02556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',24,1.1416);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',25,5.38068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',26,1.9283);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',27,2.23404);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',28,1.55735);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',29,1.49922);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',30,6.04952);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',31,0.19602);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',32,3.32461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',33,5.89105);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',34,1.98458);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',35,0.7099);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',36,11.586);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',37,2.0575);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',38,2.58644);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',39,4.45985);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',40,1.91624);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',41,1.61776);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',42,2.86261);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',43,4.51943);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',44,2.6831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',45,2.87534);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',46,3.87223);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',47,4.86499);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',48,2.0943);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-10',49,0.82632);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',0,1.12094);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',3,1.06332);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',32,1.76691);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',38,5.01692);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',47,1.51033);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-11',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',7,7.01771);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',8,2.51319);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',10,5.41282);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',18,1.14903);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',21,1.42004);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',26,1.60377);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',29,2.3945);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',36,2.42068);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-12',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',8,2.957);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',11,3.57155);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',12,1.07339);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',31,1.09431);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',37,1.321);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',45,5.72475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',46,5.65759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-13',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',27,1.41559);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',28,4.62597);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',30,2.16396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',42,4.03779);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',43,1.02725);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-14',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',1,1.63236);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',23,1.16039);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',25,2.97305);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',36,2.12264);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',39,3.03531);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',44,2.09777);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-15',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',5,17.7265);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',14,5.06746);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',19,9.05588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',20,1.74704);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',21,2.77829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',25,4.0687);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',47,10.3517);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-16',49,16.589);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',3,1.25821);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',5,4.36588);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',10,1.49229);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',16,5.77664);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',22,2.72112);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',25,1.46863);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',27,3.53145);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',30,2.22742);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',37,3.66868);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',39,1.52143);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',40,1.41496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',42,2.43208);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',45,1.17092);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',13,1.33777);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',28,1.88318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',35,7.64267);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',0,1.75598);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',11,5.81502);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',16,1.14792);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',25,4.92623);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',27,1.60643);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',31,5.43964);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',34,3.67251);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',44,1.16898);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',10,1.73015);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',21,3.26721);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',24,3.74683);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',27,1.21425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',31,2.46556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',33,1.43356);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',39,3.47439);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',44,1.29988);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',2,1.93627);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',6,1.10813);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',7,1.31015);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',12,1.27933);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',24,2.09777);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',25,2.51143);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',31,1.05502);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',41,1.27118);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-21',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',7,1.23631);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',8,2.97076);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',13,1.05325);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',41,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-22',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',0,18.5032);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',1,3.62632);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',2,18.5752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',3,14.4439);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',4,20.7003);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',5,20.8711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',7,38.823);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',8,21.087);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',9,15.7008);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',10,9.3481);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',11,22.6662);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',12,20.1777);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',13,14.8996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',14,16.1166);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',15,1.48146);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',16,23.4336);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',17,15.9465);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',18,14.3489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',19,16.1732);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',20,10.7793);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',21,10.4427);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',22,27.8945);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',23,17.9006);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',24,26.4169);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',25,35.2859);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',26,28.1116);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',27,24.4433);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',28,18.065);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',29,6.80822);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',30,27.0006);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',31,21.6758);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',32,16.9727);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',33,24.9172);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',34,22.6078);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',35,21.1949);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',36,13.6176);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',37,15.2705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',38,5.47734);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',39,32.9162);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',40,19.2494);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',41,11.7464);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',42,14.5565);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',43,28.5177);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',44,23.7467);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',45,19.6004);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',46,20.0604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',47,32.0106);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',48,21.5269);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-23',49,14.4914);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',0,4.56654);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',1,1.19515);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',2,3.2094);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',3,13.424);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',4,1.23123);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',5,3.41431);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',6,11.5917);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',7,0.06556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',9,18.1983);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',10,2.35176);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',11,2.13966);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',12,5.43977);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',13,2.9616);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',14,3.14875);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',15,5.28636);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',16,0.80997);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',18,2.0082);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',19,2.31722);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',20,5.58874);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',21,2.22107);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',22,4.46424);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',23,5.95852);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',24,4.87645);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',25,3.08217);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',26,6.95771);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',27,0.11093);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',28,4.94257);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',29,2.90889);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',30,6.6465);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',31,0.57573);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',32,3.47434);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',33,4.67148);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',35,3.53946);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',36,16.0817);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',37,5.76053);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',39,1.28567);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',40,2.71453);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',41,3.25579);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',42,5.96909);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',43,3.67244);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',44,4.68072);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',45,2.8118);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',46,4.36489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',47,4.94257);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',48,2.40127);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-24',49,3.73709);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',0,1.59935);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',16,1.11434);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',17,5.3401);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',42,6.89561);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-25',49,1.19947);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',9,2.69098);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',19,5.93674);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',20,1.39589);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',29,1.26753);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',31,1.09692);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',37,4.96853);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',38,1.72015);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',40,1.64711);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',43,1.05679);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-26',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',5,2.1853);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',7,2.9138);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',9,1.20723);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',10,1.37618);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',20,1.38317);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',24,2.22897);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',25,2.49731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',47,1.83879);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-27',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',3,2.67076);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',5,1.09752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',22,1.18101);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',24,6.69975);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',25,3.62281);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',28,2.97535);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',29,1.57549);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-28',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',8,1.42584);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',11,9.82273);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',20,3.32653);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',22,1.03599);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',29,6.20079);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',33,3.4335);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',40,3.50831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',43,1.3337);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',48,1.04949);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-29',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',0,1.59051);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',7,1.18913);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',9,1.04274);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',28,8.65156);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',37,1.21905);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',41,5.75939);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-30',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',0,3.97483);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',1,1.44899);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',5,3.23518);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',16,2.73382);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',25,4.18778);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',33,3.54378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',40,1.72015);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-05-31',49,3.87604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',16,3.10726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',23,2.13879);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',31,2.90548);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',35,17.009);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',41,2.16396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',42,2.9593);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',46,2.17475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-01',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',3,6.40415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',20,1.6637);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',24,1.22385);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',27,1.0785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',38,2.14239);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',43,4.4138);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',44,1.67877);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-02',49,9.7308);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',19,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',24,1.14155);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',26,1.20907);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',28,1.29075);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',34,6.22778);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',39,1.58167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-03',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',0,2.75692);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',4,1.21166);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',8,7.42628);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',9,1.16288);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',21,2.64126);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',48,2.43561);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-04',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',11,1.37745);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',17,1.24847);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',21,3.40449);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',23,1.33022);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',27,5.10517);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',31,2.28622);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',32,8.54328);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',34,1.58698);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',39,2.6099);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',47,13.4831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',4,1.43707);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',11,1.90165);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',24,3.46855);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',32,1.40479);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-06',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',4,1.70703);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',14,1.69996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',23,1.68584);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',31,1.19799);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',47,1.84508);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-07',49,1.40479);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',3,2.57019);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',4,1.51866);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',19,2.4497);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',26,1.05845);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',30,4.60752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',36,1.52579);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',45,2.6759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-08',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',9,1.36911);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',13,2.13879);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',17,1.42584);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',18,3.89275);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',21,1.26997);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',23,1.24645);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',30,1.29417);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',42,4.11452);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',47,6.39254);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-09',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',3,1.15042);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',5,1.11013);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',8,2.06425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',13,3.92947);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',27,2.58957);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',35,1.18322);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',38,1.4909);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-10',49,1.46512);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',8,1.82368);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',15,1.19763);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',24,4.08022);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',25,2.90825);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',26,1.99091);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',37,2.76532);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',41,1.47354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',43,2.02534);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',48,1.40479);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-11',49,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',10,1.33486);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',34,1.5396);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',35,1.27819);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-12',49,2.23052);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',2,1.13878);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',16,2.01128);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',20,3.2201);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',28,1.03643);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',32,3.8844);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',34,3.05867);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',38,2.06725);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-13',49,1.09291);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',1,1.40224);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',16,1.05856);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',19,2.48142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',22,1.72216);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',27,1.56354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',28,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',31,3.84758);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',45,1.13739);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',47,1.6135);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-14',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',6,1.48952);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',8,3.61167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',15,5.12379);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',35,2.14598);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',40,3.67609);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',45,1.20243);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-15',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',20,5.35013);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',26,1.94578);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',39,2.96847);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',42,4.90341);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',48,1.77088);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-16',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',0,2.09244);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',2,3.80572);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',3,1.46793);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',19,1.10312);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',20,3.76796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',32,1.19541);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',45,3.1455);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',10,1.85262);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',13,2.23052);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',16,1.63882);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',19,3.12537);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',45,4.85142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',4,1.73115);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',6,2.49025);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',7,2.05378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',10,6.93804);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',11,1.97159);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',31,6.56764);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',35,2.50966);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',43,1.42514);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',46,2.25378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',47,1.88318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-19',49,10.9531);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',2,1.2432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',8,12.6771);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',18,2.94783);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',28,1.40733);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',41,2.46379);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',44,1.40796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',45,1.43917);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',3,2.93179);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',9,10.5762);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',20,1.13601);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',23,2.10665);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',40,1.60996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-21',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',8,1.17009);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',16,2.60228);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',31,1.66647);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',34,1.41178);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',35,1.64066);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-22',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',19,1.39207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',30,2.22284);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',37,1.43636);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',38,1.90429);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',43,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',46,1.96752);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-23',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',8,2.39232);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',21,2.31107);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',23,2.11376);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',25,2.93179);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',34,2.03283);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',47,1.25861);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-24',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',1,3.77098);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',13,4.11071);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',26,1.52074);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',34,2.79485);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',37,2.46203);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',39,1.20058);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',47,1.06664);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-25',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',4,2.0011);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',8,1.34938);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',14,1.52074);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',16,2.79012);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',23,3.94342);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',26,4.09165);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',36,1.10112);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',37,3.28029);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',44,1.09171);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-26',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',1,2.55746);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',7,1.09291);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',20,10.504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',30,1.15734);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',37,53.6328);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',38,5.1827);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',42,2.8695);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',43,2.36662);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-27',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',6,3.21224);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',12,3.29467);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',18,2.57443);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',37,3.79155);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-28',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',2,3.774);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',15,1.06044);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',16,1.23996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',22,2.57019);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',24,2.92489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',25,2.25533);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',26,6.38673);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',39,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',43,2.61498);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',48,1.55893);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-29',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',8,3.95389);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',15,1.29646);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',29,1.05159);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',30,1.99218);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',32,5.14346);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',39,1.4539);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',47,1.88978);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',48,6.16852);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-06-30',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',10,3.2475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',16,1.11714);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',24,1.73909);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',39,1.20907);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',44,14.1806);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-01',49,4.54937);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',0,2.08889);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',5,2.66003);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',26,1.49715);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',27,3.10726);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',36,1.14266);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',42,1.41814);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',47,1.57814);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-02',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',3,1.93763);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',8,1.42514);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',9,5.0057);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',11,1.97295);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',15,1.8211);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',21,1.09451);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',33,2.45146);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',44,1.45671);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',46,1.60731);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',47,8.53462);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-03',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',2,1.53684);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',14,1.13352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',27,4.44728);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',43,1.08931);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',46,1.67877);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-04',49,3.92598);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',0,1.26753);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',1,2.09244);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',2,1.84634);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',9,1.6135);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',11,1.35576);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',32,1.44548);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',35,1.44338);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',21,1.44829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',23,3.0405);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',36,3.25489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',48,3.45686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-06',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',0,3.81635);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',6,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',11,1.87022);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',14,1.2432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',15,2.59465);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',17,2.83392);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',35,6.1849);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-07',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',22,1.50201);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',26,1.83125);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',31,1.24969);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',44,1.20169);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-08',49,1.67676);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',5,3.54378);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',25,3.55921);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',29,2.63321);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',33,7.19404);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',34,1.34415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',35,1.4525);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',37,2.34803);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',39,3.69159);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',41,2.15138);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',42,3.45686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',45,1.17657);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-09',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',2,1.15208);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',5,2.46908);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',43,2.96847);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-10',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',6,1.28504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',35,1.37144);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',38,1.48535);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',42,1.49021);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',47,4.00048);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-11',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',25,3.14886);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',31,1.19504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',43,1.35634);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-12',49,1.77088);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',6,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',7,1.71813);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',9,1.24969);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',23,3.09822);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',28,1.09612);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',43,3.54687);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-13',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',23,1.51519);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',27,9.48397);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',28,1.11133);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',33,2.10488);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',36,1.32214);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',38,1.42514);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',39,2.9272);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',40,1.34705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',42,8.95867);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',43,3.83134);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-14',49,1.39398);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',10,10.16);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',17,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',20,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',29,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',34,4.89425);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',35,8.44547);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',36,2.44794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',39,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-15',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',1,3.57827);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',6,1.49229);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',8,2.01765);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',11,4.4806);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',14,3.24996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',28,2.56807);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',31,7.32326);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',40,1.91352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',43,1.42584);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',45,5.37519);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',48,1.11754);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-16',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',9,5.10517);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',11,2.47437);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',14,5.94682);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',17,9.31096);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',23,1.87922);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',24,1.66094);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',27,2.57686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',43,1.05524);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',2,1.14931);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',6,2.45675);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',14,1.21461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',16,5.0625);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',18,3.96785);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',19,1.2286);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',39,3.22778);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',40,1.09271);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',47,1.4798);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',8,1.79796);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',29,1.38);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',30,6.2791);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',41,1.0735);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',2,1.04009);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',4,1.64803);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',5,1.23996);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',7,1.32385);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',8,2.22742);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',15,1.05879);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',19,1.74605);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',29,1.13352);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',40,8.43025);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',46,1.19652);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',0,5.1827);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',5,1.44198);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',13,1.90693);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',19,3.16228);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',22,4.21556);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',26,1.06919);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',27,5.93674);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',29,1.10953);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',35,1.85388);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',38,1.52763);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',40,7.36832);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',41,1.68382);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-21',49,1.94035);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',11,1.23306);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',17,2.68882);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',24,1.2039);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',32,1.7851);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',44,1.99982);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-22',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',4,1.78767);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',6,1.04949);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',10,1.456);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',12,1.11113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',23,11.0924);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',28,1.67575);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',36,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',47,1.13324);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',48,1.61527);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-23',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',10,1.22163);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',14,2.23362);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',17,1.11293);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',38,1.91748);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',45,3.58569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-24',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',16,1.57549);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',19,2.9138);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',29,3.68539);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',33,3.02257);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',43,5.88506);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',46,2.7082);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',48,5.75361);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-25',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',4,2.37705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',7,9.38787);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',21,1.37682);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',24,1.43707);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',26,3.28604);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',33,6.33218);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',34,10.5398);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',43,1.26348);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-26',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',0,1.21868);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',15,4.30913);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',19,3.26968);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',22,2.17115);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',26,2.8394);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',33,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',35,2.37705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',37,1.50062);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-27',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',0,6.79235);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',10,1.43005);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',17,1.63421);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',19,3.80927);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',21,2.85308);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',26,1.02205);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',27,1.87274);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',29,2.35422);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',33,1.03256);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',43,3.97848);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-28',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',2,1.33428);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-29',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',1,6.76654);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',5,1.72317);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',16,1.86142);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',31,1.5914);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',37,1.46933);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',42,2.4185);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',44,2.58702);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-30',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',1,4.35784);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',18,1.11113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',22,1.58344);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',23,1.55433);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',42,1.05635);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-07-31',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',10,1.49923);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',11,2.82571);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',18,1.06565);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',19,7.49844);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',35,2.09422);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',37,1.87922);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',38,1.69694);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',41,2.95242);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',42,10.3816);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',45,6.33831);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-01',49,2.0433);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',5,3.14886);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',14,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',19,1.43566);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',34,1.51172);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',40,5.62351);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',47,3.40786);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-02',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',15,2.45499);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',17,4.89883);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',25,1.50686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',28,1.34705);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',44,1.0825);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-03',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',0,2.0202);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',1,3.34015);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',5,4.1069);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',12,3.4627);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',18,2.50084);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',19,1.10252);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-04',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',2,8.38345);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',20,19.1383);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',29,2.56807);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',34,2.19431);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',38,3.21486);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',39,2.98716);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',48,2.00619);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-05',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',4,6.92036);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',11,1.40542);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',17,1.0527);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',18,3.44226);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',26,1.84005);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-06',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',0,9.21833);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',19,7.36832);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',24,4.87107);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',27,2.20482);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',35,7.67455);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',39,1.28333);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-07',49,5.0912);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',11,5.85547);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',22,1.04385);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',29,7.19404);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',35,2.73802);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',42,2.74432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-08',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',4,5.2066);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',5,10.0779);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',10,1.40415);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',11,1.52074);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',26,1.19504);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',33,2.43737);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',38,1.42724);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',46,3.42133);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-09',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',1,3.71951);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',2,2.1031);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',5,1.05181);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',6,1.28789);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',7,2.5026);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',13,1.17064);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',24,1.42322);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',27,1.58167);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',35,2.08534);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-10',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',2,3.5196);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',5,1.38254);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',8,4.46354);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',22,3.49701);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',29,1.98709);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',46,6.84663);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-11',49,4.37824);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',9,8.31957);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',25,3.04829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',28,5.08655);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',30,3.15893);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',47,4.18778);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',48,3.27461);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-12',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',0,1.29189);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',4,1.61527);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',9,2.92489);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',12,3.63423);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',18,1.05535);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',25,2.19881);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',46,5.87907);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-13',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',2,1.20169);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',4,1.23671);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',8,1.77609);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',19,2.73592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',22,1.23144);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',30,2.54686);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',31,6.30841);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',42,1.12395);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-14',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',0,1.11153);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',3,2.09244);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',5,2.59973);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',6,1.85639);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',31,4.86125);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',44,1.23631);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-15',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',8,1.33835);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',20,1.59228);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',28,2.15677);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',46,1.38635);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',47,2.44794);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-16',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',7,2.56807);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',8,1.30388);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',19,1.82496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',27,3.99681);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',32,2.77829);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',36,1.75201);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',38,2.14958);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',39,1.78124);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-17',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',0,2.83666);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',1,3.72569);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',5,1.1651);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',19,3.08316);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',28,13.6432);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',29,2.56383);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',45,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',48,1.14238);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-18',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',20,1.65264);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',28,4.3699);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',33,1.28732);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',43,1.12054);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-19',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',0,2.73592);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',3,1.25496);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',8,2.62007);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',18,1.05901);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',45,9.34028);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',46,17.4029);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-20',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',0,2.03582);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',20,3.40113);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',26,3.66485);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',38,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',43,1.14681);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',48,1.20021);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-21',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',1,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',11,1.44759);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',13,15.3537);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',25,1.88318);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',28,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',29,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',32,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',34,3.18341);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',38,3.71951);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',41,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',43,1.30787);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-22',49,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',0,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',1,2.23207);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',2,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',3,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',4,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',5,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',6,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',7,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',8,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',9,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',10,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',11,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',12,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',13,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',14,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',15,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',16,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',17,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',18,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',19,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',20,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',21,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',22,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',23,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',24,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',25,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',26,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',27,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',28,6.39834);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',29,3.2475);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',30,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',31,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',32,1.1421);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',33,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',34,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',35,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',36,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',37,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',38,1);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',39,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',40,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',41,1.65541);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',42,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',43,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',44,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',45,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',46,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',47,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',48,0);
INSERT INTO "ensemble_grid_weather" VALUES(31031,'2000-08-23',