#--------TEST DATA FOR POTENTIAL EVAPOTRANSPIRATION------------------------
pot_headers = "DVS,E0,ES0,ET0,LAI,EVWMX,EVSMX,TRAMX,TRA" 
pot_raw_data = [
    "5.69523834E-02;6.10846654E-02;5.89581951E-02;6.57282174E-02;0.15345266;5.70088848E-02;5.50242998E-02;4.38561430E-03;4.38561430E-03",
    "0.12485714;0.15736671;0.15619206;0.17070495;0.17156194;0.14567468;0.14458731;1.26830302E-02;1.26830302E-02",
    "0.15404762;3.11844610E-02;2.39838250E-02;2.66411509E-02;0.17871745;2.87747160E-02;2.21305005E-02;2.05866573E-03;2.05866573E-03",
    "0.15647618;2.06690300E-02;1.77385621E-02;1.83195584E-02;0.17871745;1.90718528E-02;1.63678341E-02;1.41562382E-03;1.41562382E-03",
    "0.17847620;7.00357780E-02;5.37330210E-02;5.50445542E-02;0.17871745;6.46238402E-02;4.95808609E-02;4.25350759E-03;4.25350759E-03",
    "0.24814285;8.41535777E-02;6.87399432E-02;6.29893988E-02;0.23990229;7.55418912E-02;6.17055818E-02;6.44589076E-03;6.44589076E-03",
    "0.27128565;6.99175075E-02;5.64788654E-02;5.36838956E-02;0.28510797;6.14987873E-02;4.96782847E-02;6.46404084E-03;6.46404084E-03",
    "0.30457136;0.16809782;0.13988416;0.13667247;0.28650427;0.14776441;0.12296352;1.65321454E-02;1.65321454E-02",
    "0.33757135;0.22048995;0.19939379;0.19915625;0.28849900;0.19364519;0.17511751;2.42473688E-02;2.42473688E-02",
    "0.39976186;0.20738542;0.17243721;0.16047412;0.50574958;0.16517271;0.13733810;3.26640457E-02;3.26640457E-02",
    "0.47080943;0.42418447;0.37653154;0.36316568;0.52816641;0.33445206;0.29687968;7.68244267E-02;7.68244267E-02",
    "0.53342855;0.25917622;0.22038290;0.19697800;0.82555008;0.17875403;0.15199825;6.11221306E-02;6.11221306E-02",
    "0.63933337;0.62577784;0.55846536;0.55178547;1.1155672;0.37879309;0.33804780;0.21778110;0.21778110",
    "0.77252388;0.18699233;0.16487357;0.14935531;1.8666447;8.07273537E-02;7.11783543E-02;8.48764181E-02;8.48764181E-02",
    "0.87857145;0.31759864;0.28103650;0.25974074;2.3378706;0.11091306;9.81446803E-02;0.16903305;0.16903305",
    "0.99214298;0.71430856;0.63773012;0.61919427;2.4237313;0.23999926;0.21426982;0.41115227;0.41115227",
    "1.1477001;0.44475403;0.39179820;0.35845071;2.2671106;0.16034402;0.14125222;0.22922103;0.22922103",
    "1.3361501;0.69257897;0.61800635;0.59575790;2.1396234;0.26443401;0.23596139;0.36829117;0.36829117",
    "1.5659001;0.67837942;0.60258758;0.56552833;1.8498878;0.29508317;0.26211503;0.31953341;0.31953341",
    "1.7616501;0.24525836;0.21936581;0.21158545;1.2230798;0.14144716;0.12651421;8.95583779E-02;8.95583779E-02",
    "1.9223001;0.27842784;0.24692127;0.23291716;0.27986261;0.24548130;0.21770291;2.75612399E-02;2.75612399E-02"]

class Container(object):
    pass

header_names = pot_headers.split(",")
pot_evtra_testdata = []
for strline in pot_raw_data:
    vline = strline.split(";")
    c = Container()
    for hname, value in zip(header_names, vline):
        setattr(c, hname, float(value))
    pot_evtra_testdata.append(c)


#--------TEST DATA FOR WATER-LIMITED EVAPOTRANSPIRATION: DEPNR=4.5--------------

# Evapotranspiration parameter values for testing
parvalues = (1, 0, 0, (0,0.60000002,2.0,0.60000002), 1.0000000, 4.5000000, 0.40000001, 0.26300001, 0.10000000, 9.00000036E-02)
parnames = ("IWB", "IOX", "IAIRDU", "KDIFTB", "CFET", "DEPNR", "SM0", "SMFCF", "SMW", "CRAIRC")
wl_parvalue_dict1 = dict(zip(parnames,parvalues))

# evapotranspiration test data
wl1_headers = "IWB,E0,ES0,ET0,LAI,SM,EVWMX,EVSMX,TRAMX,TRA,DVS"
wl1_raw_data = [
    ";1;4.12496999E-02;3.92372534E-02;4.25780937E-02;0.14618465;0.37103572;3.86234932E-02;3.67391743E-02;2.71077896E-03;2.71077896E-03;5.57142869E-03",
    ";1;8.01307037E-02;7.76474625E-02;8.62089992E-02;0.15477259;0.27765518;7.47397020E-02;7.24235252E-02;5.79993566E-03;5.79993566E-03;7.49523863E-02",
    ";1;0.12156279;0.11917356;0.13083348;0.17260425;0.26498863;0.11247815;0.11026748;9.77745559E-03;9.77745559E-03;0.14042857;",
    ";1;2.53944285E-02;2.12589949E-02;2.47635692E-02;0.17871745;0.26280892;2.34321021E-02;1.96162295E-02;1.91357767E-03;1.91357767E-03;0.15404762;",
    ";1;6.06068075E-02;5.45158759E-02;5.80036528E-02;0.17871745;0.26654729;5.59234843E-02;5.03032207E-02;4.48216870E-03;4.48216870E-03;0.16328572;",
    ";1;8.02474767E-02;6.92895874E-02;7.33897835E-02;0.17871745;0.26227131;7.40464404E-02;6.39353096E-02;5.67111513E-03;5.67111513E-03;0.19238095;",
    ";1;5.88302538E-02;3.97077426E-02;3.01676802E-02;0.27034116;0.26300001;5.20915464E-02;3.51594239E-02;3.45555483E-03;3.45555483E-03;0.26042855;",
    ";1;0.20531984;0.18852344;0.20068081;0.28510797;0.26122496;0.18059741;0.16582346;2.41638366E-02;2.41638366E-02;0.27466661;",
    ";1;0.20354943;0.17693305;0.17351794;0.28650427;0.26223704;0.17892773;0.15553091;2.09890399E-02;2.09890399E-02;0.30695230;",
    ";1;0.22638610;0.20436494;0.21117017;0.32027477;0.26189134;0.19600071;0.17693521;2.83431225E-02;2.83431225E-02;0.35271421;",
    ";1;0.23286064;0.19497021;0.18715708;0.50574958;0.26150563;0.18546253;0.15528458;3.80952843E-02;3.80952843E-02;0.40890470;",
    ";1;0.21331155;0.19008416;0.18748406;0.64692688;0.25588083;0.15943505;0.14207424;4.73532006E-02;4.73532006E-02;0.49385706;",
    ";1;0.28573769;0.24866831;0.23606429;0.82555008;0.24813299;0.19707349;0.17150672;7.32505769E-02;7.32505769E-02;0.54147619;",
    ";1;0.45553112;0.39793688;0.37809020;1.2833929;0.23920873;0.25568271;0.22335593;0.16587390;0.16587390;0.67857146;",
    ";1;0.32503864;0.28709969;0.26861471;1.9638548;0.23210816;0.13431790;0.11864013;0.15761325;0.15761325;0.79509526;",
    ";1;0.34260693;0.30848023;0.29411072;2.3891265;0.22359611;0.11691847;0.10527235;0.19374213;0.19374213;0.90257144;",
    ";1;0.39755616;0.35131419;0.32766971;2.4237313;0.20946671;0.13357419;0.11803743;0.21757655;0.21757655;1.0235000;",
    ";1;9.47604999E-02;8.31834227E-02;7.25952387E-02;2.2561765;0.19734369;3.43318395E-02;3.01374514E-02;4.62938994E-02;4.62938994E-02;1.1761000;",
    ";1;0.84839296;0.76790059;0.73810685;2.1372273;0.17533617;0.32427490;0.29350892;0.45598578;0.40967843;1.3802000;",
    ";1;0.33783823;0.29725331;0.27326211;1.6130878;0.14514941;0.16347788;0.14383908;0.14103222;0.14103222;1.6043501;",
    ";1;0.26032886;0.23449746;0.22417918;0.96794540;0.14322676;0.16840474;0.15169460;7.91593939E-02;7.91593939E-02;1.8007500;",
    ";1;0.31284398;0.28464359;0.28034323;0.13672256;0.13768105;0.29417637;0.26765871;1.67282727E-02;1.67282727E-02;1.9525001;"]

header_names = wl1_headers.split(",")
wl_evtra_testdata1 = []
for strline in wl1_raw_data:
    if strline[0] == ";": strline = strline[1:]
    if strline[-1] == ";": strline = strline[:-1]
    vline = strline.split(";")
    c = Container()
    for hname, value in zip(header_names, vline):
        setattr(c, hname, float(value))
    wl_evtra_testdata1.append(c)

#--------TEST DATA FOR WATER-LIMITED EVAPOTRANSPIRATION: DEPNR=2.5--------------
# Evapotranspiration parameter values for testing
parvalues = (1, 0, 0, (0,0.60000002,2.0,0.60000002), 1.0000000, 2.5000000, 0.40000001, 0.26300001, 0.10000000, 9.00000036E-02)
parnames = ("IWB", "IOX", "IAIRDU", "KDIFTB", "CFET", "DEPNR", "SM0", "SMFCF", "SMW", "CRAIRC")
wl_parvalue_dict2 = dict(zip(parnames,parvalues))

# evapotranspiration test data
wl2_headers = "IWB,E0,ES0,ET0,LAI,SM,EVWMX,EVSMX,TRAMX,TRA,DVS"
wl2_raw_data = [
    ";1;4.12496999E-02;3.92372534E-02;4.25780937E-02;0.14618465;0.37103572;3.86234932E-02;3.67391743E-02;2.71077896E-03;2.71077896E-03;5.57142869E-03",
    ";1;8.01307037E-02;7.76474625E-02;8.62089992E-02;0.15477259;0.27765518;7.47397020E-02;7.24235252E-02;5.79993566E-03;5.79993566E-03;7.49523863E-02",
    ";1;0.12156279;0.11917356;0.13083348;0.17260425;0.26498863;0.11247815;0.11026748;9.77745559E-03;9.77745559E-03;0.14042857;",
    ";1;2.53944285E-02;2.12589949E-02;2.47635692E-02;0.17871745;0.26280892;2.34321021E-02;1.96162295E-02;1.91357767E-03;1.91357767E-03;0.15404762;",
    ";1;6.06068075E-02;5.45158759E-02;5.80036528E-02;0.17871745;0.26654729;5.59234843E-02;5.03032207E-02;4.48216870E-03;4.48216870E-03;0.16328572;",
    ";1;8.02474767E-02;6.92895874E-02;7.33897835E-02;0.17871745;0.26227131;7.40464404E-02;6.39353096E-02;5.67111513E-03;5.67111513E-03;0.19238095;",
    ";1;5.88302538E-02;3.97077426E-02;3.01676802E-02;0.27034116;0.26300001;5.20915464E-02;3.51594239E-02;3.45555483E-03;3.45555483E-03;0.26042855;",
    ";1;0.20531984;0.18852344;0.20068081;0.28510797;0.26122496;0.18059741;0.16582346;2.41638366E-02;2.41638366E-02;0.27466661;",
    ";1;0.20354943;0.17693305;0.17351794;0.28650427;0.26223704;0.17892773;0.15553091;2.09890399E-02;2.09890399E-02;0.30695230;",
    ";1;0.22638610;0.20436494;0.21117017;0.32027477;0.26189134;0.19600071;0.17693521;2.83431225E-02;2.83431225E-02;0.35271421;",
    ";1;0.23286064;0.19497021;0.18715708;0.50574958;0.26150563;0.18546253;0.15528458;3.80952843E-02;3.80952843E-02;0.40890470;",
    ";1;0.21331155;0.19008416;0.18748406;0.64692688;0.25588083;0.15943505;0.14207424;4.73532006E-02;4.73532006E-02;0.49385706;",
    ";1;0.28573769;0.24866831;0.23606429;0.82555008;0.24813299;0.19707349;0.17150672;7.32505769E-02;7.32505769E-02;0.54147619;",
    ";1;0.45553112;0.39793688;0.37809020;1.2833929;0.23920873;0.25568271;0.22335593;0.16587390;0.16587390;0.67857146;",
    ";1;0.32503864;0.28709969;0.26861471;1.9638548;0.23210816;0.13431790;0.11864013;0.15761325;0.15761325;0.79509526;",
    ";1;0.34260693;0.30848023;0.29411072;2.3891265;0.22359611;0.11691847;0.10527235;0.19374213;0.19374213;0.90257144;",
    ";1;0.39755616;0.35131419;0.32766971;2.4237313;0.20946671;0.13357419;0.11803743;0.21757655;0.21757655;1.0235000;",
    ";1;9.47604999E-02;8.31834227E-02;7.25952387E-02;2.2561765;0.19734369;3.43318395E-02;3.01374514E-02;4.62938994E-02;4.62938994E-02;1.1761000;",
    ";1;0.84839296;0.76790059;0.73810685;2.1117775;0.17793705;0.32800996;0.29688960;0.45273626;0.30732119;1.3802000;",
    ";1;0.33783823;0.29725331;0.27326211;1.6130878;0.15415126;0.16347788;0.14383908;0.14103222;0.11182579;1.6043501;",
    ";1;0.26032886;0.23449746;0.22417918;0.96794540;0.15449877;0.16840474;0.15169460;7.91593939E-02;7.24825263E-02;1.8007500;",
    ";1;0.31284398;0.28464359;0.28034323;0.13672256;0.14995837;0.29417637;0.26765871;1.67282727E-02;1.20309321E-02;1.9525001;"]

header_names = wl2_headers.split(",")
wl_evtra_testdata2 = []
for strline in wl2_raw_data:
    if strline[0] == ";": strline = strline[1:]
    if strline[-1] == ";": strline = strline[:-1]
    vline = strline.split(";")
    c = Container()
    for hname, value in zip(header_names, vline):
        setattr(c, hname, float(value))
    wl_evtra_testdata2.append(c)
