#
# pdis.xpath.tests.test_parser
#
# Copyright 2004-2006 Helsinki Institute for Information Technology (HIIT)
# and the authors.  All rights reserved.
#
# Authors: Ken Rimey <rimey@hiit.fi>, Duncan McGreggor <oubiwann@adytum.us>
#

# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

def test_parser():
    """
    >>> from pdis.xpath.parser import parse_xpath as parse
    >>> print parse("/")
    /
    >>> print parse("foo")
    foo
    >>> print parse("/foo")
    /foo
    >>> print parse("foo/bar")
    foo/bar
    >>> print parse("/foo/bar")
    /foo/bar
    >>> print parse("foo//bar")
    foo//bar
    >>> print parse("//foo//bar")
    //foo//bar

    >>> print parse("child::foo")
    foo
    >>> print parse("@foo")
    @foo
    >>> print parse(".")
    .
    >>> print parse("..")
    ..
    >>> print parse("self::node()")
    .
    >>> print parse("parent::node()")
    ..

    >>> print parse("foo[one]")
    foo[one]
    >>> print parse("foo[one][two]")
    foo[one][two]

    >>> print parse("node()")
    node()
    >>> print parse("processing-instruction()")
    processing-instruction()
    >>> print parse("processing-instruction('whatever')")
    processing-instruction("whatever")

    >>> print parse("'foo'")
    "foo"
    >>> print parse("3.14")
    3.14
    >>> print parse("(3.14)")
    3.14
    >>> print parse("$work")
    $work

    >>> print parse("f()")
    f()
    >>> print parse("f(1)")
    f(1)
    >>> print parse("f(1, 2)")
    f(1, 2)

    >>> print parse("f()/blah")
    f()/blah
    >>> print parse("f()[maybe]")
    f()/self::node()[maybe]
    >>> print parse("f()[maybe]/blah")
    f()/self::node()[maybe]/blah
    >>> print parse("f()/self::node()[maybe]/blah")
    f()/self::node()[maybe]/blah

    >>> print parse("1 + 2 + 3 + 4 + 5")
    ((((1 + 2) + 3) + 4) + 5)
    >>> print parse("0 or 1 and 2 = 3 < 4 + 5 * 6 | 8")
    (0 or (1 and (2 = (3 < (4 + (5 * (6 | 8)))))))
    >>> print parse("1 + 2 * 3 | 4 * 5 + 6")
    ((1 + ((2 * (3 | 4)) * 5)) + 6)
    >>> print parse("1 | 2 * 3 + 4 * 5 | 6")
    (((1 | 2) * 3) + (4 * (5 | 6)))

    >>> print parse("1 * (2 + 3)")
    (1 * (2 + 3))
    >>> print parse("f() + f(1) + f(1, 2) + f(1, 2, 3)")
    (((f() + f(1)) + f(1, 2)) + f(1, 2, 3))
    >>> print parse("f(1 + 2, f(2, 3))")
    f((1 + 2), f(2, 3))
    >>> print parse("foo[1 + 2 = 3]")
    foo[((1 + 2) = 3)]
    >>> print parse("item[color = 'blue']")
    item[(color = "blue")]

    >>> print parse("1 * -2 * --3 * ---4")
    (((1 * (- 2)) * (- (- 3))) * (- (- (- 4))))
    >>> print parse("-1-2--3---4")
    ((((- 1) - 2) - (- 3)) - (- (- 4)))
    >>> print parse("-1 * -2|3 * -2|3|4")
    (((- 1) * (- (2 | 3))) * (- ((2 | 3) | 4)))
    """

def _test():
    import doctest, sys
    doctest.testmod(sys.modules[__name__])

if __name__ == "__main__":
    _test()
