import os
from panopticon.database import Key as dbKey
from panopticon.base import PanopticonManager
from panopticon.util.keys import get_key_from_dir

# TODO Meter logs

class KeyManager(PanopticonManager):
    key_dir_name = "keys"

    def _get_key_path(self):
        if self.panopticon.key_path:
            if self.panopticon.key_path[0] == "/":
                return self.panopticon.key_path
            else:
                return os.path.join(self.panopticon.path, self.panopticon.key_path)
        else:
            return os.path.join(self.panopticon.path, self.key_dir_name)

    def _key_generator(self):
        for name in os.listdir(self.key_path):
            key_dir = os.path.join(self.key_path, name)
            if not os.path.isdir(key_dir):
                continue
            keyfilevals = get_key_from_dir(key_dir)
            if not keyfilevals:
                continue
            algorithm, key = keyfilevals
            yield name, Key(self.panopticon, name, algorithm, key)


    def _update_after_get(self):
        return reduce(lambda x,y:x.__setitem__(*y), self._key_generator(), {})

class Key(object):
    def __init__(self, panopticon, name, algorithm, key):
        self.panopticon = panopticon
        self.name = name
        self.algorithm = algorithm
        self.key = key
        self.db_key = self.get_database_key()
        self.updated = self.key != self.db_key.get_paramiko_key()

    @property
    def computers(self):
        return [ x for x in self.panopticon.computers if x.key == self ]

    def get_database_key(self):
        session = self.panopticon.db.session
        keys = session.query(dbKey).filter(dbKey.name==self.name).all()
        if keys:
            return keys[0]
        key = dbKey.build_from_paramiko_key(self.name, self.key)
        session.add(key)
        session.commit()
        return key

    def update_computers(self):
        for computer in self.computers:
            self.computer.update_key(self.key)
        key = dbKey.build_from_paramiko_key(self.name, self.key)
        session = self.panopticon.db.session
        session.add(key)
        session.commit()
