from panopticon.base import ServiceAttribute, get_metaclass
from panopticon.actions import role_action, RoleActionManager
from panopticon.computers import Computer, Network
from panopticon.util.managers import Manager, ManagerMetaclass

def get_actions(obj):
    result = {}
    for key, attr in obj.__dict__.iteritems():
        if isinstance(attr, role_action):
            result[key] = attr
    return result

def check_all_true(result):
    return reduce(lambda x,y: x and y, result)

def filter_computers_networks(compsnetws):
    computers = filter(lambda x:isinstance(x,Computer), compsnetws)
    networks = filter(lambda x:isinstance(x,Network), compsnetws)
    return computers, networks

class RoleManager(Manager):
    managed_obj_name = "service"
    manager_attribute_name = "roles"

    def _update_after_get(self):
        return self.service._meta.roles

class RoleMetaclass(ManagerMetaclass):
    def __new__(cls, classname, bases, attrs):
        actions = {}
        todelete = []
        for name, attr in attrs.iteritems():
            if isinstance(attr, role_action):
                attr.name = name
                actions[name] = attr
                todelete.append(name)
        for name in todelete:
            del attrs[name]
        meta_attrs = { 'actions': actions }
        attrs['_meta'] = get_metaclass(meta_attrs)
        return type.__new__(cls, classname, bases, attrs)

class Role(ServiceAttribute):
    __metaclass__ = RoleMetaclass

    actions = RoleActionManager()

    def __init__(self, computers, exc_computers=(), required_roles=[],
            sensitive=True, service=None, name=None):
        super(Role, self).__init__(service=service, name=name)
        self.computers_names = computers
        self.exc_computers_names = exc_computers
        self.required_roles_names = required_roles
        self.service = service
        self.sensitive = sensitive
        self.name = name
        self.panopticon = None if service is None else service.panopticon

    @property
    def computers(self):
        computer_names = list(self.computers_names)
        for name, computer in self.panopticon.computers:
            if name in computer_names:
                yield computer
                computer_names.remove(name)
        for nname, network in self.panopticon.networks:
            if nname in computer_names:
                for cname, computer in network:
                    if not cname in self.exc_computers_names:
                        yield computer
                computer_names.remove(nname)
        for gname, cgroup in self.panopticon.computer_groups:
            if gname in computer_names:
                for cname, computer in cgroup:
                    if not gname in self.exc_computers_names:
                        yield computer
                computer_names.remove(gname)
        if len(computer_names) != 0:
            raise Exception("Couldn't resolve all computer names")

    @property
    def required_roles(self):
        for name, role in self.service.roles:
            if role != self and name in self.required_roles_names: 
                yield role

    def _get_args_kwords(self):
        return (), {'computers':self.computers_names, 
                    'exc_computers':self.exc_computers_names, 
                    'required_roles': self.required_roles_names, 
                    'sensitive':self.sensitive
                    } 

    def reinstantiate(self, service):
        role = super(Role, self).reinstantiate(service)
        actions = {}
        for name, action in self._meta.actions.iteritems():
            actions[name] = action.reinstantiate(role)
        role._meta = get_metaclass({'actions':actions})
        return role

