import re
import logging

BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE = range(8)

#The background is set with 40 plus the number of the color, and the foreground with 30

#These are the sequences need to get colored ouput
RESET_SEQ = "\033[0m"
COLOR_SEQ = "\033[1;%dm"
BOLD_SEQ = "\033[1m"

COLORS = {
    'DEBUG': BLUE,
    'INFO': WHITE,
    'WARNING': YELLOW,
    'ERROR': RED,
    'CRITICAL': YELLOW
}

def color_string(text, color):
    return COLOR_SEQ % (30 + color) + text + RESET_SEQ

class ColoredFormatter(logging.Formatter):
    def __init__(self, fmt=None, datefmt=None, use_color = True):
        logging.Formatter.__init__(self, fmt=fmt, datefmt=datefmt)
        self.use_color = use_color

    def format(self, record):
        levelname = record.levelname
        msg = record.msg
        if self.use_color and levelname in COLORS:
            msg_color = color_string(msg, COLORS[levelname])
            record.msg = msg_color
        return logging.Formatter.format(self, record)

def check_colored(color, text):
    color_text = COLOR_SEQ % (30 +color)
    return text.startswith(color_text) and text.endswith(RESET_SEQ)

def check_level(level, text):
    color = COLORS[level]
    return check_colored(color, text)
