from panopticon.util.managers import Manager

class PanopticonManager(Manager):
    managed_obj_name = "panopticon"

def AttributeFactory(class_name, attr_name):
    def __init__(self, **kwargs):
        self.name = kwargs['name']
        setattr(self, attr_name, kwargs[attr_name])

    def _get_args_kwords(self):
        return (), {'name':self.name, attr_name:getattr(self,attr_name)} 

    def reinstantiate(self, attr_obj):
        args, kwords = self._get_args_kwords()
        kwords['name'] = self.name
        kwords[attr_name] = attr_obj
        return self.__class__(*args, **kwords)

    attrs = {'__init__' : __init__,
             '_get_args_kwords' : _get_args_kwords,
             'reinstantiate' : reinstantiate
             }

    return type(class_name, (), attrs)

PanopticonAttribute = AttributeFactory('PanopticonAttribute', 'panopticon')
ServiceAttribute = AttributeFactory('ServiceAttribute', 'service')
RoleAttribute = AttributeFactory('RoleAttribute', 'role')


class MetaMixin(object):
    @classmethod
    def itermeta(cls):
        for name, value in cls.__dict__.iteritems():
            if isinstance(value, dict):
                yield name, value

    @classmethod
    def getdict(cls):
        result = {}
        for name, value in cls.itermeta():
            result[name] = value
        return result

def get_metaclass(attrs):
    return type("Meta", (MetaMixin,), attrs)

