from panopticon.roles import Role, RoleManager
from panopticon.base import PanopticonAttribute, PanopticonManager, get_metaclass
from panopticon.actions import ServiceActionManager
from panopticon.util.managers import ManagerMetaclass

class ServiceMetaclass(ManagerMetaclass):
    def __new__(cls, classname, bases, attrs):
        roles = {}
        todelete = []
        for name, attr in attrs.iteritems():
            if isinstance(attr, Role):
                attr.name = name
                roles[name] = attr
                todelete.append(name)
        for name in todelete:
            del attrs[name]
        meta_attrs = { 'roles': roles }
        attrs['_meta'] = get_metaclass(meta_attrs)
        return type.__new__(cls, classname, bases, attrs)

class ServiceManager(PanopticonManager):
    def _update_after_get(self):
        return self.panopticon._meta.services

class Service(PanopticonAttribute):
    __metaclass__ = ServiceMetaclass
    actions = ServiceActionManager()
    roles = RoleManager()

    def __init__(self, required_services=[], panopticon=None, name=None):
        super(Service, self).__init__(panopticon=panopticon, name=name)
        self.required_services_names = required_services

    @property
    def required_services(self):
        if self.panopticon is None: return self.required_services_names
        services = []
        for service_name in self.required_services_names:
            services.append(self.panopticon.services[service_name])
        return services

    def reinstantiate(self, panopticon):
        service = super(Service, self).reinstantiate(panopticon)
        roles = {}
        for name, role in self._meta.roles.iteritems():
            roles[name] = role.reinstantiate(service)
        service._meta = get_metaclass({'roles':roles})
        return service

    def _get_args_kwords(self):
        kwords = dict(required_services=self.required_services_names,
                panopticon=self.panopticon, name=self.name)
        return (), kwords
