def get_class_dict(cls):
    classes = cls.__bases__
    classes.reverse()
    classes.append(cls)
    result = {}
    for cls in classes:
        for name, attr in cls.__dict__:
            result[name] = attr
    return result

def get_class_dict_iterator(cls):
    return get_class_dict(cls).iteritems()

def get_attr_generator(obj):
    for name, attr in obj.__dict__.iteritems():
        yield name, attr
    cls_dict = get_class_dict(obj.__class__)
    for name, attr in cls_dict.iteritems():
        yield name, attr


def get_class_checker(kls):
    if kls.__class__ in (list, tuple):
        return lambda x: x in kls
    else:
        return lambda x: isinstance(x, kls)

def get_attribute_class_check(name, obj, kls):
    attr = getattr(obj, name)
    if not get_class_checker(kls)(attr):
        raise Exception("Attribute %s must be of class %s" % (name, kls))
    return attr

def get_attribute_instances(obj, kls):
    check_attr = get_class_checker(kls)
    result = []
    for name, attr in get_attr_generator(obj):
        if check_attr(attr):
            result.append(getattr(obj,name))
    return result

def attribute_name_updater(obj, kls):
    check_attr = get_class_checker(kls)
    for name, attr in get_attr_generator(obj):
        if check_attr(attr):
            attr.name = name

def update_dict_of_dicts(*dicts):
    dicts = list(dicts)
    result = {}
    for iterdict in dicts:
        for oname, ovalue in iterdict.iteritems():
            if not result.has_key(oname):
                result[oname] = ovalue
            else:
                odict = result[oname]
                for name, value in ovalue.iteritems():
                    odict[name] = value
    return result

class nonmasking_property(object):
    def __init__(self, function):
        self.function = function

    def __get__(self, obj, objtype=None):
        if obj is None:
            return self
        return self.function(obj)

