import os
from paramiko import DSSKey, RSAKey, SSHException

def check_key_algorithm(filename, kclass):
    try:
        key = kclass.from_private_key_file(filename)
    except SSHException:
        return False
    return key

def get_dsa_key_from_file(filename):
    return check_key_algorithm(filename, DSSKey)

def get_rsa_key_from_file(filename):
    return check_key_algorithm(filename, RSAKey)

def check_key_file(filename):
    if get_dsa_key_from_file(filename) or get_rsa_key_from_file(filename):
        return True
    return False

def get_key_from_dir(dirname):
    for filename in os.listdir(dirname):
        filepath = os.path.join(dirname, filename)
        keyfilevals = get_key_from_file(filepath)
        if keyfilevals:
            return keyfilevals
    return False

def get_key_from_file(filename):
    key = get_dsa_key_from_file(filename)
    if key:
        return "dsa", key
    key = get_rsa_key_from_file(filename)
    if key:
        return "rsa", key
    
