from panopticon.util.inspect import nonmasking_property

class Manager(object):
    managed_obj_name = "_obj"
    manager_attribute_name = "manageds"

    def __init__(self, obj=None):
        setattr(self, self.managed_obj_name, obj)

    def _get_obj(self):
        return getattr(self, self.managed_obj_name)

    def __get__(self, obj, objtype=None):
        if self._get_obj() is None:
            return self.__class__(obj)

    def _update_after_get(self):
        return {}

    def _to_item(self, name, item):
        return item

    @property
    def _items(self):
        if self._instantiated:
            return self._update_after_get()
        return {}

    @property
    def _instantiated(self):
        return self._get_obj() is not None

    def __iter__(self):
        for name in self._items:
            yield name, self[name]

    def __getitem__(self, name):
        return self._to_item(name, self._items[name])

    def __repr__(self):
        return "<%s: on %s>" % (self.__class__.__name__, self._get_obj())

class AttributableManager(Manager):
    def _to_attribute(self, name, value):
        return value

    def __getattr__(self, name):
        return self._to_attribute(name, self._items[name])

class ManagerMetaclass(type):
    managers_attribute_name = "managers"

    def __new__(cls, classname, bases, attrs):
        if attrs.has_key(cls.managers_attribute_name):
            managers = attrs[cls.managers_attribute_name]
        else:
            managers = []
        for base in bases:
            if hasattr(base, cls.managers_attribute_name):
                managers.extend(getattr(base, cls.managers_attribute_name))
        for manager in managers:
            if issubclass(manager, Manager):
                attr_name = manager.manager_attribute_name
                attrs[attr_name] = manager()
        return super(ManagerMetaclass, cls).__new__(cls, classname, bases, attrs)
