(function() {
  /*
Copyright 2011 Fred Hatfull

This file is part of Partify.

Partify is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Partify is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Partify.  If not, see <http://www.gnu.org/licenses/>.
*/;
  var $, GlobalQueue, History, HistoryQueue, Player, Queue, Search, Statistics, Track, UserQueue, buildRoboHashUrlFromId, secondsToTimeString, yearFromDateString;
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; }, __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __indexOf = Array.prototype.indexOf || function(item) {
    for (var i = 0, l = this.length; i < l; i++) {
      if (this[i] === item) return i;
    }
    return -1;
  }, __slice = Array.prototype.slice;
  $ = jQuery;
  $(function() {
    window.Partify = window.Partify || {};
    return window.Partify.History = new History($("#history_widget"));
  });
  History = (function() {
    function History(widget_div) {
      this.widget_div = widget_div;
      this.last_update_time = 0;
      this.ipp = 10;
      this.page = 1;
      this.total_pages = 1;
      this.in_flight_xhr = void 0;
      this.widget_div.append("<span id='history_last_updated' class='small darker left'><span id='history_update_prefix'>Last updated </span><span class='timeago' id='timeago'>never</span></span>");
      this._buildIppSelectors();
      this.widget_div.append("<ul id='history_queue'></ul>");
      this.widget_div.append("<span id='page_info' class='small darker left'></span>");
      this._buildPageSelector();
      this.queue = new HistoryQueue($("ul#history_queue"));
      this.queue.updateDisplay();
      this.update();
      setInterval(__bind(function() {
        return this.update();
      }, this), 1000 * 60 * 5);
    }
    History.prototype.update = function() {
      this._showUpdateSpinner();
      if (this.in_flight_xhr) {
        this.in_flight_xhr.abort();
        this.in_flight_xhr = void 0;
      }
      return this.in_flight_xhr = $.ajax({
        url: '/history',
        method: 'GET',
        data: {
          ipp: this.ipp,
          page: this.page
        },
        success: __bind(function(data) {
          if (data.status === 'ok') {
            this.queue.update(data.tracks);
            this.last_update_time = data.response_time;
            this.page = data.page;
            this.total_pages = data.pages;
            this._updateUpdateTime();
            this._updatePageInfo(data.page, data.pages);
            return this._updatePageSelector();
          }
        }, this)
      });
    };
    History.prototype._updatePageInfo = function(displayed_page, total_pages) {
      var page_info;
      page_info = $("span#page_info");
      page_info.empty();
      return page_info.append("Page " + displayed_page + " of " + total_pages);
    };
    History.prototype._updatePageSelector = function() {
      var page_display, page_left_btn, page_right_btn;
      page_left_btn = $("span#page_selector button#page_left");
      page_right_btn = $("span#page_selector button#page_right");
      page_display = $("span#page_selector span#page_display");
      if (this.page === 1) {
        page_left_btn.button('disable');
      } else {
        page_left_btn.button('enable');
      }
      if (this.page === this.total_pages) {
        page_right_btn.button('disable');
      } else {
        page_right_btn.button('enable');
      }
      return page_display.text(this.page);
    };
    History.prototype._showUpdateSpinner = function() {
      $("span#history_last_updated > span").empty();
      return $("span#history_last_updated > span#history_update_prefix").append("			<img src='/static/img/loading.gif' class='left' style='margin-right: 5px' />			Updating...		");
    };
    History.prototype._updateUpdateTime = function() {
      $("span#history_last_updated > span").empty();
      $("span#history_last_updated > span#history_update_prefix").append("Last updated ");
      $("span#history_last_updated > span#timeago").remove();
      $("span#history_last_updated").append("		<span class='timeago' id='timeago'>never</span>");
      $("span#history_last_updated > span#timeago").attr('title', this.last_update_time);
      return $("span.timeago").timeago();
    };
    History.prototype._buildIppSelectors = function() {
      this.widget_div.append("<span id='ipp_selector' class='small darker right'>			<span id='ipp_10'>10</span>&nbsp;			<a href='#'><span id='ipp_25'>25</span></a>&nbsp;			<a href='#'><span id='ipp_50'>50</span></a>&nbsp;			<a href='#'><span id='ipp_100'>100</span></a>&nbsp;			items per page			</span>");
      return this._buildIppSelectorLinks();
    };
    History.prototype._buildPageSelector = function() {
      this.widget_div.append("<span id='page_selector' class='small right'>			<button id='page_left'></button>			<span id='page_display'>" + this.page + "</span>			<button id='page_right'></button>		</span>");
      $("span#page_selector button#page_left").button({
        icons: {
          primary: 'ui-icon-carat-1-w'
        },
        text: false
      });
      $("span#page_selector button#page_right").button({
        icons: {
          primary: 'ui-icon-carat-1-e'
        },
        text: false
      });
      $("span#page_selector button#page_left").click(__bind(function(e) {
        this.page = Math.max(this.page - 1, 1);
        this._updatePageSelector();
        return this.update();
      }, this));
      return $("span#page_selector button#page_right").click(__bind(function(e) {
        this.page = Math.min(this.page + 1, this.total_pages);
        this._updatePageSelector();
        return this.update();
      }, this));
    };
    History.prototype._buildIppSelectorLinks = function() {
      return $("span#ipp_selector a").click(__bind(function(e) {
        var ipp_span, proposed_ipp;
        e.stopPropagation();
        $("span#ipp_selector > span#ipp_" + this.ipp).wrap("<a href='#'></a>");
        ipp_span = $(e.currentTarget).children("span").first();
        ipp_span.unwrap();
        proposed_ipp = parseInt(ipp_span.text());
        this.page = (Math.floor(((this.page - 1) * this.ipp) / proposed_ipp)) + 1;
        this.ipp = proposed_ipp;
        this.update();
        $("span#ipp_selector a").unbind('click');
        return this._buildIppSelectorLinks();
      }, this));
    };
    return History;
  })();
  /*
Copyright 2011 Fred Hatfull

This file is part of Partify.

Partify is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Partify is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Partify.  If not, see <http://www.gnu.org/licenses/>.
*/;
  $ = jQuery;
  $(function() {
    window.Partify = window.Partify || {};
    window.Partify.Player = new Player();
    window.Partify.Player.init();
    window.Partify.Queues = window.Partify.Queues || {};
    return window.Partify.Queues.GlobalQueue = window.Partify.Queues.GlobalQueue || {};
  });
  Player = (function() {
    function Player() {
      var up_next_items;
      this.info = {
        artist: '',
        title: '',
        album: '',
        elapsed: 0,
        time: 100,
        date: 1970,
        volume: 0,
        state: 'pause',
        file: '',
        last_global_playlist_update: 0
      };
      this.config = up_next_items = 3;
      this.last_update_time = (new Date()).getTime();
    }
    Player.prototype.init = function() {
      this.initPlayerVisuals();
      this.initPlayerUpdating();
      return this.info.last_global_playlist_update = (new Date()).getTime();
    };
    Player.prototype.initPlayerVisuals = function() {
      $("#player_progress").progressbar({
        value: 0
      });
      return $("#tabs").tabs();
    };
    Player.prototype.initPlayerUpdating = function() {
      this._initPlayerSynchroPolling(3000);
      return this._initPlayerLocalUpdate();
    };
    Player.prototype._initPlayerPushUpdates = function() {
      var worker;
      worker = new Worker('static/js/partify/workers/player_event.js');
      worker.addEventListener('message', __bind(function(e) {
        return console.log(e.data);
      }, this), false);
      return worker.postMessage('Start checking push');
    };
    Player.prototype._initPlayerSynchroPolling = function(poll_frequency) {
      this._synchroPoll();
      return setInterval(__bind(function() {
        return this._synchroPoll();
      }, this), poll_frequency);
    };
    Player.prototype._synchroPoll = function() {
      return $.ajax({
        url: '/player/status/poll',
        method: 'GET',
        data: {
          current: this.info.last_global_playlist_update
        },
        success: __bind(function(data) {
          if (data.elapsed) {
            data.elapsed = parseFloat(data.elapsed);
          }
          data.time = parseFloat(data.time);
          this.updatePlayerInfo(data);
          if (data.global_queue) {
            window.Partify.Queues.GlobalQueue.update(data.global_queue);
            window.Partify.History.update();
            window.Partify.Statistics.update();
          }
          if (data.user_queue) {
            return window.Partify.Queues.UserQueue.update(data.user_queue);
          }
        }, this)
      });
    };
    Player.prototype._initPlayerLocalUpdate = function() {
      return setInterval(__bind(function() {
        return this._playerLocalUpdate();
      }, this), 1000);
    };
    Player.prototype._playerLocalUpdate = function() {
      var last_update_time;
      last_update_time = this.last_update_time;
      this.last_update_time = (new Date()).getTime();
      if (this.info.state === 'play') {
        this.info.elapsed = Math.floor(this.info.elapsed) < this.info.time ? this.info.elapsed + ((this.last_update_time - last_update_time) / 1000) : this.info.elapsed;
        this.updatePlayerProgress();
        if (this.info.elapsed >= this.info.time) {
          this._synchroPoll();
          return window.Partify.Queues.UserQueue.loadPlayQueue();
        }
      }
    };
    Player.prototype.updatePlayerInfo = function(data) {
      var info, key, text, value, year, _i, _len, _ref;
      info = (function() {
        var _ref, _results;
        _ref = this.info;
        _results = [];
        for (key in _ref) {
          value = _ref[key];
          if (data.state !== 'stop' || key === 'last_global_playlist_update') {
            data[key] || (data[key] = this.info[key]);
          }
          this.info[key] = data[key];
          _results.push(key === 'date' ? (year = yearFromDateString(data[key]), this.info[key] = year !== "" && year > 0 ? year : "") : void 0);
        }
        return _results;
      }).call(this);
      _ref = ['artist', 'title', 'album', 'date'];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        text = _ref[_i];
        this._updatePlayerTextFromInfo(text);
      }
      return this.updatePlayerProgress();
    };
    Player.prototype._updatePlayerTextFromInfo = function(info_key) {
      return this._updatePlayerText(info_key, this.info[info_key]);
    };
    Player.prototype._updatePlayerText = function(info_key, data) {
      var info_span;
      info_span = $("#player_info_" + info_key).first();
      return info_span.text(data);
    };
    Player.prototype.updatePlayerProgress = function() {
      var progress;
      progress = Math.round((this.info.elapsed / this.info.time) * 100);
      $("#player_progress").progressbar({
        value: progress
      });
      this._updatePlayerText('elapsed', secondsToTimeString(this.info['elapsed']));
      return this._updatePlayerText('time', secondsToTimeString(this.info['time']));
    };
    return Player;
  })();
  yearFromDateString = function(date_string) {
    var d, year;
    d = new Date(date_string);
    year = d.getUTCFullYear();
    return year;
  };
  secondsToTimeString = function(seconds) {
    var days, hours, minutes, time_s;
    seconds = parseInt(Math.round(seconds));
    seconds = Math.floor(seconds);
    minutes = Math.floor(seconds / 60);
    hours = Math.floor(seconds / (60 * 60));
    days = Math.floor(hours / 24);
    seconds = seconds % 60;
    time_s = "";
    if (days > 0) {
      hours = hours % 24;
      time_s += "" + days + ":";
      if (hours < 10) {
        time_s += "0";
      }
    }
    if (hours > 0) {
      minutes = minutes % 60;
      time_s += "" + hours + ":";
      if (minutes < 10) {
        time_s += "0";
      }
    }
    time_s += "" + minutes + ":";
    time_s += seconds < 10 ? '0' : '';
    time_s += seconds;
    return time_s;
  };
  Array.prototype.remove = function(e) {
    var t, _ref;
    if ((t = this.indexOf(e)) > -1) {
      return ([].splice.apply(this, [t, t - t + 1].concat(_ref = [])), _ref);
    }
  };
  /*
Copyright 2011 Fred Hatfull

This file is part of Partify.

Partify is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Partify is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Partify.  If not, see <http://www.gnu.org/licenses/>.
*/;
  $ = jQuery;
  $(function() {
    window.Partify = window.Partify || {};
    window.Partify.Queues = window.Partify.Queues || {};
    window.Partify.Queues.GlobalQueue = new GlobalQueue($("#party_queue"), $("#up_next_tracks"));
    window.Partify.Queues.UserQueue = new UserQueue($("#user_queue"));
    window.Partify.Config = window.Partify.Config || {};
    window.Partify.Config.lastFmApiKey = config_lastfm_api_key;
    window.Partify.Config.lastFmApiSecret = config_lastfm_api_secret;
    window.Partify.Config.user_id = config_user_id;
    window.Partify.Config.voting_enabled = config_voting_enabled;
    window.Partify.LastCache = new LastFMCache();
    return window.Partify.LastFM = new LastFM({
      apiKey: window.Partify.Config.lastFmApiKey,
      apiSecret: window.Partify.Config.lastFmApiSecret,
      cache: window.Partify.LastCache
    });
  });
  Queue = (function() {
    function Queue(queue_div) {
      this.tracks = new Array();
      this.queue_div = queue_div;
      this.queue_div.sortable({
        placeholder: "queue-placeholder",
        forcePlacerHolderSize: true,
        axis: 'y',
        cancel: 'li.queue_header, li.queue_footer',
        opacity: 0.8,
        items: "li.queue_item_sortable"
      });
      this.queue_div.disableSelection();
      this.queue_div.addClass('queue');
    }
    Queue.prototype.update = function(tracks) {
      var track, _i, _len;
      this.tracks = new Array();
      for (_i = 0, _len = tracks.length; _i < _len; _i++) {
        track = tracks[_i];
        this.tracks.push(new Track(track));
      }
      return this.updateDisplay();
    };
    Queue.prototype.updateDisplay = function() {
      var track, _i, _len, _ref;
      this.queue_div.empty();
      this.queue_div.append(this._buildDisplayHeader());
      _ref = this.tracks;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        track = _ref[_i];
        this.queue_div.append(this._buildDisplayItem(track));
      }
      return this.queue_div.append(this._buildDisplayFooter());
    };
    Queue.prototype._buildDisplayHeader = function() {
      return "        <li class='queue_header span-23 last'>            <span class='span-1 padder'>&nbsp;</span>            <span class='span-6'>Title</span>            <span class='span-6'>Artist</span>            <span class='span-6'>Album</span>            <span class='span-3'>User</span>            <span class='span-1 last right'>Len</span>        </li>        ";
    };
    Queue.prototype._buildDisplayItem = function(track) {
      return "        <li class='queue_item queue_item_sortable ui-state-default small span-23 last'>            <span class='span-1 padder'>&nbsp;</span>            <span class='span-6'>" + track.title + "</span>            <span class='span-6'>" + track.artist + "</span>            <span class='span-6'>" + track.album + "</span>            <span class='span-3'>" + track.user + "</span>            <span class='span-1 last right'>" + (secondsToTimeString(track.length)) + "</span>        </li>        ";
    };
    Queue.prototype._buildDisplayFooter = function() {
      if (this.tracks.length > 0) {
        return this._buildQueueSummary();
      } else {
        return this._buildNoItemsRow();
      }
    };
    Queue.prototype._buildQueueSummary = function() {
      var t, total_queue_time;
      total_queue_time = ((function() {
        var _i, _len, _ref, _results;
        _ref = this.tracks;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          t = _ref[_i];
          _results.push(t.length);
        }
        return _results;
      }).call(this)).reduce(function(a, b) {
        return a + b;
      });
      return "        <li class='queue_item queue_footer ui-state-default small span-23 last'>            <span class='span-23 last'><center><p>" + this.tracks.length + " tracks - " + (secondsToTimeString(total_queue_time)) + "</p></center></span>        </li>        ";
    };
    Queue.prototype._buildNoItemsRow = function() {
      return "        <li class='queue_item queue_footer ui-state-default small span-23 last'>            <span class='span-23 last'><center><p ><em>There's nothing in this queue right now!</em></p></center></span>        </li>        ";
    };
    Queue.prototype._buildAvatarImage = function(username) {
      return "        <img id='player_info_user_avatar' src='" + (buildRoboHashUrlFromId(username, 70, 70)) + "' />        ";
    };
    Queue.prototype.removeTrack = function(track) {
      return $.ajax({
        url: '/queue/remove',
        type: 'POST',
        data: {
          track_id: track.mpd_id
        },
        success: __bind(function(data) {
          if (data.status === 'ok') {
            this.tracks.remove(track);
            this.updateDisplay();
            return window.Partify.Player._synchroPoll();
          }
        }, this),
        error: __bind(function() {
          return console.log("Could not contact the server!");
        }, this)
      });
    };
    return Queue;
  })();
  GlobalQueue = (function() {
    __extends(GlobalQueue, Queue);
    function GlobalQueue(queue_div, up_next_div) {
      GlobalQueue.__super__.constructor.call(this, queue_div);
      this.up_next_div = up_next_div;
      this.queue_div.sortable('option', 'disabled', true);
    }
    GlobalQueue.prototype.updateDisplay = function() {
      var track, up_next_dsp, _i, _len;
      GlobalQueue.__super__.updateDisplay.call(this);
      this.up_next_div.empty();
      up_next_dsp = this.tracks.slice(1, 4);
      for (_i = 0, _len = up_next_dsp.length; _i < _len; _i++) {
        track = up_next_dsp[_i];
        this.up_next_div.append(this._buildUpNextDisplayItem(track, track.mpd_id === up_next_dsp.slice(-1)[0].mpd_id));
      }
      if (window.Partify.Config.voting_enabled) {
        this._buildVotingButtons();
      }
      $("#player_info_user_name").empty();
      $("#player_info_skip_div").empty();
      $("#player_info_vote_div").empty();
      $("#user_avatar_container").empty();
      if (this.tracks.length > 0) {
        $("#player_info_user_name").append(this.tracks[0].user);
        $("#user_avatar_container").append(this._buildAvatarImage(this.tracks[0].username));
        if (this.tracks[0].user_id === window.Partify.Config.user_id) {
          $("#player_info_skip_div").append("<a href='#' id='player_skip_btn'>Skip My Track</a>");
          $("#player_skip_btn").click(__bind(function(e) {
            this.removeTrack(this.tracks[0]);
            e.stopPropagation();
            return $("#player_skip_btn").remove();
          }, this));
        } else if (window.Partify.Config.voting_enabled) {
          this._buildPlayerVoteButtons(this.tracks[0].id);
        }
        return window.Partify.LastFM.artist.getInfo({
          artist: this.tracks[0].artist
        }, {
          success: __bind(function(data) {
            var image, image_sizes, images, img_url, preferred_sizes, size, target_size, _j, _len2, _ref;
            images = (_ref = data.artist) != null ? _ref.image : void 0;
            if (images != null) {
              console.log('Got images');
              image_sizes = (function() {
                var _j, _len2, _results;
                _results = [];
                for (_j = 0, _len2 = images.length; _j < _len2; _j++) {
                  image = images[_j];
                  _results.push(image.size);
                }
                return _results;
              })();
              preferred_sizes = ['large', 'medium', 'small'];
              for (_j = 0, _len2 = preferred_sizes.length; _j < _len2; _j++) {
                size = preferred_sizes[_j];
                if (__indexOf.call(image_sizes, size) < 0) {
                  preferred_sizes.remove(size);
                }
              }
              target_size = preferred_sizes[0];
              img_url = (function() {
                var _k, _len3, _results;
                _results = [];
                for (_k = 0, _len3 = images.length; _k < _len3; _k++) {
                  image = images[_k];
                  if (image.size === target_size) {
                    _results.push(image['#text']);
                  }
                }
                return _results;
              })();
              img_url = img_url[0];
              return $('#now_playing_artist_image').attr('src', img_url);
            }
          }, this),
          error: __bind(function(code, message) {
            return console.log("" + code + " - " + message);
          }, this)
        });
      } else {
        return $('#now_playing_artist_image').attr('src', "http://debbiefong.com/images/10%20t.jpg");
      }
    };
    GlobalQueue.prototype._buildDisplayHeader = function() {
      var album_width, user_width, voting_hdr;
      user_width = 3;
      album_width = 6;
      voting_hdr = "";
      if (window.Partify.Config.voting_enabled) {
        user_width = 2;
        album_width = 5;
        voting_hdr = "<span class='span-2'>Vote</span>";
      }
      return "        <li class='queue_header span-23 last'>            <span class='span-1 padder'>&nbsp;</span>            <span class='span-6'>Title</span>            <span class='span-6'>Artist</span>            <span class='span-" + album_width + "'>Album</span>            <span class='span-" + user_width + "'>User</span>            " + voting_hdr + "            <span class='span-1 right'>Time</span>            <span class='span-1 last padder'>&nbsp;</span>        </li>        ";
    };
    GlobalQueue.prototype._buildDisplayItem = function(track) {
      var album_width, user_width, voting_section;
      user_width = 3;
      album_width = 6;
      voting_section = "";
      if (window.Partify.Config.voting_enabled) {
        user_width = 2;
        album_width = 5;
        if (track.user_id !== window.Partify.Config.user_id) {
          voting_section = "                <span class='span-2'><button class='vote_up_button'></button>                <button class='vote_down_button'></button></span>                ";
        } else {
          voting_section = "<span class='span-2'>&nbsp;</span>";
        }
      }
      return "        <li class='queue_item queue_item_sortable ui-state-default small span-23 last'>            <input type='hidden' name='id' value='" + track.id + "'>            <span class='span-1 padder'>&nbsp;</span>            <span class='span-6'>" + track.title + "</span>            <span class='span-6'>" + track.artist + "</span>            <span class='span-" + album_width + "'>" + track.album + "</span>            <span class='span-" + user_width + "'>" + track.user + "</span>            " + voting_section + "            <span class='span-1 right'>" + (secondsToTimeString(track.length)) + "</span>            <span class='span-1 last padder'>&nbsp;</span>        </li>        ";
    };
    GlobalQueue.prototype._buildVotingButtons = function() {
      $("li.queue_item span button.vote_up_button").each(function(idx, up_btn) {
        var id;
        id = $(up_btn).parents("span").first().siblings("input:hidden").first().attr('value');
        id = parseInt(id);
        $(up_btn).button({
          icons: {
            primary: "ui-icon-circle-arrow-n"
          }
        });
        return $(up_btn).click(function(e) {
          var btn;
          e.stopPropagation();
          btn = $(e.currentTarget);
          btn.button('disable');
          btn.button('option', 'icons', {
            primary: 'ui-icon-loading'
          });
          return $.ajax({
            url: "/vote/up",
            type: 'POST',
            data: {
              pqe: id
            },
            success: function(data) {
              if (data.status === "ok") {
                btn.button('option', 'icons', {
                  primary: "ui-icon-circle-arrow-n"
                });
                btn.siblings(".vote_down_button").first().button('enable');
                if (id === window.Partify.Queues.GlobalQueue.tracks[0].id) {
                  $("button#player_info_vote_up").button('disable');
                  return $("button#player_info_vote_down").button('enable');
                }
              } else {
                return this.error();
              }
            },
            error: __bind(function() {
              btn.button('enable');
              return btn.button('option', 'icons', {
                primary: "ui-icon-circle-arrow-n"
              });
            }, this)
          });
        });
      });
      $("li.queue_item span button.vote_down_button").each(function(idx, dwn_btn) {
        var id;
        id = $(dwn_btn).parents("span").first().siblings("input:hidden").first().attr('value');
        id = parseInt(id);
        $(dwn_btn).button({
          icons: {
            primary: "ui-icon-circle-arrow-s"
          }
        });
        return $(dwn_btn).click(function(e) {
          var btn;
          e.stopPropagation();
          btn = $(e.currentTarget);
          btn.button('disable');
          btn.button('option', 'icons', {
            primary: 'ui-icon-loading'
          });
          return $.ajax({
            url: "/vote/down",
            type: 'POST',
            data: {
              pqe: id
            },
            success: function(data) {
              if (data.status === "ok") {
                btn.button('option', 'icons', {
                  primary: "ui-icon-circle-arrow-s"
                });
                btn.siblings(".vote_up_button").first().button('enable');
                if (id === window.Partify.Queues.GlobalQueue.tracks[0].id) {
                  console.log($("button#player_info_vote_down"));
                  $("button#player_info_vote_down").button('disable');
                  return $("button#player_info_vote_up").button('enable');
                }
              } else {
                return this.error();
              }
            },
            error: __bind(function() {
              btn.button('enable');
              return btn.button('option', 'icons', {
                primary: "ui-icon-circle-arrow-s"
              });
            }, this)
          });
        });
      });
      return $("li.queue_item input:hidden").each(function(idx, id_input) {
        var id;
        id = $(id_input).attr('value');
        id = parseInt(id);
        return $.ajax({
          url: "/vote/status",
          type: 'GET',
          data: {
            pqe: id
          },
          success: function(data) {
            if (data.direction === -1) {
              $(id_input).parents("li").first().children("span").children("button.vote_down_button").button('disable');
              if (id === window.Partify.Queues.GlobalQueue.tracks[0].id) {
                $("button#player_info_vote_down").button('disable');
                $("button#player_info_vote_up").button('enable');
              }
            }
            if (data.direction === 1) {
              $(id_input).parents("li").first().children("span").children("button.vote_up_button").button('disable');
              if (id === window.Partify.Queues.GlobalQueue.tracks[0].id) {
                console.log;
                $("button#player_info_vote_up").button('disable');
                return $("button#player_info_vote_down").button('enable');
              }
            }
          }
        });
      });
    };
    GlobalQueue.prototype._buildPlayerImage = function(src) {
      return "       <img id='now_playing_artist_image' class='span-3' src='" + src + "' />        ";
    };
    GlobalQueue.prototype._buildUpNextDisplayItem = function(track, last) {
      var comma;
      comma = last ? '' : ', ';
      return "" + track.artist + " - " + track.title + comma;
    };
    GlobalQueue.prototype._buildPlayerVoteButtons = function(pqe_id) {
      $("#player_info_vote_div").append("        <span class='darker'>Vote on this track:</span><br />        <button id='player_info_vote_up' class='vote_up_button'></button>        <button id='player_info_vote_down' class='vote_down_button'></button>        ");
      $("button#player_info_vote_up").button({
        icons: {
          primary: "ui-icon-circle-arrow-n"
        }
      });
      $("button#player_info_vote_down").button({
        icons: {
          primary: "ui-icon-circle-arrow-s"
        }
      });
      $.ajax({
        url: "/vote/status",
        type: 'GET',
        data: {
          pqe: pqe_id
        },
        success: function(data) {
          if (data.direction === -1) {
            $("button#player_info_vote_down").button('disable');
          }
          if (data.direction === 1) {
            return $("button#player_info_vote_up").button('disable');
          }
        }
      });
      $("button#player_info_vote_up").click(function(e) {
        var btn;
        e.stopPropagation();
        btn = $(e.currentTarget);
        btn.button('disable');
        btn.button('option', 'icons', {
          primary: 'ui-icon-loading'
        });
        return $.ajax({
          url: "/vote/up",
          type: 'POST',
          data: {
            pqe: pqe_id
          },
          success: function(data) {
            if (data.status === "ok") {
              btn.button('option', 'icons', {
                primary: "ui-icon-circle-arrow-n"
              });
              $("button#player_info_vote_down").button('enable');
              window.Partify.Queues.GlobalQueue.queue_div.children("li.queue_item").first().children("span").children("button.vote_down_button").button('enable');
              return window.Partify.Queues.GlobalQueue.queue_div.children("li.queue_item").first().children("span").children("button.vote_up_button").button('disable');
            } else {
              return this.error();
            }
          },
          error: __bind(function() {
            btn.button('enable');
            return btn.button('option', 'icons', {
              primary: "ui-icon-circle-arrow-n"
            });
          }, this)
        });
      });
      return $("button#player_info_vote_down").click(function(e) {
        var btn;
        e.stopPropagation();
        btn = $(e.currentTarget);
        btn.button('disable');
        btn.button('option', 'icons', {
          primary: 'ui-icon-loading'
        });
        return $.ajax({
          url: "/vote/down",
          type: 'POST',
          data: {
            pqe: pqe_id
          },
          success: function(data) {
            if (data.status === "ok") {
              btn.button('option', 'icons', {
                primary: "ui-icon-circle-arrow-s"
              });
              $("button#player_info_vote_up").button('enable');
              window.Partify.Queues.GlobalQueue.queue_div.children("li.queue_item").first().children("span").children("button.vote_up_button").button('enable');
              return window.Partify.Queues.GlobalQueue.queue_div.children("li.queue_item").first().children("span").children("button.vote_down_button").button('disable');
            } else {
              return this.error();
            }
          },
          error: __bind(function() {
            btn.button('enable');
            return btn.button('option', 'icons', {
              primary: "ui-icon-circle-arrow-s"
            });
          }, this)
        });
      });
    };
    return GlobalQueue;
  })();
  UserQueue = (function() {
    __extends(UserQueue, Queue);
    function UserQueue(queue_div) {
      UserQueue.__super__.constructor.call(this, queue_div);
      this.queue_div.bind('sortupdate', __bind(function(e, ui) {
        var priority, track, track_list, _fn, _i, _len, _ref;
        track_list = {};
        priority = 0;
        if (this.tracks[0].id === window.Partify.Queues.GlobalQueue.tracks[0].id) {
          priority = 2;
          track_list[this.tracks[0].id] = 1;
        } else {
          priority = 1;
        }
        _ref = this.queue_div.children("li.queue_item").children('input');
        _fn = __bind(function(track) {
          var t, target_track_id, track_obj, _j, _len2, _ref2;
          target_track_id = parseInt($(track).val());
          _ref2 = this.tracks;
          for (_j = 0, _len2 = _ref2.length; _j < _len2; _j++) {
            t = _ref2[_j];
            if (t.id === target_track_id) {
              track_obj = t;
            }
          }
          track_list[track_obj.id] = priority;
          return priority++;
        }, this);
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          track = _ref[_i];
          _fn(track);
        }
        console.log(track_list);
        return $.ajax({
          url: 'queue/reorder',
          type: 'POST',
          data: track_list,
          success: function(data) {
            if (data.status === 'ok') {
              return console.log('Everything worked out');
            } else {
              return this.error();
            }
          },
          error: __bind(function() {
            console.log('Error reordering the queue!');
            return this.loadPlayQueue();
          }, this)
        });
      }, this));
      this.loadPlayQueue();
    }
    UserQueue.prototype.loadPlayQueue = function() {
      return $.ajax({
        url: 'queue/list',
        type: 'GET',
        success: __bind(function(data) {
          if (data.status === "ok") {
            return this.update(data.result);
          }
        }, this),
        error: __bind(function() {
          return console.log("Failed to populate user play queue!");
        }, this)
      });
    };
    UserQueue.prototype.updateDisplay = function() {
      var track, _i, _len, _ref;
      this.queue_div.empty();
      this.queue_div.append(this._buildDisplayHeader());
      _ref = this.tracks;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        track = _ref[_i];
        if (track.id !== window.Partify.Queues.GlobalQueue.tracks[0].id) {
          this.queue_div.append(this._buildDisplayItem(track));
        }
      }
      this.queue_div.append(this._buildDisplayFooter());
      return this._createRemoveButtons();
    };
    UserQueue.prototype._buildDisplayHeader = function() {
      return "        <li class='queue_header span-23 last'>            <span class='span-1 ui-icon ui-icon-arrowthick-2-n-s grip'>&nbsp;</span>            <span class='span-7'>Title</span>            <span class='span-6'>Artist</span>            <span class='span-6'>Album</span>            <span class='span-2 '>Time</span>            <span class='span-1 last padder'>&nbsp;</span>        </li>        ";
    };
    UserQueue.prototype._buildDisplayItem = function(track) {
      var html;
      return html = "        <li class='queue_item queue_item_sortable ui-state-default small span-23 last'>            <input type='hidden' name='id' value='" + track.id + "'>            <span class='span-1 ui-icon ui-icon-grip-dotted-vertical grip'>&nbsp;</span>            <span class='span-7'>" + track.title + "</span>            <span class='span-6'>" + track.artist + "</span>            <span class='span-6'>" + track.album + "</span>            <span class='span-2'>" + (secondsToTimeString(track.length)) + "</span>            <span class='span-1 right last'><button id='rm_" + track.id + "' class='rm_btn'></button></span>        </li>";
    };
    UserQueue.prototype._createRemoveButtons = function() {
      var track, _i, _len, _ref, _results;
      _ref = this.tracks;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        track = _ref[_i];
        _results.push(this._createRemoveButton(track));
      }
      return _results;
    };
    UserQueue.prototype._createRemoveButton = function(track) {
      var rm_btn;
      rm_btn = $('button#rm_' + track.id);
      rm_btn.button({
        icons: {
          primary: 'ui-icon-close'
        },
        text: false
      });
      return rm_btn.click(__bind(function(e) {
        rm_btn.button('disable');
        rm_btn.button('option', 'icons', {
          primary: 'ui-icon-loading'
        });
        return this.removeTrack(track);
      }, this));
    };
    return UserQueue;
  })();
  HistoryQueue = (function() {
    __extends(HistoryQueue, Queue);
    function HistoryQueue(queue_div) {
      HistoryQueue.__super__.constructor.call(this, queue_div);
      this.queue_div.sortable('option', 'disabled', true);
    }
    HistoryQueue.prototype.updateDisplay = function() {
      var track, _i, _len, _ref;
      this.queue_div.empty();
      this.queue_div.append(this._buildDisplayHeader());
      _ref = this.tracks;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        track = _ref[_i];
        this.queue_div.append(this._buildDisplayItem(track));
      }
      if (this.tracks.length === 0) {
        return this.queue_div.append(this._buildNoItemsRow());
      }
    };
    HistoryQueue.prototype._buildDisplayHeader = function() {
      return "        <li class='queue_header span-23 last'>            <span class='span-1 padder'>&nbsp;</span>            <span class='span-6'>Title</span>            <span class='span-5'>Artist</span>            <span class='span-5'>Album</span>            <span class='span-2'>User</span>            <span class='span-4 last right'>Played</span>        </li>        ";
    };
    HistoryQueue.prototype._buildDisplayItem = function(track) {
      return "        <li class='queue_item queue_item_sortable ui-state-default small span-23 last'>            <span class='span-1 padder'>&nbsp;</span>            <span class='span-6'>" + track.title + "</span>            <span class='span-5'>" + track.artist + "</span>            <span class='span-5'>" + track.album + "</span>            <span class='span-2'>" + track.user + "</span>            <span class='span-4 last right timeago' title='" + track.time_played + "'>now</span>        </li>        ";
    };
    HistoryQueue.prototype._buildNoItemsRow = function() {
      return "        <li class='queue_item queue_footer ui-state-default small span-23 last'>            <span class='span-23 last'><center><p ><em>No tracks have been played yet. Make history... be the first!</em></p></center></span>        </li>        ";
    };
    return HistoryQueue;
  })();
  buildRoboHashUrlFromId = function(id, dimension_x, dimension_y) {
    return "http://robohash.org/" + id + ".png?size=" + dimension_x + "x" + dimension_y + "&set=any&bgset=any";
  };
  /*
Copyright 2011 Fred Hatfull

This file is part of Partify.

Partify is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Partify is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Partify.  If not, see <http://www.gnu.org/licenses/>.
*/;
  $ = jQuery;
  $(function() {
    window.Partify = window.Partify || {};
    window.Partify.Search = new Search();
    return window.Partify.Search.skin_add_btns();
  });
  Search = (function() {
    Search.results = new Array();
    Search.results_display;
    Search.sortmode = {
      category: "",
      asc: true
    };
    function Search() {
      this.initializeFormHandlers();
      this.initializeSortHandlers();
      this.results_display = $("table#results_table > tbody");
      this.results = new Array();
      this.sortmode = {
        category: "",
        asc: true
      };
    }
    Search.prototype.initializeFormHandlers = function() {
      $("#track_search_form input:submit").button();
      return $("#track_search_form").submit(__bind(function(e) {
        var album, artist, title;
        e.stopPropagation();
        title = $("input#search_title").val();
        artist = $("input#search_artist").val();
        album = $("input#search_album").val();
        this.processSearch(title, artist, album);
        return false;
      }, this));
    };
    Search.prototype.initializeSortHandlers = function() {
      var category, _i, _len, _ref, _results;
      _ref = ['title', 'artist', 'album'];
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        category = _ref[_i];
        _results.push(__bind(function(category) {
          return $("#results_header_" + category).click(__bind(function(e) {
            e.stopPropagation();
            if (this.sortmode.category === category) {
              this.sortmode.asc = !this.sortmode.asc;
            } else {
              this.sortmode.category = category;
              this.sortmode.asc = true;
            }
            return this.sortResultsBy(this.sortmode.category, "artist", "album", "track", this.sortmode.asc);
          }, this));
        }, this)(category));
      }
      return _results;
    };
    Search.prototype.sortResultsBy = function() {
      var categories, is_ascending, sortfn, _i;
      categories = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), is_ascending = arguments[_i++];
      sortfn = function(a, b) {
        var category, cmp_val, _j, _len;
        cmp_val = 0;
        for (_j = 0, _len = categories.length; _j < _len; _j++) {
          category = categories[_j];
          if (cmp_val === 0) {
            (function(category) {
              if (a[category] < b[category]) {
                cmp_val = -1;
              }
              if (a[category] > b[category]) {
                return cmp_val = 1;
              }
            })(category);
          }
        }
        return cmp_val;
      };
      this.results.sort(sortfn);
      if (!is_ascending) {
        this.results.reverse();
      }
      this.updateResultsDisplay();
      return this.setSortIndicator();
    };
    Search.prototype.setSortIndicator = function() {
      this.clearSortIndicators();
      return $("#results_header_" + this.sortmode.category).append("<span id='sort_indicator_arrow' class='ui-icon ui-icon-triangle-1-" + (this.sortmode.asc ? 'n' : 's') + " grip' style='float:left'>&nbsp;</span>");
    };
    Search.prototype.clearSortIndicators = function() {
      return $("#sort_indicator_arrow").remove();
    };
    Search.prototype.processSearch = function(title, artist, album) {
      var request_data;
      this.results = new Array();
      this._show_wait_spinner();
      this.clearSortIndicators();
      this.sortmode = {
        category: "",
        asc: true
      };
      request_data = {};
      if (title !== "") {
        request_data['title'] = title;
      }
      if (artist !== "") {
        request_data['artist'] = artist;
      }
      if (album !== "") {
        request_data['album'] = album;
      }
      return $.ajax({
        url: '/track/search',
        type: 'GET',
        data: request_data,
        success: __bind(function(data) {
          var result, _i, _len, _ref;
          if (data.status === 'ok') {
            _ref = data.results;
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              result = _ref[_i];
              this.results.push(new Track(result));
            }
            return this.updateResultsDisplay();
          } else {
            return this.updateResultsDisplay();
          }
        }, this)
      });
    };
    Search.prototype.addTrack = function(spotify_url, row) {
      return $.ajax({
        url: '/queue/add',
        type: 'POST',
        data: {
          spotify_uri: spotify_url
        },
        success: __bind(function(data) {
          var btn;
          btn = row.children('td.result_add').children('button');
          if (data.status === 'ok') {
            btn.button('option', 'icons', {
              primary: 'ui-icon-check'
            });
            window.Partify.Player._synchroPoll();
            return window.Partify.Queues.UserQueue.update(data.queue);
          } else {
            return this._addTrackFail(btn);
          }
        }, this),
        error: __bind(function() {
          return this._addTrackFail(row.children('td.result_add').children('button'));
        }, this)
      });
    };
    Search.prototype.addAlbum = function(spotify_url, album_tracks) {
      var spotify_files, track, _i, _len;
      this.disableButton($("tr[id='" + album_tracks[0].file + "'] > td.result_album > button"));
      for (_i = 0, _len = album_tracks.length; _i < _len; _i++) {
        track = album_tracks[_i];
        this.disableRow($("tr[id='" + track.file + "']"));
      }
      spotify_files = (function() {
        var _j, _len2, _results;
        _results = [];
        for (_j = 0, _len2 = album_tracks.length; _j < _len2; _j++) {
          track = album_tracks[_j];
          _results.push(track.file);
        }
        return _results;
      })();
      return $.ajax({
        url: '/queue/add_album',
        type: 'POST',
        data: {
          spotify_files: spotify_files
        },
        traditional: 'true',
        success: function(data) {
          var track, _fn, _j, _len2;
          if (data.status === 'ok') {
            $("tr[id='" + album_tracks[0].file + "'] > td.result_album > button").button('option', 'icons', {
              primary: 'ui-icon-check'
            });
            _fn = function(track) {
              return $("tr[id='" + track.file + "'] > td.result_add > button").button('option', 'icons', {
                primary: 'ui-icon-check'
              });
            };
            for (_j = 0, _len2 = album_tracks.length; _j < _len2; _j++) {
              track = album_tracks[_j];
              _fn(track);
            }
            window.Partify.Player._synchroPoll();
            return window.Partify.Queues.UserQueue.update(data.queue);
          } else {
            return this.error();
          }
        },
        error: __bind(function() {
          var track, _j, _len2, _results;
          this._addTrackFail($("tr[id='" + album_tracks[0].file + "'] > td.result_album > button"));
          _results = [];
          for (_j = 0, _len2 = album_tracks.length; _j < _len2; _j++) {
            track = album_tracks[_j];
            _results.push(this._addTrackFail($("tr[id='" + track.file + "'] > td.result_add > button")));
          }
          return _results;
        }, this)
      });
    };
    Search.prototype._addTrackFail = function(btn) {
      btn.addClass('ui-state-error');
      return btn.button('option', 'icons', {
        primary: 'ui-icon-alert'
      });
    };
    Search.prototype.updateResultsDisplay = function() {
      var pos, track, _fn, _i, _len, _len2, _ref, _ref2;
      this.results_display.empty();
      if (this.results.length > 0) {
        _ref = this.results;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          track = _ref[_i];
          this.buildResultRow(track);
        }
        if (this.sortmode.category !== "title") {
          _ref2 = this.results;
          _fn = __bind(function(track, pos) {
            var album_length, end_pos, last_track, start_pos, year, year_str;
            start_pos = pos;
            end_pos = pos;
            while (start_pos > 0) {
              if (this.results[start_pos - 1].album === track.album) {
                start_pos -= 1;
              } else {
                break;
              }
            }
            while (end_pos < this.results.length - 1) {
              if (this.results[end_pos + 1].album === track.album) {
                end_pos += 1;
              } else {
                break;
              }
            }
            album_length = (end_pos - start_pos) + 1;
            if (album_length > 4) {
              if (track.album === this.results[Math.max(pos - 1, 0)].album && track.file !== this.results[Math.max(pos - 1, 0)].file) {
                $("tr[id='" + track.file + "'] > td.result_album").remove();
              } else {
                $("tr[id='" + track.file + "'] > td.result_album").attr('rowspan', album_length);
                $("tr[id='" + track.file + "'] > td.result_album").addClass('album_details');
                $("tr[id='" + track.file + "'] > td.result_album");
                year = yearFromDateString(track.date);
                year_str = year !== "" && year > 0 ? "(" + year + ")" : "";
                $("tr[id='" + track.file + "'] > td.result_album").prepend("                                <img id='" + track.file + "' src='/static/img/loading.gif' />");
                $("tr[id='" + track.file + "'] > td.result_album > a").wrap("<p></p>");
                $("tr[id='" + track.file + "'] > td.result_album > p").append(" " + year_str);
                $("tr[id='" + track.file + "'] > td.result_album").append("                                <button class='album_add_btn'>Add Album</button>                                ");
                last_track = this.results[pos + album_length - 1];
                window.Partify.LastFM.album.getInfo({
                  artist: track.artist,
                  album: track.album
                }, {
                  success: function(data) {
                    var image, image_sizes, images, img_element, img_url, target_size, _ref3;
                    images = (_ref3 = data.album) != null ? _ref3.image : void 0;
                    if (images != null) {
                      image_sizes = (function() {
                        var _j, _len3, _results;
                        _results = [];
                        for (_j = 0, _len3 = images.length; _j < _len3; _j++) {
                          image = images[_j];
                          _results.push(image.size);
                        }
                        return _results;
                      })();
                      target_size = "large";
                      if (__indexOf.call(image_sizes, target_size) >= 0) {
                        img_url = (function() {
                          var _j, _len3, _results;
                          _results = [];
                          for (_j = 0, _len3 = images.length; _j < _len3; _j++) {
                            image = images[_j];
                            if (image.size === target_size) {
                              _results.push(image['#text']);
                            }
                          }
                          return _results;
                        })();
                        img_url = img_url[0];
                        img_element = $("tr[id='" + track.file + "'] > td.result_album img[id='" + track.file + "']");
                        img_element.attr('src', img_url);
                        img_element.bind('load', function(e) {
                          img_element.addClass('album_image');
                          img_element.attr('width', 174);
                          img_element.attr('height', 174);
                          if ((4 < album_length && album_length < 8)) {
                            $("tr[id='" + last_track.file + "']").after("<tr class='album_padding'><td colspan=5>&nbsp;</td></tr>");
                            return $("tr[id='" + track.file + "'] > td.result_album").attr('rowspan', album_length + 1);
                          }
                        });
                        if (img_url === "") {
                          return img_element.remove();
                        }
                      }
                    }
                  },
                  error: __bind(function(code, message) {
                    return img_element.remove();
                  }, this)
                });
                $("tr[id='" + track.file + "'] > td.result_album > button").button({
                  icons: {
                    primary: 'ui-icon-plus'
                  },
                  text: true
                });
                $("tr[id='" + track.file + "'] > td.result_album > button").click(__bind(function(e) {
                  return this.addAlbum(track.file, this.results.slice(pos, pos + album_length));
                }, this));
              }
            }
            if (track.album !== this.results[Math.max(pos - 1, 0)].album) {
              return $("tr[id='" + track.file + "'] > td").addClass('album_seperator');
            }
          }, this);
          for (pos = 0, _len2 = _ref2.length; pos < _len2; pos++) {
            track = _ref2[pos];
            _fn(track, pos);
          }
        }
        $("table#results_table td:not(.album_details)").hover(function(e) {
          console.log($(e.currentTarget).parents("tr").first());
          return $(e.currentTarget).parents("tr").first().children("td:not(.album_details)").addClass('highlight');
        }, __bind(function(e) {
          return $(e.currentTarget).parents("tr").first().children("td:not(.album_details)").removeClass('highlight');
        }, this));
      } else {
        this.buildEmptyResultRow();
      }
      return this.skin_add_btns();
    };
    Search.prototype.buildResultRow = function(track) {
      var row_html;
      row_html = "        <tr id='" + track.file + "'>            <td class='small result_album'><a href='#'>" + track.album + "</a></td>            <td class='small result_artist'><a href='#'>" + track.artist + "</a></td>            <td class='small result_title'>" + track.title + "</td>            <td class='small result_time'>" + (secondsToTimeString(track.time)) + "</td>            <td class='small result_track'>" + track.track + "</td>            <td class='small result_add'><button class='add_btn'></button></td>        </tr>        ";
      this.results_display.append(row_html);
      $("tr[id='" + track.file + "'] td.result_album a").click(__bind(function(e) {
        e.stopPropagation();
        $("input#search_artist").val(track.artist);
        $("input#search_album").val(track.album);
        $("input#search_title").val("");
        return this.processSearch("", track.artist, track.album);
      }, this));
      return $("tr[id='" + track.file + "'] td.result_artist a").click(__bind(function(e) {
        e.stopPropagation();
        $("input#search_artist").val(track.artist);
        $("input#search_title").val("");
        $("input#search_album").val("");
        return this.processSearch("", track.artist, "");
      }, this));
    };
    Search.prototype.buildEmptyResultRow = function() {
      var row_html;
      row_html = "        <tr>            <td colspan='6' class='results_empty small'>                <center><em>No results found. Please try a different search using the form above.</em></center>            </td>        </tr>";
      return this.results_display.append(row_html);
    };
    Search.prototype.skin_add_btns = function() {
      $("button.add_btn").button({
        icons: {
          primary: 'ui-icon-plus'
        },
        text: false
      });
      return $("button.add_btn").click(__bind(function(e) {
        var spotify_url, track_row;
        track_row = $(e.currentTarget).parent('td').parent('tr').first();
        spotify_url = track_row.attr('id');
        this.disableRow(track_row);
        return this.addTrack(spotify_url, track_row);
      }, this));
    };
    Search.prototype.disableRow = function(row) {
      return this.disableButton(row.children('td.result_add').children('button'));
    };
    Search.prototype.disableButton = function(btn) {
      btn.button('disable');
      return btn.button('option', 'icons', {
        primary: 'ui-icon-loading'
      });
    };
    Search.prototype._show_wait_spinner = function() {
      this.results_display.empty();
      return this.results_display.append("        <tr>            <td colspan='6' class='results_empty'>                <center><img src='/static/img/loading.gif'></img></center>            </td>        </tr>        ");
    };
    return Search;
  })();
  Track = (function() {
    Track.id = 0;
    Track.title = "";
    Track.artist = "";
    Track.album = "";
    Track.track = "";
    Track.file = "";
    Track.time = "";
    Track.date = "";
    Track.length = "";
    Track.user = "";
    Track.user_id = 0;
    Track.playback_priority = 0;
    Track.user_priority = 0;
    Track.mpd_id = 0;
    Track.time_played = 0;
    Track.history_is_playing = false;
    function Track(data) {
      this.id = parseInt(data.id) || data.id;
      this.title = data.title;
      this.artist = data.artist;
      this.album = data.album;
      this.track = parseInt(data.track) || data.track;
      this.file = data.file;
      this.time = parseInt(data.time) || data.time;
      this.date = data.date;
      this.length = data.length;
      this.user = data.user;
      this.username = data.username;
      this.user_id = data.user_id;
      this.playback_priority = data.playback_priority;
      this.user_priority = data.user_priority;
      if (data.mpd_id) {
        this.mpd_id = data.mpd_id;
      }
      if (data.time_played) {
        this.time_played = data.time_played;
      }
      this.history_is_playing = data.is_playing;
    }
    return Track;
  })();
  /*
Copyright 2011 Fred Hatfull

This file is part of Partify.

Partify is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Partify is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Partify.  If not, see <http://www.gnu.org/licenses/>.
*/;
  $ = jQuery;
  $(function() {
    window.Partify = window.Partify || {};
    return window.Partify.Statistics = new Statistics($("#stats_widget"));
  });
  Statistics = (function() {
    function Statistics(widget_div) {
      this.widget_div = widget_div;
      this.last_update_time = 0;
      this.in_flight_xhr = void 0;
      this.deferred_images = new Array();
      this.widget_div.append("<span id='statistics_last_updated' class='small darker left'><span id='statistics_update_prefix'>Last updated </span><span class='timeago' id='timeago'>never</span></span>");
      this.widget_div.append("<div id='stats_container' class='span-23 last'></div>");
      this.update();
      setInterval(__bind(function() {
        return this.update();
      }, this), 1000 * 60 * 15);
    }
    Statistics.prototype.update = function() {
      this._showUpdateSpinner();
      return this.in_flight_xhr = $.ajax({
        url: '/statistics',
        method: 'GET',
        success: __bind(function(data) {
          if (data.status === 'ok') {
            this.last_update_time = data.response_time;
            this._updateUpdateTime();
            return this.updateStatisticsDisplay(data);
          }
        }, this)
      });
    };
    Statistics.prototype.updateStatisticsDisplay = function(data) {
      var statistics, stats_container;
      statistics = data.statistics;
      stats_container = $("div#stats_container");
      stats_container.empty();
      this._buildStatisticsTimeSection(statistics.day, "Today", stats_container);
      this._buildStatisticsTimeSection(statistics.week, "This Week", stats_container);
      this._buildStatisticsTimeSection(statistics.month, "This Month", stats_container);
      this._buildStatisticsTimeSection(statistics.year, "This Year", stats_container);
      return this._buildStatisticsTimeSection(statistics.all, "All Time", stats_container);
    };
    Statistics.prototype._buildStatisticsTimeSection = function(section, label, stats_container) {
      stats_container.append("		<h4>" + label + "</h4>		");
      label = label.replace(" ", "_");
      stats_container.append("<div class='stat_border span-23 last append-bottom' id='" + label + "_container'>			<div class='span-23 last append-bottom'><span class='small'>" + section.total_tracks + " tracks played (" + (secondsToTimeString(section.total_time)) + ")</span></div>			</div>");
      stats_container = $("div#" + label + "_container");
      this._buildStatisticsSegment(section.top_artists, 'artists', stats_container, label);
      this._buildStatisticsSegment(section.top_albums, 'albums', stats_container, label);
      return this._buildStatisticsSegment(section.top_users, 'users', stats_container, label);
    };
    Statistics.prototype._buildStatisticsSegment = function(segment, type, stats_container, label) {
      var e, max_rank, rank, segment_container, segment_vpad;
      segment_vpad = type === "users" ? "" : "append-bottom";
      stats_container.append("		<div class='span-23 last " + segment_vpad + "'><h5>Top " + type + "</h5></div>");
      segment_container = stats_container.children("div").last();
      max_rank = Math.max.apply(Math, (function() {
        var _results;
        _results = [];
        for (rank in segment) {
          e = segment[rank];
          _results.push(rank);
        }
        return _results;
      })());
      if (max_rank > 0) {
        if (type === "artists") {
          for (rank = 1; 1 <= max_rank ? rank <= max_rank : rank >= max_rank; 1 <= max_rank ? rank++ : rank--) {
            this._buildTopArtist(segment[rank].artist, segment[rank].plays, rank, segment_container, label);
          }
        } else if (type === "albums") {
          for (rank = 1; 1 <= max_rank ? rank <= max_rank : rank >= max_rank; 1 <= max_rank ? rank++ : rank--) {
            this._buildTopAlbum(segment[rank].artist, segment[rank].plays, segment[rank].album, rank, segment_container, label);
          }
        } else if (type === "users") {
          for (rank = 1; 1 <= max_rank ? rank <= max_rank : rank >= max_rank; 1 <= max_rank ? rank++ : rank--) {
            this._buildTopUser(segment[rank].username, segment[rank].user, segment[rank].plays, rank, segment_container, label);
          }
        }
        return segment_container.append("<div class='span-" + (((5 - max_rank) * 5) + 3) + " last'>&nbsp;</div>");
      } else {
        return this._buildNoData(segment_container);
      }
    };
    Statistics.prototype._buildTopArtist = function(artist, plays, rank, segment_container, label) {
      segment_container.append("		<div class='span-5'>			<div class='span-5 last top_stat'><span>" + artist + "</span></div>			<div class='span-5 last'><span class='darker'>" + plays + " plays</span></div>			<img class='span-5 last' id='" + label + "_top_artist_" + rank + "' src />		</div>		");
      return this._buildArtistImage(artist, $("img#" + label + "_top_artist_" + rank));
    };
    Statistics.prototype._buildTopAlbum = function(artist, plays, album, rank, segment_container, label) {
      segment_container.append("		<div class='span-5'>			<div class='span-5 last top_stat'><span>" + album + "</span></div>			<div class='span-5 last top_stat'><span class='darker'>by </span><span>" + artist + "</span></div>			<div class='span-5 last'><span class='darker'>" + plays + " plays</span></div>			<img class='span-5 last' id='" + label + "_top_album_" + rank + "' />		</div>		");
      return this._buildAlbumImage(artist, album, $("img#" + label + "_top_album_" + rank));
    };
    Statistics.prototype._buildTopUser = function(username, user, plays, rank, segment_container, label) {
      segment_container.append("		<div class='span-5'>			<div class='span-5 last top_stat'><span>" + user + "</span></div>			<div class='span-5 last'><span class='darker'>" + plays + " plays</span></div>			<img id='" + label + "_top_user_" + rank + "' />		</div>		");
      return this._buildUserImage(username, $("img#" + label + "_top_user_" + rank));
    };
    Statistics.prototype._buildArtistImage = function(artist, img_element) {
      return window.Partify.LastFM.artist.getInfo({
        artist: artist
      }, {
        success: __bind(function(data) {
          var image, image_sizes, images, img_url, preferred_sizes, size, target_size, _i, _len, _ref;
          images = (_ref = data.artist) != null ? _ref.image : void 0;
          if (images != null) {
            image_sizes = (function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = images.length; _i < _len; _i++) {
                image = images[_i];
                _results.push(image.size);
              }
              return _results;
            })();
            preferred_sizes = ['extralarge', 'large', 'medium', 'small'];
            for (_i = 0, _len = preferred_sizes.length; _i < _len; _i++) {
              size = preferred_sizes[_i];
              if (__indexOf.call(image_sizes, size) < 0) {
                preferred_sizes.remove(size);
              }
            }
            target_size = preferred_sizes[0];
            img_url = (function() {
              var _j, _len2, _results;
              _results = [];
              for (_j = 0, _len2 = images.length; _j < _len2; _j++) {
                image = images[_j];
                if (image.size === target_size) {
                  _results.push(image['#text']);
                }
              }
              return _results;
            })();
            img_url = img_url[0];
            return img_element.attr('src', img_url);
          }
        }, this),
        error: __bind(function(code, message) {
          return console.log("" + code + " - " + message);
        }, this)
      });
    };
    Statistics.prototype._buildAlbumImage = function(artist, album, img_element) {
      return window.Partify.LastFM.album.getInfo({
        artist: artist,
        album: album
      }, {
        success: function(data) {
          var image, image_sizes, images, img_url, preferred_sizes, size, target_size, _i, _len, _ref;
          images = (_ref = data.album) != null ? _ref.image : void 0;
          if (images != null) {
            image_sizes = (function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = images.length; _i < _len; _i++) {
                image = images[_i];
                _results.push(image.size);
              }
              return _results;
            })();
            preferred_sizes = ['large', 'medium', 'small'];
            for (_i = 0, _len = preferred_sizes.length; _i < _len; _i++) {
              size = preferred_sizes[_i];
              if (__indexOf.call(image_sizes, size) < 0) {
                preferred_sizes.remove(size);
              }
            }
            target_size = preferred_sizes[0];
            img_url = (function() {
              var _j, _len2, _results;
              _results = [];
              for (_j = 0, _len2 = images.length; _j < _len2; _j++) {
                image = images[_j];
                if (image.size === target_size) {
                  _results.push(image['#text']);
                }
              }
              return _results;
            })();
            img_url = img_url[0];
            return img_element.attr('src', img_url);
          }
        },
        error: __bind(function(code, message) {
          return console.log("" + code + " - " + message);
        }, this)
      });
    };
    Statistics.prototype._buildUserImage = function(user, img_element) {
      return img_element.attr('src', buildRoboHashUrlFromId(user, 190, 190));
    };
    Statistics.prototype._showUpdateSpinner = function() {
      $("span#statistics_last_updated > span").empty();
      return $("span#statistics_last_updated > span#statistics_update_prefix").append("			<img src='/static/img/loading.gif' class='left' style='margin-right: 5px' />			Updating...		");
    };
    Statistics.prototype._updateUpdateTime = function() {
      $("span#statistics_last_updated > span").empty();
      $("span#statistics_last_updated > span#statistics_update_prefix").append("Last updated ");
      $("span#statistics_last_updated > span#timeago").remove();
      $("span#statistics_last_updated").append("		<span class='timeago' id='timeago'>never</span>");
      $("span#statistics_last_updated > span#timeago").attr('title', this.last_update_time);
      return $("span.timeago").timeago();
    };
    return Statistics;
  })();
}).call(this);
