"""
Full CSS2 property table
This appendix is informative, not normative.
http://www.w3.org/TR/CSS2/propidx.html
"""
properties = (
    ("azimuth", "<angle> | [[ left-side | far-left | left | center-left | center | center-right | right | far-right | right-side ] || behind ] | leftwards | rightwards | inherit", "center", None, "yes", None, "aural"),
    ("background-attachment", "scroll | fixed | inherit", "scroll", None, "no", None, "visual"),
    ("background-color", "<color> | transparent | inherit", "transparent", None, "no", None, "visual"),
    ("background-image", "<uri> | none | inherit", "none", None, "no", None, "visual"),
    ("background-position", "[ [ <percentage> | <length> | left | center | right ] [ <percentage> | <length> | top | center | bottom ]? ] | [ [ left | center | right ] || [ top | center | bottom ] ] | inherit", "0% 0%", None, "no", "refer to the size of the box itself", "visual"),
    ("background-repeat", "repeat | repeat-x | repeat-y | no-repeat | inherit", "repeat", None, "no", None, "visual"),
    ("background", "['background-color' || 'background-image' || 'background-repeat' || 'background-attachment' || 'background-position'] | inherit", "see individual properties", None, "no", "allowed on 'background-position", "visual"),
    ("border-collapse", "collapse | separate | inherit", "separate", "table' and 'inline-table' elements", "yes", None, "visual"),
    ("border-color", "[ <color> | transparent ]{1,4} | inherit", "see individual properties", None, "no", None, "visual"),
    ("border-spacing", "<length> <length>? | inherit", "0", "'table' and 'inline-table' elements ", "yes", None, "visual"),
    ("border-style", "<border-style>{1,4} | inherit", "see individual properties", None, "no", None, "visual"),
    ("border-top border-right border-bottom border-left", "[ <border-width> || <border-style> || 'border-top-color' ] | inherit", "see individual properties", None, "no", None, "visual"),
    ("border-top-color border-right-color border-bottom-color border-left-color", "<color> | transparent | inherit", "the value of the 'color' property", None, "no", None, "visual"),
    ("border-top-style border-right-style border-bottom-style border-left-style", "<border-style> | inherit", "none", None, "no", None, "visual"),
    ("border-top-width border-right-width border-bottom-width border-left-width", "<border-width> | inherit", "medium", None, "no", None, "visual"),
    ("border-width", "<border-width>{1,4} | inherit", "see individual properties", None, "no", None, "visual"),
    ("border", "[ <border-width> || <border-style> || 'border-top-color' ] | inherit", "see individual properties", None, "no", None, "visual"),
    ("bottom", "<length> | <percentage> | auto | inherit", "auto", "positioned elements", "no", "refer to height of containing block", "visual"),
    ("caption-side", "top | bottom | inherit", "top", "'table-caption' elements", "yes", None, "visual"),
    ("clear", "none | left | right | both | inherit", "none", "block-level elements", "no", None, "visual"),
    ("clip", "<shape> | auto | inherit", "auto", "absolutely positioned elements", "no", None, "visual"),
    ("color", "<color> | inherit", "depends on user agent", None, "yes", None, "visual"),
    ("content", "normal | none | [ <string> | <uri> | <counter> | attr(<identifier>) | open-quote | close-quote | no-open-quote | no-close-quote ]+ | inherit", "normal", ":before and :after pseudo-elements", "no", None, "all"),
    ("counter-increment", "[ <identifier> <integer>? ]+ | none | inherit", "none", None, "no", None, "all"),
    ("counter-reset", "[ <identifier> <integer>? ]+ | none | inherit", "none", None, "no", None, "all"),
    ("cue-after", "<uri> | none | inherit", "none", None, "no", None, "aural"),
    ("cue-before", "<uri> | none | inherit", "none", None, "no", None, "aural"),
    ("cue", "[ 'cue-before' || 'cue-after' ] | inherit", "see individual properties", None, "no", None, "aural"),
    ("cursor", "[ [<uri> ,]* [ auto | crosshair | default | pointer | move | e-resize | ne-resize | nw-resize | n-resize | se-resize | sw-resize | s-resize | w-resize | text | wait | help | progress ] ] | inherit", "auto", None, "yes", None, "visual, interactive"),
    ("direction", "ltr | rtl | inherit", "ltr", "all elements, but see prose", "yes", None, "visual"),
    ("display", "inline | block | list-item | inline-block | table | inline-table | table-row-group | table-header-group | table-footer-group | table-row | table-column-group | table-column | table-cell | table-caption | none | inherit", "inline", None, "no", None, "all"),
    ("elevation", "<angle> | below | level | above | higher | lower | inherit", "level", None, "yes", None, "aural"),
    ("empty-cells", "show | hide | inherit", "show", "'table-cell' elements", "yes", None, "visual"),
    ("float", "left | right | none | inherit", "none", "all, but see 9.7", "no", None, "visual"),
    ("font-family", "[[ <family-name> | <generic-family> ] [, <family-name>| <generic-family>]* ] | inherit", "depends on user agent", None, "yes", None, "visual"),
    ("font-size", "<absolute-size> | <relative-size> | <length> | <percentage> | inherit", "medium", None, "yes", "refer to inherited font size", "visual"),
    ("font-style", "normal | italic | oblique | inherit", "normal", None, "yes", None, "visual"),
    ("font-variant", "normal | small-caps | inherit", "normal", None, "yes", None, "visual"),
    ("font-weight", "normal | bold | bolder | lighter | 100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900 | inherit", "normal", None, "yes", None, "visual"),
    ("font", "[ [ 'font-style' || 'font-variant' || 'font-weight' ]? 'font-size' [ / 'line-height' ]? 'font-family' ] | caption | icon | menu | message-box | small-caption | status-bar | inherit", "see individual properties", None, "yes", "see individual properties", "visual"),
    ("height", "<length> | <percentage> | auto | inherit", "auto", "all elements but non-replaced inline elements, table columns, and column groups", "no", "see prose", "visual"),
    ("left", "<length> | <percentage> | auto | inherit", "auto", "positioned elements", "no", "refer to width of containing block", "visual"),
    ("letter-spacing", "normal | <length> | inherit", "normal", None, "yes", None, "visual"),
    ("line-height", "normal | <number> | <length> | <percentage> | inherit", "normal", None, "yes", "refer to the font size of the element itself", "visual"),
    ("list-style-image", "<uri> | none | inherit", "none", "elements with 'display: list-item", "yes", None, "visual"),
    ("list-style-position", "inside | outside | inherit", "outside", "elements with 'display: list-item", "yes", None, "visual"),
    ("list-style-type", "disc | circle | square | decimal | decimal-leading-zero | lower-roman | upper-roman | lower-greek | lower-latin | upper-latin | armenian | georgian | lower-alpha | upper-alpha | none | inherit", "disc", "elements with 'display: list-item", "yes", None, "visual"),
    ("list-style", "[ 'list-style-type' || 'list-style-position' || 'list-style-image' ] | inherit", "see individual properties", "elements with 'display: list-item", "yes", None, "visual"),
    ("margin-right margin-left", "<margin-width> | inherit", "0", "all elements except elements with table display types other than table-caption, table and inline-table", "no", "refer to width of containing block", "visual"),
    ("margin-top margin-bottom", "<margin-width> | inherit", "0", "all elements except elements with table display types other than table-caption, table and inline-table", "no", "refer to width of containing block", "visual"),
    ("margin", "<margin-width>{1,4} | inherit", "see individual properties", "all elements except elements with table display types other than table-caption, table and inline-table", "no", "refer to width of containing block", "visual"),
    ("max-height", "<length> | <percentage> | none | inherit", "none", "all elements but non-replaced inline elements, table columns, and column groups", "no", "see prose", "visual"),
    ("max-width", "<length> | <percentage> | none | inherit", "none", "all elements but non-replaced inline elements, table rows, and row groups", "no", "refer to width of containing block", "visual"),
    ("min-height", "<length> | <percentage> | inherit", "0", "all elements but non-replaced inline elements, table columns, and column groups", "no", "see prose", "visual"),
    ("min-width", "<length> | <percentage> | inherit", "0", "all elements but non-replaced inline elements, table rows, and row groups", "no", "refer to width of containing block", "visual"),
    ("orphans", "<integer> | inherit", "2", "block container elements", "yes", None, "visual, paged"),
    ("outline-color", "<color> | invert | inherit", "invert", None, "no", None, "visual, interactive"),
    ("outline-style", "<border-style> | inherit", "none", None, "no", None, "visual, interactive"),
    ("outline-width", "<border-width> | inherit", "medium", None, "no", None, "visual, interactive"),
    ("outline", "[ 'outline-color' || 'outline-style' || 'outline-width' ] | inherit", "see individual properties", None, "no", None, "visual, interactive"),
    ("overflow", "visible | hidden | scroll | auto | inherit", "visible", "block containers", "no", None, "visual"),
    ("padding-top padding-right padding-bottom padding-left", "<padding-width> | inherit", "0", "all elements except table-row-group, table-header-group, table-footer-group, table-row, table-column-group and table-column", "no", "refer to width of containing block", "visual"),
    ("padding", "<padding-width>{1,4} | inherit", "see individual properties", "all elements except table-row-group, table-header-group, table-footer-group, table-row, table-column-group and table-column", "no", "refer to width of containing block", "visual"),
    ("page-break-after", "auto | always | avoid | left | right | inherit", "auto", "block-level elements (but see text)", "no", None, "visual, paged"),
    ("page-break-before", "auto | always | avoid | left | right | inherit", "auto", "block-level elements (but see text)", "no", None, "visual, paged"),
    ("page-break-inside", "avoid | auto | inherit", "auto", "block-level elements (but see text)", "no", None, "visual, paged"),
    ("pause-after", "<time> | <percentage> | inherit", "0", None, "no", "see prose", "aural"),
    ("pause-before", "<time> | <percentage> | inherit", "0", None, "no", "see prose", "aural"),
    ("pause", "[ [<time> | <percentage>]{1,2} ] | inherit", "see individual properties", None, "no", "see descriptions of 'pause-before' and 'pause-after", "aural"),
    ("pitch-range", "<number> | inherit", "50", None, "yes", None, "aural"),
    ("pitch", "<frequency> | x-low | low | medium | high | x-high | inherit", "medium", None, "yes", None, "aural"),
    ("play-during", "<uri> [ mix || repeat ]? | auto | none | inherit", "auto", None, "no", None, "aural"),
    ("position", "static | relative | absolute | fixed | inherit", "static", None, "no", None, "visual"),
    ("quotes", "[<string> <string>]+ | none | inherit", "depends on user agent", None, "yes", None, "visual"),
    ("richness", "<number> | inherit", "50", None, "yes", None, "aural"),
    ("right", "<length> | <percentage> | auto | inherit", "auto", "positioned elements", "no", "refer to width of containing block", "visual"),
    ("speak-header", "once | always | inherit", "once", "elements that have table header information", "yes", None, "aural"),
    ("speak-numeral", "digits | continuous | inherit", "continuous", None, "yes", None, "aural"),
    ("speak-punctuation", "code | none | inherit", "none", None, "yes", None, "aural"),
    ("speak", "normal | none | spell-out | inherit", "normal", None, "yes", None, "aural"),
    ("speech-rate", "<number> | x-slow | slow | medium | fast | x-fast | faster | slower | inherit", "medium", None, "yes", None, "aural"),
    ("stress", "<number> | inherit", "50", None, "yes", None, "aural"),
    ("table-layout", "auto | fixed | inherit", "auto", "'table' and 'inline-table' elements", "no", None, "visual"),
    ("text-align", "left | right | center | justify | inherit", "a nameless value that acts as 'left' if 'direction' is 'ltr', 'right' if 'direction' is 'rtl", "block containers", "yes", None, "visual"),
    ("text-decoration", "none | [ underline || overline || line-through || blink ] | inherit", "none", None, "no (see prose)", None, "visual"),
    ("text-indent", "<length> | <percentage> | inherit", "0", "block containers", "yes", "refer to width of containing block", "visual"),
    ("text-transform", "capitalize | uppercase | lowercase | none | inherit", "none", None, "yes", None, "visual"),
    ("top", "<length> | <percentage> | auto | inherit", "auto", "positioned elements", "no", "refer to height of containing block", "visual"),
    ("unicode-bidi", "normal | embed | bidi-override | inherit", "normal", "all elements, but see prose", "no", None, "visual"),
    ("vertical-align", "baseline | sub | super | top | text-top | middle | bottom | text-bottom | <percentage> | <length> | inherit", "baseline", "inline-level and 'table-cell' elements", "no", "refer to the 'line-height' of the element itself", "visual"),
    ("visibility", "visible | hidden | collapse | inherit", "visible", None, "yes", None, "visual"),
    ("voice-family", "[[<specific-voice> | <generic-voice> ],]* [<specific-voice> | <generic-voice> ] | inherit", "depends on user agent", None, "yes", None, "aural"),
    ("volume", "<number> | <percentage> | silent | x-soft | soft | medium | loud | x-loud | inherit", "medium", None, "yes", "refer to inherited value", "aural"),
    ("white-space", "normal | pre | nowrap | pre-wrap | pre-line | inherit", "normal", None, "yes", None, "visual"),
    ("widows", "<integer> | inherit", "2", "block container elements", "yes", None, "visual, paged"),
    ("width", "<length> | <percentage> | auto | inherit", "auto", "all elements but non-replaced inline elements, table rows, and row groups", "no", "refer to width of containing block", "visual"),
    ("word-spacing", "normal | <length> | inherit", "normal", None, "yes", None, "visual"),
    ("z-index", "auto | <integer> | inherit", "auto", "positioned elements", "no", None, "visual"),
)